/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class ButtonSkin
extends LabeledSkinBase<Button, ButtonBehavior<Button>> {
    Runnable defaultButtonRunnable = () -> {
        if (((Button)this.getSkinnable()).getScene() != null && ((Button)this.getSkinnable()).impl_isTreeVisible() && !((Button)this.getSkinnable()).isDisabled()) {
            ((Button)this.getSkinnable()).fire();
        }
    };
    Runnable cancelButtonRunnable = () -> {
        if (((Button)this.getSkinnable()).getScene() != null && ((Button)this.getSkinnable()).impl_isTreeVisible() && !((Button)this.getSkinnable()).isDisabled()) {
            ((Button)this.getSkinnable()).fire();
        }
    };
    private KeyCodeCombination defaultAcceleratorKeyCodeCombination;
    private KeyCodeCombination cancelAcceleratorKeyCodeCombination;

    public ButtonSkin(Button button) {
        super(button, new ButtonBehavior<Button>(button));
        this.registerChangeListener(button.defaultButtonProperty(), "DEFAULT_BUTTON");
        this.registerChangeListener(button.cancelButtonProperty(), "CANCEL_BUTTON");
        this.registerChangeListener(button.focusedProperty(), "FOCUSED");
        if (((Button)this.getSkinnable()).isDefaultButton()) {
            this.setDefaultButton(true);
        }
        if (((Button)this.getSkinnable()).isCancelButton()) {
            this.setCancelButton(true);
        }
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("DEFAULT_BUTTON".equals(p)) {
            this.setDefaultButton(((Button)this.getSkinnable()).isDefaultButton());
        } else if ("CANCEL_BUTTON".equals(p)) {
            this.setCancelButton(((Button)this.getSkinnable()).isCancelButton());
        } else if ("FOCUSED".equals(p)) {
            ContextMenu cm;
            if (!((Button)this.getSkinnable()).isFocused() && (cm = ((Button)this.getSkinnable()).getContextMenu()) != null && cm.isShowing()) {
                cm.hide();
                Utils.removeMnemonics(cm, ((Button)this.getSkinnable()).getScene());
            }
        } else if ("PARENT".equals(p) && ((Button)this.getSkinnable()).getParent() == null && ((Button)this.getSkinnable()).getScene() != null) {
            if (((Button)this.getSkinnable()).isDefaultButton()) {
                ((Button)this.getSkinnable()).getScene().getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
            }
            if (((Button)this.getSkinnable()).isCancelButton()) {
                ((Button)this.getSkinnable()).getScene().getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
            }
        }
    }

    private void setDefaultButton(boolean value) {
        Scene scene = ((Button)this.getSkinnable()).getScene();
        if (scene != null) {
            KeyCode acceleratorCode = KeyCode.ENTER;
            this.defaultAcceleratorKeyCodeCombination = new KeyCodeCombination(acceleratorCode, new KeyCombination.Modifier[0]);
            Runnable oldDefault = (Runnable)scene.getAccelerators().get(this.defaultAcceleratorKeyCodeCombination);
            if (!value) {
                if (this.defaultButtonRunnable.equals(oldDefault)) {
                    scene.getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
                }
            } else if (!this.defaultButtonRunnable.equals(oldDefault)) {
                scene.getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
                scene.getAccelerators().put(this.defaultAcceleratorKeyCodeCombination, this.defaultButtonRunnable);
            }
        }
    }

    private void setCancelButton(boolean value) {
        Scene scene = ((Button)this.getSkinnable()).getScene();
        if (scene != null) {
            KeyCode acceleratorCode = KeyCode.ESCAPE;
            this.cancelAcceleratorKeyCodeCombination = new KeyCodeCombination(acceleratorCode, new KeyCombination.Modifier[0]);
            Runnable oldCancel = (Runnable)scene.getAccelerators().get(this.cancelAcceleratorKeyCodeCombination);
            if (!value) {
                if (this.cancelButtonRunnable.equals(oldCancel)) {
                    scene.getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
                }
            } else if (!this.cancelButtonRunnable.equals(oldCancel)) {
                scene.getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
                scene.getAccelerators().put(this.cancelAcceleratorKeyCodeCombination, this.cancelButtonRunnable);
            }
        }
    }
}

