/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import java.util.Collections;
import javafx.collections.ObservableList;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class TableRowBehaviorBase<T extends Cell>
extends CellBehaviorBase<T> {
    public TableRowBehaviorBase(T control) {
        super(control, Collections.emptyList());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isClickPositionValid(e.getX(), e.getY())) {
            return;
        }
        super.mousePressed(e);
    }

    @Override
    protected abstract TableSelectionModel<?> getSelectionModel();

    protected abstract TablePositionBase<?> getFocusedCell();

    protected abstract ObservableList getVisibleLeafColumns();

    @Override
    protected void doSelect(double x, double y, MouseButton button, int clickCount, boolean shiftDown, boolean shortcutDown) {
        Control table = this.getCellContainer();
        if (table == null) {
            return;
        }
        if (this.handleDisclosureNode(x, y)) {
            return;
        }
        MultipleSelectionModel sm = this.getSelectionModel();
        if (sm == null || ((TableSelectionModel)sm).isCellSelectionEnabled()) {
            return;
        }
        int index = this.getIndex();
        boolean isAlreadySelected = ((TableSelectionModel)sm).isSelected(index);
        if (clickCount == 1) {
            if (!this.isClickPositionValid(x, y)) {
                return;
            }
            if (isAlreadySelected && shortcutDown) {
                ((TableSelectionModel)sm).clearSelection(index);
            } else if (shortcutDown) {
                ((TableSelectionModel)sm).select(this.getIndex());
            } else if (shiftDown) {
                TablePositionBase<?> anchor = TableCellBehavior.getAnchor(table, this.getFocusedCell());
                int anchorRow = anchor.getRow();
                this.selectRows(anchorRow, index);
            } else {
                this.simpleSelect(button, clickCount, shortcutDown);
            }
        } else {
            this.simpleSelect(button, clickCount, shortcutDown);
        }
    }

    @Override
    protected boolean isClickPositionValid(double x, double y) {
        ObservableList columns = this.getVisibleLeafColumns();
        double width = 0.0;
        for (int i = 0; i < columns.size(); ++i) {
            width += ((TableColumnBase)columns.get(i)).getWidth();
        }
        return x > width;
    }
}

