/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.DatePickerContent;
import com.sun.javafx.scene.traversal.Direction;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.DateCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class DateCellBehavior
extends BehaviorBase<DateCell> {
    protected static final List<KeyBinding> DATE_CELL_BINDINGS = new ArrayList<KeyBinding>();

    public DateCellBehavior(DateCell dateCell) {
        super(dateCell, DATE_CELL_BINDINGS);
    }

    @Override
    public void callAction(String name) {
        DateCell cell = (DateCell)this.getControl();
        DatePickerContent dpc = this.findDatePickerContent(cell);
        if (dpc != null) {
            switch (name) {
                case "SelectDate": {
                    dpc.selectDayCell(cell);
                    break;
                }
                default: {
                    super.callAction(name);
                }
            }
            return;
        }
        super.callAction(name);
    }

    @Override
    public void traverse(Node node, Direction dir) {
        boolean rtl = node.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        switch (dir) {
            case UP: 
            case DOWN: 
            case LEFT: 
            case RIGHT: {
                DatePickerContent dpc;
                if (!(node instanceof DateCell) || (dpc = this.findDatePickerContent(node)) == null) break;
                DateCell cell = (DateCell)node;
                switch (dir) {
                    case UP: {
                        dpc.goToDayCell(cell, -1, ChronoUnit.WEEKS, true);
                        break;
                    }
                    case DOWN: {
                        dpc.goToDayCell(cell, 1, ChronoUnit.WEEKS, true);
                        break;
                    }
                    case LEFT: {
                        dpc.goToDayCell(cell, rtl ? 1 : -1, ChronoUnit.DAYS, true);
                        break;
                    }
                    case RIGHT: {
                        dpc.goToDayCell(cell, rtl ? -1 : 1, ChronoUnit.DAYS, true);
                    }
                }
                return;
            }
        }
        super.traverse(node, dir);
    }

    protected DatePickerContent findDatePickerContent(Node node) {
        Node parent = node;
        while ((parent = parent.getParent()) != null && !(parent instanceof DatePickerContent)) {
        }
        return (DatePickerContent)parent;
    }

    static {
        DATE_CELL_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        DATE_CELL_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        DATE_CELL_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        DATE_CELL_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        DATE_CELL_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_RELEASED, "SelectDate"));
        DATE_CELL_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, "SelectDate"));
    }
}

