/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.png;

import com.sun.javafx.iio.common.ImageTools;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PNGIDATChunkInputStream
extends InputStream {
    static final int IDAT_TYPE = 1229209940;
    private DataInputStream source;
    private int numBytesAvailable = 0;
    private boolean foundAllIDATChunks = false;
    private int nextChunkLength = 0;
    private int nextChunkType = 0;

    PNGIDATChunkInputStream(DataInputStream input, int firstIDATChunkLength) throws IOException {
        if (firstIDATChunkLength < 0) {
            throw new IOException("Invalid chunk length");
        }
        this.source = input;
        this.numBytesAvailable = firstIDATChunkLength;
    }

    private void nextChunk() throws IOException {
        if (!this.foundAllIDATChunks) {
            ImageTools.skipFully(this.source, 4L);
            int chunkLength = this.source.readInt();
            if (chunkLength < 0) {
                throw new IOException("Invalid chunk length");
            }
            int chunkType = this.source.readInt();
            if (chunkType == 1229209940) {
                this.numBytesAvailable += chunkLength;
            } else {
                this.foundAllIDATChunks = true;
                this.nextChunkLength = chunkLength;
                this.nextChunkType = chunkType;
            }
        }
    }

    boolean isFoundAllIDATChunks() {
        return this.foundAllIDATChunks;
    }

    int getNextChunkLength() {
        return this.nextChunkLength;
    }

    int getNextChunkType() {
        return this.nextChunkType;
    }

    @Override
    public int read() throws IOException {
        if (this.numBytesAvailable == 0) {
            this.nextChunk();
        }
        if (this.numBytesAvailable == 0) {
            return -1;
        }
        --this.numBytesAvailable;
        return this.source.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.numBytesAvailable == 0) {
            this.nextChunk();
            if (this.numBytesAvailable == 0) {
                return -1;
            }
        }
        int totalRead = 0;
        while (this.numBytesAvailable > 0 && len > 0) {
            int numToRead = len < this.numBytesAvailable ? len : this.numBytesAvailable;
            int numRead = this.source.read(b, off, numToRead);
            if (numRead == -1) {
                throw new EOFException();
            }
            this.numBytesAvailable -= numRead;
            off += numRead;
            totalRead += numRead;
            if (this.numBytesAvailable != 0 || (len -= numRead) <= 0) continue;
            this.nextChunk();
        }
        return totalRead;
    }
}

