/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.ShapePair;
import com.sun.javafx.geom.transform.BaseTransform;

public final class ConcentricShapePair
extends ShapePair {
    private final Shape outer;
    private final Shape inner;

    public ConcentricShapePair(Shape outer, Shape inner) {
        this.outer = outer;
        this.inner = inner;
    }

    @Override
    public int getCombinationType() {
        return 1;
    }

    @Override
    public Shape getOuterShape() {
        return this.outer;
    }

    @Override
    public Shape getInnerShape() {
        return this.inner;
    }

    @Override
    public Shape copy() {
        return new ConcentricShapePair(this.outer.copy(), this.inner.copy());
    }

    @Override
    public boolean contains(float x, float y) {
        return this.outer.contains(x, y) && !this.inner.contains(x, y);
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        return this.outer.intersects(x, y, w, h) && !this.inner.contains(x, y, w, h);
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        return this.outer.contains(x, y, w, h) && !this.inner.intersects(x, y, w, h);
    }

    @Override
    public RectBounds getBounds() {
        return this.outer.getBounds();
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new PairIterator(this.outer.getPathIterator(tx), this.inner.getPathIterator(tx));
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new PairIterator(this.outer.getPathIterator(tx, flatness), this.inner.getPathIterator(tx, flatness));
    }

    static class PairIterator
    implements PathIterator {
        PathIterator outer;
        PathIterator inner;

        PairIterator(PathIterator outer, PathIterator inner) {
            this.outer = outer;
            this.inner = inner;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.outer.isDone()) {
                return this.inner.currentSegment(coords);
            }
            return this.outer.currentSegment(coords);
        }

        @Override
        public boolean isDone() {
            return this.outer.isDone() && this.inner.isDone();
        }

        @Override
        public void next() {
            if (this.outer.isDone()) {
                this.inner.next();
            } else {
                this.outer.next();
            }
        }
    }
}

