/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model;

import gov.sandia.cognition.learning.algorithm.bayes.VectorNaiveBayesCategorizer;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.pair.IndependentPair;

public class GaussianVectorNaiveBayesModel<T>
implements EstimatableModel<double[], T> {
    VectorNaiveBayesCategorizer.BatchGaussianLearner<T> learner = new VectorNaiveBayesCategorizer.BatchGaussianLearner();
    private VectorNaiveBayesCategorizer<T, UnivariateGaussian.PDF> model;

    @Override
    public boolean estimate(List<? extends IndependentPair<double[], T>> data) {
        ArrayList<DefaultInputOutputPair> cfdata = new ArrayList<DefaultInputOutputPair>();
        for (IndependentPair<double[], T> d : data) {
            DefaultInputOutputPair iop = new DefaultInputOutputPair((Object)VectorFactory.getDefault().copyArray((double[])d.firstObject()), d.secondObject());
            cfdata.add(iop);
        }
        this.model = this.learner.learn(cfdata);
        return true;
    }

    @Override
    public T predict(double[] data) {
        return (T)this.model.evaluate((Vectorizable)VectorFactory.getDefault().copyArray(data));
    }

    @Override
    public int numItemsToEstimate() {
        return 0;
    }

    public GaussianVectorNaiveBayesModel<T> clone() {
        try {
            return (GaussianVectorNaiveBayesModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        GaussianVectorNaiveBayesModel model = new GaussianVectorNaiveBayesModel();
        ArrayList<IndependentPair> data = new ArrayList<IndependentPair>();
        data.add(IndependentPair.pair((Object)new double[]{0.0}, (Object)true));
        data.add(IndependentPair.pair((Object)new double[]{0.1}, (Object)true));
        data.add(IndependentPair.pair((Object)new double[]{-0.1}, (Object)true));
        data.add(IndependentPair.pair((Object)new double[]{9.9}, (Object)false));
        data.add(IndependentPair.pair((Object)new double[]{10.0}, (Object)false));
        data.add(IndependentPair.pair((Object)new double[]{10.1}, (Object)false));
        model.estimate((List)data);
        double[] q = new double[]{5.0};
        System.out.println(model.predict(q));
        System.out.println(" logP(true): " + model.model.computeLogPosterior(VectorFactory.getDefault().copyArray(q), (Object)true));
        System.out.println("logP(false): " + model.model.computeLogPosterior(VectorFactory.getDefault().copyArray(q), (Object)false));
        System.out.println("    P(true): " + model.model.computePosterior(VectorFactory.getDefault().copyArray(q), (Object)true));
        System.out.println("   P(false): " + model.model.computePosterior(VectorFactory.getDefault().copyArray(q), (Object)false));
        System.out.println(model.model.getPriors());
    }
}

