/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class ClipTrack
implements VirtualTrack {
    private VirtualTrack src;
    private int from;
    private int to;
    private int startFrame;
    private double startPts;
    private List<VirtualPacket> gop;
    private boolean eof;

    public ClipTrack(VirtualTrack src, int frameFrom, int frameTo) {
        if (frameTo <= frameFrom) {
            throw new IllegalArgumentException("Clipping negative or zero frames.");
        }
        this.src = src;
        this.from = frameFrom;
        this.to = frameTo;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket nextPacket;
        if (this.eof) {
            return null;
        }
        if (this.gop == null) {
            this.gop = this.getGop(this.src, this.from);
            this.startPts = this.gop.get(0).getPts();
            this.startFrame = this.gop.get(0).getFrameNo();
        }
        VirtualPacket virtualPacket = nextPacket = this.gop.size() > 0 ? this.gop.remove(0) : this.src.nextPacket();
        if (nextPacket == null || nextPacket.getFrameNo() >= this.to) {
            this.eof = true;
            return null;
        }
        return new ClipPacket(nextPacket);
    }

    protected List<VirtualPacket> getGop(VirtualTrack src, int from) throws IOException {
        VirtualPacket nextPacket;
        ArrayList<VirtualPacket> result = new ArrayList<VirtualPacket>();
        do {
            if ((nextPacket = src.nextPacket()) == null) continue;
            if (nextPacket.isKeyframe()) {
                result.clear();
            }
            result.add(nextPacket);
        } while (nextPacket != null && nextPacket.getFrameNo() < from);
        return result;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.src.getCodecMeta();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    public class ClipPacket
    extends VirtualPacketWrapper {
        public ClipPacket(VirtualPacket src) {
            super(src);
        }

        @Override
        public double getPts() {
            return super.getPts() - ClipTrack.this.startPts;
        }

        @Override
        public int getFrameNo() {
            return super.getFrameNo() - ClipTrack.this.startFrame;
        }
    }
}

