/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.model.ChannelLabel;
import org.jcodec.common.tools.ToJSON;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.BoxFactory;
import org.jcodec.containers.mp4.boxes.ChannelBox;
import org.jcodec.containers.mp4.boxes.EndianBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.WaveExtension;
import org.jcodec.containers.mp4.boxes.channel.ChannelUtils;
import org.jcodec.containers.mp4.boxes.channel.Label;

public class AudioSampleEntry
extends SampleEntry {
    public static int kAudioFormatFlagIsFloat = 1;
    public static int kAudioFormatFlagIsBigEndian = 2;
    public static int kAudioFormatFlagIsSignedInteger = 4;
    public static int kAudioFormatFlagIsPacked = 8;
    public static int kAudioFormatFlagIsAlignedHigh = 16;
    public static int kAudioFormatFlagIsNonInterleaved = 32;
    public static int kAudioFormatFlagIsNonMixable = 64;
    private static final MyFactory FACTORY = new MyFactory();
    private short channelCount;
    private short sampleSize;
    private float sampleRate;
    private short revision;
    private int vendor;
    private int compressionId;
    private int pktSize;
    private int samplesPerPkt;
    private int bytesPerPkt;
    private int bytesPerFrame;
    private int bytesPerSample;
    private short version;
    private int lpcmFlags;
    public static Set<String> pcms = new HashSet<String>();
    private static Map<Label, ChannelLabel> translationStereo;
    private static Map<Label, ChannelLabel> translationSurround;

    public AudioSampleEntry(Header atom) {
        super(atom);
        this.factory = FACTORY;
    }

    public AudioSampleEntry(Header header, short drefInd, short channelCount, short sampleSize, int sampleRate, short revision, int vendor, int compressionId, int pktSize, int samplesPerPkt, int bytesPerPkt, int bytesPerFrame, int bytesPerSample, short version) {
        super(header, drefInd);
        this.channelCount = channelCount;
        this.sampleSize = sampleSize;
        this.sampleRate = sampleRate;
        this.revision = revision;
        this.vendor = vendor;
        this.compressionId = compressionId;
        this.pktSize = pktSize;
        this.samplesPerPkt = samplesPerPkt;
        this.bytesPerPkt = bytesPerPkt;
        this.bytesPerFrame = bytesPerFrame;
        this.bytesPerSample = bytesPerSample;
        this.version = version;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.version = input.getShort();
        this.revision = input.getShort();
        this.vendor = input.getInt();
        this.channelCount = input.getShort();
        this.sampleSize = input.getShort();
        this.compressionId = input.getShort();
        this.pktSize = input.getShort();
        long sr = (long)input.getInt() & 0xFFFFFFFFL;
        this.sampleRate = (float)sr / 65536.0f;
        if (this.version == 1) {
            this.samplesPerPkt = input.getInt();
            this.bytesPerPkt = input.getInt();
            this.bytesPerFrame = input.getInt();
            this.bytesPerSample = input.getInt();
        } else if (this.version == 2) {
            input.getInt();
            this.sampleRate = (float)Double.longBitsToDouble(input.getLong());
            this.channelCount = (short)input.getInt();
            input.getInt();
            this.sampleSize = (short)input.getInt();
            this.lpcmFlags = input.getInt();
            this.bytesPerFrame = input.getInt();
            this.samplesPerPkt = input.getInt();
        }
        this.parseExtensions(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putShort(this.version);
        out.putShort(this.revision);
        out.putInt(this.vendor);
        if (this.version < 2) {
            out.putShort(this.channelCount);
            if (this.version == 0) {
                out.putShort(this.sampleSize);
            } else {
                out.putShort((short)16);
            }
            out.putShort((short)this.compressionId);
            out.putShort((short)this.pktSize);
            out.putInt((int)Math.round((double)this.sampleRate * 65536.0));
            if (this.version == 1) {
                out.putInt(this.samplesPerPkt);
                out.putInt(this.bytesPerPkt);
                out.putInt(this.bytesPerFrame);
                out.putInt(this.bytesPerSample);
            }
        } else if (this.version == 2) {
            out.putShort((short)3);
            out.putShort((short)16);
            out.putShort((short)-2);
            out.putShort((short)0);
            out.putInt(65536);
            out.putInt(72);
            out.putLong(Double.doubleToLongBits(this.sampleRate));
            out.putInt(this.channelCount);
            out.putInt(0x7F000000);
            out.putInt(this.sampleSize);
            out.putInt(this.lpcmFlags);
            out.putInt(this.bytesPerFrame);
            out.putInt(this.samplesPerPkt);
        }
        this.writeExtensions(out);
    }

    public short getChannelCount() {
        return this.channelCount;
    }

    public int calcFrameSize() {
        if (this.version == 0 || this.bytesPerFrame == 0) {
            return (this.sampleSize >> 3) * this.channelCount;
        }
        return this.bytesPerFrame;
    }

    public int calcSampleSize() {
        return this.calcFrameSize() / this.channelCount;
    }

    public short getSampleSize() {
        return this.sampleSize;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public int getBytesPerSample() {
        return this.bytesPerSample;
    }

    public short getVersion() {
        return this.version;
    }

    public EndianBox.Endian getEndian() {
        EndianBox endianBox = Box.findFirst((NodeBox)this, EndianBox.class, WaveExtension.fourcc(), EndianBox.fourcc());
        if (endianBox == null) {
            if ("twos".equals(this.header.getFourcc())) {
                return EndianBox.Endian.BIG_ENDIAN;
            }
            if ("lpcm".equals(this.header.getFourcc())) {
                return (this.lpcmFlags & kAudioFormatFlagIsBigEndian) != 0 ? EndianBox.Endian.BIG_ENDIAN : EndianBox.Endian.LITTLE_ENDIAN;
            }
            if ("sowt".equals(this.header.getFourcc())) {
                return EndianBox.Endian.LITTLE_ENDIAN;
            }
            return EndianBox.Endian.BIG_ENDIAN;
        }
        return endianBox.getEndian();
    }

    public boolean isFloat() {
        return "fl32".equals(this.header.getFourcc()) || "fl64".equals(this.header.getFourcc()) || "lpcm".equals(this.header.getFourcc()) && (this.lpcmFlags & kAudioFormatFlagIsFloat) != 0;
    }

    public boolean isPCM() {
        return pcms.contains(this.header.getFourcc());
    }

    public AudioFormat getFormat() {
        return new AudioFormat((int)this.sampleRate, this.calcSampleSize() << 3, this.channelCount, true, this.getEndian() == EndianBox.Endian.BIG_ENDIAN);
    }

    public ChannelLabel[] getLabels() {
        ChannelBox channelBox = Box.findFirst((NodeBox)this, ChannelBox.class, "chan");
        if (channelBox != null) {
            Label[] labels = ChannelUtils.getLabels(channelBox);
            if (this.channelCount == 2) {
                return this.translate(translationStereo, labels);
            }
            return this.translate(translationSurround, labels);
        }
        switch (this.channelCount) {
            case 1: {
                return new ChannelLabel[]{ChannelLabel.MONO};
            }
            case 2: {
                return new ChannelLabel[]{ChannelLabel.STEREO_LEFT, ChannelLabel.STEREO_RIGHT};
            }
            case 6: {
                return new ChannelLabel[]{ChannelLabel.FRONT_LEFT, ChannelLabel.FRONT_RIGHT, ChannelLabel.CENTER, ChannelLabel.LFE, ChannelLabel.REAR_LEFT, ChannelLabel.REAR_RIGHT};
            }
        }
        ChannelLabel[] lbl = new ChannelLabel[this.channelCount];
        Arrays.fill((Object[])lbl, (Object)ChannelLabel.MONO);
        return lbl;
    }

    private ChannelLabel[] translate(Map<Label, ChannelLabel> translation, Label[] labels) {
        ChannelLabel[] result = new ChannelLabel[labels.length];
        int i = 0;
        for (Label label : labels) {
            result[i++] = translation.get((Object)label);
        }
        return result;
    }

    @Override
    protected void getModelFields(List<String> list) {
        ToJSON.allFieldsExcept(this.getClass(), "endian", "float", "format", "labels");
    }

    static {
        pcms.add("raw ");
        pcms.add("twos");
        pcms.add("sowt");
        pcms.add("fl32");
        pcms.add("fl64");
        pcms.add("in24");
        pcms.add("in32");
        pcms.add("lpcm");
        translationStereo = new HashMap<Label, ChannelLabel>();
        translationSurround = new HashMap<Label, ChannelLabel>();
        translationStereo.put(Label.Left, ChannelLabel.STEREO_LEFT);
        translationStereo.put(Label.Right, ChannelLabel.STEREO_RIGHT);
        translationStereo.put(Label.HeadphonesLeft, ChannelLabel.STEREO_LEFT);
        translationStereo.put(Label.HeadphonesRight, ChannelLabel.STEREO_RIGHT);
        translationStereo.put(Label.LeftTotal, ChannelLabel.STEREO_LEFT);
        translationStereo.put(Label.RightTotal, ChannelLabel.STEREO_RIGHT);
        translationStereo.put(Label.LeftWide, ChannelLabel.STEREO_LEFT);
        translationStereo.put(Label.RightWide, ChannelLabel.STEREO_RIGHT);
        translationSurround.put(Label.Left, ChannelLabel.FRONT_LEFT);
        translationSurround.put(Label.Right, ChannelLabel.FRONT_RIGHT);
        translationSurround.put(Label.LeftCenter, ChannelLabel.FRONT_CENTER_LEFT);
        translationSurround.put(Label.RightCenter, ChannelLabel.FRONT_CENTER_RIGHT);
        translationSurround.put(Label.Center, ChannelLabel.CENTER);
        translationSurround.put(Label.CenterSurround, ChannelLabel.REAR_CENTER);
        translationSurround.put(Label.CenterSurroundDirect, ChannelLabel.REAR_CENTER);
        translationSurround.put(Label.LeftSurround, ChannelLabel.REAR_LEFT);
        translationSurround.put(Label.LeftSurroundDirect, ChannelLabel.REAR_LEFT);
        translationSurround.put(Label.RightSurround, ChannelLabel.REAR_RIGHT);
        translationSurround.put(Label.RightSurroundDirect, ChannelLabel.REAR_RIGHT);
        translationSurround.put(Label.RearSurroundLeft, ChannelLabel.SIDE_LEFT);
        translationSurround.put(Label.RearSurroundRight, ChannelLabel.SIDE_RIGHT);
        translationSurround.put(Label.LFE2, ChannelLabel.LFE);
        translationSurround.put(Label.LFEScreen, ChannelLabel.LFE);
        translationSurround.put(Label.LeftTotal, ChannelLabel.STEREO_LEFT);
        translationSurround.put(Label.RightTotal, ChannelLabel.STEREO_RIGHT);
        translationSurround.put(Label.LeftWide, ChannelLabel.STEREO_LEFT);
        translationSurround.put(Label.RightWide, ChannelLabel.STEREO_RIGHT);
    }

    public static class MyFactory
    extends BoxFactory {
        private Map<String, Class<? extends Box>> mappings = new HashMap<String, Class<? extends Box>>();

        public MyFactory() {
            this.mappings.put(WaveExtension.fourcc(), WaveExtension.class);
            this.mappings.put(ChannelBox.fourcc(), ChannelBox.class);
            this.mappings.put("esds", LeafBox.class);
        }

        @Override
        public Class<? extends Box> toClass(String fourcc) {
            return this.mappings.get(fourcc);
        }
    }
}

