/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264.decode;

import org.jcodec.codecs.h264.H264Const;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.PredictionWeightTable;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.tools.MathUtil;

public class Prediction {
    private SliceHeader sh;

    public Prediction(SliceHeader sh) {
        this.sh = sh;
    }

    public void mergePrediction(int refIdxL0, int refIdxL1, H264Const.PartPred predType, int comp, int[] pred0, int[] pred1, int off, int stride, int blkW, int blkH, int[] out, Frame[][] refs, Frame thisFrame) {
        PictureParameterSet pps = this.sh.pps;
        if (this.sh.slice_type == SliceType.P) {
            if (pps.weighted_pred_flag && this.sh.pred_weight_table != null) {
                PredictionWeightTable w = this.sh.pred_weight_table;
                this.weight(pred0, stride, off, blkW, blkH, comp == 0 ? w.luma_log2_weight_denom : w.chroma_log2_weight_denom, comp == 0 ? w.luma_weight[0][refIdxL0] : w.chroma_weight[0][comp - 1][refIdxL0], comp == 0 ? w.luma_offset[0][refIdxL0] : w.chroma_offset[0][comp - 1][refIdxL0], out);
            } else {
                this.copyPrediction(pred0, stride, off, blkW, blkH, out);
            }
        } else if (!pps.weighted_pred_flag || this.sh.pps.weighted_bipred_idc == 0 || this.sh.pps.weighted_bipred_idc == 2 && predType != H264Const.PartPred.Bi) {
            this.mergeAvg(pred0, pred1, stride, predType, off, blkW, blkH, out);
        } else if (this.sh.pps.weighted_bipred_idc == 1) {
            int o0;
            int w1;
            int w0;
            PredictionWeightTable w = this.sh.pred_weight_table;
            int n = refIdxL0 == -1 ? 0 : (w0 = comp == 0 ? w.luma_weight[0][refIdxL0] : w.chroma_weight[0][comp - 1][refIdxL0]);
            int n2 = refIdxL1 == -1 ? 0 : (w1 = comp == 0 ? w.luma_weight[1][refIdxL1] : w.chroma_weight[1][comp - 1][refIdxL1]);
            int n3 = refIdxL0 == -1 ? 0 : (o0 = comp == 0 ? w.luma_offset[0][refIdxL0] : w.chroma_offset[0][comp - 1][refIdxL0]);
            int o1 = refIdxL1 == -1 ? 0 : (comp == 0 ? w.luma_offset[1][refIdxL1] : w.chroma_offset[1][comp - 1][refIdxL1]);
            this.mergeWeight(pred0, pred1, stride, predType, off, blkW, blkH, comp == 0 ? w.luma_log2_weight_denom : w.chroma_log2_weight_denom, w0, w1, o0, o1, out);
        } else {
            int tx;
            int dsf;
            int tb = MathUtil.clip(thisFrame.getPOC() - refs[0][refIdxL0].getPOC(), -128, 127);
            int td = MathUtil.clip(refs[1][refIdxL1].getPOC() - refs[0][refIdxL0].getPOC(), -128, 127);
            int w0 = 32;
            int w1 = 32;
            if (td != 0 && refs[0][refIdxL0].isShortTerm() && refs[1][refIdxL1].isShortTerm() && (dsf = MathUtil.clip(tb * (tx = (16384 + Math.abs(td / 2)) / td) + 32 >> 6, -1024, 1023) >> 2) >= -64 && dsf <= 128) {
                w1 = dsf;
                w0 = 64 - dsf;
            }
            this.mergeWeight(pred0, pred1, stride, predType, off, blkW, blkH, 5, w0, w1, 0, 0, out);
        }
    }

    private void mergeAvg(int[] blk0, int[] blk1, int stride, H264Const.PartPred p0, int off, int blkW, int blkH, int[] o) {
        if (p0 == H264Const.PartPred.Bi) {
            this.mergePrediction(blk0, blk1, stride, p0, off, blkW, blkH, o);
        } else if (p0 == H264Const.PartPred.L0) {
            this.copyPrediction(blk0, stride, off, blkW, blkH, o);
        } else if (p0 == H264Const.PartPred.L1) {
            this.copyPrediction(blk1, stride, off, blkW, blkH, o);
        }
    }

    private void mergeWeight(int[] blk0, int[] blk1, int stride, H264Const.PartPred partPred, int off, int blkW, int blkH, int logWD, int w0, int w1, int o0, int o1, int[] out) {
        if (partPred == H264Const.PartPred.L0) {
            this.weight(blk0, stride, off, blkW, blkH, logWD, w0, o0, out);
        } else if (partPred == H264Const.PartPred.L1) {
            this.weight(blk1, stride, off, blkW, blkH, logWD, w1, o1, out);
        } else if (partPred == H264Const.PartPred.Bi) {
            this.weightPrediction(blk0, blk1, stride, off, blkW, blkH, logWD, w0, w1, o0, o1, out);
        }
    }

    private void copyPrediction(int[] in, int stride, int off, int blkW, int blkH, int[] o) {
        int i = 0;
        while (i < blkH) {
            int j = 0;
            while (j < blkW) {
                o[off] = in[off];
                ++j;
                ++off;
            }
            ++i;
            off += stride - blkW;
        }
    }

    private void mergePrediction(int[] blk0, int[] blk1, int stride, H264Const.PartPred p0, int off, int blkW, int blkH, int[] o) {
        int i = 0;
        while (i < blkH) {
            int j = 0;
            while (j < blkW) {
                o[off] = blk0[off] + blk1[off] + 1 >> 1;
                ++j;
                ++off;
            }
            ++i;
            off += stride - blkW;
        }
    }

    private void weightPrediction(int[] blk0, int[] blk1, int stride, int off, int blkW, int blkH, int logWD, int w0, int w1, int o0, int o1, int[] out) {
        int dvadva = 1 << logWD;
        int sum = o0 + o1 + 1 >> 1;
        int logWDCP1 = logWD + 1;
        int i = 0;
        while (i < blkH) {
            int j = 0;
            while (j < blkW) {
                out[off] = MathUtil.clip((blk0[off] * w0 + blk1[off] * w1 + dvadva >> logWDCP1) + sum, 0, 255);
                ++j;
                ++off;
            }
            ++i;
            off += stride - blkW;
        }
    }

    private void weight(int[] blk0, int stride, int off, int blkW, int blkH, int logWD, int w, int o, int[] out) {
        int dva = 1 << logWD - 1;
        if (logWD >= 1) {
            int i = 0;
            while (i < blkH) {
                int j = 0;
                while (j < blkW) {
                    out[off] = MathUtil.clip((blk0[off] * w + dva >> logWD) + o, 0, 255);
                    ++j;
                    ++off;
                }
                ++i;
                off += stride - blkW;
            }
        } else {
            int i = 0;
            while (i < blkH) {
                int j = 0;
                while (j < blkW) {
                    out[off] = MathUtil.clip(blk0[off] * w + o, 0, 255);
                    ++j;
                    ++off;
                }
                ++i;
                off += stride - blkW;
            }
        }
    }
}

