/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.nlogo.api.FileIO$;
import org.nlogo.api.ModelReader$;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelType$Normal$;
import org.nlogo.api.Version$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.core.Model;
import org.nlogo.fileformat.ConversionError;
import org.nlogo.fileformat.FailedConversionResult;
import org.nlogo.swing.BrowserLauncher$;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.OptionDialog$;
import org.nlogo.window.AutoConversionErrorDialog;
import org.nlogo.workspace.ModelTracker;
import org.nlogo.workspace.OpenModel;
import org.nlogo.workspace.SaveModel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\f\u0018\u0001yA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)!\t\u0001C\u0001\u0007\")\u0001\n\u0001C\u0001\u0013\")1\r\u0001C\u0001I\")a\u000f\u0001C\u0001o\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0013\u0001\t\u0003\tY\u0005\u0003\u0006\u0002P\u0001A)\u0019!C\u0001\u0003#Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\t9\u000b\u0001C\u0005\u0003SCq!a+\u0001\t\u0003\ti\u000bC\u0004\u00022\u0002!\t!a-\u0003\u001d\u0019KG.Z\"p]R\u0014x\u000e\u001c7fe*\u0011\u0001$G\u0001\u0007o&tGm\\<\u000b\u0005iY\u0012!\u00028m_\u001e|'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001yRe\f\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019bcBA\u0014+\u001b\u0005A#BA\u0015\u001a\u0003%9xN]6ta\u0006\u001cW-\u0003\u0002,Q\u0005Iq\n]3o\u001b>$W\r\\\u0005\u0003[9\u0012!bQ8oiJ|G\u000e\\3s\u0015\tY\u0003\u0006\u0005\u00021g9\u0011q%M\u0005\u0003e!\n\u0011bU1wK6{G-\u001a7\n\u00055\"$B\u0001\u001a)\u0003\u0015ywO\\3s!\t9D(D\u00019\u0015\tI$(A\u0002boRT\u0011aO\u0001\u0005U\u00064\u0018-\u0003\u0002>q\tI1i\\7q_:,g\u000e^\u0001\r[>$W\r\u001c+sC\u000e\\WM\u001d\t\u0003O\u0001K!!\u0011\u0015\u0003\u00195{G-\u001a7Ue\u0006\u001c7.\u001a:\u0002\rqJg.\u001b;?)\r!ei\u0012\t\u0003\u000b\u0002i\u0011a\u0006\u0005\u0006k\r\u0001\rA\u000e\u0005\u0006}\r\u0001\raP\u0001\u0010KJ\u0014xN](qK:LgnZ+S\u0013R\u0019!*T+\u0011\u0005\u0001Z\u0015B\u0001'\"\u0005\u0011)f.\u001b;\t\u000b9#\u0001\u0019A(\u0002\u0007U\u0014\u0018\u000e\u0005\u0002Q'6\t\u0011K\u0003\u0002Su\u0005\u0019a.\u001a;\n\u0005Q\u000b&aA+S\u0013\")a\u000b\u0002a\u0001/\u0006IQ\r_2faRLwN\u001c\t\u00031\u0002t!!\u00170\u000f\u0005ikV\"A.\u000b\u0005qk\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\ty\u0016%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'!C#yG\u0016\u0004H/[8o\u0015\ty\u0016%\u0001\rfeJ|'/Q;u_\u000e|gN^3si&tw-T8eK2$\"!\u001a8\u0011\u0007\u00012\u0007.\u0003\u0002hC\t1q\n\u001d;j_:\u0004\"!\u001b7\u000e\u0003)T!a[\r\u0002\t\r|'/Z\u0005\u0003[*\u0014Q!T8eK2DQa\\\u0003A\u0002A\f1A]3t!\t\tH/D\u0001s\u0015\t\u0019\u0018$\u0001\u0006gS2,gm\u001c:nCRL!!\u001e:\u0003-\u0019\u000b\u0017\u000e\\3e\u0007>tg/\u001a:tS>t'+Z:vYR\fqc\u001d5po\u0006+Ho\\2p]Z,'o]5p]\u0016\u0013(o\u001c:\u0015\u0007\u0015D\u0018\u0010C\u0003p\r\u0001\u0007\u0001\u000fC\u0003{\r\u0001\u000710\u0001\u0003cCN,\u0007c\u0001?\u0002\u00029\u0011QP \t\u00035\u0006J!a`\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\ty\u0018%\u0001\u0007j]Z\fG.\u001b3N_\u0012,G\u000eF\u0002K\u0003\u0017AQAT\u0004A\u0002=CSaBA\b\u0003C\u0001R\u0001IA\t\u0003+I1!a\u0005\"\u0005\u0019!\bN]8xgB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001ci\nA\u0001\\1oO&!\u0011qDA\r\u0005UIE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:\u001c#!!\u0006\u0002'%tg/\u00197jI6{G-\u001a7WKJ\u001c\u0018n\u001c8\u0015\u000b)\u000b9#!\u000b\t\u000b9C\u0001\u0019A(\t\r\u0005-\u0002\u00021\u0001|\u0003\u001d1XM]:j_:\fqd\u001d5pk2$w\n]3o\u001b>$W\r\\(g\t&4g-\u001a:j]\u001e\f%/\u001b;z)\u0019\t\t$a\u000e\u0002BA\u0019\u0001%a\r\n\u0007\u0005U\u0012EA\u0004C_>dW-\u00198\t\u000f\u0005e\u0012\u00021\u0001\u0002<\u0005)\u0011M]5usB\u0019\u0001%!\u0010\n\u0007\u0005}\u0012EA\u0002J]RDa!a\u000b\n\u0001\u0004Y\u0018aH:i_VdGm\u00149f]6{G-\u001a7PMVs7N\\8x]Z+'o]5p]R!\u0011\u0011GA$\u0011\u0019\tYC\u0003a\u0001w\u0006q2\u000f[8vY\u0012|\u0005/\u001a8N_\u0012,Gn\u00144MK\u001e\f7-\u001f,feNLwN\u001c\u000b\u0005\u0003c\ti\u0005\u0003\u0004\u0002,-\u0001\ra_\u0001\u0019G>tG/\u001b8vK\u0006sGmQ1oG\u0016dw\n\u001d;j_:\u001cXCAA*!\u0015\u0001\u0013QKA-\u0013\r\t9&\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003/\tY&\u0003\u0003\u0002^\u0005e!AB(cU\u0016\u001cG/\u0001\u0019dQ\u0016\u001c7nV5uQV\u001bXM\u001d\"fM>\u0014Xm\u00149f]&tw-T8eK24%o\\7GkR,(/\u001a,feNLwN\u001c\u000b\u0004\u0015\u0006\r\u0004BBA\u0016\u001b\u0001\u00071\u0010K\u0003\u000e\u0003O\n\u0019\bE\u0003!\u0003#\tI\u0007\u0005\u0003\u0002l\u0005=TBAA7\u0015\tI\u0014$\u0003\u0003\u0002r\u00055$aE+tKJ\u001c\u0015M\\2fY\u0016C8-\u001a9uS>t7EAA5\u0003\u0015\u001a\u0007.Z2l/&$\b.V:fe\n+gm\u001c:f\u001fB,g.\u001b8hg\u0011ku\u000eZ3mS:\u0014D\tF\u0002K\u0003sBa!a\u000b\u000f\u0001\u0004Y\b&\u0002\b\u0002h\u0005M\u0014!J2iK\u000e\\w+\u001b;i+N,'OQ3g_J,w\n]3oS:<'\u0007R'pI\u0016d\u0017N\\\u001aE)\u0005Q\u0005&B\b\u0002h\u0005M\u0014A\u00068pi&4\u00170V:fe:{GOV1mS\u00124\u0015\u000e\\3\u0015\u0007)\u000b9\tC\u0003O!\u0001\u0007q\nK\u0003\u0011\u0003O\n\u0019(\u0001\u0011tQ><h+\u001a:tS>tw+\u0019:oS:<\u0017I\u001c3HKR\u0014Vm\u001d9p]N,G\u0003BA\u0019\u0003\u001fCa!a\u000b\u0012\u0001\u0004Y\u0018AD2i_>\u001cXMR5mKB\u000bG\u000f\u001b\u000b\u0005\u0003+\u000b9\nE\u0002!M>Cq!!'\u0013\u0001\u0004\tY*A\u0005n_\u0012,G\u000eV=qKB!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"f\t1!\u00199j\u0013\u0011\t)+a(\u0003\u00135{G-\u001a7UsB,\u0017!D4vKN\u001ch)\u001b7f\u001d\u0006lW-F\u0001|\u0003\u0005\u001a\bn\\;mIN\u000bg/Z'pI\u0016dwJ\u001a#jM\u001a,'/\u001b8h-\u0016\u00148/[8o)\u0011\t\t$a,\t\r\u0005-B\u00031\u0001|\u0003U9\u0018M\u001d8J]Z\fG.\u001b3GS2,gi\u001c:nCR$2ASA[\u0011\u0019\t9,\u0006a\u0001w\u00061am\u001c:nCR\u0004")
public class FileController
implements OpenModel.Controller,
SaveModel.Controller {
    private Object[] continueAndCancelOptions;
    private final Component owner;
    private final ModelTracker modelTracker;
    private volatile boolean bitmap$0;

    @Override
    public void errorOpeningURI(URI uri, Exception exception) {
        Object[] options = new Object[]{I18N$.MODULE$.gui().get("common.buttons.ok")};
        Predef$.MODULE$.println(exception);
        exception.printStackTrace();
        OptionDialog$.MODULE$.showMessage(this.owner, "NetLogo", I18N$.MODULE$.gui().getN("file.open.error.unableToOpen", Predef$.MODULE$.wrapRefArray(new Object[]{((Object)Paths.get(uri)).toString(), exception.getMessage()})), options);
        throw new UserCancelException();
    }

    @Override
    public Option<Model> errorAutoconvertingModel(FailedConversionResult res) {
        return this.showAutoconversionError(res, "model");
    }

    public Option<Model> showAutoconversionError(FailedConversionResult res, String base) {
        res.errors().foreach((Function1<ConversionError, Object> & Serializable & scala.Serializable)x$1 -> {
            FileController.$anonfun$showAutoconversionError$1(x$1);
            return BoxedUnit.UNIT;
        });
        AutoConversionErrorDialog dialog = new AutoConversionErrorDialog(this.owner, base);
        dialog.doShow(res);
        return dialog.modelToOpen();
    }

    @Override
    public void invalidModel(URI uri) throws IllegalStateException {
        this.notifyUserNotValidFile(uri);
    }

    @Override
    public void invalidModelVersion(URI uri, String version) {
        this.notifyUserNotValidFile(uri);
    }

    @Override
    public boolean shouldOpenModelOfDifferingArity(int arity, String version) {
        try {
            if (arity == 3) {
                this.checkWithUserBeforeOpening3DModelin2D(version);
            } else {
                this.checkWithUserBeforeOpening2DModelin3D();
            }
            return true;
        }
        catch (UserCancelException userCancelException) {
            return false;
        }
    }

    @Override
    public boolean shouldOpenModelOfUnknownVersion(String version) {
        try {
            this.checkWithUserBeforeOpeningModelFromFutureVersion(version);
            return true;
        }
        catch (UserCancelException userCancelException) {
            return false;
        }
    }

    @Override
    public boolean shouldOpenModelOfLegacyVersion(String version) {
        return this.showVersionWarningAndGetResponse(version);
    }

    private Object[] continueAndCancelOptions$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.continueAndCancelOptions = new Object[]{I18N$.MODULE$.gui().get("common.buttons.continue"), I18N$.MODULE$.gui().get("common.buttons.cancel")};
                this.bitmap$0 = true;
            }
        }
        return this.continueAndCancelOptions;
    }

    public Object[] continueAndCancelOptions() {
        if (!this.bitmap$0) {
            return this.continueAndCancelOptions$lzycompute();
        }
        return this.continueAndCancelOptions;
    }

    public void checkWithUserBeforeOpeningModelFromFutureVersion(String version) throws UserCancelException {
        String message = I18N$.MODULE$.gui().getN("file.open.warn.version.newer", Predef$.MODULE$.wrapRefArray(new Object[]{Version$.MODULE$.version(), version}));
        if (OptionDialog$.MODULE$.showMessage(this.owner, "NetLogo", message, this.continueAndCancelOptions()) != 0) {
            throw new UserCancelException();
        }
    }

    public void checkWithUserBeforeOpening3DModelin2D(String version) throws UserCancelException {
        String message = I18N$.MODULE$.gui().getN("file.open.warn.intwod.openthreed", Predef$.MODULE$.wrapRefArray(new Object[]{Version$.MODULE$.version(), version}));
        if (OptionDialog$.MODULE$.showMessage(this.owner, "NetLogo", message, this.continueAndCancelOptions()) != 0) {
            throw new UserCancelException();
        }
    }

    public void checkWithUserBeforeOpening2DModelin3D() throws UserCancelException {
        String message = I18N$.MODULE$.gui().getN("file.open.warn.inthreed.opentwod", Predef$.MODULE$.wrapRefArray(new Object[]{Version$.MODULE$.version()}));
        if (OptionDialog$.MODULE$.showMessage(this.owner, "NetLogo", message, this.continueAndCancelOptions()) != 0) {
            throw new UserCancelException();
        }
    }

    public void notifyUserNotValidFile(URI uri) throws UserCancelException {
        String warningText = (String)Try$.MODULE$.apply((Function0<Path> & Serializable & scala.Serializable)() -> Paths.get(uri)).toOption().map((Function1<Path, String> & Serializable & scala.Serializable)path -> I18N$.MODULE$.gui().getN("file.open.error.invalidmodel.withPath", Predef$.MODULE$.wrapRefArray(new Object[]{((Object)path).toString()}))).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> I18N$.MODULE$.gui().get("file.open.error.invalidmodel"));
        Object[] options = new Object[]{I18N$.MODULE$.gui().get("common.buttons.ok")};
        OptionDialog$.MODULE$.showMessage(this.owner, "NetLogo", warningText, options);
        throw new UserCancelException();
    }

    public boolean showVersionWarningAndGetResponse(String version) {
        String message = I18N$.MODULE$.gui().getN("file.open.warn.version.older", Predef$.MODULE$.wrapRefArray(new Object[]{version, Version$.MODULE$.version()}));
        Object[] options = new Object[]{I18N$.MODULE$.gui().get("common.buttons.continue"), I18N$.MODULE$.gui().get("file.open.warn.version.transitionGuide"), I18N$.MODULE$.gui().get("common.buttons.cancel")};
        int response = OptionDialog$.MODULE$.showMessage(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), message, options);
        switch (response) {
            case 0: {
                return true;
            }
            case 1: {
                BrowserLauncher$.MODULE$.openURI(this.owner, new URI(I18N$.MODULE$.gui().get("file.open.transitionGuide.url")));
                return this.showVersionWarningAndGetResponse(version);
            }
            case 2: {
                return false;
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(response));
    }

    @Override
    public Option<URI> chooseFilePath(ModelType modelType) {
        String extensionPath;
        Path path;
        block5: {
            block4: {
                String userPath;
                String newFileName = this.guessFileName();
                ModelType modelType2 = this.modelTracker.getModelType();
                ModelType$Normal$ modelType$Normal$ = ModelType$Normal$.MODULE$;
                if (!(modelType2 != null ? !modelType2.equals(modelType$Normal$) : modelType$Normal$ != null)) {
                    FileDialog$.MODULE$.setDirectory(this.modelTracker.getModelDir());
                }
                if (!(path = Paths.get(extensionPath = FileIO$.MODULE$.ensureExtension(userPath = FileDialog$.MODULE$.showFiles(this.owner, I18N$.MODULE$.gui().get("menu.file.saveAs"), 1, newFileName), ModelReader$.MODULE$.modelSuffix()), new String[0])).toFile().exists()) break block4;
                String string2 = userPath;
                if (string2 != null ? !string2.equals(extensionPath) : extensionPath != null) break block5;
            }
            return new Some<URI>(path.toUri());
        }
        return FileDialog$.MODULE$.confirmFileOverwrite(this.owner, extensionPath).map((Function1<String, URI> & Serializable & scala.Serializable)x$2 -> path.toUri());
    }

    private String guessFileName() {
        return FileIO$.MODULE$.ensureExtension(this.modelTracker.modelNameForDisplay(), ModelReader$.MODULE$.modelSuffix());
    }

    @Override
    public boolean shouldSaveModelOfDifferingVersion(String version) {
        block3: {
            block2: {
                if (Version$.MODULE$.compatibleVersion(version)) break block2;
                Object[] options = new Object[]{I18N$.MODULE$.gui().get("common.buttons.save"), I18N$.MODULE$.gui().get("common.buttons.cancel")};
                String message = I18N$.MODULE$.gui().getN("file.save.warn.savingInNewerVersion", Predef$.MODULE$.wrapRefArray(new Object[]{version, Version$.MODULE$.version()}));
                if (!(OptionDialog$.MODULE$.showMessage(this.owner, "NetLogo", message, options) == 0)) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public void warnInvalidFileFormat(String format2) {
        Object[] options = new Object[]{I18N$.MODULE$.gui().get("common.buttons.ok")};
        String message = I18N$.MODULE$.gui().getN("file.save.warn.invalidFormat", Predef$.MODULE$.wrapRefArray(new Object[]{format2}));
        OptionDialog$.MODULE$.showMessage(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), message, options);
    }

    public static final /* synthetic */ void $anonfun$showAutoconversionError$2(Exception e) {
        Predef$.MODULE$.println(e);
        e.printStackTrace();
    }

    public static final /* synthetic */ void $anonfun$showAutoconversionError$1(ConversionError x$1) {
        x$1.errors().foreach((Function1<Exception, Object> & Serializable & scala.Serializable)e -> {
            FileController.$anonfun$showAutoconversionError$2(e);
            return BoxedUnit.UNIT;
        });
    }

    public FileController(Component owner, ModelTracker modelTracker) {
        this.owner = owner;
        this.modelTracker = modelTracker;
    }
}

