/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JOptionPane;
import org.nlogo.swing.BrowserLauncher;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcZ$sp;

public final class BrowserLauncher$ {
    public static BrowserLauncher$ MODULE$;
    private final String osName;
    private final String unableToOpenBrowserError;
    private volatile byte bitmap$init$0;

    static {
        new BrowserLauncher$();
    }

    private String osName() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/swing/BrowserLauncher.scala: 13");
        }
        return this.osName;
    }

    public String unableToOpenBrowserError() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/swing/BrowserLauncher.scala: 14");
        }
        return this.unableToOpenBrowserError;
    }

    public void openURL(Component comp, String urlString, boolean local) {
        if (local) {
            this.openPath(comp, Paths.get(urlString, new String[0]), "");
            return;
        }
        Option$.MODULE$.apply(this.makeURI(comp, urlString)).foreach((Function1<URI, Object> & Serializable & scala.Serializable)x$1 -> {
            BrowserLauncher$.MODULE$.openURI(comp, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void openURI(Component comp, URI uri) {
        try {
            if (!BoxesRunTime.unboxToBoolean(this.desktop().map((Function1<Desktop, Object> & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean(BrowserLauncher$.$anonfun$openURI$1(uri, d))).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> false))) {
                ((Function1)this.osSpecificBrowserRunner().getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> MODULE$.browserNotFound())).apply(uri.toString());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            JOptionPane.showMessageDialog(comp, this.unableToOpenBrowserError());
            return;
        }
        catch (BrowserLauncher.BrowserNotFoundException ex) {
            JOptionPane.showMessageDialog(comp, ex.getLocalizedMessage());
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(comp, new StringBuilder(72).append("Unable to open a browser to: ").append(uri.toString()).append("\n").append("Please report to bugs@ccl.northwestern.edu").toString());
        }
    }

    public void openPath(Component comp, Path path, String anchor) {
        URI u = path.toUri();
        if (anchor == null || anchor.equals("")) {
            this.openURI(comp, u);
            return;
        }
        URI uriWithAnchor = new URI(u.getScheme(), u.getHost(), u.getPath(), anchor);
        Path redirectFile = Files.createTempFile("redirectHelper", ".html", new FileAttribute[0]);
        Files.write(redirectFile, this.redirectHelper(uriWithAnchor).getBytes("UTF-8"), new OpenOption[0]);
        this.openURI(comp, redirectFile.toUri());
    }

    private String redirectHelper(URI targetUri) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("|<html>\n        |<head><meta http-equiv=\"refresh\" content=\"0;url=").append(targetUri).append("\" /></head>\n        |<body>\n        |<script type=\"text/javascript\">onload=\"window.location = '").append(targetUri).append("'\"</script>\n        |</body>\n        |</html>").toString())).stripMargin();
    }

    public URI makeURI(Component comp, String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException uRISyntaxException) {
            JOptionPane.showMessageDialog(comp, new StringBuilder(72).append("Unable to open a browser to: ").append(s).append("\n").append("Please report to bugs@ccl.northwestern.edu").toString());
            return null;
        }
    }

    public Path docPath(String docName) {
        String docRoot = System.getProperty("netlogo.docs.dir", "docs");
        return Paths.get(new StringBuilder(1).append(docRoot).append("/").append(docName).toString(), new String[0]);
    }

    private Option<Desktop> desktop() {
        if (Desktop.isDesktopSupported()) {
            return new Some<Desktop>(Desktop.getDesktop());
        }
        return None$.MODULE$;
    }

    private Option<Function1<String, BoxedUnit>> osSpecificBrowserRunner() throws BrowserLauncher.BrowserNotFoundException {
        if (this.osName().startsWith("Windows")) {
            return new Some<Function1<String, Object> & Serializable & scala.Serializable>((Function1<String, Object> & Serializable & scala.Serializable)urlString -> {
                BrowserLauncher$.MODULE$.runCommand((String[])((Object[])new String[]{"cmd.exe", "/c", "start", "\"\"", new StringBuilder(2).append("\"").append(urlString).append("\"").toString()}));
                return BoxedUnit.UNIT;
            });
        }
        if (this.osName().startsWith("Mac")) {
            return None$.MODULE$;
        }
        return new Some<Function1<String, Object> & Serializable & scala.Serializable>((Function1<String, Object> & Serializable & scala.Serializable)urlString -> {
            BrowserLauncher$.$anonfun$osSpecificBrowserRunner$2(urlString);
            return BoxedUnit.UNIT;
        });
    }

    private Process runCommand(String[] cmd) {
        return Runtime.getRuntime().exec(cmd);
    }

    private Nothing$ browserNotFound() {
        throw new BrowserLauncher.BrowserNotFoundException(this.unableToOpenBrowserError());
    }

    private Nothing$ firefoxNotFound(Exception ex) {
        throw new BrowserLauncher.BrowserNotFoundException(new StringBuilder(245).append("NetLogo could not find and execute a web browser named 'firefox'.Please install Firefox and ensure that the 'firefox' command is in your executable PATH.  Firefox is available here:\n http://www.mozilla.com/firefox/\n\nThe full error message was:\n ").append(ex.getLocalizedMessage()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$openURI$1(URI uri$1, Desktop d) {
        d.browse(uri$1);
        return true;
    }

    public static final /* synthetic */ void $anonfun$osSpecificBrowserRunner$2(String urlString) {
        try {
            if (MODULE$.runCommand((String[])((Object[])new String[]{"firefox", "-remote", new StringBuilder(11).append("'openURL(").append(urlString).append(")'").toString()})).waitFor() != 0) {
                MODULE$.runCommand((String[])((Object[])new String[]{"firefox", urlString}));
            }
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
        catch (IOException ex) {
            throw MODULE$.firefoxNotFound(ex);
        }
    }

    private BrowserLauncher$() {
        MODULE$ = this;
        this.osName = System.getProperty("os.name");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.unableToOpenBrowserError = "We were unable to open a browser on your system.\nThis error can be reported to bugs@ccl.northwestern.edu";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

