/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.ObjectOutputStream;
import java.util.Date;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.Version$;
import org.nlogo.hubnet.connection.AbstractConnection;
import org.nlogo.hubnet.connection.MessageEnvelope;
import org.nlogo.hubnet.connection.Streamable;
import org.nlogo.hubnet.protocol.ActivityCommand;
import org.nlogo.hubnet.protocol.DisableView$;
import org.nlogo.hubnet.protocol.EnterMessage$;
import org.nlogo.hubnet.protocol.ExitMessage;
import org.nlogo.hubnet.protocol.HandshakeFromClient;
import org.nlogo.hubnet.protocol.LoginFailure;
import org.nlogo.hubnet.protocol.Message;
import org.nlogo.hubnet.server.ConnectionManagerInterface;
import org.nlogo.hubnet.server.HubNetUtils$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011)\u0019!C\u0001[!A1\b\u0001B\u0001B\u0003%a\u0006\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d1\u0005\u00011A\u0005\n\u001dCq\u0001\u0014\u0001A\u0002\u0013%Q\n\u0003\u0004T\u0001\u0001\u0006K\u0001\u0013\u0005\b)\u0002\u0001\r\u0011\"\u0003H\u0011\u001d)\u0006\u00011A\u0005\nYCa\u0001\u0017\u0001!B\u0013A\u0005bB/\u0001\u0001\u0004%\t!\f\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0011\u0019\t\u0007\u0001)Q\u0005]!)!\r\u0001C!G\u001a9\u0011\u000e\u0001I\u0001$\u0003Q\u0007\"B6\u0011\r\u0003a\u0007\"B6\u0001\t\u0013)\b\"B<\u0001\t\u0013A\b\"B>\u0001\t\u0003b\b\"B>\u0001\t\u0003q\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0002\u0015'\u0016\u0014h/\u001a:TS\u0012,7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005eQ\u0012AB:feZ,'O\u0003\u0002\u001c9\u00051\u0001.\u001e2oKRT!!\b\u0010\u0002\u000b9dwnZ8\u000b\u0003}\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015R\u0012AC2p]:,7\r^5p]&\u0011q\u0005\n\u0002\u0013\u0003\n\u001cHO]1di\u000e{gN\\3di&|g.A\td_:tWm\u0019;j_:\u001cFO]3b[N\u0004\"a\t\u0016\n\u0005-\"#AC*ue\u0016\fW.\u00192mK\u0006i!/Z7pi\u0016\fE\r\u001a:fgN,\u0012A\f\t\u0003_ar!\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M\u0002\u0013A\u0002\u001fs_>$hHC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9D'\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c5\u00039\u0011X-\\8uK\u0006#GM]3tg\u0002\u0002\"!\u0010 \u000e\u0003aI!a\u0010\r\u00035\r{gN\\3di&|g.T1oC\u001e,'/\u00138uKJ4\u0017mY3\u0002\rqJg.\u001b;?)\u0011\u00115\tR#\u0011\u0005u\u0002\u0001\"\u0002\u0015\u0006\u0001\u0004I\u0003\"\u0002\u0017\u0006\u0001\u0004q\u0003\"B\r\u0006\u0001\u0004a\u0014A\u0005<bY&$7\t\\5f]R4VM]:j_:,\u0012\u0001\u0013\t\u0003\u0013*k\u0011\u0001N\u0005\u0003\u0017R\u0012qAQ8pY\u0016\fg.\u0001\fwC2LGm\u00117jK:$h+\u001a:tS>tw\fJ3r)\tq\u0015\u000b\u0005\u0002J\u001f&\u0011\u0001\u000b\u000e\u0002\u0005+:LG\u000fC\u0004S\u000f\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'A\nwC2LGm\u00117jK:$h+\u001a:tS>t\u0007%A\u0007eSN\u001cwN\u001c8fGRLgnZ\u0001\u0012I&\u001c8m\u001c8oK\u000e$\u0018N\\4`I\u0015\fHC\u0001(X\u0011\u001d\u0011&\"!AA\u0002!\u000ba\u0002Z5tG>tg.Z2uS:<\u0007\u0005\u000b\u0002\f5B\u0011\u0011jW\u0005\u00039R\u0012\u0001B^8mCRLG.Z\u0001\tG2LWM\u001c;JI\u0006a1\r\\5f]RLEm\u0018\u0013fcR\u0011a\n\u0019\u0005\b%6\t\t\u00111\u0001/\u0003%\u0019G.[3oi&#\u0007%A\u0006sK\u000e,\u0017N^3ECR\fGC\u0001(e\u0011\u0015)w\u00021\u0001g\u0003\u0005\t\u0007CA%h\u0013\tAGG\u0001\u0004B]f\u0014VM\u001a\u0002\u000f\u001b\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s'\t\u0001b-A\u0007iC:$G.Z'fgN\fw-\u001a\u000b\u0003\u001d6DQA\\\tA\u0002=\fq!\\3tg\u0006<W\r\u0005\u0002qg6\t\u0011O\u0003\u0002s5\u0005A\u0001O]8u_\u000e|G.\u0003\u0002uc\n9Q*Z:tC\u001e,GC\u0001(w\u0011\u0015q'\u00031\u0001p\u0003\u001d!\u0017.\u001a%be\u0012$\"AT=\t\u000bi\u001c\u0002\u0019\u0001\u0018\u0002\rI,\u0017m]8o\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0003\u001dvDQA\u001f\u000bA\u00029\"BAT@\u0002\u0004!1\u0011\u0011A\u000bA\u0002!\u000bAB\\8uS\u001aL8\t\\5f]RDQA_\u000bA\u00029\n\u0001\u0002[1oI2,W\t\u001f\u000b\u0006\u001d\u0006%\u0011q\u0004\u0005\b\u0003\u00171\u0002\u0019AA\u0007\u0003\u0005)\u0007\u0003BA\b\u00033qA!!\u0005\u0002\u00169\u0019\u0011'a\u0005\n\u0003UJ1!a\u00065\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0007\u0002\u001e\tIQ\t_2faRLwN\u001c\u0006\u0004\u0003/!\u0004BBA\u0011-\u0001\u0007\u0001*A\u0005tK:$\u0017N\\4Fq\u0002")
public class ServerSideConnection
extends AbstractConnection {
    private final String remoteAddress;
    private final ConnectionManagerInterface server;
    private boolean validClientVersion;
    private volatile boolean disconnecting;
    private String clientId;
    private volatile byte bitmap$init$0;

    public String remoteAddress() {
        return this.remoteAddress;
    }

    private boolean validClientVersion() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/hubnet/server/ServerSideConnection.scala: 32");
        }
        return this.validClientVersion;
    }

    private void validClientVersion_$eq(boolean x$1) {
        this.validClientVersion = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private boolean disconnecting() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/hubnet/server/ServerSideConnection.scala: 33");
        }
        return this.disconnecting;
    }

    private void disconnecting_$eq(boolean x$1) {
        this.disconnecting = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public String clientId() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/hubnet/server/ServerSideConnection.scala: 34");
        }
        return this.clientId;
    }

    public void clientId_$eq(String x$1) {
        this.clientId = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    @Override
    public void receiveData(Object a) {
        if (a instanceof String) {
            String string2 = (String)a;
            if (this.clientId() == null) {
                String string3 = string2;
                String string4 = Version$.MODULE$.version();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    this.validClientVersion_$eq(true);
                }
                this.sendData(Version$.MODULE$.version());
                return;
            }
            this.dieHard(new StringBuilder(31).append("Received message out of order: ").append(a).toString());
            return;
        }
        if (a instanceof Message) {
            Message message = (Message)a;
            this.handleMessage(message);
            return;
        }
        this.dieHard(new StringBuilder(22).append("Unknown message type: ").append(a.getClass()).toString());
    }

    private void handleMessage(Message message) {
        block25: {
            block26: {
                String clientType;
                String userId;
                block28: {
                    block27: {
                        if (!(message instanceof HandshakeFromClient)) break block26;
                        HandshakeFromClient handshakeFromClient = (HandshakeFromClient)message;
                        userId = handshakeFromClient.userId();
                        clientType = handshakeFromClient.clientType();
                        if (userId == null) break block27;
                        String string2 = userId.trim();
                        String string3 = "";
                        if (string2 == null || !string2.equals(string3)) break block28;
                    }
                    this.sendData(new LoginFailure("Server received empty username."));
                    return;
                }
                if (!this.validClientVersion()) {
                    this.sendData(new LoginFailure(new StringBuilder(134).append("The version of the HubNet Client you are using does not match the version of the server.\nPlease use the HubNet Client that comes with ").append(Version$.MODULE$.version()).toString()));
                    return;
                }
                if (!this.server.isSupportedClientType(clientType)) {
                    this.sendData(new LoginFailure(new StringBuilder(73).append("The HubNet model you are connected to does not support your client type: ").append(clientType).toString()));
                    return;
                }
                if (this.clientId() == null) {
                    try {
                        ObjectOutputStream objectOutputStream = this.output();
                        synchronized (objectOutputStream) {
                            if (this.server.finalizeConnection(this, userId)) {
                                this.clientId_$eq(userId);
                                this.sendData(this.server.createHandshakeMessage(clientType));
                                if (HubNetUtils$.MODULE$.viewMirroring()) {
                                    this.server.fullViewUpdate();
                                } else {
                                    this.sendData(DisableView$.MODULE$);
                                }
                                if (HubNetUtils$.MODULE$.plotMirroring()) {
                                    this.server.sendPlots(userId);
                                }
                            } else {
                                this.sendData(new LoginFailure(new StringBuilder(64).append("\"").append(userId).append("\" is already taken by another user.\nPlease choose another name.").toString()));
                            }
                            break block25;
                        }
                    }
                    catch (RuntimeException ex) {
                        Exceptions$.MODULE$.handle(ex);
                        return;
                    }
                }
                break block25;
            }
            if (EnterMessage$.MODULE$.equals(message)) {
                if (this.clientId() != null) {
                    this.server.putClientData(new MessageEnvelope.EnterMessageEnvelope(this.clientId()));
                    return;
                }
                this.dieHard("Client login failed, please try logging in again");
                return;
            }
            if (message instanceof ActivityCommand) {
                ActivityCommand activityCommand = (ActivityCommand)message;
                if (this.clientId() != null) {
                    this.server.putClientData(new MessageEnvelope.ActivityMessageEnvelope(this.clientId(), activityCommand.tag(), activityCommand.content()));
                    return;
                }
                this.dieHard("Client login failed, please try logging in again");
                return;
            }
            if (message instanceof ExitMessage) {
                String reason = ((ExitMessage)message).reason();
                if (this.clientId() != null) {
                    this.server.removeClient(this.clientId(), false, reason);
                    return;
                }
                this.disconnect("Disconnecting client");
                return;
            }
            this.dieHard(new StringBuilder(22).append("Unknown message type: ").append(message.getClass()).toString());
        }
    }

    private void dieHard(String reason) {
        if (!this.server.removeClient(this.clientId(), true, reason)) {
            this.waitForSendData(new ExitMessage(reason));
            this.stopWriting();
            super.disconnect(reason);
        }
    }

    @Override
    public void disconnect(String reason) {
        if (!this.disconnecting()) {
            this.disconnecting_$eq(true);
            if (!this.server.removeClient(this.clientId(), false, reason)) {
                this.stopWriting();
                super.disconnect(reason);
                return;
            }
        }
    }

    public void disconnect(boolean notifyClient, String reason) {
        this.disconnecting_$eq(true);
        if (this.clientId() != null) {
            this.server.putClientData(new MessageEnvelope.ExitMessageEnvelope(this.clientId()));
        }
        if (notifyClient) {
            this.sendData(new ExitMessage(reason));
        }
        this.stopWriting();
        super.disconnect(reason);
    }

    @Override
    public void handleEx(Exception e, boolean sendingEx) {
        if (!this.disconnecting()) {
            this.disconnecting_$eq(true);
            if (this.clientId() != null) {
                this.server.removeClient(this.clientId(), !sendingEx, e.toString());
            } else {
                this.stopWriting();
                super.disconnect(e.toString());
            }
            if (e instanceof ClassNotFoundException) {
                String message = new StringBuilder(163).append("An incompatible version of the HubNet Client tried logging in.\nPlease ensure that everyone is using the version of the HubNet Client that  came with this release. ").append(Version$.MODULE$.version()).toString();
                Exceptions$.MODULE$.handle(new Exception(message, e));
                return;
            }
            if (!sendingEx) {
                Exceptions$.MODULE$.handle(e);
                return;
            }
            System.err.println(new StringBuilder(5).append("@ ").append(new Date()).append(" : ").toString());
            System.err.println(new StringBuilder(19).append("sending exception:\n").append(e).toString());
            this.server.logMessage(e.getMessage());
        }
    }

    public ServerSideConnection(Streamable connectionStreams, String remoteAddress, ConnectionManagerInterface server) {
        this.remoteAddress = remoteAddress;
        this.server = server;
        super("ServerSideConnection", connectionStreams);
        this.validClientVersion = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.disconnecting = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.clientId = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public interface MessageHandler {
        public void handleMessage(Message var1);
    }
}

