/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import java.util.Random;
import java.util.StringTokenizer;

public strictfp final class MersenneTwisterFast
extends Random
implements Serializable,
Cloneable {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] __mt;
    private int mti;
    private int[] __mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;
    private static final String IDENTIFIER = "0";

    public MersenneTwisterFast clone() {
        MersenneTwisterFast result;
        try {
            result = (MersenneTwisterFast)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        result.__mag01 = (int[])result.__mag01.clone();
        result.__mt = (int[])result.__mt.clone();
        return result;
    }

    public String save() {
        StringBuilder result = new StringBuilder("0 " + this.__mag01[0] + " " + this.__mag01[1] + " " + this.mti + " " + this.__nextNextGaussian + " " + this.__haveNextNextGaussian);
        for (int i = 0; i < 624; ++i) {
            result.append(" ");
            result.append(Integer.toString(this.__mt[i]));
        }
        return result.toString();
    }

    public void load(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s);
        String identifier = tokenizer.nextToken();
        if (!identifier.equals(IDENTIFIER)) {
            throw new RuntimeException("identifier mismatch: expected \"0\", got \"" + identifier + "\"");
        }
        this.__mag01[0] = Integer.parseInt(tokenizer.nextToken());
        this.__mag01[1] = Integer.parseInt(tokenizer.nextToken());
        this.mti = Integer.parseInt(tokenizer.nextToken());
        this.__nextNextGaussian = Double.parseDouble(tokenizer.nextToken());
        String next = tokenizer.nextToken();
        if (next.equals("true")) {
            this.__haveNextNextGaussian = true;
        } else if (next.equals("false")) {
            this.__haveNextNextGaussian = false;
        } else {
            throw new RuntimeException("expected true or false, got \"" + next + "\"");
        }
        for (int i = 0; i < 624; ++i) {
            this.__mt[i] = Integer.parseInt(tokenizer.nextToken());
        }
        assert (!tokenizer.hasMoreTokens());
    }

    public MersenneTwisterFast() {
        this(System.nanoTime());
    }

    public MersenneTwisterFast(long seed) {
        this.setSeed(seed);
    }

    public MersenneTwisterFast(int[] array) {
        this.setSeed(array);
    }

    @Override
    public synchronized void setSeed(long seed) {
        this.__haveNextNextGaussian = false;
        this.__nextNextGaussian = 0.0;
        this.__mt = new int[624];
        this.__mag01 = new int[2];
        this.__mag01[0] = 0;
        this.__mag01[1] = -1727483681;
        this.__mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.__mt[this.mti] = 1812433253 * (this.__mt[this.mti - 1] ^ this.__mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.__mt[n] = this.__mt[n] & 0xFFFFFFFF;
        }
    }

    public synchronized void setSeed(int[] array) {
        int k;
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        int n = k = 624 > array.length ? 624 : array.length;
        while (k != 0) {
            this.__mt[i] = (this.__mt[i] ^ (this.__mt[i - 1] ^ this.__mt[i - 1] >>> 30) * 1664525) + array[j] + j;
            int n2 = i++;
            this.__mt[n2] = this.__mt[n2] & 0xFFFFFFFF;
            ++j;
            if (i >= 624) {
                this.__mt[0] = this.__mt[623];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.__mt[i] = (this.__mt[i] ^ (this.__mt[i - 1] ^ this.__mt[i - 1] >>> 30) * 1566083941) - i;
            int n3 = i++;
            this.__mt[n3] = this.__mt[n3] & 0xFFFFFFFF;
            if (i < 624) continue;
            this.__mt[0] = this.__mt[623];
            i = 1;
        }
        this.__mt[0] = Integer.MIN_VALUE;
    }

    @Override
    public int nextInt() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    public short nextShort() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (short)(y >>> 16);
    }

    public char nextChar() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (char)(y >>> 16);
    }

    @Override
    public boolean nextBoolean() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        return (y ^= y >>> 18) >>> 31 != 0;
    }

    public boolean nextBoolean(float probability) {
        int y;
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0f) {
            return false;
        }
        if (probability == 1.0f) {
            return true;
        }
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        return (float)((y ^= y >>> 18) >>> 8) / 1.6777216E7f < probability;
    }

    public boolean nextBoolean(double probability) {
        int z;
        int y;
        int kk;
        int[] mag01;
        int[] mt;
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
            }
            while (kk < 623) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                ++kk;
            }
            z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
            this.mti = 0;
        }
        z = this.__mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        return (double)(((long)(y >>> 6) << 27) + (long)((z ^= z >>> 18) >>> 5)) / 9.007199254740992E15 < probability;
    }

    public byte nextByte() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (byte)(y >>> 24);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            int y;
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.__mt;
                int[] mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            bytes[x] = (byte)(y >>> 24);
        }
    }

    @Override
    public long nextLong() {
        int z;
        int y;
        int kk;
        int[] mag01;
        int[] mt;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
            }
            while (kk < 623) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                ++kk;
            }
            z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
            this.mti = 0;
        }
        z = this.__mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return ((long)y << 32) + (long)z;
    }

    @Override
    public long nextLong(long n) {
        long val;
        int z;
        int y;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        do {
            int kk;
            int[] mag01;
            int[] mt;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
                }
                while (kk < 623) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                    ++kk;
                }
                z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
                this.mti = 0;
            }
            z = this.__mt[this.mti++];
            z ^= z >>> 11;
            z ^= z << 7 & 0x9D2C5680;
            z ^= z << 15 & 0xEFC60000;
        } while ((bits = ((long)y << 32) + (long)(z ^= z >>> 18) >>> 1) - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    @Override
    public double nextDouble() {
        int z;
        int y;
        int kk;
        int[] mag01;
        int[] mt;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
            }
            while (kk < 623) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                ++kk;
            }
            z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
            this.mti = 0;
        }
        z = this.__mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return (double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15;
    }

    @Override
    public double nextGaussian() {
        int b;
        int a;
        double v2;
        int z;
        int y;
        double v1;
        double s;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        do {
            int kk;
            int[] mag01;
            int[] mt;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
                }
                while (kk < 623) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                    ++kk;
                }
                z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
                this.mti = 0;
            }
            z = this.__mt[this.mti++];
            z ^= z >>> 11;
            z ^= z << 7 & 0x9D2C5680;
            z ^= z << 15 & 0xEFC60000;
            z ^= z >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    a = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ a >>> 1 ^ mag01[a & 1];
                }
                while (kk < 623) {
                    a = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ a >>> 1 ^ mag01[a & 1];
                    ++kk;
                }
                a = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ a >>> 1 ^ mag01[a & 1];
                this.mti = 0;
            }
            a = this.__mt[this.mti++];
            a ^= a >>> 11;
            a ^= a << 7 & 0x9D2C5680;
            a ^= a << 15 & 0xEFC60000;
            a ^= a >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    b = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ b >>> 1 ^ mag01[b & 1];
                }
                while (kk < 623) {
                    b = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ b >>> 1 ^ mag01[b & 1];
                    ++kk;
                }
                b = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ b >>> 1 ^ mag01[b & 1];
                this.mti = 0;
            }
            b = this.__mt[this.mti++];
            b ^= b >>> 11;
            b ^= b << 7 & 0x9D2C5680;
            b ^= b << 15 & 0xEFC60000;
        } while ((s = (v1 = 2.0 * ((double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15) - 1.0) * v1 + (v2 = 2.0 * ((double)(((long)(a >>> 6) << 27) + (long)((b ^= b >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * v2) >= 1.0 || s == 0.0);
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    @Override
    public float nextFloat() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (float)(y >>> 8) / 1.6777216E7f;
    }

    @Override
    public int nextInt(int n) {
        int val;
        int y;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            int y2;
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.__mt;
                int[] mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                    ++kk;
                }
                y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.__mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            return (int)((long)n * (long)(y2 >>> 1) >> 31);
        }
        do {
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.__mt;
                int[] mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
        } while ((bits = (y ^= y >>> 18) >>> 1) - (val = bits % n) + (n - 1) < 0);
        return val;
    }

    @Override
    protected int next(int bits) {
        throw new UnsupportedOperationException();
    }
}

