/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.mathml;

import java.awt.Color;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.image.typography.mathml.MathMLFont;

public class MathMLFontStyle<T>
extends FontStyle<T> {
    public static final AttributedCharacterIterator.Attribute TEXT_MODE = null;
    private MathInput mathInput = MathInput.LATEX;
    private boolean textMode;

    protected MathMLFontStyle(MathMLFont font, T col) {
        super(font, col);
    }

    public LayoutContext getLayoutContext() {
        LayoutContextImpl mlc = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
        Object col = this.colour;
        if (col instanceof Float[]) {
            Float[] mcol = (Float[])col;
            mlc.setParameter(Parameter.MATHCOLOR, (Object)new Color(mcol[0].floatValue(), mcol[1].floatValue(), mcol[2].floatValue()));
        } else if (col instanceof Float) {
            mlc.setParameter(Parameter.MATHCOLOR, (Object)new Color(((Float)col).floatValue(), ((Float)col).floatValue(), ((Float)col).floatValue()));
        }
        mlc.setParameter(Parameter.MATHSIZE, (Object)this.getFontSize());
        return mlc;
    }

    public MathInput getMathInput() {
        return this.mathInput;
    }

    public void setMathInput(MathInput input) {
        this.mathInput = input;
    }

    public boolean isTextMode() {
        return this.textMode;
    }

    @Override
    public void parseAttributes(Map<? extends AttributedCharacterIterator.Attribute, Object> attrs) {
        super.parseAttributes(attrs);
        if (attrs.containsKey(TEXT_MODE)) {
            this.textMode = (Boolean)attrs.get(TEXT_MODE);
        }
    }

    static enum MathInput {
        MATHML,
        LATEX;

    }
}

