/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.renderer;

import java.util.Arrays;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;

public class ScanRasteriser {
    private ScanRasteriser() {
    }

    public static void scanFill(List<Point2d> p, ScanLineListener listener) {
        int n = p.size();
        int miny = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            Point2d pt = p.get(i);
            miny = Math.min(miny, Math.round(pt.getY()));
            maxy = Math.max(maxy, Math.round(pt.getY()));
        }
        float[] scans = new float[n];
        for (int y = miny; y <= maxy; ++y) {
            int i;
            int nScans = 0;
            for (i = 0; i < n; ++i) {
                float x2;
                float x1;
                int index2;
                int index1;
                if (i == 0) {
                    index1 = n - 1;
                    index2 = 0;
                } else {
                    index1 = i - 1;
                    index2 = i;
                }
                Point2d p1 = p.get(index1);
                Point2d p2 = p.get(index2);
                float y1 = p1.getY();
                float y2 = p2.getY();
                if (y1 < y2) {
                    x1 = p1.getX();
                    x2 = p2.getX();
                } else {
                    if (!(y1 > y2)) continue;
                    y2 = p1.getY();
                    y1 = p2.getY();
                    x2 = p1.getX();
                    x1 = p2.getX();
                }
                if ((float)y >= y1 && (float)y < y2) {
                    scans[nScans++] = ((float)y - y1) * (x2 - x1) / (y2 - y1) + x1;
                    continue;
                }
                if (y != maxy || !((float)y > y1) || !((float)y <= y2)) continue;
                scans[nScans++] = ((float)y - y1) * (x2 - x1) / (y2 - y1) + x1;
            }
            Arrays.sort(scans, 0, nScans);
            for (i = 0; i < nScans; i += 2) {
                if (i + 1 >= nScans) continue;
                listener.process(Math.round(scans[i]), Math.round(scans[i + 1]), y);
            }
        }
    }

    public static interface ScanLineListener {
        public void process(int var1, int var2, int var3);
    }
}

