/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import Jama.Matrix;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.Comparator;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageProvider;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analyser.PixelAnalyser;
import org.openimaj.image.combiner.AccumulatingImageCombiner;
import org.openimaj.image.combiner.ImageCombiner;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.GridProcessor;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.PixelProcessor;
import org.openimaj.image.processor.Processor;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.renderer.RenderHints;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.math.geometry.path.Path2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public abstract class Image<Q, I extends Image<Q, I>>
implements Cloneable,
Serializable,
ImageProvider<I> {
    private static final long serialVersionUID = 1L;

    public void accumulateWith(AccumulatingImageCombiner<I, ?> combiner) {
        combiner.accumulate(this);
    }

    public abstract I abs();

    public I add(Image<?, ?> im) {
        Object newImage = this.clone();
        ((Image)newImage).addInplace((Q)im);
        return (I)newImage;
    }

    public I add(Q num) {
        Object newImage = this.clone();
        ((Image)newImage).addInplace(num);
        return (I)newImage;
    }

    public abstract I addInplace(Image<?, ?> var1);

    public abstract I addInplace(Q var1);

    public void analyseWith(ImageAnalyser<I> analyser) {
        analyser.analyseImage(this);
    }

    public void analyseWith(PixelAnalyser<Q> analyser) {
        analyser.reset();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                analyser.analysePixel(this.getPixel(x, y));
            }
        }
    }

    public void analyseWithMasked(FImage mask, PixelAnalyser<Q> analyser) {
        analyser.reset();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (mask.pixels[y][x] == 0.0f) continue;
                analyser.analysePixel(this.getPixel(x, y));
            }
        }
    }

    public abstract I clip(Q var1, Q var2);

    public abstract I clipMax(Q var1);

    public abstract I clipMin(Q var1);

    public abstract I clone();

    public abstract ImageRenderer<Q, I> createRenderer();

    public abstract ImageRenderer<Q, I> createRenderer(RenderHints var1);

    public <OUT extends Image<?, OUT>, OTHER extends Image<?, OTHER>> OUT combineWith(ImageCombiner<I, OTHER, OUT> combiner, OTHER other) {
        return combiner.combine(this, other);
    }

    public Q defaultBackgroundColour() {
        return this.createRenderer().defaultBackgroundColour();
    }

    public Q defaultForegroundColour() {
        return this.createRenderer().defaultForegroundColour();
    }

    public I divide(Image<?, ?> im) {
        Object newImage = this.clone();
        ((Image)newImage).divideInplace((Q)im);
        return (I)newImage;
    }

    public I divide(Q val) {
        Object newImage = this.clone();
        ((Image)newImage).divideInplace(val);
        return (I)newImage;
    }

    public abstract I divideInplace(Image<?, ?> var1);

    public abstract I divideInplace(Q var1);

    public void drawConnectedPoints(List<? extends Point2d> pts, Q col) {
        this.createRenderer().drawConnectedPoints(pts, col);
    }

    public Point2d[] drawCubicBezier(Point2d p1, Point2d p2, Point2d c1, Point2d c2, int thickness, Q col) {
        return this.createRenderer().drawCubicBezier(p1, p2, c1, c2, thickness, col);
    }

    public void drawImage(I image, int x, int y) {
        this.createRenderer().drawImage(image, x, y);
    }

    public void drawImage(I image, Point2d pt) {
        this.createRenderer().drawImage(image, (int)pt.getX(), (int)pt.getY());
    }

    public void drawImage(I image, int x, int y, Q ... ignoreList) {
        this.createRenderer().drawImage(image, x, y, ignoreList);
    }

    public void drawLine(int x1, int y1, double theta, int length, int thickness, Q col) {
        this.createRenderer().drawLine(x1, y1, theta, length, thickness, col);
    }

    public void drawLine(int x1, int y1, double theta, int length, Q col) {
        this.createRenderer().drawLine(x1, y1, theta, length, 1, col);
    }

    public void drawLine(int x0, int y0, int x1, int y1, int thickness, Q col) {
        this.createRenderer().drawLine(x0, y0, x1, y1, thickness, col);
    }

    public void drawLine(int x0, int y0, int x1, int y1, Q col) {
        this.createRenderer().drawLine(x0, y0, x1, y1, 1, col);
    }

    public void drawLine(Point2d p1, Point2d p2, Q col) {
        this.createRenderer().drawLine(p1, p2, col);
    }

    public void drawLine(Point2d p1, Point2d p2, int thickness, Q col) {
        this.createRenderer().drawLine(p1, p2, thickness, col);
    }

    public void drawLine(Path2d line, int thickness, Q col) {
        this.createRenderer().drawLine(line, thickness, col);
    }

    public void drawPath(Path2d line, int thickness, Q col) {
        this.createRenderer().drawPath(line, thickness, col);
    }

    public void drawLines(Iterable<? extends Path2d> lines, int thickness, Q col) {
        this.createRenderer().drawLines(lines, thickness, col);
    }

    public void drawPaths(Iterable<? extends Path2d> lines, int thickness, Q col) {
        this.createRenderer().drawPaths(lines, thickness, col);
    }

    public void drawPoint(Point2d p, Q col, int size) {
        this.createRenderer().drawPoint(p, col, size);
    }

    public void drawPoints(Iterable<? extends Point2d> pts, Q col, int size) {
        this.createRenderer().drawPoints(pts, col, size);
    }

    public void drawPolygon(Polygon p, int thickness, Q col) {
        this.createRenderer().drawPolygon(p, thickness, col);
    }

    public void drawPolygon(Polygon p, Q col) {
        this.createRenderer().drawPolygon(p, col);
    }

    public void drawPolygonFilled(Polygon p, Q col) {
        this.createRenderer().drawPolygonFilled(p, col);
    }

    public void drawShape(Shape s, int thickness, Q col) {
        this.createRenderer().drawShape(s, thickness, col);
    }

    public void drawShape(Shape p, Q col) {
        this.createRenderer().drawShape(p, col);
    }

    public void drawShapeFilled(Shape s, Q col) {
        this.createRenderer().drawShapeFilled(s, col);
    }

    public void drawText(AttributedString text, int x, int y) {
        this.createRenderer().drawText(text, x, y);
    }

    public void drawText(AttributedString text, Point2d pt) {
        this.createRenderer().drawText(text, pt);
    }

    public <F extends Font<F>> void drawText(String text, int x, int y, F f, int sz) {
        this.createRenderer().drawText(text, x, y, f, sz);
    }

    public <F extends Font<F>> void drawText(String text, int x, int y, F f, int sz, Q col) {
        this.createRenderer().drawText(text, x, y, f, sz, col);
    }

    public void drawText(String text, int x, int y, FontStyle<Q> f) {
        this.createRenderer().drawText(text, x, y, f);
    }

    public <F extends Font<F>> void drawText(String text, Point2d pt, F f, int sz) {
        this.createRenderer().drawText(text, pt, f, sz);
    }

    public <F extends Font<F>> void drawText(String text, Point2d pt, F f, int sz, Q col) {
        this.createRenderer().drawText(text, pt, f, sz, col);
    }

    public void drawText(String text, Point2d pt, FontStyle<Q> f) {
        this.createRenderer().drawText(text, pt, f);
    }

    public I extractCenter(int w, int h) {
        int sw = (int)Math.floor((this.getWidth() - w) / 2);
        int sh = (int)Math.floor((this.getHeight() - h) / 2);
        return this.extractROI(sw, sh, w, h);
    }

    public I extractCenter(int x, int y, int w, int h) {
        int sw = (int)Math.floor(x - w / 2);
        int sh = (int)Math.floor(y - h / 2);
        return this.extractROI(sw, sh, w, h);
    }

    public abstract I extractROI(int var1, int var2, I var3);

    public abstract I extractROI(int var1, int var2, int var3, int var4);

    public I extractROI(Rectangle r) {
        return this.extractROI((int)r.x, (int)r.y, (int)r.width, (int)r.height);
    }

    public abstract I fill(Q var1);

    public abstract I flipX();

    public abstract I flipY();

    public Rectangle getBounds() {
        return new Rectangle(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    public int getCols() {
        return this.getWidth();
    }

    public abstract Rectangle getContentArea();

    public abstract I getField(Field var1);

    public abstract I getFieldCopy(Field var1);

    public abstract I getFieldInterpolate(Field var1);

    public abstract int getHeight();

    public abstract Q getPixel(int var1, int var2);

    public Q getPixel(Pixel p) {
        return this.getPixel(p.x, p.y);
    }

    public abstract Comparator<? super Q> getPixelComparator();

    public abstract Q getPixelInterp(double var1, double var3);

    public abstract Q getPixelInterp(double var1, double var3, Q var5);

    public Q[] getPixelVector(Q[] f) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                f[x + y * this.getWidth()] = this.getPixel(x, y);
            }
        }
        return f;
    }

    public int getRows() {
        return this.getHeight();
    }

    public abstract int getWidth();

    public abstract I internalCopy(I var1);

    public abstract I internalAssign(I var1);

    public abstract I internalAssign(int[] var1, int var2, int var3);

    public abstract I inverse();

    public abstract Q max();

    public abstract Q min();

    public I multiply(Image<?, ?> im) {
        Object newImage = this.clone();
        ((Image)newImage).multiplyInplace((Q)im);
        return (I)newImage;
    }

    public I multiply(Q num) {
        Object newImage = this.clone();
        ((Image)newImage).multiplyInplace(num);
        return (I)newImage;
    }

    public abstract I multiplyInplace(Image<?, ?> var1);

    public abstract I multiplyInplace(Q var1);

    public abstract I newInstance(int var1, int var2);

    public abstract I normalise();

    public I padding(int paddingWidth, int paddingHeight) {
        return this.padding(paddingWidth, paddingHeight, null);
    }

    public I padding(int paddingWidth, int paddingHeight, Q paddingColour) {
        I out = this.newInstance(paddingWidth + this.getWidth() + paddingWidth, paddingHeight + this.getHeight() + paddingHeight);
        ((Image)out).createRenderer().drawImage(this, paddingWidth, paddingHeight);
        int rightLimit = paddingWidth + this.getWidth();
        int bottomLimit = paddingHeight + this.getHeight();
        if (paddingColour != null) {
            for (int y = 0; y < ((Image)out).getHeight(); ++y) {
                for (int x = 0; x < ((Image)out).getWidth(); ++x) {
                    if (x >= paddingWidth && x < rightLimit && y >= paddingHeight && y < bottomLimit) continue;
                    ((Image)out).setPixel(x, y, paddingColour);
                }
            }
        } else {
            for (int y = 0; y < ((Image)out).getHeight(); ++y) {
                for (int x = 0; x < ((Image)out).getWidth(); ++x) {
                    if (x >= paddingWidth && x < rightLimit && y >= paddingHeight && y < bottomLimit) continue;
                    if (x < paddingWidth && y < paddingHeight) {
                        ((Image)out).setPixel(x, y, this.getPixel(0, 0));
                        continue;
                    }
                    if (x < paddingWidth && y >= bottomLimit) {
                        ((Image)out).setPixel(x, y, this.getPixel(0, this.getHeight() - 1));
                        continue;
                    }
                    if (x >= rightLimit && y < paddingHeight) {
                        ((Image)out).setPixel(x, y, this.getPixel(this.getWidth() - 1, 0));
                        continue;
                    }
                    if (x >= rightLimit && y >= bottomLimit) {
                        ((Image)out).setPixel(x, y, this.getPixel(this.getWidth() - 1, this.getHeight() - 1));
                        continue;
                    }
                    if (x < paddingWidth) {
                        ((Image)out).setPixel(x, y, this.getPixel(0, y - paddingHeight));
                        continue;
                    }
                    if (x >= rightLimit) {
                        ((Image)out).setPixel(x, y, this.getPixel(this.getWidth() - 1, y - paddingHeight));
                        continue;
                    }
                    if (y < paddingHeight) {
                        ((Image)out).setPixel(x, y, this.getPixel(x - paddingWidth, 0));
                        continue;
                    }
                    if (y < bottomLimit) continue;
                    ((Image)out).setPixel(x, y, this.getPixel(x - paddingWidth, this.getHeight() - 1));
                }
            }
        }
        return out;
    }

    public I paddingSymmetric(int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        I out = this.newInstance(paddingLeft + this.getWidth() + paddingRight, paddingTop + this.getHeight() + paddingBottom);
        Object clone = this.clone();
        I hflip = ((Image)((Image)clone).clone()).flipX();
        ImageRenderer<Q, Object> rend = ((Image)out).createRenderer();
        rend.drawImage(clone, paddingLeft, paddingTop);
        int i = paddingLeft - this.getWidth();
        int c = 0;
        while (i > -this.getWidth()) {
            if (c % 2 == 0) {
                rend.drawImage(hflip, i, paddingTop);
            } else {
                rend.drawImage(clone, i, paddingTop);
            }
            i -= this.getWidth();
            ++c;
        }
        i = paddingLeft + this.getWidth();
        c = 0;
        while (i < paddingLeft + paddingRight + this.getWidth()) {
            if (c % 2 == 0) {
                rend.drawImage(hflip, i, paddingTop);
            } else {
                rend.drawImage(clone, i, paddingTop);
            }
            i += this.getWidth();
            ++c;
        }
        I centre = ((Image)out).extractROI(0, paddingTop, paddingLeft + this.getWidth() + paddingRight, this.getHeight());
        I yflip = ((Image)((Image)centre).clone()).flipY();
        int i2 = paddingTop - this.getHeight();
        int c2 = 0;
        while (i2 > -this.getHeight()) {
            if (c2 % 2 == 0) {
                rend.drawImage(yflip, 0, i2);
            } else {
                rend.drawImage(centre, 0, i2);
            }
            i2 -= this.getHeight();
            ++c2;
        }
        i2 = paddingTop + this.getHeight();
        c2 = 0;
        while (i2 < paddingTop + paddingBottom + this.getHeight()) {
            if (c2 % 2 == 0) {
                rend.drawImage(yflip, 0, i2);
            } else {
                rend.drawImage(centre, 0, i2);
            }
            i2 += this.getHeight();
            ++c2;
        }
        return out;
    }

    public I process(GridProcessor<Q, I> p) {
        int height = p.getVerticalGridElements();
        int width = p.getHorizontalGridElements();
        I newImage = this.newInstance(width, height);
        ((Image)newImage).zero();
        int gridWidth = this.getWidth() / width;
        int gridHeight = this.getHeight() / height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ((Image)newImage).setPixel(x, y, p.processGridElement(this.extractROI(gridWidth * x, gridHeight * y, gridWidth, gridHeight)));
            }
        }
        return newImage;
    }

    public I process(ImageProcessor<I> p) {
        Object newImage = this.clone();
        ((Image)newImage).processInplace(p);
        return (I)newImage;
    }

    public I process(KernelProcessor<Q, I> p) {
        return this.process(p, false);
    }

    public I process(KernelProcessor<Q, I> p, boolean pad) {
        Object newImage = this.clone();
        ((Image)newImage).zero();
        int kh = p.getKernelHeight();
        int kw = p.getKernelWidth();
        int hh = p.getKernelHeight() / 2;
        int hw = p.getKernelWidth() / 2;
        I tmp = this.newInstance(kw, kh);
        if (!pad) {
            for (int y = hh; y < this.getHeight() - (kh - hh); ++y) {
                for (int x = hw; x < this.getWidth() - (kw - hw); ++x) {
                    ((Image)newImage).setPixel(x, y, p.processKernel(this.extractROI(x - hw, y - hh, tmp)));
                }
            }
        } else {
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    ((Image)newImage).setPixel(x, y, p.processKernel(this.extractROI(x - hw, y - hh, tmp)));
                }
            }
        }
        return (I)newImage;
    }

    public I process(PixelProcessor<Q> p) {
        Object newImage = this.clone();
        ((Image)newImage).processInplace(p);
        return (I)newImage;
    }

    public I process(Processor<I> p) {
        Object newImage = this.clone();
        ((Image)newImage).processInplace(p);
        return (I)newImage;
    }

    public I processInplace(Processor<I> p) {
        if (p == null) {
            return (I)this;
        }
        if (p instanceof ImageProcessor) {
            return this.processInplace((ImageProcessor)p);
        }
        if (p instanceof KernelProcessor) {
            return this.processInplace((KernelProcessor)p);
        }
        if (p instanceof PixelProcessor) {
            return this.processInplace((PixelProcessor)((Object)p));
        }
        throw new UnsupportedOperationException("Unsupported Processor type");
    }

    public I processInplace(ImageProcessor<I> p) {
        p.processImage(this);
        return (I)this;
    }

    public I processInplace(KernelProcessor<Q, I> p) {
        return this.processInplace(p, false);
    }

    public I processInplace(KernelProcessor<Q, I> p, boolean pad) {
        I newImage = this.process(p, pad);
        this.internalAssign(newImage);
        return (I)this;
    }

    public I processInplace(PixelProcessor<Q> p) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.setPixel(x, y, p.processPixel(this.getPixel(x, y)));
            }
        }
        return (I)this;
    }

    public I processMasked(FImage mask, PixelProcessor<Q> p) {
        Object newImage = this.clone();
        ((Image)newImage).processMaskedInplace(mask, p);
        return (I)newImage;
    }

    public I processMaskedInplace(FImage mask, PixelProcessor<Q> p) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (mask.pixels[y][x] == 0.0f) continue;
                this.setPixel(x, y, p.processPixel(this.getPixel(x, y)));
            }
        }
        return (I)this;
    }

    public abstract void setPixel(int var1, int var2, Q var3);

    public I subtract(Image<?, ?> im) {
        Object newImage = this.clone();
        ((Image)newImage).subtractInplace((Q)im);
        return (I)newImage;
    }

    public I subtract(Q num) {
        Object newImage = this.clone();
        ((Image)newImage).subtractInplace(num);
        return (I)newImage;
    }

    public abstract I subtractInplace(Image<?, ?> var1);

    public abstract I subtractInplace(Q var1);

    public abstract I threshold(Q var1);

    public abstract byte[] toByteImage();

    public abstract int[] toPackedARGBPixels();

    public I transform(Matrix transform) {
        double[][][] extrema;
        boolean unset = true;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        for (double[][] ext : extrema = new double[][][]{new double[][]{{0.0}, {0.0}, {1.0}}, new double[][]{{0.0}, {this.getHeight()}, {1.0}}, new double[][]{{this.getWidth()}, {0.0}, {1.0}}, new double[][]{{this.getWidth()}, {this.getHeight()}, {1.0}}}) {
            Matrix tmp = transform.times(Matrix.constructWithCopy((double[][])ext));
            if (unset) {
                minX = maxX = tmp.get(0, 0);
                maxY = minY = tmp.get(1, 0);
                unset = false;
                continue;
            }
            if (tmp.get(0, 0) > maxX) {
                maxX = tmp.get(0, 0);
            }
            if (tmp.get(1, 0) > maxY) {
                maxY = tmp.get(1, 0);
            }
            if (tmp.get(0, 0) < minX) {
                minX = tmp.get(0, 0);
            }
            if (!(tmp.get(1, 0) < minY)) continue;
            minY = tmp.get(1, 0);
        }
        I output = this.newInstance((int)Math.abs(maxX - minX), (int)Math.abs(maxY - minY));
        Matrix invTrans = transform.inverse();
        double[][] invTransData = invTrans.getArray();
        for (int x = 0; x < ((Image)output).getWidth(); ++x) {
            for (int y = 0; y < ((Image)output).getHeight(); ++y) {
                double oldx = invTransData[0][0] * (double)x + invTransData[0][1] * (double)y + invTransData[0][2];
                double oldy = invTransData[1][0] * (double)x + invTransData[1][1] * (double)y + invTransData[1][2];
                double norm = invTransData[2][0] * (double)x + invTransData[2][1] * (double)y + invTransData[2][2];
                if ((oldx /= norm) < 0.0 || oldx >= (double)this.getWidth() || (oldy /= norm) < 0.0 || oldy >= (double)this.getHeight()) continue;
                ((Image)output).setPixel(x, y, this.getPixelInterp(oldx, oldy));
            }
        }
        return output;
    }

    public I trim() {
        Rectangle rect = this.getContentArea();
        return this.extractROI((int)rect.minX(), (int)rect.minY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public abstract I zero();

    public I shiftLeftInplace() {
        return this.shiftLeftInplace(1);
    }

    public I shiftRightInplace() {
        return this.shiftRightInplace(1);
    }

    public I shiftLeftInplace(int count) {
        return this.internalAssign(this.shiftLeft(count));
    }

    public I shiftRightInplace(int count) {
        return this.internalAssign(this.shiftRight(count));
    }

    public I shiftLeft() {
        return this.shiftLeft(1);
    }

    public I shiftLeft(int nPixels) {
        I output = this.newInstance(this.getWidth(), this.getHeight());
        I img = this.extractROI(0, 0, nPixels, this.getHeight());
        ((Image)output).createRenderer().drawImage(this.extractROI(nPixels, 0, this.getWidth() - nPixels, this.getHeight()), 0, 0);
        ((Image)output).createRenderer().drawImage(img, this.getWidth() - nPixels, 0);
        return output;
    }

    public I shiftRight() {
        return this.shiftRight(1);
    }

    public I shiftRight(int nPixels) {
        I output = this.newInstance(this.getWidth(), this.getHeight());
        I img = this.extractROI(this.getWidth() - nPixels, 0, nPixels, this.getHeight());
        ((Image)output).createRenderer().drawImage(this.extractROI(0, 0, this.getWidth() - nPixels, this.getHeight()), nPixels, 0);
        ((Image)output).createRenderer().drawImage(img, 0, 0);
        return output;
    }

    public I shiftUpInplace() {
        return this.shiftUpInplace(1);
    }

    public I shiftDownInplace() {
        return this.shiftDownInplace(1);
    }

    public I shiftUpInplace(int count) {
        return this.internalAssign(this.shiftUp(count));
    }

    public I shiftDownInplace(int count) {
        return this.internalAssign(this.shiftDown(count));
    }

    public I shiftUp() {
        return this.shiftUp(1);
    }

    public I shiftUp(int nPixels) {
        I output = this.newInstance(this.getWidth(), this.getHeight());
        I img = this.extractROI(0, 0, this.getWidth(), nPixels);
        ((Image)output).createRenderer().drawImage(this.extractROI(0, nPixels, this.getWidth(), this.getHeight() - nPixels), 0, 0);
        ((Image)output).createRenderer().drawImage(img, 0, this.getHeight() - nPixels);
        return output;
    }

    public I shiftDown() {
        return this.shiftDown(1);
    }

    public I shiftDown(int nPixels) {
        I output = this.newInstance(this.getWidth(), this.getHeight());
        I img = this.extractROI(0, this.getHeight() - nPixels, this.getWidth(), nPixels);
        ((Image)output).createRenderer().drawImage(this.extractROI(0, 0, this.getWidth(), this.getHeight() - nPixels), 0, nPixels);
        ((Image)output).createRenderer().drawImage(img, 0, 0);
        return output;
    }

    public I overlay(I image, int x, int y) {
        Object img = this.clone();
        ((Image)img).overlayInplace(image, x, y);
        return (I)img;
    }

    public abstract I overlayInplace(I var1, int var2, int var3);

    @Override
    public I getImage() {
        return (I)this;
    }

    public abstract I replace(Q var1, Q var2);

    public I extractCentreSubPix(Point2d centre, int width, int height) {
        return this.extractCentreSubPix(centre.getX(), centre.getY(), width, height);
    }

    public I extractCentreSubPix(float cx, float cy, int width, int height) {
        I out = this.newInstance(width, height);
        return this.extractCentreSubPix(cx, cy, out);
    }

    public I extractCentreSubPix(Point2d centre, I out) {
        return this.extractCentreSubPix(centre.getX(), centre.getY(), out);
    }

    public abstract I extractCentreSubPix(float var1, float var2, I var3);

    public static enum Field {
        ODD,
        EVEN;

    }
}

