/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public final class DOMBuilder {
    private static final Log LOGGER = LogFactory.getLog(DOMBuilder.class);
    @GuardedBy(value="itself")
    private final Transformer contentTransformer;
    @GuardedBy(value="itself")
    private final Transformer identityTransformer = this.createIdentityTransformer();
    @GuardedBy(value="itself")
    private final Transformer namespaceTransformer;

    protected DOMBuilder() {
        this.contentTransformer = this.createTransformer("/net/sourceforge/jeuclid/content/mathmlc2p.xsl", this.identityTransformer);
        this.namespaceTransformer = this.createTransformer("/net/sourceforge/jeuclid/addMathMLNamespace.xsl", this.identityTransformer);
    }

    private Transformer createIdentityTransformer() {
        Transformer transformer;
        block2: {
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerException transformerException) {
                LOGGER.warn((Object)transformerException.getMessage());
                transformer = null;
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return transformer;
    }

    private Transformer createTransformer(String string, Transformer transformer) {
        Transformer transformer2;
        try {
            transformer2 = TransformerFactory.newInstance().newTemplates(new StreamSource(DOMBuilder.class.getResourceAsStream(string))).newTransformer();
        }
        catch (TransformerException transformerException) {
            LOGGER.warn((Object)transformerException.getMessage());
            transformer2 = transformer;
        }
        return transformer2;
    }

    public static DOMBuilder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static DOMBuilder getDOMBuilder() {
        return DOMBuilder.getInstance();
    }

    public DocumentElement createJeuclidDom(Node node) {
        return this.createJeuclidDom(node, true);
    }

    public DocumentElement createJeuclidDom(Node node, boolean bl) {
        return this.createJeuclidDom(node, bl, false);
    }

    public DocumentElement createJeuclidDom(Node node, boolean bl, boolean bl2) {
        Node node2;
        Node node3;
        if (node instanceof Document) {
            node3 = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            node3 = node;
        } else if (node instanceof DocumentFragment) {
            node2 = node.getFirstChild();
            if (!(node2 instanceof Element)) {
                throw new IllegalArgumentException("Expected DocumentFragment with Element child");
            }
            node3 = node2;
        } else {
            throw new IllegalArgumentException("Unsupported node: " + node + ". Expected either Document, Element or DocumentFragment");
        }
        if (bl2) {
            node3 = this.applyTransform(node3, this.namespaceTransformer);
        }
        node2 = bl ? this.applyTransform(node3, this.contentTransformer) : this.applyTransform(node3, this.identityTransformer);
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentElement applyTransform(Node node, Transformer transformer) {
        DocumentElement documentElement;
        try {
            DOMSource dOMSource = new DOMSource(node);
            documentElement = new DocumentElement();
            DOMResult dOMResult = new DOMResult(documentElement);
            Transformer transformer2 = transformer;
            synchronized (transformer2) {
                transformer.transform(dOMSource, dOMResult);
            }
        }
        catch (TransformerException transformerException) {
            documentElement = null;
            LOGGER.warn((Object)transformerException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            documentElement = null;
            LOGGER.warn((Object)nullPointerException.getMessage());
        }
        catch (DOMException dOMException) {
            documentElement = null;
            LOGGER.warn((Object)dOMException.getMessage());
        }
        return documentElement;
    }

    private static final class SingletonHolder {
        private static final DOMBuilder INSTANCE = new DOMBuilder();

        private SingletonHolder() {
        }
    }
}

