/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPResponse
implements Response {
    private static Logger _log = Logger.getLogger(SOAPResponse.class);
    private List<Element> payload;
    private String errorCode;
    private String errorMessage;
    private final SOAPEnvelope envelope;

    public SOAPResponse(SOAPEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public void parse(Document document) {
        try {
            SOAPFault fault;
            SOAPBody body = (SOAPBody)this.envelope.getBody();
            if (Flickr.debugStream) {
                _log.debug((Object)"SOAP RESPONSE.parse");
                _log.debug((Object)body.getAsString());
            }
            if ((fault = (SOAPFault)body.getFault()) != null) {
                _log.warn((Object)("FAULT: " + fault.getAsString()));
                this.errorCode = fault.getFaultCode();
                this.errorMessage = fault.getFaultString();
            } else {
                Iterator i = body.getChildElements();
                while (i.hasNext()) {
                    Element bodyelement = (Element)i.next();
                    bodyelement.normalize();
                    this.payload = (List)XMLUtilities.getChildElements(bodyelement);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getStat() {
        return null;
    }

    @Override
    public Element getPayload() {
        if (this.payload.isEmpty()) {
            throw new RuntimeException("SOAP response payload has no elements");
        }
        return this.payload.get(0);
    }

    @Override
    public Collection<Element> getPayloadCollection() {
        return this.payload;
    }

    @Override
    public boolean isError() {
        return this.errorCode != null;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

