/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.py;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URLClassLoader;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.FileIO$;
import org.nlogo.extensions.py.PythonConfig;
import org.nlogo.extensions.py.PythonSubprocess;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class PythonExtension$ {
    public static PythonExtension$ MODULE$;
    private Option<PythonSubprocess> _pythonProcess;
    private final File extDirectory;
    private final String propFileName;
    private final File extCheckFile;
    private final File propFile;
    private final PythonConfig config;

    static {
        new PythonExtension$();
    }

    private Option<PythonSubprocess> _pythonProcess() {
        return this._pythonProcess;
    }

    private void _pythonProcess_$eq(Option<PythonSubprocess> x$1) {
        this._pythonProcess = x$1;
    }

    public File extDirectory() {
        return this.extDirectory;
    }

    private String propFileName() {
        return this.propFileName;
    }

    private File extCheckFile() {
        return this.extCheckFile;
    }

    private File propFile() {
        return this.propFile;
    }

    public PythonConfig config() {
        return this.config;
    }

    public PythonSubprocess pythonProcess() {
        return (PythonSubprocess)this._pythonProcess().getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new ExtensionException("Python process has not been started. Please run PY:SETUP before any other python extension primitive.");
        });
    }

    public void pythonProcess_$eq(PythonSubprocess proc) {
        this._pythonProcess().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this._pythonProcess_$eq((Option<PythonSubprocess>)new Some((Object)proc));
    }

    public void killPython() {
        this._pythonProcess().foreach((Function1 & java.io.Serializable & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this._pythonProcess_$eq((Option<PythonSubprocess>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHeadless() {
        if (GraphicsEnvironment.isHeadless()) return true;
        String string = System.getProperty("org.nlogo.preferHeadless");
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public Nothing$ pythonNotFound() {
        throw new ExtensionException("Couldn't find an appropriate version of Python. Please set the path to your Python executable in the configuration menu.");
    }

    public double validNum(double d) {
        double d2 = d;
        if (Predef$.MODULE$.double2Double(d2).isInfinite()) {
            throw new ExtensionException("Python reported a number too large for NetLogo.");
        }
        if (Predef$.MODULE$.double2Double(d2).isNaN()) {
            throw new ExtensionException("Python reported a non-numeric value from a mathematical operation.");
        }
        double d3 = d2;
        return d3;
    }

    private PythonExtension$() {
        MODULE$ = this;
        this._pythonProcess = None$.MODULE$;
        this.extDirectory = new File(((URLClassLoader)this.getClass().getClassLoader()).getURLs()[0].toURI().getPath()).getParentFile();
        this.propFileName = "python.properties";
        this.extCheckFile = new File(this.extDirectory(), this.propFileName());
        this.propFile = this.extCheckFile().exists() ? this.extCheckFile() : new File(FileIO$.MODULE$.perUserDir("py", FileIO$.MODULE$.perUserDir$default$2()), this.propFileName());
        this.config = new PythonConfig(this.propFile());
    }
}

