/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.list;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class SkippingListView<T>
extends AbstractList<T> {
    private List<T> list;
    private int[] skips;
    private int size;

    public SkippingListView(List<T> list, int ... skips) {
        if (skips == null) {
            skips = new int[]{};
        }
        this.list = list;
        this.size = list.size() - skips.length;
        this.skips = (int[])skips.clone();
        Arrays.sort(this.skips);
        for (int i = 0; i < skips.length; ++i) {
            int n = i;
            this.skips[n] = this.skips[n] - i;
        }
    }

    @Override
    public T get(int index) {
        int shift = Arrays.binarySearch(this.skips, index);
        if (shift < 0) {
            shift = -1 * (shift + 1);
        } else {
            while (shift < this.skips.length - 1 && this.skips[shift] == this.skips[shift + 1]) {
                ++shift;
            }
            ++shift;
        }
        return this.list.get(index + shift);
    }

    @Override
    public int size() {
        return this.size;
    }
}

