/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;
import org.openimaj.util.iterator.NumericIterable;

public class UniformLongRangeIterable
implements NumericIterable<Long> {
    private long stop;
    private long step;
    private long current;

    public UniformLongRangeIterable(long start, long stop, long step) {
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    public UniformLongRangeIterable(long start, long stop) {
        this(start, stop, 1L);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return UniformLongRangeIterable.this.current + UniformLongRangeIterable.this.step <= UniformLongRangeIterable.this.stop;
            }

            @Override
            public Long next() {
                long ret = UniformLongRangeIterable.this.current;
                UniformLongRangeIterable.this.current = UniformLongRangeIterable.this.current + UniformLongRangeIterable.this.step;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

