/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.hash.composition;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.util.hash.HashFunction;
import org.openimaj.util.hash.HashFunctionFactory;

public abstract class HashComposition<OBJECT>
implements HashFunction<OBJECT> {
    protected List<HashFunction<OBJECT>> hashFunctions;

    public HashComposition(List<HashFunction<OBJECT>> functions) {
        this.hashFunctions = functions;
    }

    @SafeVarargs
    public HashComposition(HashFunction<OBJECT> first, HashFunction<OBJECT> ... remainder) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        this.hashFunctions.add(first);
        for (HashFunction<OBJECT> r : remainder) {
            this.hashFunctions.add(r);
        }
    }

    public HashComposition(HashFunctionFactory<OBJECT> factory, int nFuncs) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        for (int i = 0; i < nFuncs; ++i) {
            this.hashFunctions.add(factory.create());
        }
    }
}

