/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseLongArray;

public class SparseBinSearchLongArray
extends SparseLongArray {
    protected int[] keys;
    protected long[] values;
    protected int used;

    public SparseBinSearchLongArray(long[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0L) continue;
            this.set(i, values[i]);
        }
    }

    public SparseBinSearchLongArray(int length, int used, int[] keys, long[] values) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (length < values.length) {
            throw new IllegalArgumentException("length is shorter than number of current values!");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys does not match number of values.");
        }
        this.length = length;
        this.used = used;
        this.keys = keys;
        this.values = values;
    }

    public SparseBinSearchLongArray(int length) {
        this(length, 10);
    }

    public SparseBinSearchLongArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.keys = new int[capacity];
        this.values = new long[capacity];
    }

    public SparseBinSearchLongArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.keys = new int[capacity];
        this.values = new long[capacity];
    }

    @Override
    public int[] indices() {
        return Arrays.copyOf(this.keys, this.used);
    }

    @Override
    public long[] values() {
        return Arrays.copyOf(this.values, this.used);
    }

    @Override
    public Iterable<SparseLongArray.DualEntry> unionEntries(SparseLongArray otherArray) {
        if (otherArray instanceof SparseBinSearchLongArray) {
            return this.unionEntries((SparseBinSearchLongArray)otherArray);
        }
        return super.unionEntries(otherArray);
    }

    public Iterable<SparseLongArray.DualEntry> unionEntries(final SparseBinSearchLongArray otherArray) {
        return new Iterable<SparseLongArray.DualEntry>(){

            @Override
            public Iterator<SparseLongArray.DualEntry> iterator() {
                return new Iterator<SparseLongArray.DualEntry>(){
                    private SparseLongArray.DualEntry entry = new SparseLongArray.DualEntry();
                    private int innerIndex = 0;
                    private int otherInnerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchLongArray.this.used || this.otherInnerIndex < otherArray.used;
                    }

                    @Override
                    public SparseLongArray.DualEntry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        if (this.innerIndex < SparseBinSearchLongArray.this.used && (this.otherInnerIndex >= otherArray.used || SparseBinSearchLongArray.this.keys[this.innerIndex] < otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = SparseBinSearchLongArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchLongArray.this.values[this.innerIndex];
                            this.entry.otherValue = 0L;
                            ++this.innerIndex;
                        } else if (this.otherInnerIndex < otherArray.used && (this.innerIndex >= SparseBinSearchLongArray.this.used || SparseBinSearchLongArray.this.keys[this.innerIndex] > otherArray.keys[this.otherInnerIndex])) {
                            this.entry.index = otherArray.keys[this.otherInnerIndex];
                            this.entry.value = 0L;
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.otherInnerIndex;
                        } else {
                            this.entry.index = SparseBinSearchLongArray.this.keys[this.innerIndex];
                            this.entry.value = SparseBinSearchLongArray.this.values[this.innerIndex];
                            this.entry.otherValue = otherArray.values[this.otherInnerIndex];
                            ++this.innerIndex;
                            ++this.otherInnerIndex;
                        }
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<SparseLongArray.Entry> entries() {
        return new Iterable<SparseLongArray.Entry>(){

            @Override
            public Iterator<SparseLongArray.Entry> iterator() {
                return new Iterator<SparseLongArray.Entry>(){
                    private SparseLongArray.Entry entry = new SparseLongArray.Entry();
                    private int innerIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.innerIndex < SparseBinSearchLongArray.this.used;
                    }

                    @Override
                    public SparseLongArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.entry.index = SparseBinSearchLongArray.this.keys[this.innerIndex];
                        this.entry.value = SparseBinSearchLongArray.this.values[this.innerIndex];
                        ++this.innerIndex;
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBinSearchLongArray)) {
            return false;
        }
        return this.length == ((SparseBinSearchLongArray)obj).length && this.used == ((SparseBinSearchLongArray)obj).used && Arrays.equals(this.keys, ((SparseBinSearchLongArray)obj).keys) && Arrays.equals(this.values, this.values);
    }

    @Override
    public long get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        return spot < 0 ? 0L : this.values[spot];
    }

    public int hashCode() {
        return this.length ^ Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean isUsed(int key) {
        return 0 <= Arrays.binarySearch(this.keys, 0, this.used, key);
    }

    @Override
    public long set(int key, long value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            this.values[spot] = value;
            return this.values[spot];
        }
        return this.update(-1 - spot, key, value);
    }

    @Override
    public long increment(int key, long value) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            int n = spot;
            long l = this.values[n] + value;
            this.values[n] = l;
            return l;
        }
        return this.update(-1 - spot, key, value);
    }

    private long update(int spot, int key, long value) {
        if (this.used == this.keys.length) {
            int capacity = this.keys.length * 3 / 2 + 1;
            this.keys = Arrays.copyOf(this.keys, capacity);
            this.values = Arrays.copyOf(this.values, capacity);
        }
        if (spot < this.used) {
            System.arraycopy(this.keys, spot, this.keys, spot + 1, this.used - spot);
            System.arraycopy(this.values, spot, this.values, spot + 1, this.used - spot);
        }
        ++this.used;
        this.keys[spot] = key;
        this.values[spot] = value;
        return this.values[spot];
    }

    @Override
    public int used() {
        return this.used;
    }

    @Override
    public void compact() {
        this.keys = Arrays.copyOf(this.keys, this.used);
        this.values = Arrays.copyOf(this.values, this.used);
    }

    @Override
    public SparseLongArray copy() {
        SparseBinSearchLongArray copy = new SparseBinSearchLongArray(this.length);
        copy.used = this.used;
        copy.keys = Arrays.copyOf(this.keys, this.keys.length);
        copy.values = Arrays.copyOf(this.values, this.values.length);
        return copy;
    }

    @Override
    public SparseLongArray reverse() {
        int len = this.used;
        int hlen = len / 2;
        for (int i = 0; i < hlen; ++i) {
            long tmpVal = this.values[i];
            this.values[i] = this.values[len - i - 1];
            this.values[len - i - 1] = tmpVal;
            int tmpKey = this.keys[i];
            this.keys[i] = this.length - this.keys[len - i - 1];
            this.keys[len - i - 1] = this.length - tmpKey;
        }
        return this;
    }
}

