/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableLong
implements ReadWriteable,
Comparable<ReadWriteableLong> {
    public long value;

    public ReadWriteableLong(long value) {
        this.value = value;
    }

    public ReadWriteableLong() {
        this.value = 0L;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.value = in.nextLong();
    }

    @Override
    public byte[] binaryHeader() {
        return new byte[0];
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.value + "\n");
    }

    public boolean equals(Object o) {
        return o instanceof ReadWriteableLong && ((ReadWriteableLong)o).value == this.value;
    }

    public int hashCode() {
        return new Long(this.value).hashCode();
    }

    @Override
    public int compareTo(ReadWriteableLong arg0) {
        return new Long(this.value).compareTo(arg0.value);
    }
}

