/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableByte
implements ReadWriteable,
Comparable<ReadWriteableByte> {
    public byte value;

    public ReadWriteableByte(byte value) {
        this.value = value;
    }

    public ReadWriteableByte() {
        this.value = 0;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.value = in.nextByte();
    }

    @Override
    public byte[] binaryHeader() {
        return new byte[0];
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.value + "\n");
    }

    public boolean equals(Object o) {
        return o instanceof ReadWriteableByte && ((ReadWriteableByte)o).value == this.value;
    }

    public int hashCode() {
        return new Byte(this.value).hashCode();
    }

    @Override
    public int compareTo(ReadWriteableByte arg0) {
        return new Byte(this.value).compareTo(arg0.value);
    }
}

