SYD-OFD(1)

# NAME

*syd-ofd* - Take a lock on a file, then execute into another program

# SYNOPSIS

*syd-ofd* _[-n | -N]_ _[-t timeout]_ _[-d fd]_ _[-s=-r | -x=-w]_ _file_ {command [arg...]}

# DESCRIPTION

syd-ofd takes a lock on a file, then executes into another program. It
is functionally identical to the _s6-setlock_(1) utility except it uses
OFD locks which are new in POSIX 2024. This lock type is also known as
"file-private locks" and is open file description-based rather than
process based like the old-style POSIX locks that _s6-setlock_(1) uses.
This allows _syd_(1) to pass the file descriptor to the sandbox process
and close its own copy while the sandbox process still holding the lock
which is not possible with old style locks and _s6-setlock_(1).

# OPTIONS

|[ *-h*
:< Display help.
|[ *-n*
:< Nonblocking lock. If syd-ofd cannot acquire the lock, it will exit 11 ("EAGAIN": Try again) immediately.
|[ *-N*
:< Blocking lock. syd-ofd will wait until it can acquire the lock. This is the default.
|[ *-t timeout*
:< Timed lock. If syd-ofd cannot acquire the lock after timeout milliseconds, it will exit 4 ("EINTR": Interrupted system call).
|[ *-s=-r*
:< Shared lock. Other shared locks on the same file will not prevent the lock from being acquired (but an exclusive lock will).
|[
:< The *-r* option is retained for compatibility with the _s6-setlock_(1) utility.
|[ *-x=-w*
:< Exclusive lock. This is the default.
|[
:< The *-w* option is retained for compatibility with the _s6-setlock_(1) utility.
|[ *-d fd*
:< Make the lock visible in _program_ on file descriptor _fd_.

# EXIT STATUS

On clean exit, *syd-ofd* exits with the same code as the child
process. On unclean termination, exit code is set to 128 plus signal
number. In case executing the child process fails *syd-ofd* exits
with the _errno_(3) number.

# SECURITY

*syd-ofd* uses _openat_(2) with the resolve flags RESOLVE_NO_MAGICLINKS
and RESOLVE_NO_SYMLINKS when opening or creating the lock file.
Consequently, if any component of the specified path is a symbolic link,
the call fails and returns error code 40 (ELOOP: "Too many symbolic
links encountered"). In the same manner, the presence of any *..*
(dot-dot) component in the lock-file path causes the call to fail and
return error code 13 (EACCES: "Permission denied"). This restriction is
intended to mitigate confused-deputy vulnerabilities during lock-file
creation and related file operations by preventing an intermediary or
less-privileged actor from redirecting the operation via symbolic links
or parent-directory (*..*) components to an unintended filesystem
location.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-lock_(1), _syd-mdwe_(1), _syd-pds_(1), _syd-sec_(1), _s6-setlock_(1), _fcntl_(2), _F_OFD_SETLKW(2const)_, _openat2_(2)

- *syd* homepage: https://sydbox.exherbo.org/
- *s6-setlock* manpage: https://skarnet.org/software/s6/s6-setlock.html
- *POSIX 2024* _fcntl_(2) manpage: https://pubs.opengroup.org/onlinepubs/9799919799/functions/fcntl.html

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
