//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package guestconfiguration

import original "github.com/Azure/azure-sdk-for-go/services/guestconfiguration/mgmt/2021-01-25/guestconfiguration"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActionAfterReboot = original.ActionAfterReboot

const (
	ActionAfterRebootContinueConfiguration ActionAfterReboot = original.ActionAfterRebootContinueConfiguration
	ActionAfterRebootStopConfiguration     ActionAfterReboot = original.ActionAfterRebootStopConfiguration
)

type AssignmentType = original.AssignmentType

const (
	AssignmentTypeApplyAndAutoCorrect  AssignmentType = original.AssignmentTypeApplyAndAutoCorrect
	AssignmentTypeApplyAndMonitor      AssignmentType = original.AssignmentTypeApplyAndMonitor
	AssignmentTypeAudit                AssignmentType = original.AssignmentTypeAudit
	AssignmentTypeDeployAndAutoCorrect AssignmentType = original.AssignmentTypeDeployAndAutoCorrect
)

type ComplianceStatus = original.ComplianceStatus

const (
	ComplianceStatusCompliant    ComplianceStatus = original.ComplianceStatusCompliant
	ComplianceStatusNonCompliant ComplianceStatus = original.ComplianceStatusNonCompliant
	ComplianceStatusPending      ComplianceStatus = original.ComplianceStatusPending
)

type ConfigurationMode = original.ConfigurationMode

const (
	ConfigurationModeApplyAndAutoCorrect ConfigurationMode = original.ConfigurationModeApplyAndAutoCorrect
	ConfigurationModeApplyAndMonitor     ConfigurationMode = original.ConfigurationModeApplyAndMonitor
	ConfigurationModeApplyOnly           ConfigurationMode = original.ConfigurationModeApplyOnly
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type Kind = original.Kind

const (
	KindDSC Kind = original.KindDSC
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCanceled  ProvisioningState = original.ProvisioningStateCanceled
	ProvisioningStateCreated   ProvisioningState = original.ProvisioningStateCreated
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
)

type Type = original.Type

const (
	TypeConsistency Type = original.TypeConsistency
	TypeInitial     Type = original.TypeInitial
)

type Assignment = original.Assignment
type AssignmentInfo = original.AssignmentInfo
type AssignmentList = original.AssignmentList
type AssignmentProperties = original.AssignmentProperties
type AssignmentReport = original.AssignmentReport
type AssignmentReportDetails = original.AssignmentReportDetails
type AssignmentReportList = original.AssignmentReportList
type AssignmentReportProperties = original.AssignmentReportProperties
type AssignmentReportResource = original.AssignmentReportResource
type AssignmentReportResourceComplianceReason = original.AssignmentReportResourceComplianceReason
type AssignmentReportType = original.AssignmentReportType
type AssignmentReportsClient = original.AssignmentReportsClient
type AssignmentReportsVMSSClient = original.AssignmentReportsVMSSClient
type AssignmentsClient = original.AssignmentsClient
type AssignmentsVMSSClient = original.AssignmentsVMSSClient
type BaseClient = original.BaseClient
type ConfigurationInfo = original.ConfigurationInfo
type ConfigurationParameter = original.ConfigurationParameter
type ConfigurationSetting = original.ConfigurationSetting
type ErrorResponse = original.ErrorResponse
type ErrorResponseError = original.ErrorResponseError
type HCRPAssignmentReportsClient = original.HCRPAssignmentReportsClient
type HCRPAssignmentsClient = original.HCRPAssignmentsClient
type Navigation = original.Navigation
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type VMInfo = original.VMInfo
type VMSSVMInfo = original.VMSSVMInfo

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAssignmentReportsClient(subscriptionID string) AssignmentReportsClient {
	return original.NewAssignmentReportsClient(subscriptionID)
}
func NewAssignmentReportsClientWithBaseURI(baseURI string, subscriptionID string) AssignmentReportsClient {
	return original.NewAssignmentReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssignmentReportsVMSSClient(subscriptionID string) AssignmentReportsVMSSClient {
	return original.NewAssignmentReportsVMSSClient(subscriptionID)
}
func NewAssignmentReportsVMSSClientWithBaseURI(baseURI string, subscriptionID string) AssignmentReportsVMSSClient {
	return original.NewAssignmentReportsVMSSClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssignmentsClient(subscriptionID string) AssignmentsClient {
	return original.NewAssignmentsClient(subscriptionID)
}
func NewAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) AssignmentsClient {
	return original.NewAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssignmentsVMSSClient(subscriptionID string) AssignmentsVMSSClient {
	return original.NewAssignmentsVMSSClient(subscriptionID)
}
func NewAssignmentsVMSSClientWithBaseURI(baseURI string, subscriptionID string) AssignmentsVMSSClient {
	return original.NewAssignmentsVMSSClientWithBaseURI(baseURI, subscriptionID)
}
func NewHCRPAssignmentReportsClient(subscriptionID string) HCRPAssignmentReportsClient {
	return original.NewHCRPAssignmentReportsClient(subscriptionID)
}
func NewHCRPAssignmentReportsClientWithBaseURI(baseURI string, subscriptionID string) HCRPAssignmentReportsClient {
	return original.NewHCRPAssignmentReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHCRPAssignmentsClient(subscriptionID string) HCRPAssignmentsClient {
	return original.NewHCRPAssignmentsClient(subscriptionID)
}
func NewHCRPAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) HCRPAssignmentsClient {
	return original.NewHCRPAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleActionAfterRebootValues() []ActionAfterReboot {
	return original.PossibleActionAfterRebootValues()
}
func PossibleAssignmentTypeValues() []AssignmentType {
	return original.PossibleAssignmentTypeValues()
}
func PossibleComplianceStatusValues() []ComplianceStatus {
	return original.PossibleComplianceStatusValues()
}
func PossibleConfigurationModeValues() []ConfigurationMode {
	return original.PossibleConfigurationModeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
