# - Locate HepMC library
# in a directory defined via  HEPMC2_ROOT_DIR or HEPMC2_DIR.
# Defines:
#
#  HEPMC2_FOUND
#  HEPMC2_INCLUDE_DIR
#  HEPMC2_INCLUDE_DIRS (not cached)
#  HEPMC2_LIBRARIES
if (HEPMC2_ROOT_DIR OR HEPMC2_DIR OR (DEFINED ENV{HEPMC2_ROOT_DIR}) OR (DEFINED ENV{HEPMC2_DIR}) )
  set(HEPMC2_SEARCH_DIRS "" CACHE STRING "" FORCE)
  if (HEPMC2_ROOT_DIR)
    list (APPEND HEPMC2_SEARCH_DIRS "${HEPMC2_ROOT_DIR}" )
  endif()
  if (HEPMC2_DIR)
    list (APPEND HEPMC2_SEARCH_DIRS "${HEPMC2_DIR}" )
  endif()
  if (DEFINED EVN{HEPMC2_ROOT_DIR})
    list (APPEND HEPMC2_SEARCH_DIRS "$ENV{HEPMC2_ROOT_DIR}" )
  endif()
  if (DEFINED ENV{HEPMC2_DIR})
    list (APPEND HEPMC2_SEARCH_DIRS "ENV{HEPMC2_DIR}" )
  endif()
endif()

if (HEPMC2_SEARCH_DIRS)
  find_path(HEPMC2_INCLUDE_DIR HepMC/GenEvent.h PATHS ${HEPMC2_SEARCH_DIRS} PATH_SUFFIXES include NO_DEFAULT_PATH)
  find_library(HEPMC2_HepMC_LIBRARY NAMES HepMC PATHS ${HEPMC2_SEARCH_DIRS}  PATH_SUFFIXES lib lib64 NO_DEFAULT_PATH)
  find_library(HEPMC2_HepMCfio_LIBRARY NAMES HepMCfio  PATHS ${HEPMC2_SEARCH_DIRS}  PATH_SUFFIXES lib lib64 NO_DEFAULT_PATH)
else()
  find_path(HEPMC2_INCLUDE_DIR HepMC/GenEvent.h PATH_SUFFIXES include)
  find_library(HEPMC2_HepMC_LIBRARY NAMES HepMC PATHS_SUFFIXES lib lib64)
  find_library(HEPMC2_HepMCfio_LIBRARY NAMES HepMCfio PATHS_SUFFIXES lib lib64)
endif()

set(HEPMC2_VERSION 0.0.0)
if (HEPMC2_INCLUDE_DIR)
  if (EXISTS ${HEPMC2_INCLUDE_DIR}/HepMC/HepMCDefs.h)
    file(STRINGS ${HEPMC2_INCLUDE_DIR}/HepMC/HepMCDefs.h HEPMC2_VERSION_STRING_CONTENT REGEX "^#define[ ]+HEPMC_VERSION[ ]+\"")
    string(REGEX MATCH "[1234567890\.]+[a-zA-Z]*" HEPMC2_VERSION ${HEPMC2_VERSION_STRING_CONTENT})
  endif()
endif()

if (HEPMC2_HepMC_LIBRARY)
  set(HEPMC2_LIBRARIES ${HEPMC2_HepMC_LIBRARY})
endif()
if (HEPMC2_HepMCfio_LIBRARY)
  set(HEPMC2_FIO_LIBRARIES ${HEPMC2_HepMCfio_LIBRARY})
  set(HepMC2_FIO_FOUND TRUE)
endif()

set(HEPMC2_INCLUDE_DIRS ${HEPMC2_INCLUDE_DIR})

# handle the QUIETLY and REQUIRED arguments and set HEPMC2_FOUND to TRUE if
# all listed variables are TRUE

INCLUDE(FindPackageHandleStandardArgs)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(HepMC2 FOUND_VAR HEPMC2_FOUND REQUIRED_VARS HEPMC2_INCLUDE_DIR HEPMC2_LIBRARIES HEPMC2_VERSION HANDLE_COMPONENTS)


if(HepMC2_FOUND AND NOT TARGET HepMC2::HepMC2)
    add_library(HepMC2::HepMC2 UNKNOWN IMPORTED)
    set_target_properties(HepMC2::HepMC2 PROPERTIES
        IMPORTED_LOCATION "${HEPMC2_HepMC_LIBRARY}"
        INTERFACE_INCLUDE_DIRECTORIES "${HEPMC2_INCLUDE_DIRS}"
    )
endif()

if(HepMC2_FIO_FOUND AND NOT TARGET HepMC2::HepMC2fio)
    add_library(HepMC2::HepMC2fio UNKNOWN IMPORTED)
    set_target_properties(HepMC2::HepMC2fio PROPERTIES
        IMPORTED_LOCATION "${HEPMC2_HepMCfio_LIBRARY}"
        INTERFACE_INCLUDE_DIRECTORIES "${HEPMC2_INCLUDE_DIRS}"
    )
endif()

mark_as_advanced(HepMC2_FOUND HEPMC2_INCLUDE_DIRS HEPMC2_LIBRARIES)
