/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Place {
    /// name of the transit stop / PoI / address
    #[serde(rename = "name")]
    pub name: String,
    /// The ID of the stop. This is often something that users don't care about.
    #[serde(rename = "stopId", skip_serializing_if = "Option::is_none")]
    pub stop_id: Option<String>,
    /// latitude
    #[serde(rename = "lat")]
    pub lat: f64,
    /// longitude
    #[serde(rename = "lon")]
    pub lon: f64,
    /// level according to OpenStreetMap
    #[serde(rename = "level")]
    pub level: f64,
    /// arrival time
    #[serde(rename = "arrival", skip_serializing_if = "Option::is_none")]
    pub arrival: Option<String>,
    /// departure time
    #[serde(rename = "departure", skip_serializing_if = "Option::is_none")]
    pub departure: Option<String>,
    /// scheduled arrival time
    #[serde(rename = "scheduledArrival", skip_serializing_if = "Option::is_none")]
    pub scheduled_arrival: Option<String>,
    /// scheduled departure time
    #[serde(rename = "scheduledDeparture", skip_serializing_if = "Option::is_none")]
    pub scheduled_departure: Option<String>,
    /// scheduled track from the static schedule timetable dataset
    #[serde(rename = "scheduledTrack", skip_serializing_if = "Option::is_none")]
    pub scheduled_track: Option<String>,
    /// The current track/platform information, updated with real-time updates if available.  Can be missing if neither real-time updates nor the schedule timetable contains track information. 
    #[serde(rename = "track", skip_serializing_if = "Option::is_none")]
    pub track: Option<String>,
    #[serde(rename = "vertexType", skip_serializing_if = "Option::is_none")]
    pub vertex_type: Option<models::VertexType>,
}

impl Place {
    pub fn new(name: String, lat: f64, lon: f64, level: f64) -> Place {
        Place {
            name,
            stop_id: None,
            lat,
            lon,
            level,
            arrival: None,
            departure: None,
            scheduled_arrival: None,
            scheduled_departure: None,
            scheduled_track: None,
            track: None,
            vertex_type: None,
        }
    }
}

