
/******************************************/
/* Begin Kernel                           */
/******************************************/
.amdgcn_target "amdgcn-amd-amdhsa--gfx942"
.text
.protected Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01
.globl Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01
.p2align 8
.type Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01,@function
.section .rodata,#alloc
.p2align 6
.amdhsa_kernel Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01
  .amdhsa_user_sgpr_kernarg_segment_ptr 1
  .amdhsa_accum_offset 256 // accvgpr offset
  .amdhsa_next_free_vgpr 264 // vgprs
  .amdhsa_next_free_sgpr 82 // sgprs
  .amdhsa_group_segment_fixed_size 39424 // lds bytes
  .amdhsa_private_segment_fixed_size 0
  .amdhsa_system_sgpr_workgroup_id_x 1
  .amdhsa_system_sgpr_workgroup_id_y 1
  .amdhsa_system_sgpr_workgroup_id_z 1
  .amdhsa_system_vgpr_workitem_id 0
  .amdhsa_float_denorm_mode_32 3
  .amdhsa_float_denorm_mode_16_64 3
.end_amdhsa_kernel
.text
/* Num VGPR   =256 */
/* Num AccVGPR=8 */
/* Num SGPR   =82 */

/******************************************/
/* Optimizations and Config:              */
/******************************************/
/* ThreadTile= 8 x 1 */
/* SubGroup= 16 x 16 */
/* VectorWidthA=2 */
/* VectorWidthB=1 */
/* GlobalReadVectorWidthA=8, GlobalReadVectorWidthB=8 */
/* DirectToLdsA=False */
/* DirectToLdsB=False */
/* UseSgprForGRO=1 */
.amdgpu_metadata
---
amdhsa.version:
  - 1
  - 1
amdhsa.kernels:
  - .name: Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01
    .symbol: 'Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01.kd'
    .language:                   OpenCL C
    .language_version:
      - 2
      - 0
    .args:
      - .name:            SizesFree0
        .size:            4
        .offset:          0
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree1
        .size:            4
        .offset:          4
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree2
        .size:            4
        .offset:          8
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesSum0
        .size:            4
        .offset:          12
        .value_kind:      by_value
        .value_type:      u32
      - .name:            D
        .size:            8
        .offset:          16
        .value_kind:      global_buffer
        .value_type:      bf16
        .address_space:   generic
      - .name:            C
        .size:            8
        .offset:          24
        .value_kind:      global_buffer
        .value_type:      bf16
        .address_space:   generic
      - .name:            A
        .size:            8
        .offset:          32
        .value_kind:      global_buffer
        .value_type:      bf16
        .address_space:   generic
      - .name:            B
        .size:            8
        .offset:          40
        .value_kind:      global_buffer
        .value_type:      bf16
        .address_space:   generic
      - .name:            strideD0
        .size:            4
        .offset:          48
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideD1
        .size:            4
        .offset:          52
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC0
        .size:            4
        .offset:          56
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC1
        .size:            4
        .offset:          60
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA0
        .size:            4
        .offset:          64
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA1
        .size:            4
        .offset:          68
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB0
        .size:            4
        .offset:          72
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB1
        .size:            4
        .offset:          76
        .value_kind:      by_value
        .value_type:      u32
      - .name:            alpha
        .size:            4
        .offset:          80
        .value_kind:      by_value
        .value_type:      f32
      - .name:            beta
        .size:            4
        .offset:          84
        .value_kind:      by_value
        .value_type:      f32
      - .name:            internalArgs
        .size:            4
        .offset:          88
        .value_kind:      by_value
        .value_type:      u32
      - .name:            dstD
        .size:            8
        .offset:          92
        .value_kind:      global_buffer
        .value_type:      bf16
        .address_space:   generic
      - .name:            Synchronizer
        .size:            8
        .offset:          100
        .value_kind:      global_buffer
        .value_type:      f32
        .address_space:   generic
      - .name:            GSUSync
        .size:            4
        .offset:          108
        .value_kind:      by_value
        .value_type:      u32
    .group_segment_fixed_size:   39424
    .kernarg_segment_align:      8
    .kernarg_segment_size:       112
    .max_flat_workgroup_size:    256
    .private_segment_fixed_size: 0
    .sgpr_count:                 82
    .sgpr_spill_count:           0
    .vgpr_count:                 256
    .vgpr_spill_count:           0
    .wavefront_size:             64
...
.end_amdgpu_metadata
Custom_Cijk_Alik_Bljk_BBS_BH_MT128x16x128_MI16x16x1_SN_GSUM_K1_MIWT2_1_01:
.long 0xC0120700, 0x00000000
.long 0xC00A0B00, 0x00000040
.long 0xC0060C00, 0x00000050
.long 0xC0020C80, 0x00000058
.long 0xBEFC00FF, 0x00009A00
.long 0x7EB40300
.long 0x2602B4BF
.long 0x2600028F
.long 0x24000087
.long 0x20020284
.long 0x26020280
.long 0x2402028B
.long 0x68000101
.long 0x24000081
.long 0x2602B4BF
.long 0x20020284
.long 0x24020283
.long 0x68000101
.long 0x2002B486
.long 0x26020283
.long 0x2402028C
.long 0x68000101
.long 0x2604B4BF
.long 0x2602048F
.long 0x24020287
.long 0x20040484
.long 0x26040480
.long 0x2404048B
.long 0x68020302
.long 0x2604B4BF
.long 0x20040484
.long 0x24040483
.long 0x68020302
.long 0x2004B488
.long 0xBEB300FF, 0x00000080
.long 0xD2850002, 0x00020433
.long 0xD1FE0058, 0x02060102
.long 0x2006B089
.long 0x24060685
.long 0x68B0B103
.long 0x2000B488
.long 0xBEB30090
.long 0xD2850000, 0x00020033
.long 0xD1FE0059, 0x02060300
.long 0x2004B288
.long 0x24040485
.long 0x68B2B302
.long 0x32B2B2FF, 0x00008800
.long 0x2608B4BF
.long 0x20000884
.long 0x2602088F
.long 0x2008B486
.long 0x7E0A02A0
.long 0xD2850000, 0x00020105
.long 0x68000104
.long 0x24020283
.long 0x7E080301
.long 0x260AB4BF
.long 0x20040A84
.long 0x26060A8F
.long 0x7E66055A
.long 0x8F338633
.long 0x92338433
.long 0x68040433
.long 0x24060683
.long 0x7E0A0303
.long 0x106000FF, 0x00000080
.long 0xD1FE0030, 0x02066104
.long 0x200C6089
.long 0x240C0C85
.long 0x68606106
.long 0x106204FF, 0x00000080
.long 0xD1FE0031, 0x02066305
.long 0x200C6288
.long 0x240C0C85
.long 0x68626306
.long 0x326262FF, 0x00008800
.long 0xBF8CC07F
.long 0x8609FF32, 0x0000FF00
.long 0x8F098809
.long 0x8632FF32, 0x000000FF
.long 0x7E1002FF, 0x00000080
.long 0x7E0E021C
.long 0x7E0C0D08
.long 0x7E0C4706
.long 0x7E120D07
.long 0x0A0C1306
.long 0x7E0C0F06
.long 0x10121106
.long 0x6A121307
.long 0xD0CD006A, 0x00010109
.long 0xD11C6A06, 0x01A90106
.long 0x7E100290
.long 0x7E0E021D
.long 0x7E280506
.long 0x7E0C0D08
.long 0x7E0C4706
.long 0x7E120D07
.long 0x0A0C1306
.long 0x7E0C0F06
.long 0x10121106
.long 0x6A121307
.long 0xD0CD006A, 0x00010109
.long 0xD11C6A06, 0x01A90106
.long 0xBF800000
.long 0x7E2A0506
.long 0x80A49024
.long 0x82A58025
.long 0x80A69026
.long 0x82A78027
.long 0xD042006A, 0x00010030
.long 0xBF860001
.long 0xBE9F0080
.long 0xBF068132
.long 0xBF850012
.long 0x7E0C0C32
.long 0x7E0C4706
.long 0x7E0E0C03
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00006506
.long 0x6A0E0E03
.long 0xD0DA007E, 0x00006507
.long 0x680C0C81
.long 0x7E0E0280
.long 0xBEFE01C1
.long 0x7E060506
.long 0x7E0C0507
.long 0xBE850081
.long 0xBE880082
.long 0xBF820003
.long 0xBE860180
.long 0xBE850081
.long 0xBE880081
.long 0xBF0B8109
.long 0xBF850035
.long 0x7E0C0C09
.long 0x7E0C4706
.long 0x7E0E0C03
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00001306
.long 0x6A0E0E03
.long 0xD0DA007E, 0x00001307
.long 0x680C0C81
.long 0xBEFE01C1
.long 0x7EA00506
.long 0x92510950
.long 0x80D15103
.long 0x92511451
.long 0x80510251
.long 0x7E0C0C09
.long 0x7E0C4706
.long 0x7E0E0C15
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00001306
.long 0x6A0E0E15
.long 0xD0DA007E, 0x00001307
.long 0x680C0C81
.long 0xBEFE01C1
.long 0x7E9C0506
.long 0x924F4E09
.long 0x80CD4F15
.long 0xBF06804D
.long 0xBECD0209
.long 0xBF094E50
.long 0x854E094D
.long 0x7E0C0C4E
.long 0x7E0C4706
.long 0x7E0E0C51
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00009D06
.long 0x6A0E0E51
.long 0xD0DA007E, 0x00009D07
.long 0x680C0C81
.long 0x7E0E0280
.long 0xBEFE01C1
.long 0x7E040506
.long 0x7E060507
.long 0x92500950
.long 0x80035003
.long 0xD2850006, 0x0002002C
.long 0x32640D01
.long 0x68646488
.long 0x24646481
.long 0x9246842C
.long 0x8E468146
.long 0x9247882C
.long 0x8E478147
.long 0x92488C2C
.long 0x8E488148
.long 0x9249902C
.long 0x8E498149
.long 0x924A942C
.long 0x8E4A814A
.long 0x924B982C
.long 0x8E4B814B
.long 0x924C9C2C
.long 0x8E4C814C
.long 0xD2850006, 0x0002042E
.long 0x32660D03
.long 0x68666688
.long 0x24666681
.long 0x9651FF02, 0x00000080
.long 0x9250FF02, 0x00000080
.long 0x96512C50
.long 0x92502C50
.long 0x964F06FF, 0x00000080
.long 0x924E06FF, 0x00000080
.long 0x80504E50
.long 0x82514F51
.long 0xBEBC0081
.long 0xBEBD0080
.long 0x80CE811F
.long 0x964F4E81
.long 0x924E4E81
.long 0x803C4E3C
.long 0x823D4F3D
.long 0x80CE811C
.long 0x964F4E2C
.long 0x924E4E2C
.long 0x803C4E3C
.long 0x823D4F3D
.long 0x80BC503C
.long 0x82BD513D
.long 0x8EBC813C
.long 0x803C903C
.long 0x823D803D
.long 0xBF06803D
.long 0x8536C13C
.long 0x964F042D
.long 0x924E042D
.long 0x80504E50
.long 0x82514F51
.long 0x8ED08150
.long 0x80345024
.long 0x82355125
.long 0xBEB700FF, 0x00020000
.long 0x96519003
.long 0x92509003
.long 0x96512E50
.long 0x92502E50
.long 0x964F06FF, 0x00000080
.long 0x924E06FF, 0x00000080
.long 0x80504E50
.long 0x82514F51
.long 0xBEBE0081
.long 0xBEBF0080
.long 0x80CE811F
.long 0x964F4E81
.long 0x924E4E81
.long 0x803E4E3E
.long 0x823F4F3F
.long 0x80CE811D
.long 0x964F4E2E
.long 0x924E4E2E
.long 0x803E4E3E
.long 0x823F4F3F
.long 0x80BE503E
.long 0x82BF513F
.long 0x8EBE813E
.long 0x803E903E
.long 0x823F803F
.long 0xBF06803F
.long 0x853AC13E
.long 0x964F042F
.long 0x924E042F
.long 0x80504E50
.long 0x82514F51
.long 0x8ED08150
.long 0x80385026
.long 0x82395127
.long 0xBEBB00FF, 0x00020000
.long 0x924DFF32, 0x00000100
.long 0xBEC4004D
.long 0x924DFF32, 0x00000100
.long 0xBEC5004D
.long 0x8F0A871F
.long 0xBF068132
.long 0xBF850012
.long 0x7E000C32
.long 0x7E004700
.long 0x7E020C0A
.long 0x0A000300
.long 0x7E000F00
.long 0xD1080001, 0x00006500
.long 0x6A02020A
.long 0xD0DA007E, 0x00006501
.long 0x68000081
.long 0x7E020280
.long 0xBEFE01C1
.long 0x7E140500
.long 0x7E0E0501
.long 0x804E0A81
.long 0xBF0A0706
.long 0xBE8A024E
.long 0xBE8B000A
.long 0xBECE0084
.long 0x8E4F814E
.long 0xBF094F0B
.long 0xBF850002
.long 0x8F4E814E
.long 0xBF82FFFB
.long 0x80CF814E
.long 0xBF09814E
.long 0x8533804F
.long 0x86330433
.long 0x8E338133
.long 0x96CF4433
.long 0x924E4433
.long 0x96C1440A
.long 0x9240440A
.long 0x80C04044
.long 0x82C14180
.long 0x80344E34
.long 0x82354F35
.long 0x80BC4E3C
.long 0x82BD4F3D
.long 0xBF06803D
.long 0x8536C13C
.long 0x96CF4533
.long 0x924E4533
.long 0x96C3450A
.long 0x9242450A
.long 0x80C24245
.long 0x82C34380
.long 0x80384E38
.long 0x82394F39
.long 0x80BE4E3E
.long 0x82BF4F3F
.long 0xBF06803F
.long 0x853AC13E
.long 0x80338233
.long 0xBF06800A
.long 0xBF850026
.long 0xE05C1000, 0x800D3432
.long 0xE05C1000, 0x460D3832
.long 0xE05C1000, 0x470D3C32
.long 0xE05C1000, 0x480D4032
.long 0xE05C1000, 0x490D4432
.long 0xE05C1000, 0x4A0D4832
.long 0xE05C1000, 0x4B0D4C32
.long 0xE05C1000, 0x4C0D5032
.long 0xE05C1000, 0x800E5433
.long 0x8050810A
.long 0xBF065033
.long 0x854E4440
.long 0x854F8041
.long 0x80344E34
.long 0x82354F35
.long 0x80BC4E3C
.long 0x82BD4F3D
.long 0xBF06803D
.long 0x8536C13C
.long 0x8050810A
.long 0xBF065033
.long 0x854E4542
.long 0x854F8043
.long 0x80384E38
.long 0x82394F39
.long 0x80BE4E3E
.long 0x82BF4F3F
.long 0xBF06803F
.long 0x853AC13E
.long 0xBE8C0020
.long 0xBE8D0021
.long 0xBE8E00FF, 0x80000000
.long 0xBE8F00FF, 0x00020000
.long 0xBE900022
.long 0xBE910023
.long 0xBE9200FF, 0x80000000
.long 0xBE9300FF, 0x00020000
.long 0x92500390
.long 0x964F2A50
.long 0x924E2A50
.long 0x8ECE054E
.long 0x80104E22
.long 0x82114F23
.long 0x964F2850
.long 0x924E2850
.long 0x8ECE084E
.long 0x800C4E20
.long 0x820D4F21
.long 0x964F2B04
.long 0x924E2B04
.long 0x8ECE054E
.long 0x80104E10
.long 0x82114F11
.long 0x964F2904
.long 0x924E2904
.long 0x8ECE084E
.long 0x800C4E0C
.long 0x820D4F0D
.long 0xBE96000C
.long 0xBE97000D
.long 0xBF068132
.long 0xBF850011
.long 0x964F061C
.long 0x924E061C
.long 0x80D1811D
.long 0x92510651
.long 0x96502A51
.long 0x924D2A51
.long 0x804E4D4E
.long 0x824F504F
.long 0x80D1811E
.long 0x92510651
.long 0x96502B51
.long 0x924D2B51
.long 0x804E4D4E
.long 0x824F504F
.long 0x8ECE824E
.long 0x800C4E0C
.long 0x820D4F0D
.long 0xD3D94000, 0x18000080
.long 0xD3D94001, 0x18000080
.long 0xD3D94002, 0x18000080
.long 0xD3D94003, 0x18000080
.long 0xD3D94004, 0x18000080
.long 0xD3D94005, 0x18000080
.long 0xD3D94006, 0x18000080
.long 0xD3D94007, 0x18000080
.long 0xBF06800A
.long 0xBF840006
.long 0xBECE1C00
.long 0x815084FF, 0x00002940
.long 0x804E504E
.long 0x824F804F
.long 0xBE801D4E
.long 0xBF8C0F70
.long 0xD9BE0000, 0x00003430
.long 0xD9BE0440, 0x00003830
.long 0xD9BE0880, 0x00003C30
.long 0xD9BE0CC0, 0x00004030
.long 0xD9BE1100, 0x00004430
.long 0xD9BE1540, 0x00004830
.long 0xD9BE1980, 0x00004C30
.long 0xD9BE1DC0, 0x00005030
.long 0xD9BE0000, 0x00005431
.long 0xBF06810A
.long 0xBF850012
.long 0xE05C1000, 0x800D3432
.long 0xE05C1000, 0x460D3832
.long 0xE05C1000, 0x470D3C32
.long 0xE05C1000, 0x480D4032
.long 0xE05C1000, 0x490D4432
.long 0xE05C1000, 0x4A0D4832
.long 0xE05C1000, 0x4B0D4C32
.long 0xE05C1000, 0x4C0D5032
.long 0xE05C1000, 0x800E5433
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD9FE0000, 0x00000058
.long 0xD9FE0100, 0x04000058
.long 0xD9FE0000, 0x20000059
.long 0xBF06810A
.long 0xBF8500F9
.long 0xBF0B820A
.long 0xBF850086
.long 0xBF8CC07F
.long 0xD3E18000, 0x04024100
.long 0xD9FE0040, 0x08000058
.long 0xD9FE0040, 0x24000059
.long 0xD9FE0140, 0x0C000058
.long 0xBF06330A
.long 0x854E4440
.long 0x854F8041
.long 0x80344E34
.long 0x82354F35
.long 0x80BC4E3C
.long 0x82BD4F3D
.long 0xD3E18004, 0x04124104
.long 0xD9FE0080, 0x10000058
.long 0xD9FE0080, 0x28000059
.long 0xBF06803D
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024502
.long 0xD9FE0180, 0x14000058
.long 0x8536C13C
.long 0xD3E18004, 0x04124506
.long 0xD9FE00C0, 0x18000058
.long 0xD9FE00C0, 0x2C000059
.long 0xBF06330A
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024908
.long 0xD9FE01C0, 0x1C000058
.long 0x854E4542
.long 0xD3E18004, 0x0412490C
.long 0x854F8043
.long 0xBF8CC67F
.long 0xD3E18000, 0x04024D0A
.long 0x80384E38
.long 0xD3E18004, 0x04124D0E
.long 0x82394F39
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025110
.long 0x80BE4E3E
.long 0xD3E18004, 0x04125114
.long 0x82BF4F3F
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025512
.long 0xBF06803F
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD3E18004, 0x04125516
.long 0x853AC13E
.long 0xBF8C0F78
.long 0xD9BE0000, 0x00003430
.long 0xE05C1000, 0x800D3432
.long 0xBF8C0F78
.long 0xD9BE0440, 0x00003830
.long 0xE05C1000, 0x460D3832
.long 0xBF8C0F78
.long 0xD9BE0880, 0x00003C30
.long 0xE05C1000, 0x470D3C32
.long 0xBF8C0F78
.long 0xD9BE0CC0, 0x00004030
.long 0xE05C1000, 0x480D4032
.long 0xBF8C0F78
.long 0xD9BE1100, 0x00004430
.long 0xE05C1000, 0x490D4432
.long 0xBF8C0F78
.long 0xD9BE1540, 0x00004830
.long 0xE05C1000, 0x4A0D4832
.long 0xBF8C0F78
.long 0xD9BE1980, 0x00004C30
.long 0xE05C1000, 0x4B0D4C32
.long 0xBF8C0F78
.long 0xD9BE1DC0, 0x00005030
.long 0xE05C1000, 0x4C0D5032
.long 0xBF8C0F78
.long 0xD9BE0000, 0x00005431
.long 0xE05C1000, 0x800E5433
.long 0xBF8CC97F
.long 0xD3E18000, 0x04025918
.long 0xD3E18004, 0x0412591C
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC97F
.long 0xD3E18000, 0x04025D1A
.long 0xD9FE0000, 0x00000058
.long 0xD9FE0000, 0x20000059
.long 0xD9FE0100, 0x04000058
.long 0xD3E18004, 0x04125D1E
.long 0x808A810A
.long 0xBF00820A
.long 0xBF84FF7A
.long 0xBF8CC07F
.long 0xD3E18000, 0x04024100
.long 0xD9FE0040, 0x08000058
.long 0xD9FE0040, 0x24000059
.long 0xD9FE0140, 0x0C000058
.long 0xBF06330A
.long 0x854E4440
.long 0x854F8041
.long 0x80344E34
.long 0x82354F35
.long 0x80BC4E3C
.long 0x82BD4F3D
.long 0xD3E18004, 0x04124104
.long 0xD9FE0080, 0x10000058
.long 0xD9FE0080, 0x28000059
.long 0xBF06803D
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024502
.long 0xD9FE0180, 0x14000058
.long 0x8536C13C
.long 0xD3E18004, 0x04124506
.long 0xD9FE00C0, 0x18000058
.long 0xD9FE00C0, 0x2C000059
.long 0xBF06330A
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024908
.long 0xD9FE01C0, 0x1C000058
.long 0x854E4542
.long 0xD3E18004, 0x0412490C
.long 0x854F8043
.long 0xBF8CC67F
.long 0xD3E18000, 0x04024D0A
.long 0x80384E38
.long 0xD3E18004, 0x04124D0E
.long 0x82394F39
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025110
.long 0x80BE4E3E
.long 0xD3E18004, 0x04125114
.long 0x82BF4F3F
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025512
.long 0xBF06803F
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD3E18004, 0x04125516
.long 0x853AC13E
.long 0xBF8C0F78
.long 0xD9BE0000, 0x00003430
.long 0xBF8C0F77
.long 0xD9BE0440, 0x00003830
.long 0xBF8C0F76
.long 0xD9BE0880, 0x00003C30
.long 0xBF8C0F75
.long 0xD9BE0CC0, 0x00004030
.long 0xBF8C0F74
.long 0xD9BE1100, 0x00004430
.long 0xBF8C0F73
.long 0xD9BE1540, 0x00004830
.long 0xBF8C0F72
.long 0xD9BE1980, 0x00004C30
.long 0xBF8C0F71
.long 0xD9BE1DC0, 0x00005030
.long 0xBF8C0F70
.long 0xD9BE0000, 0x00005431
.long 0xBF8CC97F
.long 0xD3E18000, 0x04025918
.long 0xD3E18004, 0x0412591C
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xBF8CC97F
.long 0xD3E18000, 0x04025D1A
.long 0xD9FE0000, 0x00000058
.long 0xD9FE0000, 0x20000059
.long 0xD9FE0100, 0x04000058
.long 0xD3E18004, 0x04125D1E
.long 0xBF068132
.long 0xBF8408E4
.long 0xB4310000
.long 0xBF8408E2
.long 0xBF06F230
.long 0xBF8408E0
.long 0x864E1CFF, 0x0000007F
.long 0x804F14C1
.long 0xBF094F02
.long 0x854E804E
.long 0xB54E0000
.long 0xBF8508D9
.long 0x864E1D8F
.long 0x804F15C1
.long 0xBF094F03
.long 0x854E804E
.long 0xB54E0000
.long 0xBF8508D3
.long 0x864F1FFF, 0x0000007F
.long 0xBF06804F
.long 0xBF8408CF
.long 0xBF8CC07F
.long 0xD3E18000, 0x04024100
.long 0xD9FE0040, 0x08000058
.long 0xD9FE0040, 0x24000059
.long 0xD9FE0140, 0x0C000058
.long 0xD3E18004, 0x04124104
.long 0xD9FE0080, 0x10000058
.long 0xD9FE0080, 0x28000059
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024502
.long 0xD9FE0180, 0x14000058
.long 0xD3E18004, 0x04124506
.long 0xD9FE00C0, 0x18000058
.long 0xD9FE00C0, 0x2C000059
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024908
.long 0xD9FE01C0, 0x1C000058
.long 0xD3E18004, 0x0412490C
.long 0xBF8CC67F
.long 0xD3E18000, 0x04024D0A
.long 0xD3E18004, 0x04124D0E
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025110
.long 0xD3E18004, 0x04125114
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025512
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD3E18004, 0x04125516
.long 0xBF8CC07F
.long 0xD3E18000, 0x04025918
.long 0xD3E18004, 0x0412591C
.long 0xBF8CC07F
.long 0xD3E18000, 0x04025D1A
.long 0xD3E18004, 0x04125D1E
.long 0xC00A0D00, 0x0000005C
.long 0x2008B486
.long 0x20020882
.long 0xD2850001, 0x00020290
.long 0x260AB48F
.long 0xD1FE0001, 0x02020305
.long 0xD2850002, 0x00005501
.long 0xD2850003, 0x00005101
.long 0x260A0883
.long 0xD2850005, 0x00020A90
.long 0x2600B4BF
.long 0x20000084
.long 0x24000082
.long 0xD1FE0000, 0x02060105
.long 0x923302FF, 0x00000080
.long 0x68000033
.long 0x92330390
.long 0x68020233
.long 0xBF8CC07F
.long 0xBEBB00FF, 0x00020000
.long 0xBEBA00FF, 0x80000000
.long 0x92330390
.long 0x963D2A33
.long 0x923C2A33
.long 0x8EBC813C
.long 0x80383C34
.long 0x82393D35
.long 0x963D042B
.long 0x923C042B
.long 0x8EBC813C
.long 0x80383C38
.long 0x82393D39
.long 0xD1FE000A, 0x02060103
.long 0xD1FE000B, 0x02060103
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000104
.long 0xD3D84012, 0x18000101
.long 0xD3D84013, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84015, 0x18000106
.long 0xD3D84016, 0x18000103
.long 0xD3D84017, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x8003100A
.long 0xBF800000
.long 0x7E66055A
.long 0x80858132
.long 0x923F1415
.long 0x923F043F
.long 0x923E1403
.long 0x803E023E
.long 0x803E3F3E
.long 0x8F338633
.long 0x923F1514
.long 0x923F1E3F
.long 0x9233333F
.long 0x80333E33
.long 0x923F843F
.long 0x923F803F
.long 0x803E3F33
.long 0x8E3E823E
.long 0x80183E36
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9645811C
.long 0x9244811C
.long 0x80C8811D
.long 0x92488148
.long 0x96472A48
.long 0x92462A48
.long 0x80444644
.long 0x82454745
.long 0x80C8811E
.long 0x92488148
.long 0x96472B48
.long 0x92462B48
.long 0x80444644
.long 0x82454745
.long 0x8EC08144
.long 0x92434106
.long 0x963E4006
.long 0x92424006
.long 0x80433E43
.long 0x80C4420C
.long 0x82C5430D
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF84081F
.long 0x7E1C02FF, 0x80000000
.long 0xBEC40016
.long 0xBEC50017
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xE05CD000, 0x8011100A
.long 0xE05CD010, 0x8011140A
.long 0xBE850032
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8507B9
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80115C0F
.long 0xE05CD010, 0x8011600F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85079F
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011640F
.long 0xE05CD010, 0x8011680F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850779
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80116C0F
.long 0xE05CD010, 0x8011700F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850747
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011740F
.long 0xE05CD010, 0x8011780F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850709
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80117C0F
.long 0xE05CD010, 0x8011800F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8506BF
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011840F
.long 0xE05CD010, 0x8011880F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850669
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80118C0F
.long 0xE05CD010, 0x8011900F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850607
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011940F
.long 0xE05CD010, 0x8011980F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850599
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80119C0F
.long 0xE05CD010, 0x8011A00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85051F
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011A40F
.long 0xE05CD010, 0x8011A80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850499
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011AC0F
.long 0xE05CD010, 0x8011B00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850407
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011B40F
.long 0xE05CD010, 0x8011B80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850369
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011BC0F
.long 0xE05CD010, 0x8011C00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8502BF
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011C40F
.long 0xE05CD010, 0x8011C80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850209
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011CC0F
.long 0xE05CD010, 0x8011D00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506F0
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80115C0F
.long 0xE05CD010, 0x8011600F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506DA
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011640F
.long 0xE05CD010, 0x8011680F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506C4
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80116C0F
.long 0xE05CD010, 0x8011700F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506AE
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011740F
.long 0xE05CD010, 0x8011780F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850698
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80117C0F
.long 0xE05CD010, 0x8011800F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850682
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011840F
.long 0xE05CD010, 0x8011880F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85066C
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80118C0F
.long 0xE05CD010, 0x8011900F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850656
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011940F
.long 0xE05CD010, 0x8011980F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850640
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80119C0F
.long 0xE05CD010, 0x8011A00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85062A
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011A40F
.long 0xE05CD010, 0x8011A80F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850614
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011AC0F
.long 0xE05CD010, 0x8011B00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505FE
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011B40F
.long 0xE05CD010, 0x8011B80F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505E8
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011BC0F
.long 0xE05CD010, 0x8011C00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505D2
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011C40F
.long 0xE05CD010, 0x8011C80F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18039910
.long 0xD3B24012, 0x18039D12
.long 0xD3B24014, 0x1803A114
.long 0xD3B24016, 0x1803A516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505BC
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011CC0F
.long 0xE05CD010, 0x8011D00F
.long 0xBF02CE05
.long 0xBF85FEB4
.long 0xBE850032
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8505A3
.long 0xBF8C0F7D
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850597
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85058B
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85057F
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850573
.long 0xBF8C0F79
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850567
.long 0xBF8C0F78
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF85055B
.long 0xBF8C0F77
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85054F
.long 0xBF8C0F76
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850543
.long 0xBF8C0F75
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850537
.long 0xBF8C0F74
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF85052B
.long 0xBF8C0F73
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF85051F
.long 0xBF8C0F72
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF850513
.long 0xBF8C0F71
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF008105
.long 0xBF850507
.long 0xBF8C0F70
.long 0xD3B24010, 0x18039910
.long 0xD3B24012, 0x18039D12
.long 0xD3B24014, 0x1803A114
.long 0xD3B24016, 0x1803A516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504FB
.long 0xBE850032
.long 0xBF8C0F7D
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504EE
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504E2
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504D6
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504CA
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504BE
.long 0xBF8C0F78
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504B2
.long 0xBF8C0F77
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504A6
.long 0xBF8C0F76
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85049A
.long 0xBF8C0F75
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF85048E
.long 0xBF8C0F74
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850482
.long 0xBF8C0F73
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF850476
.long 0xBF8C0F72
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF85046A
.long 0xBF8C0F71
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF85045E
.long 0xBF8C0F70
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF008105
.long 0xBF850452
.long 0xBE850032
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850445
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850439
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85042D
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850421
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850415
.long 0xBF8C0F77
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850409
.long 0xBF8C0F76
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503FD
.long 0xBF8C0F75
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503F1
.long 0xBF8C0F74
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503E5
.long 0xBF8C0F73
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503D9
.long 0xBF8C0F72
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503CD
.long 0xBF8C0F71
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503C1
.long 0xBF8C0F70
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503B5
.long 0xBE850032
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503A8
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85039C
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850390
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850384
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850378
.long 0xBF8C0F76
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF85036C
.long 0xBF8C0F75
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850360
.long 0xBF8C0F74
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF850354
.long 0xBF8C0F73
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850348
.long 0xBF8C0F72
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF85033C
.long 0xBF8C0F71
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF850330
.long 0xBF8C0F70
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF850324
.long 0xBE850032
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850317
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85030B
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502FF
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502F3
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502E7
.long 0xBF8C0F75
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502DB
.long 0xBF8C0F74
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502CF
.long 0xBF8C0F73
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502C3
.long 0xBF8C0F72
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502B7
.long 0xBF8C0F71
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502AB
.long 0xBF8C0F70
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF85029F
.long 0xBE850032
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850292
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850286
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85027A
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85026E
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850262
.long 0xBF8C0F74
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850256
.long 0xBF8C0F73
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF85024A
.long 0xBF8C0F72
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85023E
.long 0xBF8C0F71
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850232
.long 0xBF8C0F70
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850226
.long 0xBE850032
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850219
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85020D
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850201
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501F5
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501E9
.long 0xBF8C0F73
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501DD
.long 0xBF8C0F72
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501D1
.long 0xBF8C0F71
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501C5
.long 0xBF8C0F70
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501B9
.long 0xBE850032
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501AC
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501A0
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850194
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850188
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85017C
.long 0xBF8C0F72
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850170
.long 0xBF8C0F71
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850164
.long 0xBF8C0F70
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF850158
.long 0xBE850032
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85014B
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85013F
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850133
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850127
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85011B
.long 0xBF8C0F71
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF85010F
.long 0xBF8C0F70
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850103
.long 0xBE850032
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500F6
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500EA
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500DE
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500D2
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500C6
.long 0xBF8C0F70
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500BA
.long 0xBE850032
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500AD
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500A1
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850095
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850089
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85007D
.long 0xBE850032
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850070
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850064
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850058
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85004C
.long 0xBE850032
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85003F
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850033
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850027
.long 0xBE850032
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85001A
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85000E
.long 0xBE850032
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850001
.long 0xBE850032
.long 0x7E0E02FF, 0xFFFF0000
.long 0x7E1002FF, 0x7FFF0000
.long 0x7E1202FF, 0x00007FFF
.long 0xD048003C, 0x00022110
.long 0xD1C80006, 0x02052110
.long 0xD1FF0006, 0x04260D10
.long 0xD1000010, 0x00F21106
.long 0x20202090
.long 0xD048003C, 0x00022311
.long 0xD1C80006, 0x02052111
.long 0xD1FF0006, 0x04260D11
.long 0xD1000011, 0x00F21106
.long 0xD2010010, 0x04420F11
.long 0xD048003C, 0x00022512
.long 0xD1C80006, 0x02052112
.long 0xD1FF0006, 0x04260D12
.long 0xD1000012, 0x00F21106
.long 0x20242490
.long 0xD048003C, 0x00022713
.long 0xD1C80006, 0x02052113
.long 0xD1FF0006, 0x04260D13
.long 0xD1000013, 0x00F21106
.long 0xD2010011, 0x044A0F13
.long 0xD048003C, 0x00022914
.long 0xD1C80006, 0x02052114
.long 0xD1FF0006, 0x04260D14
.long 0xD1000014, 0x00F21106
.long 0x20282890
.long 0xD048003C, 0x00022B15
.long 0xD1C80006, 0x02052115
.long 0xD1FF0006, 0x04260D15
.long 0xD1000015, 0x00F21106
.long 0xD2010012, 0x04520F15
.long 0xD048003C, 0x00022D16
.long 0xD1C80006, 0x02052116
.long 0xD1FF0006, 0x04260D16
.long 0xD1000016, 0x00F21106
.long 0x202C2C90
.long 0xD048003C, 0x00022F17
.long 0xD1C80006, 0x02052117
.long 0xD1FF0006, 0x04260D17
.long 0xD1000017, 0x00F21106
.long 0xD2010013, 0x045A0F17
.long 0xE07CD000, 0x800E100B
.long 0xBF800000
.long 0xBF820000
.long 0xBF810000
.long 0xBF8CC07F
.long 0xD3E18000, 0x04024100
.long 0xD9FE0040, 0x08000058
.long 0xD9FE0040, 0x24000059
.long 0xD9FE0140, 0x0C000058
.long 0xD3E18004, 0x04124104
.long 0xD9FE0080, 0x10000058
.long 0xD9FE0080, 0x28000059
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024502
.long 0xD9FE0180, 0x14000058
.long 0xD3E18004, 0x04124506
.long 0xD9FE00C0, 0x18000058
.long 0xD9FE00C0, 0x2C000059
.long 0xBF8CC57F
.long 0xD3E18000, 0x04024908
.long 0xD9FE01C0, 0x1C000058
.long 0xD3E18004, 0x0412490C
.long 0xBF8CC67F
.long 0xD3E18000, 0x04024D0A
.long 0xD3E18004, 0x04124D0E
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025110
.long 0xD3E18004, 0x04125114
.long 0xBF8CC37F
.long 0xD3E18000, 0x04025512
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD3E18004, 0x04125516
.long 0xBF8CC07F
.long 0xD3E18000, 0x04025918
.long 0xD3E18004, 0x0412591C
.long 0xBF8CC07F
.long 0xD3E18000, 0x04025D1A
.long 0xD3E18004, 0x04125D1E
.long 0x860A1FFF, 0x0000007F
.long 0xBF070706
.long 0xBE8A0280
.long 0xBF06800A
.long 0xBE8B0080
.long 0xBF8500C8
.long 0x81CE3383
.long 0x96CF444E
.long 0x924E444E
.long 0x80CE404E
.long 0x82CF414F
.long 0x80344E34
.long 0x82354F35
.long 0x80BC4E3C
.long 0x82BD4F3D
.long 0xBF06803D
.long 0x8536C13C
.long 0x81CE3383
.long 0x96CF454E
.long 0x924E454E
.long 0x80CE424E
.long 0x82CF434F
.long 0x80384E38
.long 0x82394F39
.long 0x80BE4E3E
.long 0x82BF4F3F
.long 0xBF06803F
.long 0x853AC13E
.long 0xE0501000, 0x800D3432
.long 0xE0501004, 0x800D3532
.long 0xE0501008, 0x800D3632
.long 0xE050100C, 0x800D3732
.long 0xE0501000, 0x460D3832
.long 0xE0501004, 0x460D3932
.long 0xE0501008, 0x460D3A32
.long 0xE050100C, 0x460D3B32
.long 0xE0501000, 0x470D3C32
.long 0xE0501004, 0x470D3D32
.long 0xE0501008, 0x470D3E32
.long 0xE050100C, 0x470D3F32
.long 0xE0501000, 0x480D4032
.long 0xE0501004, 0x480D4132
.long 0xE0501008, 0x480D4232
.long 0xE050100C, 0x480D4332
.long 0xE0501000, 0x490D4432
.long 0xE0501004, 0x490D4532
.long 0xE0501008, 0x490D4632
.long 0xE050100C, 0x490D4732
.long 0xE0501000, 0x4A0D4832
.long 0xE0501004, 0x4A0D4932
.long 0xE0501008, 0x4A0D4A32
.long 0xE050100C, 0x4A0D4B32
.long 0xE0501000, 0x4B0D4C32
.long 0xE0501004, 0x4B0D4D32
.long 0xE0501008, 0x4B0D4E32
.long 0xE050100C, 0x4B0D4F32
.long 0xE0501000, 0x4C0D5032
.long 0xE0501004, 0x4C0D5132
.long 0xE0501008, 0x4C0D5232
.long 0xE050100C, 0x4C0D5332
.long 0xE0501000, 0x800E5433
.long 0xE0501004, 0x800E5533
.long 0xE0501008, 0x800E5633
.long 0xE050100C, 0x800E5733
.long 0xBF8C0F70
.long 0xBF8A0000
.long 0xD9BE0000, 0x00003430
.long 0xD9BE0440, 0x00003830
.long 0xD9BE0880, 0x00003C30
.long 0xD9BE0CC0, 0x00004030
.long 0xD9BE1100, 0x00004430
.long 0xD9BE1540, 0x00004830
.long 0xD9BE1980, 0x00004C30
.long 0xD9BE1DC0, 0x00005030
.long 0xD9BE0000, 0x00005431
.long 0x2602B4BF
.long 0x2600028F
.long 0x24000087
.long 0x20020284
.long 0x26020280
.long 0x2402028B
.long 0x68000101
.long 0x24000081
.long 0x2602B4BF
.long 0x20020284
.long 0x24020282
.long 0x68000101
.long 0x2002B486
.long 0x26020283
.long 0x2402028C
.long 0x68000101
.long 0x2604B4BF
.long 0x2602048F
.long 0x24020287
.long 0x20040484
.long 0x26040480
.long 0x2404048B
.long 0x68020302
.long 0x2604B4BF
.long 0x20040484
.long 0x24040482
.long 0x68020302
.long 0x2004B488
.long 0xBE8500FF, 0x00000080
.long 0xD2850002, 0x00020405
.long 0xD1FE0058, 0x02060102
.long 0x2006B089
.long 0x24060685
.long 0x68B0B103
.long 0x2000B488
.long 0xBE850090
.long 0xD2850000, 0x00020005
.long 0xD1FE0059, 0x02060300
.long 0x2004B288
.long 0x24040485
.long 0x68B2B302
.long 0x32B2B2FF, 0x00008800
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD8EC0000, 0x00000058
.long 0xD8EC0100, 0x02000058
.long 0xD8EC0000, 0x20000059
.long 0xBE8500A0
.long 0x32B0B005
.long 0x32B2B205
.long 0xBF8CC07F
.long 0x2660B4BF
.long 0x20606084
.long 0x24606082
.long 0xD0C6004E, 0x00001530
.long 0xD1000000, 0x01390100
.long 0xD1000002, 0x01390102
.long 0xD1000001, 0x01390101
.long 0xD1000003, 0x01390103
.long 0xD1000020, 0x01390120
.long 0xD1000021, 0x01390121
.long 0xBF800001
.long 0xD3E18000, 0x04024100
.long 0xD3E18004, 0x04124102
.long 0x818A900A
.long 0x800B900B
.long 0xBF05800A
.long 0xBF84FFDC
.long 0xC00A0D00, 0x0000005C
.long 0x2008B486
.long 0x20020882
.long 0xD2850001, 0x00020290
.long 0x260AB48F
.long 0xD1FE0001, 0x02020305
.long 0xD2850002, 0x00005501
.long 0xD2850003, 0x00005101
.long 0x260A0883
.long 0xD2850005, 0x00020A90
.long 0x2600B4BF
.long 0x20000084
.long 0x24000082
.long 0xD1FE0000, 0x02060105
.long 0x923302FF, 0x00000080
.long 0x68000033
.long 0x92330390
.long 0x68020233
.long 0xBF8CC07F
.long 0xBEBB00FF, 0x00020000
.long 0xBEBA00FF, 0x80000000
.long 0x92330390
.long 0x963D2A33
.long 0x923C2A33
.long 0x8EBC813C
.long 0x80383C34
.long 0x82393D35
.long 0x963D042B
.long 0x923C042B
.long 0x8EBC813C
.long 0x80383C38
.long 0x82393D39
.long 0xB4310000
.long 0xBF8410FC
.long 0x863C1CFF, 0x0000007F
.long 0x803D14C1
.long 0xBF093D02
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850878
.long 0x863C1D8F
.long 0x803D15C1
.long 0xBF093D03
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850872
.long 0xD1FE000A, 0x020A0103
.long 0xD1FE000B, 0x02060103
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000104
.long 0xD3D84012, 0x18000101
.long 0xD3D84013, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84015, 0x18000106
.long 0xD3D84016, 0x18000103
.long 0xD3D84017, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x8003100A
.long 0xE07CD010, 0x8003140A
.long 0xBF800000
.long 0x7E66055A
.long 0x80858132
.long 0x923F1415
.long 0x923F043F
.long 0x923E1403
.long 0x803E023E
.long 0x803E3F3E
.long 0x8F338633
.long 0x923F1514
.long 0x923F1E3F
.long 0x9233333F
.long 0x80333E33
.long 0x923F843F
.long 0x923F803F
.long 0x803E3F33
.long 0x8E3E823E
.long 0x80183E36
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9645811C
.long 0x9244811C
.long 0x80C8811D
.long 0x92488148
.long 0x96472A48
.long 0x92462A48
.long 0x80444644
.long 0x82454745
.long 0x80C8811E
.long 0x92488148
.long 0x96472B48
.long 0x92462B48
.long 0x80444644
.long 0x82454745
.long 0x8EC08244
.long 0x92434106
.long 0x963E4006
.long 0x92424006
.long 0x80433E43
.long 0x80C4420C
.long 0x82C5430D
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF840827
.long 0x7E1C02FF, 0x80000000
.long 0xBEC40016
.long 0xBEC50017
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xE05CD000, 0x8011100A
.long 0xE05CD010, 0x8011140A
.long 0xBE850032
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8507B9
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80115C0F
.long 0xE05CD010, 0x8011600F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85079F
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011640F
.long 0xE05CD010, 0x8011680F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850779
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80116C0F
.long 0xE05CD010, 0x8011700F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850747
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011740F
.long 0xE05CD010, 0x8011780F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850709
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80117C0F
.long 0xE05CD010, 0x8011800F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8506BF
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011840F
.long 0xE05CD010, 0x8011880F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850669
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80118C0F
.long 0xE05CD010, 0x8011900F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850607
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011940F
.long 0xE05CD010, 0x8011980F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850599
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80119C0F
.long 0xE05CD010, 0x8011A00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85051F
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011A40F
.long 0xE05CD010, 0x8011A80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850499
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011AC0F
.long 0xE05CD010, 0x8011B00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850407
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011B40F
.long 0xE05CD010, 0x8011B80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850369
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011BC0F
.long 0xE05CD010, 0x8011C00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8502BF
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011C40F
.long 0xE05CD010, 0x8011C80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850209
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011CC0F
.long 0xE05CD010, 0x8011D00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506F0
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80115C0F
.long 0xE05CD010, 0x8011600F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506DA
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011640F
.long 0xE05CD010, 0x8011680F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506C4
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80116C0F
.long 0xE05CD010, 0x8011700F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506AE
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011740F
.long 0xE05CD010, 0x8011780F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850698
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80117C0F
.long 0xE05CD010, 0x8011800F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850682
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011840F
.long 0xE05CD010, 0x8011880F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85066C
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80118C0F
.long 0xE05CD010, 0x8011900F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850656
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011940F
.long 0xE05CD010, 0x8011980F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850640
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80119C0F
.long 0xE05CD010, 0x8011A00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85062A
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011A40F
.long 0xE05CD010, 0x8011A80F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850614
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011AC0F
.long 0xE05CD010, 0x8011B00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505FE
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011B40F
.long 0xE05CD010, 0x8011B80F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505E8
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011BC0F
.long 0xE05CD010, 0x8011C00F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505D2
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011C40F
.long 0xE05CD010, 0x8011C80F
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18039910
.long 0xD3B24012, 0x18039D12
.long 0xD3B24014, 0x1803A114
.long 0xD3B24016, 0x1803A516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505BC
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011CC0F
.long 0xE05CD010, 0x8011D00F
.long 0xBF02CE05
.long 0xBF85FEB4
.long 0xBE850032
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8505A3
.long 0xBF8C0F7D
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850597
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85058B
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85057F
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850573
.long 0xBF8C0F79
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850567
.long 0xBF8C0F78
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF85055B
.long 0xBF8C0F77
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85054F
.long 0xBF8C0F76
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850543
.long 0xBF8C0F75
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850537
.long 0xBF8C0F74
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF85052B
.long 0xBF8C0F73
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF85051F
.long 0xBF8C0F72
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF850513
.long 0xBF8C0F71
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF008105
.long 0xBF850507
.long 0xBF8C0F70
.long 0xD3B24010, 0x18039910
.long 0xD3B24012, 0x18039D12
.long 0xD3B24014, 0x1803A114
.long 0xD3B24016, 0x1803A516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504FB
.long 0xBE850032
.long 0xBF8C0F7D
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504EE
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504E2
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504D6
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504CA
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504BE
.long 0xBF8C0F78
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504B2
.long 0xBF8C0F77
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504A6
.long 0xBF8C0F76
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85049A
.long 0xBF8C0F75
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF85048E
.long 0xBF8C0F74
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850482
.long 0xBF8C0F73
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF850476
.long 0xBF8C0F72
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF85046A
.long 0xBF8C0F71
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF85045E
.long 0xBF8C0F70
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF008105
.long 0xBF850452
.long 0xBE850032
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850445
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850439
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85042D
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850421
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850415
.long 0xBF8C0F77
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850409
.long 0xBF8C0F76
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503FD
.long 0xBF8C0F75
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503F1
.long 0xBF8C0F74
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503E5
.long 0xBF8C0F73
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503D9
.long 0xBF8C0F72
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503CD
.long 0xBF8C0F71
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503C1
.long 0xBF8C0F70
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503B5
.long 0xBE850032
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503A8
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85039C
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850390
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850384
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850378
.long 0xBF8C0F76
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF85036C
.long 0xBF8C0F75
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850360
.long 0xBF8C0F74
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF850354
.long 0xBF8C0F73
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850348
.long 0xBF8C0F72
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF85033C
.long 0xBF8C0F71
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF850330
.long 0xBF8C0F70
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF850324
.long 0xBE850032
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850317
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85030B
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502FF
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502F3
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502E7
.long 0xBF8C0F75
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502DB
.long 0xBF8C0F74
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502CF
.long 0xBF8C0F73
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502C3
.long 0xBF8C0F72
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502B7
.long 0xBF8C0F71
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502AB
.long 0xBF8C0F70
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF85029F
.long 0xBE850032
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850292
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850286
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85027A
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85026E
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850262
.long 0xBF8C0F74
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850256
.long 0xBF8C0F73
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF85024A
.long 0xBF8C0F72
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85023E
.long 0xBF8C0F71
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850232
.long 0xBF8C0F70
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850226
.long 0xBE850032
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850219
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85020D
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850201
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501F5
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501E9
.long 0xBF8C0F73
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501DD
.long 0xBF8C0F72
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501D1
.long 0xBF8C0F71
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501C5
.long 0xBF8C0F70
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501B9
.long 0xBE850032
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501AC
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501A0
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850194
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850188
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85017C
.long 0xBF8C0F72
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850170
.long 0xBF8C0F71
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850164
.long 0xBF8C0F70
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF850158
.long 0xBE850032
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85014B
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85013F
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850133
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850127
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85011B
.long 0xBF8C0F71
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF85010F
.long 0xBF8C0F70
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850103
.long 0xBE850032
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500F6
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500EA
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500DE
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500D2
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500C6
.long 0xBF8C0F70
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500BA
.long 0xBE850032
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500AD
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500A1
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850095
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850089
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85007D
.long 0xBE850032
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850070
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850064
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850058
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85004C
.long 0xBE850032
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85003F
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850033
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850027
.long 0xBE850032
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85001A
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85000E
.long 0xBE850032
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850001
.long 0xBE850032
.long 0x0A202030
.long 0x0A222230
.long 0x0A242430
.long 0x0A262630
.long 0x0A282830
.long 0x0A2A2A30
.long 0x0A2C2C30
.long 0x0A2E2E30
.long 0x7E0E02FF, 0xFFFF0000
.long 0x7E1002FF, 0x7FFF0000
.long 0x7E1202FF, 0x00007FFF
.long 0xD048003C, 0x00022110
.long 0xD1C80006, 0x02052110
.long 0xD1FF0006, 0x04260D10
.long 0xD1000010, 0x00F21106
.long 0x20202090
.long 0xD048003C, 0x00022311
.long 0xD1C80006, 0x02052111
.long 0xD1FF0006, 0x04260D11
.long 0xD1000011, 0x00F21106
.long 0xD2010010, 0x04420F11
.long 0xD048003C, 0x00022512
.long 0xD1C80006, 0x02052112
.long 0xD1FF0006, 0x04260D12
.long 0xD1000012, 0x00F21106
.long 0x20242490
.long 0xD048003C, 0x00022713
.long 0xD1C80006, 0x02052113
.long 0xD1FF0006, 0x04260D13
.long 0xD1000013, 0x00F21106
.long 0xD2010011, 0x044A0F13
.long 0xD048003C, 0x00022914
.long 0xD1C80006, 0x02052114
.long 0xD1FF0006, 0x04260D14
.long 0xD1000014, 0x00F21106
.long 0x20282890
.long 0xD048003C, 0x00022B15
.long 0xD1C80006, 0x02052115
.long 0xD1FF0006, 0x04260D15
.long 0xD1000015, 0x00F21106
.long 0xD2010012, 0x04520F15
.long 0xD048003C, 0x00022D16
.long 0xD1C80006, 0x02052116
.long 0xD1FF0006, 0x04260D16
.long 0xD1000016, 0x00F21106
.long 0x202C2C90
.long 0xD048003C, 0x00022F17
.long 0xD1C80006, 0x02052117
.long 0xD1FF0006, 0x04260D17
.long 0xD1000017, 0x00F21106
.long 0xD2010013, 0x045A0F17
.long 0xE07CD000, 0x800E100B
.long 0xBF800000
.long 0xBF8219B4
.long 0x7E1802FF, 0x80000000
.long 0xD0C9003C, 0x00003900
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000A, 0x020A0103
.long 0xD100000A, 0x0102150C
.long 0xD1FE000B, 0x02060103
.long 0xD100000B, 0x0102170C
.long 0xD3D84010, 0x18000100
.long 0xD3D84011, 0x18000104
.long 0xD3D84012, 0x18000101
.long 0xD3D84013, 0x18000105
.long 0xD3D84014, 0x18000102
.long 0xD3D84015, 0x18000106
.long 0xD3D84016, 0x18000103
.long 0xD3D84017, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x8003100A
.long 0xE07CD010, 0x8003140A
.long 0xBF800000
.long 0x7E66055A
.long 0x80858132
.long 0x92431415
.long 0x92430443
.long 0x92421403
.long 0x80420242
.long 0x80424342
.long 0x8F338633
.long 0x92431514
.long 0x92431E43
.long 0x92333343
.long 0x80334233
.long 0x92438443
.long 0x92438043
.long 0x80424333
.long 0x8E428242
.long 0x80184236
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9649811C
.long 0x9248811C
.long 0x80CC811D
.long 0x924C814C
.long 0x964B2A4C
.long 0x924A2A4C
.long 0x80484A48
.long 0x82494B49
.long 0x80CC811E
.long 0x924C814C
.long 0x964B2B4C
.long 0x924A2B4C
.long 0x80484A48
.long 0x82494B49
.long 0x8EC48248
.long 0x92474506
.long 0x96424406
.long 0x92464406
.long 0x80474247
.long 0x80C8460C
.long 0x82C9470D
.long 0xBECA000E
.long 0xBECB000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF840827
.long 0x7E1A02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE05CD000, 0x8012100A
.long 0xE05CD010, 0x8012140A
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8507B9
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80125C0E
.long 0xE05CD010, 0x8012600E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85079F
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012640E
.long 0xE05CD010, 0x8012680E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850779
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80126C0E
.long 0xE05CD010, 0x8012700E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850747
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012740E
.long 0xE05CD010, 0x8012780E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850709
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80127C0E
.long 0xE05CD010, 0x8012800E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8506BF
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012840E
.long 0xE05CD010, 0x8012880E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850669
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80128C0E
.long 0xE05CD010, 0x8012900E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850607
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012940E
.long 0xE05CD010, 0x8012980E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850599
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80129C0E
.long 0xE05CD010, 0x8012A00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85051F
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012A40E
.long 0xE05CD010, 0x8012A80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850499
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012AC0E
.long 0xE05CD010, 0x8012B00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850407
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012B40E
.long 0xE05CD010, 0x8012B80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850369
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012BC0E
.long 0xE05CD010, 0x8012C00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8502BF
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012C40E
.long 0xE05CD010, 0x8012C80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012CC0E
.long 0xE05CD010, 0x8012D00E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506F0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80125C0E
.long 0xE05CD010, 0x8012600E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506DA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012640E
.long 0xE05CD010, 0x8012680E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506C4
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80126C0E
.long 0xE05CD010, 0x8012700E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506AE
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012740E
.long 0xE05CD010, 0x8012780E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850698
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80127C0E
.long 0xE05CD010, 0x8012800E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850682
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012840E
.long 0xE05CD010, 0x8012880E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85066C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80128C0E
.long 0xE05CD010, 0x8012900E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850656
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012940E
.long 0xE05CD010, 0x8012980E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850640
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80129C0E
.long 0xE05CD010, 0x8012A00E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85062A
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012A40E
.long 0xE05CD010, 0x8012A80E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850614
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012AC0E
.long 0xE05CD010, 0x8012B00E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505FE
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012B40E
.long 0xE05CD010, 0x8012B80E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505E8
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012BC0E
.long 0xE05CD010, 0x8012C00E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505D2
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012C40E
.long 0xE05CD010, 0x8012C80E
.long 0xBF8C0F7E
.long 0xD3B24010, 0x18039910
.long 0xD3B24012, 0x18039D12
.long 0xD3B24014, 0x1803A114
.long 0xD3B24016, 0x1803A516
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505BC
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012CC0E
.long 0xE05CD010, 0x8012D00E
.long 0xBF02CE05
.long 0xBF85FEB4
.long 0xBE850032
.long 0xBF8C0F7E
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8505A3
.long 0xBF8C0F7D
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850597
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85058B
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85057F
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850573
.long 0xBF8C0F79
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850567
.long 0xBF8C0F78
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF85055B
.long 0xBF8C0F77
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85054F
.long 0xBF8C0F76
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850543
.long 0xBF8C0F75
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850537
.long 0xBF8C0F74
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF85052B
.long 0xBF8C0F73
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF85051F
.long 0xBF8C0F72
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF850513
.long 0xBF8C0F71
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF008105
.long 0xBF850507
.long 0xBF8C0F70
.long 0xD3B24010, 0x18039910
.long 0xD3B24012, 0x18039D12
.long 0xD3B24014, 0x1803A114
.long 0xD3B24016, 0x1803A516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504FB
.long 0xBE850032
.long 0xBF8C0F7D
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504EE
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504E2
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504D6
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504CA
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504BE
.long 0xBF8C0F78
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504B2
.long 0xBF8C0F77
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8504A6
.long 0xBF8C0F76
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85049A
.long 0xBF8C0F75
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF85048E
.long 0xBF8C0F74
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850482
.long 0xBF8C0F73
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF850476
.long 0xBF8C0F72
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF85046A
.long 0xBF8C0F71
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF85045E
.long 0xBF8C0F70
.long 0xD3B24010, 0x18038910
.long 0xD3B24012, 0x18038D12
.long 0xD3B24014, 0x18039114
.long 0xD3B24016, 0x18039516
.long 0x81858105
.long 0xBF008105
.long 0xBF850452
.long 0xBE850032
.long 0xBF8C0F7C
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850445
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850439
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85042D
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850421
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850415
.long 0xBF8C0F77
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850409
.long 0xBF8C0F76
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503FD
.long 0xBF8C0F75
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503F1
.long 0xBF8C0F74
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503E5
.long 0xBF8C0F73
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503D9
.long 0xBF8C0F72
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503CD
.long 0xBF8C0F71
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503C1
.long 0xBF8C0F70
.long 0xD3B24010, 0x18037910
.long 0xD3B24012, 0x18037D12
.long 0xD3B24014, 0x18038114
.long 0xD3B24016, 0x18038516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503B5
.long 0xBE850032
.long 0xBF8C0F7B
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8503A8
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85039C
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850390
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850384
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850378
.long 0xBF8C0F76
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF85036C
.long 0xBF8C0F75
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850360
.long 0xBF8C0F74
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF850354
.long 0xBF8C0F73
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850348
.long 0xBF8C0F72
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF85033C
.long 0xBF8C0F71
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF850330
.long 0xBF8C0F70
.long 0xD3B24010, 0x18036910
.long 0xD3B24012, 0x18036D12
.long 0xD3B24014, 0x18037114
.long 0xD3B24016, 0x18037516
.long 0x81858105
.long 0xBF008105
.long 0xBF850324
.long 0xBE850032
.long 0xBF8C0F7A
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850317
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85030B
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502FF
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502F3
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502E7
.long 0xBF8C0F75
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502DB
.long 0xBF8C0F74
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502CF
.long 0xBF8C0F73
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502C3
.long 0xBF8C0F72
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502B7
.long 0xBF8C0F71
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF8502AB
.long 0xBF8C0F70
.long 0xD3B24010, 0x18035910
.long 0xD3B24012, 0x18035D12
.long 0xD3B24014, 0x18036114
.long 0xD3B24016, 0x18036516
.long 0x81858105
.long 0xBF008105
.long 0xBF85029F
.long 0xBE850032
.long 0xBF8C0F79
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850292
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850286
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF85027A
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85026E
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF850262
.long 0xBF8C0F74
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850256
.long 0xBF8C0F73
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF85024A
.long 0xBF8C0F72
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF85023E
.long 0xBF8C0F71
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF850232
.long 0xBF8C0F70
.long 0xD3B24010, 0x18034910
.long 0xD3B24012, 0x18034D12
.long 0xD3B24014, 0x18035114
.long 0xD3B24016, 0x18035516
.long 0x81858105
.long 0xBF008105
.long 0xBF850226
.long 0xBE850032
.long 0xBF8C0F78
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850219
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85020D
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850201
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501F5
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501E9
.long 0xBF8C0F73
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501DD
.long 0xBF8C0F72
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501D1
.long 0xBF8C0F71
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501C5
.long 0xBF8C0F70
.long 0xD3B24010, 0x18033910
.long 0xD3B24012, 0x18033D12
.long 0xD3B24014, 0x18034114
.long 0xD3B24016, 0x18034516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501B9
.long 0xBE850032
.long 0xBF8C0F77
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501AC
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8501A0
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850194
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850188
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85017C
.long 0xBF8C0F72
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF850170
.long 0xBF8C0F71
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850164
.long 0xBF8C0F70
.long 0xD3B24010, 0x18032910
.long 0xD3B24012, 0x18032D12
.long 0xD3B24014, 0x18033114
.long 0xD3B24016, 0x18033516
.long 0x81858105
.long 0xBF008105
.long 0xBF850158
.long 0xBE850032
.long 0xBF8C0F76
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85014B
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85013F
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850133
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850127
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85011B
.long 0xBF8C0F71
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF85010F
.long 0xBF8C0F70
.long 0xD3B24010, 0x18031910
.long 0xD3B24012, 0x18031D12
.long 0xD3B24014, 0x18032114
.long 0xD3B24016, 0x18032516
.long 0x81858105
.long 0xBF008105
.long 0xBF850103
.long 0xBE850032
.long 0xBF8C0F75
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500F6
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500EA
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500DE
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500D2
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500C6
.long 0xBF8C0F70
.long 0xD3B24010, 0x18030910
.long 0xD3B24012, 0x18030D12
.long 0xD3B24014, 0x18031114
.long 0xD3B24016, 0x18031516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500BA
.long 0xBE850032
.long 0xBF8C0F74
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500AD
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF8500A1
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850095
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF850089
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802F910
.long 0xD3B24012, 0x1802FD12
.long 0xD3B24014, 0x18030114
.long 0xD3B24016, 0x18030516
.long 0x81858105
.long 0xBF008105
.long 0xBF85007D
.long 0xBE850032
.long 0xBF8C0F73
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850070
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850064
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850058
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802E910
.long 0xD3B24012, 0x1802ED12
.long 0xD3B24014, 0x1802F114
.long 0xD3B24016, 0x1802F516
.long 0x81858105
.long 0xBF008105
.long 0xBF85004C
.long 0xBE850032
.long 0xBF8C0F72
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85003F
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF850033
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802D910
.long 0xD3B24012, 0x1802DD12
.long 0xD3B24014, 0x1802E114
.long 0xD3B24016, 0x1802E516
.long 0x81858105
.long 0xBF008105
.long 0xBF850027
.long 0xBE850032
.long 0xBF8C0F71
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF85001A
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802C910
.long 0xD3B24012, 0x1802CD12
.long 0xD3B24014, 0x1802D114
.long 0xD3B24016, 0x1802D516
.long 0x81858105
.long 0xBF008105
.long 0xBF85000E
.long 0xBE850032
.long 0xBF8C0F70
.long 0xD3B24010, 0x1802B910
.long 0xD3B24012, 0x1802BD12
.long 0xD3B24014, 0x1802C114
.long 0xD3B24016, 0x1802C516
.long 0x81858105
.long 0xBF008105
.long 0xBF850001
.long 0xBE850032
.long 0x0A202030
.long 0x0A222230
.long 0x0A242430
.long 0x0A262630
.long 0x0A282830
.long 0x0A2A2A30
.long 0x0A2C2C30
.long 0x0A2E2E30
.long 0x7E0E02FF, 0xFFFF0000
.long 0x7E1002FF, 0x7FFF0000
.long 0x7E1202FF, 0x00007FFF
.long 0xD048003C, 0x00022110
.long 0xD1C80006, 0x02052110
.long 0xD1FF0006, 0x04260D10
.long 0xD1000010, 0x00F21106
.long 0x20202090
.long 0xD048003C, 0x00022311
.long 0xD1C80006, 0x02052111
.long 0xD1FF0006, 0x04260D11
.long 0xD1000011, 0x00F21106
.long 0xD2010010, 0x04420F11
.long 0xD048003C, 0x00022512
.long 0xD1C80006, 0x02052112
.long 0xD1FF0006, 0x04260D12
.long 0xD1000012, 0x00F21106
.long 0x20242490
.long 0xD048003C, 0x00022713
.long 0xD1C80006, 0x02052113
.long 0xD1FF0006, 0x04260D13
.long 0xD1000013, 0x00F21106
.long 0xD2010011, 0x044A0F13
.long 0xD048003C, 0x00022914
.long 0xD1C80006, 0x02052114
.long 0xD1FF0006, 0x04260D14
.long 0xD1000014, 0x00F21106
.long 0x20282890
.long 0xD048003C, 0x00022B15
.long 0xD1C80006, 0x02052115
.long 0xD1FF0006, 0x04260D15
.long 0xD1000015, 0x00F21106
.long 0xD2010012, 0x04520F15
.long 0xD048003C, 0x00022D16
.long 0xD1C80006, 0x02052116
.long 0xD1FF0006, 0x04260D16
.long 0xD1000016, 0x00F21106
.long 0x202C2C90
.long 0xD048003C, 0x00022F17
.long 0xD1C80006, 0x02052117
.long 0xD1FF0006, 0x04260D17
.long 0xD1000017, 0x00F21106
.long 0xD2010013, 0x045A0F17
.long 0xE07CD000, 0x800E100B
.long 0xBF800000
.long 0xBF821137
.long 0x863C1CFF, 0x0000007F
.long 0x803D14C1
.long 0xBF093D02
.long 0x853C803C
.long 0xB53C0000
.long 0xBF850894
.long 0x863C1D8F
.long 0x803D15C1
.long 0xBF093D03
.long 0x853C803C
.long 0xB53C0000
.long 0xBF85088E
.long 0xD1FE000C, 0x02060102
.long 0xE05C1000, 0x8004100C
.long 0xD1FE000A, 0x020A0103
.long 0xD1FE000B, 0x02060103
.long 0xD3D84018, 0x18000100
.long 0xD3D84019, 0x18000104
.long 0xD3D8401A, 0x18000101
.long 0xD3D8401B, 0x18000105
.long 0xD3D8401C, 0x18000102
.long 0xD3D8401D, 0x18000106
.long 0xD3D8401E, 0x18000103
.long 0xD3D8401F, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x8003180A
.long 0xE07CD010, 0x80031C0A
.long 0xBF800000
.long 0x7E66055A
.long 0x80858132
.long 0x923F1415
.long 0x923F043F
.long 0x923E1403
.long 0x803E023E
.long 0x803E3F3E
.long 0x8F338633
.long 0x923F1514
.long 0x923F1E3F
.long 0x9233333F
.long 0x80333E33
.long 0x923F843F
.long 0x923F803F
.long 0x803E3F33
.long 0x8E3E823E
.long 0x80183E36
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9645811C
.long 0x9244811C
.long 0x80C8811D
.long 0x92488148
.long 0x96472A48
.long 0x92462A48
.long 0x80444644
.long 0x82454745
.long 0x80C8811E
.long 0x92488148
.long 0x96472B48
.long 0x92462B48
.long 0x80444644
.long 0x82454745
.long 0x8EC08244
.long 0x92434106
.long 0x963E4006
.long 0x92424006
.long 0x80433E43
.long 0x80C4420C
.long 0x82C5430D
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF84083F
.long 0x7E1C02FF, 0x80000000
.long 0xBEC40016
.long 0xBEC50017
.long 0xBEC6000E
.long 0xBEC7000F
.long 0xE05CD000, 0x8011180A
.long 0xE05CD010, 0x80111C0A
.long 0xBE850032
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8507B9
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80115C0F
.long 0xE05CD010, 0x8011600F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85079F
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011640F
.long 0xE05CD010, 0x8011680F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850779
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80116C0F
.long 0xE05CD010, 0x8011700F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850747
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011740F
.long 0xE05CD010, 0x8011780F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850709
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80117C0F
.long 0xE05CD010, 0x8011800F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8506BF
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011840F
.long 0xE05CD010, 0x8011880F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850669
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80118C0F
.long 0xE05CD010, 0x8011900F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850607
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011940F
.long 0xE05CD010, 0x8011980F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850599
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80119C0F
.long 0xE05CD010, 0x8011A00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF85051F
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011A40F
.long 0xE05CD010, 0x8011A80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850499
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011AC0F
.long 0xE05CD010, 0x8011B00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850407
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011B40F
.long 0xE05CD010, 0x8011B80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850369
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011BC0F
.long 0xE05CD010, 0x8011C00F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF8502BF
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011C40F
.long 0xE05CD010, 0x8011C80F
.long 0x81858105
.long 0x80444044
.long 0x82454145
.long 0xBF008005
.long 0xBF850209
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011CC0F
.long 0xE05CD010, 0x8011D00F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506F0
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80115C0F
.long 0xE05CD010, 0x8011600F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506DA
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011640F
.long 0xE05CD010, 0x8011680F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506C4
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80116C0F
.long 0xE05CD010, 0x8011700F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506AE
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011740F
.long 0xE05CD010, 0x8011780F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850698
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80117C0F
.long 0xE05CD010, 0x8011800F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850682
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011840F
.long 0xE05CD010, 0x8011880F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85066C
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80118C0F
.long 0xE05CD010, 0x8011900F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850656
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011940F
.long 0xE05CD010, 0x8011980F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850640
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x80119C0F
.long 0xE05CD010, 0x8011A00F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85062A
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011A40F
.long 0xE05CD010, 0x8011A80F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850614
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011AC0F
.long 0xE05CD010, 0x8011B00F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505FE
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011B40F
.long 0xE05CD010, 0x8011B80F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505E8
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011BC0F
.long 0xE05CD010, 0x8011C00F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18038918
.long 0xD3B2401A, 0x18038D1A
.long 0xD3B2401C, 0x1803911C
.long 0xD3B2401E, 0x1803951E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505D2
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011C40F
.long 0xE05CD010, 0x8011C80F
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18039918
.long 0xD3B2401A, 0x18039D1A
.long 0xD3B2401C, 0x1803A11C
.long 0xD3B2401E, 0x1803A51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505BC
.long 0x80444044
.long 0x82454145
.long 0xD0C60042, 0x00000A80
.long 0xD100000F, 0x010A1D0A
.long 0xE05CD000, 0x8011CC0F
.long 0xE05CD010, 0x8011D00F
.long 0xBF02CE05
.long 0xBF85FEB4
.long 0xBE850032
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8505A3
.long 0xBF8C0F7D
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850597
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85058B
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85057F
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850573
.long 0xBF8C0F79
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850567
.long 0xBF8C0F78
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF85055B
.long 0xBF8C0F77
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF85054F
.long 0xBF8C0F76
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF850543
.long 0xBF8C0F75
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF850537
.long 0xBF8C0F74
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF85052B
.long 0xBF8C0F73
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF85051F
.long 0xBF8C0F72
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF008105
.long 0xBF850513
.long 0xBF8C0F71
.long 0xD3B24018, 0x18038918
.long 0xD3B2401A, 0x18038D1A
.long 0xD3B2401C, 0x1803911C
.long 0xD3B2401E, 0x1803951E
.long 0x81858105
.long 0xBF008105
.long 0xBF850507
.long 0xBF8C0F70
.long 0xD3B24018, 0x18039918
.long 0xD3B2401A, 0x18039D1A
.long 0xD3B2401C, 0x1803A11C
.long 0xD3B2401E, 0x1803A51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504FB
.long 0xBE850032
.long 0xBF8C0F7D
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504EE
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504E2
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504D6
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504CA
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504BE
.long 0xBF8C0F78
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504B2
.long 0xBF8C0F77
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504A6
.long 0xBF8C0F76
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF85049A
.long 0xBF8C0F75
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF85048E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF850482
.long 0xBF8C0F73
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF850476
.long 0xBF8C0F72
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF85046A
.long 0xBF8C0F71
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF008105
.long 0xBF85045E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18038918
.long 0xD3B2401A, 0x18038D1A
.long 0xD3B2401C, 0x1803911C
.long 0xD3B2401E, 0x1803951E
.long 0x81858105
.long 0xBF008105
.long 0xBF850452
.long 0xBE850032
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850445
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850439
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85042D
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850421
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850415
.long 0xBF8C0F77
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850409
.long 0xBF8C0F76
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503FD
.long 0xBF8C0F75
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503F1
.long 0xBF8C0F74
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503E5
.long 0xBF8C0F73
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503D9
.long 0xBF8C0F72
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503CD
.long 0xBF8C0F71
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503C1
.long 0xBF8C0F70
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503B5
.long 0xBE850032
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503A8
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85039C
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850390
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850384
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850378
.long 0xBF8C0F76
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF85036C
.long 0xBF8C0F75
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF850360
.long 0xBF8C0F74
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF850354
.long 0xBF8C0F73
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF850348
.long 0xBF8C0F72
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF85033C
.long 0xBF8C0F71
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF850330
.long 0xBF8C0F70
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF850324
.long 0xBE850032
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850317
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85030B
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502FF
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502F3
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502E7
.long 0xBF8C0F75
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502DB
.long 0xBF8C0F74
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502CF
.long 0xBF8C0F73
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502C3
.long 0xBF8C0F72
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502B7
.long 0xBF8C0F71
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502AB
.long 0xBF8C0F70
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF85029F
.long 0xBE850032
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850292
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850286
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85027A
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85026E
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850262
.long 0xBF8C0F74
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850256
.long 0xBF8C0F73
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF85024A
.long 0xBF8C0F72
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF85023E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF850232
.long 0xBF8C0F70
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF850226
.long 0xBE850032
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850219
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85020D
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850201
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501F5
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501E9
.long 0xBF8C0F73
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501DD
.long 0xBF8C0F72
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501D1
.long 0xBF8C0F71
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501C5
.long 0xBF8C0F70
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501B9
.long 0xBE850032
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501AC
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501A0
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850194
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850188
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF85017C
.long 0xBF8C0F72
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850170
.long 0xBF8C0F71
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF850164
.long 0xBF8C0F70
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF850158
.long 0xBE850032
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85014B
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85013F
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850133
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850127
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF85011B
.long 0xBF8C0F71
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF85010F
.long 0xBF8C0F70
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF850103
.long 0xBE850032
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500F6
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500EA
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500DE
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500D2
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500C6
.long 0xBF8C0F70
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500BA
.long 0xBE850032
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500AD
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500A1
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850095
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850089
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF85007D
.long 0xBE850032
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850070
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850064
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850058
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85004C
.long 0xBE850032
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85003F
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850033
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850027
.long 0xBE850032
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85001A
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85000E
.long 0xBE850032
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850001
.long 0xBE850032
.long 0x0A303030
.long 0x0A323230
.long 0x0A343430
.long 0x0A363630
.long 0x0A383830
.long 0x0A3A3A30
.long 0x0A3C3C30
.long 0x0A3E3E30
.long 0x7E0E02FF, 0xFFFF0000
.long 0x7E1002FF, 0x7FFF0000
.long 0x7E1202FF, 0x00007FFF
.long 0x24082090
.long 0xD13B0018, 0x00006304
.long 0x26080F10
.long 0xD13B0019, 0x00006304
.long 0x24082290
.long 0xD13B001A, 0x00006304
.long 0x26080F11
.long 0xD13B001B, 0x00006304
.long 0x24082490
.long 0xD13B001C, 0x00006304
.long 0x26080F12
.long 0xD13B001D, 0x00006304
.long 0x24082690
.long 0xD13B001E, 0x00006304
.long 0x26080F13
.long 0xD13B001F, 0x00006304
.long 0xD048003C, 0x00023118
.long 0xD1C80006, 0x02052118
.long 0xD1FF0006, 0x04260D18
.long 0xD1000018, 0x00F21106
.long 0x20303090
.long 0xD048003C, 0x00023319
.long 0xD1C80006, 0x02052119
.long 0xD1FF0006, 0x04260D19
.long 0xD1000019, 0x00F21106
.long 0xD2010018, 0x04620F19
.long 0xD048003C, 0x0002351A
.long 0xD1C80006, 0x0205211A
.long 0xD1FF0006, 0x04260D1A
.long 0xD100001A, 0x00F21106
.long 0x20343490
.long 0xD048003C, 0x0002371B
.long 0xD1C80006, 0x0205211B
.long 0xD1FF0006, 0x04260D1B
.long 0xD100001B, 0x00F21106
.long 0xD2010019, 0x046A0F1B
.long 0xD048003C, 0x0002391C
.long 0xD1C80006, 0x0205211C
.long 0xD1FF0006, 0x04260D1C
.long 0xD100001C, 0x00F21106
.long 0x20383890
.long 0xD048003C, 0x00023B1D
.long 0xD1C80006, 0x0205211D
.long 0xD1FF0006, 0x04260D1D
.long 0xD100001D, 0x00F21106
.long 0xD201001A, 0x04720F1D
.long 0xD048003C, 0x00023D1E
.long 0xD1C80006, 0x0205211E
.long 0xD1FF0006, 0x04260D1E
.long 0xD100001E, 0x00F21106
.long 0x203C3C90
.long 0xD048003C, 0x00023F1F
.long 0xD1C80006, 0x0205211F
.long 0xD1FF0006, 0x04260D1F
.long 0xD100001F, 0x00F21106
.long 0xD201001B, 0x047A0F1F
.long 0xE07CD000, 0x800E180B
.long 0xBF800000
.long 0xBF82089C
.long 0x7E1802FF, 0x80000000
.long 0xD0C9003C, 0x00003900
.long 0xD0C90040, 0x00003B01
.long 0x86C0403C
.long 0xD1FE000A, 0x02060102
.long 0xD100000A, 0x0102150C
.long 0xE05C1000, 0x8004100A
.long 0xD1FE000A, 0x020A0103
.long 0xD100000A, 0x0102150C
.long 0xD1FE000B, 0x02060103
.long 0xD100000B, 0x0102170C
.long 0xD3D84018, 0x18000100
.long 0xD3D84019, 0x18000104
.long 0xD3D8401A, 0x18000101
.long 0xD3D8401B, 0x18000105
.long 0xD3D8401C, 0x18000102
.long 0xD3D8401D, 0x18000106
.long 0xD3D8401E, 0x18000103
.long 0xD3D8401F, 0x18000107
.long 0xBF800001
.long 0xE07CD000, 0x8003180A
.long 0xE07CD010, 0x80031C0A
.long 0xBF800000
.long 0x7E66055A
.long 0x80858132
.long 0x92431415
.long 0x92430443
.long 0x92421403
.long 0x80420242
.long 0x80424342
.long 0x8F338633
.long 0x92431514
.long 0x92431E43
.long 0x92333343
.long 0x80334233
.long 0x92438443
.long 0x92438043
.long 0x80424333
.long 0x8E428242
.long 0x80184236
.long 0x82198037
.long 0xBF8C0000
.long 0x80B38132
.long 0xC2330CCC, 0x00000000
.long 0x9649811C
.long 0x9248811C
.long 0x80CC811D
.long 0x924C814C
.long 0x964B2A4C
.long 0x924A2A4C
.long 0x80484A48
.long 0x82494B49
.long 0x80CC811E
.long 0x924C814C
.long 0x964B2B4C
.long 0x924A2B4C
.long 0x80484A48
.long 0x82494B49
.long 0x8EC48248
.long 0x92474506
.long 0x96424406
.long 0x92464406
.long 0x80474247
.long 0x80C8460C
.long 0x82C9470D
.long 0xBECA000E
.long 0xBECB000F
.long 0xBF8CC07F
.long 0xBF068133
.long 0xBF840840
.long 0x7E1A02FF, 0x80000000
.long 0xBEC80016
.long 0xBEC90017
.long 0xBECA000E
.long 0xBECB000F
.long 0xE05CD000, 0x8012180A
.long 0xE05CD010, 0x80121C0A
.long 0xBE850032
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8507B9
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80125C0E
.long 0xE05CD010, 0x8012600E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85079F
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012640E
.long 0xE05CD010, 0x8012680E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850779
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80126C0E
.long 0xE05CD010, 0x8012700E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850747
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012740E
.long 0xE05CD010, 0x8012780E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850709
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80127C0E
.long 0xE05CD010, 0x8012800E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8506BF
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012840E
.long 0xE05CD010, 0x8012880E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850669
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80128C0E
.long 0xE05CD010, 0x8012900E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850607
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012940E
.long 0xE05CD010, 0x8012980E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850599
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80129C0E
.long 0xE05CD010, 0x8012A00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF85051F
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012A40E
.long 0xE05CD010, 0x8012A80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850499
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012AC0E
.long 0xE05CD010, 0x8012B00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850407
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012B40E
.long 0xE05CD010, 0x8012B80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850369
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012BC0E
.long 0xE05CD010, 0x8012C00E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF8502BF
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012C40E
.long 0xE05CD010, 0x8012C80E
.long 0x81858105
.long 0x80484448
.long 0x82494549
.long 0xBF008005
.long 0xBF850209
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012CC0E
.long 0xE05CD010, 0x8012D00E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506F0
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80125C0E
.long 0xE05CD010, 0x8012600E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506DA
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012640E
.long 0xE05CD010, 0x8012680E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506C4
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80126C0E
.long 0xE05CD010, 0x8012700E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8506AE
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012740E
.long 0xE05CD010, 0x8012780E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850698
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80127C0E
.long 0xE05CD010, 0x8012800E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850682
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012840E
.long 0xE05CD010, 0x8012880E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85066C
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80128C0E
.long 0xE05CD010, 0x8012900E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850656
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012940E
.long 0xE05CD010, 0x8012980E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850640
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x80129C0E
.long 0xE05CD010, 0x8012A00E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF85062A
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012A40E
.long 0xE05CD010, 0x8012A80E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF850614
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012AC0E
.long 0xE05CD010, 0x8012B00E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505FE
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012B40E
.long 0xE05CD010, 0x8012B80E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505E8
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012BC0E
.long 0xE05CD010, 0x8012C00E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18038918
.long 0xD3B2401A, 0x18038D1A
.long 0xD3B2401C, 0x1803911C
.long 0xD3B2401E, 0x1803951E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505D2
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012C40E
.long 0xE05CD010, 0x8012C80E
.long 0xBF8C0F7E
.long 0xD3B24018, 0x18039918
.long 0xD3B2401A, 0x18039D1A
.long 0xD3B2401C, 0x1803A11C
.long 0xD3B2401E, 0x1803A51E
.long 0x81858105
.long 0xBF05CE05
.long 0xBF8505BC
.long 0x80484448
.long 0x82494549
.long 0xD0C60046, 0x00000A80
.long 0xD100000E, 0x011A1B0A
.long 0xE05CD000, 0x8012CC0E
.long 0xE05CD010, 0x8012D00E
.long 0xBF02CE05
.long 0xBF85FEB4
.long 0xBE850032
.long 0xBF8C0F7E
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8505A3
.long 0xBF8C0F7D
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850597
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85058B
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85057F
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850573
.long 0xBF8C0F79
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850567
.long 0xBF8C0F78
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF85055B
.long 0xBF8C0F77
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF85054F
.long 0xBF8C0F76
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF850543
.long 0xBF8C0F75
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF850537
.long 0xBF8C0F74
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF85052B
.long 0xBF8C0F73
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF85051F
.long 0xBF8C0F72
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF008105
.long 0xBF850513
.long 0xBF8C0F71
.long 0xD3B24018, 0x18038918
.long 0xD3B2401A, 0x18038D1A
.long 0xD3B2401C, 0x1803911C
.long 0xD3B2401E, 0x1803951E
.long 0x81858105
.long 0xBF008105
.long 0xBF850507
.long 0xBF8C0F70
.long 0xD3B24018, 0x18039918
.long 0xD3B2401A, 0x18039D1A
.long 0xD3B2401C, 0x1803A11C
.long 0xD3B2401E, 0x1803A51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504FB
.long 0xBE850032
.long 0xBF8C0F7D
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504EE
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504E2
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504D6
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504CA
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504BE
.long 0xBF8C0F78
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504B2
.long 0xBF8C0F77
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8504A6
.long 0xBF8C0F76
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF85049A
.long 0xBF8C0F75
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF85048E
.long 0xBF8C0F74
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF850482
.long 0xBF8C0F73
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF850476
.long 0xBF8C0F72
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF85046A
.long 0xBF8C0F71
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF008105
.long 0xBF85045E
.long 0xBF8C0F70
.long 0xD3B24018, 0x18038918
.long 0xD3B2401A, 0x18038D1A
.long 0xD3B2401C, 0x1803911C
.long 0xD3B2401E, 0x1803951E
.long 0x81858105
.long 0xBF008105
.long 0xBF850452
.long 0xBE850032
.long 0xBF8C0F7C
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850445
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850439
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85042D
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850421
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850415
.long 0xBF8C0F77
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850409
.long 0xBF8C0F76
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503FD
.long 0xBF8C0F75
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503F1
.long 0xBF8C0F74
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503E5
.long 0xBF8C0F73
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503D9
.long 0xBF8C0F72
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503CD
.long 0xBF8C0F71
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503C1
.long 0xBF8C0F70
.long 0xD3B24018, 0x18037918
.long 0xD3B2401A, 0x18037D1A
.long 0xD3B2401C, 0x1803811C
.long 0xD3B2401E, 0x1803851E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503B5
.long 0xBE850032
.long 0xBF8C0F7B
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8503A8
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85039C
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850390
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850384
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850378
.long 0xBF8C0F76
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF85036C
.long 0xBF8C0F75
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF850360
.long 0xBF8C0F74
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF850354
.long 0xBF8C0F73
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF850348
.long 0xBF8C0F72
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF85033C
.long 0xBF8C0F71
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF850330
.long 0xBF8C0F70
.long 0xD3B24018, 0x18036918
.long 0xD3B2401A, 0x18036D1A
.long 0xD3B2401C, 0x1803711C
.long 0xD3B2401E, 0x1803751E
.long 0x81858105
.long 0xBF008105
.long 0xBF850324
.long 0xBE850032
.long 0xBF8C0F7A
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850317
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85030B
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502FF
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502F3
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502E7
.long 0xBF8C0F75
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502DB
.long 0xBF8C0F74
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502CF
.long 0xBF8C0F73
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502C3
.long 0xBF8C0F72
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502B7
.long 0xBF8C0F71
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF8502AB
.long 0xBF8C0F70
.long 0xD3B24018, 0x18035918
.long 0xD3B2401A, 0x18035D1A
.long 0xD3B2401C, 0x1803611C
.long 0xD3B2401E, 0x1803651E
.long 0x81858105
.long 0xBF008105
.long 0xBF85029F
.long 0xBE850032
.long 0xBF8C0F79
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850292
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850286
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85027A
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85026E
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF850262
.long 0xBF8C0F74
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850256
.long 0xBF8C0F73
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF85024A
.long 0xBF8C0F72
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF85023E
.long 0xBF8C0F71
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF850232
.long 0xBF8C0F70
.long 0xD3B24018, 0x18034918
.long 0xD3B2401A, 0x18034D1A
.long 0xD3B2401C, 0x1803511C
.long 0xD3B2401E, 0x1803551E
.long 0x81858105
.long 0xBF008105
.long 0xBF850226
.long 0xBE850032
.long 0xBF8C0F78
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850219
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85020D
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850201
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501F5
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501E9
.long 0xBF8C0F73
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501DD
.long 0xBF8C0F72
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501D1
.long 0xBF8C0F71
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501C5
.long 0xBF8C0F70
.long 0xD3B24018, 0x18033918
.long 0xD3B2401A, 0x18033D1A
.long 0xD3B2401C, 0x1803411C
.long 0xD3B2401E, 0x1803451E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501B9
.long 0xBE850032
.long 0xBF8C0F77
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501AC
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8501A0
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850194
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850188
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF85017C
.long 0xBF8C0F72
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF850170
.long 0xBF8C0F71
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF850164
.long 0xBF8C0F70
.long 0xD3B24018, 0x18032918
.long 0xD3B2401A, 0x18032D1A
.long 0xD3B2401C, 0x1803311C
.long 0xD3B2401E, 0x1803351E
.long 0x81858105
.long 0xBF008105
.long 0xBF850158
.long 0xBE850032
.long 0xBF8C0F76
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85014B
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85013F
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850133
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850127
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF85011B
.long 0xBF8C0F71
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF85010F
.long 0xBF8C0F70
.long 0xD3B24018, 0x18031918
.long 0xD3B2401A, 0x18031D1A
.long 0xD3B2401C, 0x1803211C
.long 0xD3B2401E, 0x1803251E
.long 0x81858105
.long 0xBF008105
.long 0xBF850103
.long 0xBE850032
.long 0xBF8C0F75
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500F6
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500EA
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500DE
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500D2
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500C6
.long 0xBF8C0F70
.long 0xD3B24018, 0x18030918
.long 0xD3B2401A, 0x18030D1A
.long 0xD3B2401C, 0x1803111C
.long 0xD3B2401E, 0x1803151E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500BA
.long 0xBE850032
.long 0xBF8C0F74
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500AD
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF8500A1
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850095
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850089
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802F918
.long 0xD3B2401A, 0x1802FD1A
.long 0xD3B2401C, 0x1803011C
.long 0xD3B2401E, 0x1803051E
.long 0x81858105
.long 0xBF008105
.long 0xBF85007D
.long 0xBE850032
.long 0xBF8C0F73
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850070
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850064
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850058
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802E918
.long 0xD3B2401A, 0x1802ED1A
.long 0xD3B2401C, 0x1802F11C
.long 0xD3B2401E, 0x1802F51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85004C
.long 0xBE850032
.long 0xBF8C0F72
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85003F
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850033
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802D918
.long 0xD3B2401A, 0x1802DD1A
.long 0xD3B2401C, 0x1802E11C
.long 0xD3B2401E, 0x1802E51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850027
.long 0xBE850032
.long 0xBF8C0F71
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85001A
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802C918
.long 0xD3B2401A, 0x1802CD1A
.long 0xD3B2401C, 0x1802D11C
.long 0xD3B2401E, 0x1802D51E
.long 0x81858105
.long 0xBF008105
.long 0xBF85000E
.long 0xBE850032
.long 0xBF8C0F70
.long 0xD3B24018, 0x1802B918
.long 0xD3B2401A, 0x1802BD1A
.long 0xD3B2401C, 0x1802C11C
.long 0xD3B2401E, 0x1802C51E
.long 0x81858105
.long 0xBF008105
.long 0xBF850001
.long 0xBE850032
.long 0x0A303030
.long 0x0A323230
.long 0x0A343430
.long 0x0A363630
.long 0x0A383830
.long 0x0A3A3A30
.long 0x0A3C3C30
.long 0x0A3E3E30
.long 0xBF8C0F70
.long 0x7E0E02FF, 0xFFFF0000
.long 0x7E1002FF, 0x7FFF0000
.long 0x7E1202FF, 0x00007FFF
.long 0x24082090
.long 0xD13B0018, 0x00006304
.long 0x26080F10
.long 0xD13B0019, 0x00006304
.long 0x24082290
.long 0xD13B001A, 0x00006304
.long 0x26080F11
.long 0xD13B001B, 0x00006304
.long 0x24082490
.long 0xD13B001C, 0x00006304
.long 0x26080F12
.long 0xD13B001D, 0x00006304
.long 0x24082690
.long 0xD13B001E, 0x00006304
.long 0x26080F13
.long 0xD13B001F, 0x00006304
.long 0xD048003C, 0x00023118
.long 0xD1C80006, 0x02052118
.long 0xD1FF0006, 0x04260D18
.long 0xD1000018, 0x00F21106
.long 0x20303090
.long 0xD048003C, 0x00023319
.long 0xD1C80006, 0x02052119
.long 0xD1FF0006, 0x04260D19
.long 0xD1000019, 0x00F21106
.long 0xD2010018, 0x04620F19
.long 0xD048003C, 0x0002351A
.long 0xD1C80006, 0x0205211A
.long 0xD1FF0006, 0x04260D1A
.long 0xD100001A, 0x00F21106
.long 0x20343490
.long 0xD048003C, 0x0002371B
.long 0xD1C80006, 0x0205211B
.long 0xD1FF0006, 0x04260D1B
.long 0xD100001B, 0x00F21106
.long 0xD2010019, 0x046A0F1B
.long 0xD048003C, 0x0002391C
.long 0xD1C80006, 0x0205211C
.long 0xD1FF0006, 0x04260D1C
.long 0xD100001C, 0x00F21106
.long 0x20383890
.long 0xD048003C, 0x00023B1D
.long 0xD1C80006, 0x0205211D
.long 0xD1FF0006, 0x04260D1D
.long 0xD100001D, 0x00F21106
.long 0xD201001A, 0x04720F1D
.long 0xD048003C, 0x00023D1E
.long 0xD1C80006, 0x0205211E
.long 0xD1FF0006, 0x04260D1E
.long 0xD100001E, 0x00F21106
.long 0x203C3C90
.long 0xD048003C, 0x00023F1F
.long 0xD1C80006, 0x0205211F
.long 0xD1FF0006, 0x04260D1F
.long 0xD100001F, 0x00F21106
.long 0xD201001B, 0x047A0F1F
.long 0xE07CD000, 0x800E180B
.long 0xBF800000
.long 0xBF820000
.long 0xBF810000
