golang-lru
==========

This provides the `lru` package which implements a fixed-size
thread safe LRU cache. It is based on the cache in Groupcache.

Documentation
=============

Full docs are available on [Go Packages](https://pkg.go.dev/github.com/hashicorp/golang-lru/v2)

Example
=======

Using the LRU is very simple:

```go
package main

import (
	"fmt"
	"github.com/hashicorp/golang-lru/v2"
)

func main() {
  l, _ := lru.New[int, any](128)
  for i := 0; i < 256; i++ {
      l.Add(i, nil)
  }
  if l.Len() != 128 {
      panic(fmt.Sprintf("bad len: %v", l.Len()))
  }
}
```
