%define __python python3
%define _archdependent 0
# don't generate a debug package
%global debug_package %{nil}
%define requirements_txt empty

Name:           tortoisehg
Version:        hg
Release:        hg
Summary:        Mercurial GUI command line tool thg
Group:          Development/Tools
License:        GPLv2+
URL:            https://foss.heptapod.net/mercurial/tortoisehg/thg
Source0:        %{name}-%{version}.tar.gz
%if "%{_archdependent}" == "0"
BuildArch:      noarch
%endif
BuildRequires:  python3-devel
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
# don't let rpmbuild add requirements itself,
# it will add requirements that are already provided by the virtualenv
AutoReqProv:    no

%description
This package contains the thg command line tool, which provides a graphical
user interface to the Mercurial distributed revision control system.

%package        nautilus
Summary:        Mercurial GUI plug-in to the Nautilus file manager
Group:          Development/Tools
Requires:       %{name} = %{version}-%{release}, nautilus-python
Requires:       python36

%description    nautilus
This package contains the TortoiseHg Gnome/Nautilus extension, which makes the
Mercurial distributed revision control system available in the file manager
with a graphical interface.

%prep
%setup -q

%build
# we install the requirements here to be able to build tortoisehg, but do the install again in the install section
# (as that directory gets cleared before the install section)
# --> we could consider not doing anything in the build section and instead just do everything in the install section
pip3 install -r %{requirements_txt} --prefix=%{buildroot}%{_prefix}/local/lib/thg-env --ignore-installed
export PYTHONPATH=%{buildroot}%{_prefix}/local/lib/thg-env/lib/python%{python3_version}/site-packages:%{buildroot}%{_prefix}/local/lib/thg-env/lib64/python%{python3_version}/site-packages

python3 setup.py build

# make sure we can generate documentation
# --> doing this in the Docker image at root level clashes with existing packages
pip3 install sphinx --user

(export PATH=$HOME/.local/bin:$PATH; cd doc && make html)
rm -f doc/build/html/.buildinfo

%install
rm -rf $RPM_BUILD_ROOT
echo $RPM_BUILD_ROOT

pip3 install -r %{requirements_txt} --prefix=%{buildroot}%{_prefix}/local/lib/thg-env --ignore-installed
# Mercurial binaries for RHEL are installed using rust support, so let's do the same for Mercurial shipped with Tortoisehg for RHEL
pip3 install mercurial --prefix=%{buildroot}%{_prefix}/local/lib/thg-env --ignore-installed --global-option="--rust"
export PYTHONPATH=%{buildroot}%{_prefix}/local/lib/thg-env/lib/python%{python3_version}/site-packages:%{buildroot}%{_prefix}/local/lib/thg-env/lib64/python%{python3_version}/site-packages

python3 setup.py install -O1 --skip-build --root %{buildroot}%{_prefix}/local/lib/thg-env

cat > %{buildroot}%{_prefix}/local/lib/thg-env/usr/lib/python%{python3_version}/site-packages/tortoisehg/util/config.py << EOT
bin_path     = "%{_prefix}/local/lib/thg-env/bin"
license_path = "%{_docdir}/%{name}-%{version}/COPYING.txt"
locale_path  = "%{_prefix}/local/lib/thg-env/usr/share/locale"
icon_path    = "%{_prefix}/local/lib/thg-env/usr/share/pixmaps/tortoisehg"
nofork       = True
EOT

mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/mercurial/hgrc.d
install contrib/mergetools.rc $RPM_BUILD_ROOT%{_sysconfdir}/mercurial/hgrc.d/thgmergetools.rc

desktop-file-install --dir=%{buildroot}%{_datadir}/applications contrib/thg.desktop

# add script to start tortoisehg
mkdir -p %{buildroot}%{_prefix}/local/bin
cat > %{buildroot}%{_prefix}/local/bin/thg << EOF
#!/bin/sh
export PYTHONPATH=%{_prefix}/local/lib/thg-env/lib/python%{python3_version}/site-packages/:\$PYTHONPATH
export PYTHONPATH=%{_prefix}/local/lib/thg-env/lib64/python%{python3_version}/site-packages/:\$PYTHONPATH
export PYTHONPATH=%{_prefix}/local/lib/thg-env/usr/lib/python%{python3_version}/site-packages/:\$PYTHONPATH
export PATH=%{_prefix}/local/lib/thg-env/bin:\$PATH
%{_prefix}/local/lib/thg-env/usr/bin/thg "\$@"
EOF
chmod +x %{buildroot}%{_prefix}/local/bin/thg

#%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files

%defattr(-,root,root,-)
%doc COPYING.txt doc/build/html/
/usr/local/bin/thg
/usr/local/lib/thg-env
%{_datadir}/applications/thg.desktop

%config(noreplace) %attr(644,root,root) %{_sysconfdir}/mercurial/hgrc.d/thgmergetools.rc

%files nautilus
%defattr(-,root,root,-)

%changelog
