/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Iterator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscCompoundQueueConsumerQueueIndex;
import org.jctools.util.PortableJvmInfo;

public class MpscCompoundQueue<E>
extends MpscCompoundQueueConsumerQueueIndex<E> {
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;

    public MpscCompoundQueue(int capacity) {
        this(capacity, PortableJvmInfo.CPUs);
    }

    public MpscCompoundQueue(int capacity, int queueParallelism) {
        super(capacity, queueParallelism);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        if (queues[start].offer(e)) {
            return true;
        }
        return this.slowOffer(queues, parallelQueuesMask, start + 1, e);
    }

    private boolean slowOffer(MpscArrayQueue<E>[] queues, int parallelQueuesMask, int start, E e) {
        int status;
        int queueCount = parallelQueuesMask + 1;
        int end = start + queueCount;
        do {
            status = 0;
            for (int i = start; i < end; ++i) {
                int s = queues[i & parallelQueuesMask].failFastOffer(e);
                if (s == 0) {
                    return true;
                }
                status += s;
            }
        } while (status != queueCount);
        return false;
    }

    @Override
    public E poll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].poll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E peek() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].peek()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int size() {
        int size = 0;
        for (MpscArrayQueue lane : this.queues) {
            size += lane.size();
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        if (queues[start].failFastOffer(e) == 0) {
            return true;
        }
        for (int i = start + 1; i < start + parallelQueuesMask + 1; ++i) {
            if (queues[i & parallelQueuesMask].failFastOffer(e) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public E relaxedPoll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].relaxedPoll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E relaxedPeek() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].relaxedPeek()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int capacity() {
        return this.queues.length * this.queues[0].capacity();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int limit = this.capacity();
        return this.drain(c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)result;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        for (int i = 0; i < limit; ++i) {
            E e = this.relaxedPoll();
            if (e == null) {
                return i;
            }
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        int filled = queues[start].fill(s, limit);
        if (filled == limit) {
            return limit;
        }
        for (int i = start + 1; i < start + parallelQueuesMask + 1; ++i) {
            if ((filled += queues[i & parallelQueuesMask].fill(s, limit - filled)) != limit) continue;
            return limit;
        }
        return filled;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = this.relaxedPoll();
            if (e == null) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            if (this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }
}

