// Package glx is the X client API for the GLX extension.
package glx

// This file is automatically generated from glx.xml. Edit at your peril!

import (
	"github.com/jezek/xgb"

	"github.com/jezek/xgb/xproto"
)

// Init must be called before using the GLX extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 3, "GLX").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named GLX could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["GLX"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["GLX"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["GLX"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["GLX"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["GLX"] = make(map[int]xgb.NewErrorFun)
}

// BadBadContext is the error number for a BadBadContext.
const BadBadContext = 0

type BadContextError GenericError

// BadContextErrorNew constructs a BadContextError value that implements xgb.Error from a byte slice.
func BadContextErrorNew(buf []byte) xgb.Error {
	v := BadContextError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadContext"
	return v
}

// SequenceId returns the sequence id attached to the BadBadContext error.
// This is mostly used internally.
func (err BadContextError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadContext error. If no bad value exists, 0 is returned.
func (err BadContextError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadContext error.
func (err BadContextError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadContext {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][0] = BadContextErrorNew
}

// BadBadContextState is the error number for a BadBadContextState.
const BadBadContextState = 1

type BadContextStateError GenericError

// BadContextStateErrorNew constructs a BadContextStateError value that implements xgb.Error from a byte slice.
func BadContextStateErrorNew(buf []byte) xgb.Error {
	v := BadContextStateError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadContextState"
	return v
}

// SequenceId returns the sequence id attached to the BadBadContextState error.
// This is mostly used internally.
func (err BadContextStateError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadContextState error. If no bad value exists, 0 is returned.
func (err BadContextStateError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadContextState error.
func (err BadContextStateError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadContextState {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][1] = BadContextStateErrorNew
}

// BadBadContextTag is the error number for a BadBadContextTag.
const BadBadContextTag = 4

type BadContextTagError GenericError

// BadContextTagErrorNew constructs a BadContextTagError value that implements xgb.Error from a byte slice.
func BadContextTagErrorNew(buf []byte) xgb.Error {
	v := BadContextTagError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadContextTag"
	return v
}

// SequenceId returns the sequence id attached to the BadBadContextTag error.
// This is mostly used internally.
func (err BadContextTagError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadContextTag error. If no bad value exists, 0 is returned.
func (err BadContextTagError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadContextTag error.
func (err BadContextTagError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadContextTag {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][4] = BadContextTagErrorNew
}

// BadBadCurrentDrawable is the error number for a BadBadCurrentDrawable.
const BadBadCurrentDrawable = 11

type BadCurrentDrawableError GenericError

// BadCurrentDrawableErrorNew constructs a BadCurrentDrawableError value that implements xgb.Error from a byte slice.
func BadCurrentDrawableErrorNew(buf []byte) xgb.Error {
	v := BadCurrentDrawableError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadCurrentDrawable"
	return v
}

// SequenceId returns the sequence id attached to the BadBadCurrentDrawable error.
// This is mostly used internally.
func (err BadCurrentDrawableError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadCurrentDrawable error. If no bad value exists, 0 is returned.
func (err BadCurrentDrawableError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadCurrentDrawable error.
func (err BadCurrentDrawableError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadCurrentDrawable {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][11] = BadCurrentDrawableErrorNew
}

// BadBadCurrentWindow is the error number for a BadBadCurrentWindow.
const BadBadCurrentWindow = 5

type BadCurrentWindowError GenericError

// BadCurrentWindowErrorNew constructs a BadCurrentWindowError value that implements xgb.Error from a byte slice.
func BadCurrentWindowErrorNew(buf []byte) xgb.Error {
	v := BadCurrentWindowError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadCurrentWindow"
	return v
}

// SequenceId returns the sequence id attached to the BadBadCurrentWindow error.
// This is mostly used internally.
func (err BadCurrentWindowError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadCurrentWindow error. If no bad value exists, 0 is returned.
func (err BadCurrentWindowError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadCurrentWindow error.
func (err BadCurrentWindowError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadCurrentWindow {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][5] = BadCurrentWindowErrorNew
}

// BadBadDrawable is the error number for a BadBadDrawable.
const BadBadDrawable = 2

type BadDrawableError GenericError

// BadDrawableErrorNew constructs a BadDrawableError value that implements xgb.Error from a byte slice.
func BadDrawableErrorNew(buf []byte) xgb.Error {
	v := BadDrawableError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadDrawable"
	return v
}

// SequenceId returns the sequence id attached to the BadBadDrawable error.
// This is mostly used internally.
func (err BadDrawableError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadDrawable error. If no bad value exists, 0 is returned.
func (err BadDrawableError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadDrawable error.
func (err BadDrawableError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadDrawable {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][2] = BadDrawableErrorNew
}

// BadBadFBConfig is the error number for a BadBadFBConfig.
const BadBadFBConfig = 9

type BadFBConfigError GenericError

// BadFBConfigErrorNew constructs a BadFBConfigError value that implements xgb.Error from a byte slice.
func BadFBConfigErrorNew(buf []byte) xgb.Error {
	v := BadFBConfigError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadFBConfig"
	return v
}

// SequenceId returns the sequence id attached to the BadBadFBConfig error.
// This is mostly used internally.
func (err BadFBConfigError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadFBConfig error. If no bad value exists, 0 is returned.
func (err BadFBConfigError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadFBConfig error.
func (err BadFBConfigError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadFBConfig {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][9] = BadFBConfigErrorNew
}

// BadBadLargeRequest is the error number for a BadBadLargeRequest.
const BadBadLargeRequest = 7

type BadLargeRequestError GenericError

// BadLargeRequestErrorNew constructs a BadLargeRequestError value that implements xgb.Error from a byte slice.
func BadLargeRequestErrorNew(buf []byte) xgb.Error {
	v := BadLargeRequestError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadLargeRequest"
	return v
}

// SequenceId returns the sequence id attached to the BadBadLargeRequest error.
// This is mostly used internally.
func (err BadLargeRequestError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadLargeRequest error. If no bad value exists, 0 is returned.
func (err BadLargeRequestError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadLargeRequest error.
func (err BadLargeRequestError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadLargeRequest {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][7] = BadLargeRequestErrorNew
}

// BadBadPbuffer is the error number for a BadBadPbuffer.
const BadBadPbuffer = 10

type BadPbufferError GenericError

// BadPbufferErrorNew constructs a BadPbufferError value that implements xgb.Error from a byte slice.
func BadPbufferErrorNew(buf []byte) xgb.Error {
	v := BadPbufferError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadPbuffer"
	return v
}

// SequenceId returns the sequence id attached to the BadBadPbuffer error.
// This is mostly used internally.
func (err BadPbufferError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadPbuffer error. If no bad value exists, 0 is returned.
func (err BadPbufferError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadPbuffer error.
func (err BadPbufferError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadPbuffer {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][10] = BadPbufferErrorNew
}

// BadBadPixmap is the error number for a BadBadPixmap.
const BadBadPixmap = 3

type BadPixmapError GenericError

// BadPixmapErrorNew constructs a BadPixmapError value that implements xgb.Error from a byte slice.
func BadPixmapErrorNew(buf []byte) xgb.Error {
	v := BadPixmapError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadPixmap"
	return v
}

// SequenceId returns the sequence id attached to the BadBadPixmap error.
// This is mostly used internally.
func (err BadPixmapError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadPixmap error. If no bad value exists, 0 is returned.
func (err BadPixmapError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadPixmap error.
func (err BadPixmapError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadPixmap {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][3] = BadPixmapErrorNew
}

// BadBadRenderRequest is the error number for a BadBadRenderRequest.
const BadBadRenderRequest = 6

type BadRenderRequestError GenericError

// BadRenderRequestErrorNew constructs a BadRenderRequestError value that implements xgb.Error from a byte slice.
func BadRenderRequestErrorNew(buf []byte) xgb.Error {
	v := BadRenderRequestError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadRenderRequest"
	return v
}

// SequenceId returns the sequence id attached to the BadBadRenderRequest error.
// This is mostly used internally.
func (err BadRenderRequestError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadRenderRequest error. If no bad value exists, 0 is returned.
func (err BadRenderRequestError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadRenderRequest error.
func (err BadRenderRequestError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadRenderRequest {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][6] = BadRenderRequestErrorNew
}

// BadBadWindow is the error number for a BadBadWindow.
const BadBadWindow = 12

type BadWindowError GenericError

// BadWindowErrorNew constructs a BadWindowError value that implements xgb.Error from a byte slice.
func BadWindowErrorNew(buf []byte) xgb.Error {
	v := BadWindowError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "BadWindow"
	return v
}

// SequenceId returns the sequence id attached to the BadBadWindow error.
// This is mostly used internally.
func (err BadWindowError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadWindow error. If no bad value exists, 0 is returned.
func (err BadWindowError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadWindow error.
func (err BadWindowError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadBadWindow {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][12] = BadWindowErrorNew
}

type Bool32 uint32

// BufferSwapComplete is the event number for a BufferSwapCompleteEvent.
const BufferSwapComplete = 1

type BufferSwapCompleteEvent struct {
	Sequence uint16
	// padding: 1 bytes
	EventType uint16
	// padding: 2 bytes
	Drawable Drawable
	UstHi    uint32
	UstLo    uint32
	MscHi    uint32
	MscLo    uint32
	Sbc      uint32
}

// BufferSwapCompleteEventNew constructs a BufferSwapCompleteEvent value that implements xgb.Event from a byte slice.
func BufferSwapCompleteEventNew(buf []byte) xgb.Event {
	v := BufferSwapCompleteEvent{}
	b := 1 // don't read event number

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.EventType = xgb.Get16(buf[b:])
	b += 2

	b += 2 // padding

	v.Drawable = Drawable(xgb.Get32(buf[b:]))
	b += 4

	v.UstHi = xgb.Get32(buf[b:])
	b += 4

	v.UstLo = xgb.Get32(buf[b:])
	b += 4

	v.MscHi = xgb.Get32(buf[b:])
	b += 4

	v.MscLo = xgb.Get32(buf[b:])
	b += 4

	v.Sbc = xgb.Get32(buf[b:])
	b += 4

	return v
}

// Bytes writes a BufferSwapCompleteEvent value to a byte slice.
func (v BufferSwapCompleteEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 1
	b += 1

	b += 1 // padding

	b += 2 // skip sequence number

	xgb.Put16(buf[b:], v.EventType)
	b += 2

	b += 2 // padding

	xgb.Put32(buf[b:], uint32(v.Drawable))
	b += 4

	xgb.Put32(buf[b:], v.UstHi)
	b += 4

	xgb.Put32(buf[b:], v.UstLo)
	b += 4

	xgb.Put32(buf[b:], v.MscHi)
	b += 4

	xgb.Put32(buf[b:], v.MscLo)
	b += 4

	xgb.Put32(buf[b:], v.Sbc)
	b += 4

	return buf
}

// SequenceId returns the sequence id attached to the BufferSwapComplete event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v BufferSwapCompleteEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of BufferSwapCompleteEvent.
func (v BufferSwapCompleteEvent) String() string {
	fieldVals := make([]string, 0, 9)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("EventType: %d", v.EventType))
	fieldVals = append(fieldVals, xgb.Sprintf("Drawable: %d", v.Drawable))
	fieldVals = append(fieldVals, xgb.Sprintf("UstHi: %d", v.UstHi))
	fieldVals = append(fieldVals, xgb.Sprintf("UstLo: %d", v.UstLo))
	fieldVals = append(fieldVals, xgb.Sprintf("MscHi: %d", v.MscHi))
	fieldVals = append(fieldVals, xgb.Sprintf("MscLo: %d", v.MscLo))
	fieldVals = append(fieldVals, xgb.Sprintf("Sbc: %d", v.Sbc))
	return "BufferSwapComplete {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["GLX"][1] = BufferSwapCompleteEventNew
}

type Context uint32

func NewContextId(c *xgb.Conn) (Context, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Context(id), nil
}

type ContextTag uint32

type Drawable uint32

func NewDrawableId(c *xgb.Conn) (Drawable, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Drawable(id), nil
}

type Fbconfig uint32

func NewFbconfigId(c *xgb.Conn) (Fbconfig, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Fbconfig(id), nil
}

type Float32 float64

type Float64 float64

// BadGLXBadProfileARB is the error number for a BadGLXBadProfileARB.
const BadGLXBadProfileARB = 13

type GLXBadProfileARBError GenericError

// GLXBadProfileARBErrorNew constructs a GLXBadProfileARBError value that implements xgb.Error from a byte slice.
func GLXBadProfileARBErrorNew(buf []byte) xgb.Error {
	v := GLXBadProfileARBError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "GLXBadProfileARB"
	return v
}

// SequenceId returns the sequence id attached to the BadGLXBadProfileARB error.
// This is mostly used internally.
func (err GLXBadProfileARBError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadGLXBadProfileARB error. If no bad value exists, 0 is returned.
func (err GLXBadProfileARBError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadGLXBadProfileARB error.
func (err GLXBadProfileARBError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadGLXBadProfileARB {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][13] = GLXBadProfileARBErrorNew
}

const (
	GcGlCurrentBit        = 1
	GcGlPointBit          = 2
	GcGlLineBit           = 4
	GcGlPolygonBit        = 8
	GcGlPolygonStippleBit = 16
	GcGlPixelModeBit      = 32
	GcGlLightingBit       = 64
	GcGlFogBit            = 128
	GcGlDepthBufferBit    = 256
	GcGlAccumBufferBit    = 512
	GcGlStencilBufferBit  = 1024
	GcGlViewportBit       = 2048
	GcGlTransformBit      = 4096
	GcGlEnableBit         = 8192
	GcGlColorBufferBit    = 16384
	GcGlHintBit           = 32768
	GcGlEvalBit           = 65536
	GcGlListBit           = 131072
	GcGlTextureBit        = 262144
	GcGlScissorBit        = 524288
	GcGlAllAttribBits     = 16777215
)

// BadGeneric is the error number for a BadGeneric.
const BadGeneric = -1

type GenericError struct {
	Sequence    uint16
	NiceName    string
	BadValue    uint32
	MinorOpcode uint16
	MajorOpcode byte
	// padding: 21 bytes
}

// GenericErrorNew constructs a GenericError value that implements xgb.Error from a byte slice.
func GenericErrorNew(buf []byte) xgb.Error {
	v := GenericError{}
	v.NiceName = "Generic"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.BadValue = xgb.Get32(buf[b:])
	b += 4

	v.MinorOpcode = xgb.Get16(buf[b:])
	b += 2

	v.MajorOpcode = buf[b]
	b += 1

	b += 21 // padding

	return v
}

// SequenceId returns the sequence id attached to the BadGeneric error.
// This is mostly used internally.
func (err GenericError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadGeneric error. If no bad value exists, 0 is returned.
func (err GenericError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadGeneric error.

func (err GenericError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadGeneric {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][-1] = GenericErrorNew
}

const (
	PbcdtWindow  = 32793
	PbcdtPbuffer = 32794
)

const (
	PbcetDamaged = 32791
	PbcetSaved   = 32792
)

type Pbuffer uint32

func NewPbufferId(c *xgb.Conn) (Pbuffer, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Pbuffer(id), nil
}

// PbufferClobber is the event number for a PbufferClobberEvent.
const PbufferClobber = 0

type PbufferClobberEvent struct {
	Sequence uint16
	// padding: 1 bytes
	EventType uint16
	DrawType  uint16
	Drawable  Drawable
	BMask     uint32
	AuxBuffer uint16
	X         uint16
	Y         uint16
	Width     uint16
	Height    uint16
	Count     uint16
	// padding: 4 bytes
}

// PbufferClobberEventNew constructs a PbufferClobberEvent value that implements xgb.Event from a byte slice.
func PbufferClobberEventNew(buf []byte) xgb.Event {
	v := PbufferClobberEvent{}
	b := 1 // don't read event number

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.EventType = xgb.Get16(buf[b:])
	b += 2

	v.DrawType = xgb.Get16(buf[b:])
	b += 2

	v.Drawable = Drawable(xgb.Get32(buf[b:]))
	b += 4

	v.BMask = xgb.Get32(buf[b:])
	b += 4

	v.AuxBuffer = xgb.Get16(buf[b:])
	b += 2

	v.X = xgb.Get16(buf[b:])
	b += 2

	v.Y = xgb.Get16(buf[b:])
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.Count = xgb.Get16(buf[b:])
	b += 2

	b += 4 // padding

	return v
}

// Bytes writes a PbufferClobberEvent value to a byte slice.
func (v PbufferClobberEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 0
	b += 1

	b += 1 // padding

	b += 2 // skip sequence number

	xgb.Put16(buf[b:], v.EventType)
	b += 2

	xgb.Put16(buf[b:], v.DrawType)
	b += 2

	xgb.Put32(buf[b:], uint32(v.Drawable))
	b += 4

	xgb.Put32(buf[b:], v.BMask)
	b += 4

	xgb.Put16(buf[b:], v.AuxBuffer)
	b += 2

	xgb.Put16(buf[b:], v.X)
	b += 2

	xgb.Put16(buf[b:], v.Y)
	b += 2

	xgb.Put16(buf[b:], v.Width)
	b += 2

	xgb.Put16(buf[b:], v.Height)
	b += 2

	xgb.Put16(buf[b:], v.Count)
	b += 2

	b += 4 // padding

	return buf
}

// SequenceId returns the sequence id attached to the PbufferClobber event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v PbufferClobberEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of PbufferClobberEvent.
func (v PbufferClobberEvent) String() string {
	fieldVals := make([]string, 0, 12)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("EventType: %d", v.EventType))
	fieldVals = append(fieldVals, xgb.Sprintf("DrawType: %d", v.DrawType))
	fieldVals = append(fieldVals, xgb.Sprintf("Drawable: %d", v.Drawable))
	fieldVals = append(fieldVals, xgb.Sprintf("BMask: %d", v.BMask))
	fieldVals = append(fieldVals, xgb.Sprintf("AuxBuffer: %d", v.AuxBuffer))
	fieldVals = append(fieldVals, xgb.Sprintf("X: %d", v.X))
	fieldVals = append(fieldVals, xgb.Sprintf("Y: %d", v.Y))
	fieldVals = append(fieldVals, xgb.Sprintf("Width: %d", v.Width))
	fieldVals = append(fieldVals, xgb.Sprintf("Height: %d", v.Height))
	fieldVals = append(fieldVals, xgb.Sprintf("Count: %d", v.Count))
	return "PbufferClobber {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["GLX"][0] = PbufferClobberEventNew
}

type Pixmap uint32

func NewPixmapId(c *xgb.Conn) (Pixmap, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Pixmap(id), nil
}

const (
	RmGlRender   = 7168
	RmGlFeedback = 7169
	RmGlSelect   = 7170
)

// BadUnsupportedPrivateRequest is the error number for a BadUnsupportedPrivateRequest.
const BadUnsupportedPrivateRequest = 8

type UnsupportedPrivateRequestError GenericError

// UnsupportedPrivateRequestErrorNew constructs a UnsupportedPrivateRequestError value that implements xgb.Error from a byte slice.
func UnsupportedPrivateRequestErrorNew(buf []byte) xgb.Error {
	v := UnsupportedPrivateRequestError(GenericErrorNew(buf).(GenericError))
	v.NiceName = "UnsupportedPrivateRequest"
	return v
}

// SequenceId returns the sequence id attached to the BadUnsupportedPrivateRequest error.
// This is mostly used internally.
func (err UnsupportedPrivateRequestError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadUnsupportedPrivateRequest error. If no bad value exists, 0 is returned.
func (err UnsupportedPrivateRequestError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadUnsupportedPrivateRequest error.
func (err UnsupportedPrivateRequestError) Error() string {
	fieldVals := make([]string, 0, 4)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("BadValue: %d", err.BadValue))
	fieldVals = append(fieldVals, xgb.Sprintf("MinorOpcode: %d", err.MinorOpcode))
	fieldVals = append(fieldVals, xgb.Sprintf("MajorOpcode: %d", err.MajorOpcode))
	return "BadUnsupportedPrivateRequest {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["GLX"][8] = UnsupportedPrivateRequestErrorNew
}

type Window uint32

func NewWindowId(c *xgb.Conn) (Window, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Window(id), nil
}

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// AreTexturesResidentCookie is a cookie used only for AreTexturesResident requests.
type AreTexturesResidentCookie struct {
	*xgb.Cookie
}

// AreTexturesResident sends a checked request.
// If an error occurs, it will be returned with the reply by calling AreTexturesResidentCookie.Reply()
func AreTexturesResident(c *xgb.Conn, ContextTag ContextTag, N int32, Textures []uint32) AreTexturesResidentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'AreTexturesResident' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(areTexturesResidentRequest(c, ContextTag, N, Textures), cookie)
	return AreTexturesResidentCookie{cookie}
}

// AreTexturesResidentUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func AreTexturesResidentUnchecked(c *xgb.Conn, ContextTag ContextTag, N int32, Textures []uint32) AreTexturesResidentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'AreTexturesResident' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(areTexturesResidentRequest(c, ContextTag, N, Textures), cookie)
	return AreTexturesResidentCookie{cookie}
}

// AreTexturesResidentReply represents the data returned from a AreTexturesResident request.
type AreTexturesResidentReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal Bool32
	// padding: 20 bytes
	Data []bool // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a AreTexturesResident request.
func (cook AreTexturesResidentCookie) Reply() (*AreTexturesResidentReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return areTexturesResidentReply(buf), nil
}

// areTexturesResidentReply reads a byte slice into a AreTexturesResidentReply value.
func areTexturesResidentReply(buf []byte) *AreTexturesResidentReply {
	v := new(AreTexturesResidentReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = Bool32(xgb.Get32(buf[b:]))
	b += 4

	b += 20 // padding

	v.Data = make([]bool, (int(v.Length) * 4))
	for i := 0; i < int((int(v.Length) * 4)); i++ {
		if buf[b] == 1 {
			v.Data[i] = true
		} else {
			v.Data[i] = false
		}
		b += 1
	}

	return v
}

// Write request to wire for AreTexturesResident
// areTexturesResidentRequest writes a AreTexturesResident request to a byte slice.
func areTexturesResidentRequest(c *xgb.Conn, ContextTag ContextTag, N int32, Textures []uint32) []byte {
	size := xgb.Pad((12 + xgb.Pad((int(N) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 143 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(N))
	b += 4

	for i := 0; i < int(N); i++ {
		xgb.Put32(buf[b:], Textures[i])
		b += 4
	}

	return buf
}

// ChangeDrawableAttributesCookie is a cookie used only for ChangeDrawableAttributes requests.
type ChangeDrawableAttributesCookie struct {
	*xgb.Cookie
}

// ChangeDrawableAttributes sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangeDrawableAttributes(c *xgb.Conn, Drawable Drawable, NumAttribs uint32, Attribs []uint32) ChangeDrawableAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'ChangeDrawableAttributes' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changeDrawableAttributesRequest(c, Drawable, NumAttribs, Attribs), cookie)
	return ChangeDrawableAttributesCookie{cookie}
}

// ChangeDrawableAttributesChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangeDrawableAttributesCookie.Check()
func ChangeDrawableAttributesChecked(c *xgb.Conn, Drawable Drawable, NumAttribs uint32, Attribs []uint32) ChangeDrawableAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'ChangeDrawableAttributes' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changeDrawableAttributesRequest(c, Drawable, NumAttribs, Attribs), cookie)
	return ChangeDrawableAttributesCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangeDrawableAttributesCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangeDrawableAttributes
// changeDrawableAttributesRequest writes a ChangeDrawableAttributes request to a byte slice.
func changeDrawableAttributesRequest(c *xgb.Conn, Drawable Drawable, NumAttribs uint32, Attribs []uint32) []byte {
	size := xgb.Pad((12 + xgb.Pad(((int(NumAttribs) * 2) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 30 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	xgb.Put32(buf[b:], NumAttribs)
	b += 4

	for i := 0; i < int((int(NumAttribs) * 2)); i++ {
		xgb.Put32(buf[b:], Attribs[i])
		b += 4
	}

	return buf
}

// ClientInfoCookie is a cookie used only for ClientInfo requests.
type ClientInfoCookie struct {
	*xgb.Cookie
}

// ClientInfo sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ClientInfo(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, StrLen uint32, String string) ClientInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'ClientInfo' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(clientInfoRequest(c, MajorVersion, MinorVersion, StrLen, String), cookie)
	return ClientInfoCookie{cookie}
}

// ClientInfoChecked sends a checked request.
// If an error occurs, it can be retrieved using ClientInfoCookie.Check()
func ClientInfoChecked(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, StrLen uint32, String string) ClientInfoCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'ClientInfo' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(clientInfoRequest(c, MajorVersion, MinorVersion, StrLen, String), cookie)
	return ClientInfoCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ClientInfoCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ClientInfo
// clientInfoRequest writes a ClientInfo request to a byte slice.
func clientInfoRequest(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, StrLen uint32, String string) []byte {
	size := xgb.Pad((16 + xgb.Pad((int(StrLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], MajorVersion)
	b += 4

	xgb.Put32(buf[b:], MinorVersion)
	b += 4

	xgb.Put32(buf[b:], StrLen)
	b += 4

	copy(buf[b:], String[:StrLen])
	b += int(StrLen)

	return buf
}

// CopyContextCookie is a cookie used only for CopyContext requests.
type CopyContextCookie struct {
	*xgb.Cookie
}

// CopyContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CopyContext(c *xgb.Conn, Src Context, Dest Context, Mask uint32, SrcContextTag ContextTag) CopyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CopyContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(copyContextRequest(c, Src, Dest, Mask, SrcContextTag), cookie)
	return CopyContextCookie{cookie}
}

// CopyContextChecked sends a checked request.
// If an error occurs, it can be retrieved using CopyContextCookie.Check()
func CopyContextChecked(c *xgb.Conn, Src Context, Dest Context, Mask uint32, SrcContextTag ContextTag) CopyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CopyContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(copyContextRequest(c, Src, Dest, Mask, SrcContextTag), cookie)
	return CopyContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CopyContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CopyContext
// copyContextRequest writes a CopyContext request to a byte slice.
func copyContextRequest(c *xgb.Conn, Src Context, Dest Context, Mask uint32, SrcContextTag ContextTag) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put32(buf[b:], uint32(Dest))
	b += 4

	xgb.Put32(buf[b:], Mask)
	b += 4

	xgb.Put32(buf[b:], uint32(SrcContextTag))
	b += 4

	return buf
}

// CreateContextCookie is a cookie used only for CreateContext requests.
type CreateContextCookie struct {
	*xgb.Cookie
}

// CreateContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateContext(c *xgb.Conn, Context Context, Visual xproto.Visualid, Screen uint32, ShareList Context, IsDirect bool) CreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createContextRequest(c, Context, Visual, Screen, ShareList, IsDirect), cookie)
	return CreateContextCookie{cookie}
}

// CreateContextChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateContextCookie.Check()
func CreateContextChecked(c *xgb.Conn, Context Context, Visual xproto.Visualid, Screen uint32, ShareList Context, IsDirect bool) CreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createContextRequest(c, Context, Visual, Screen, ShareList, IsDirect), cookie)
	return CreateContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateContext
// createContextRequest writes a CreateContext request to a byte slice.
func createContextRequest(c *xgb.Conn, Context Context, Visual xproto.Visualid, Screen uint32, ShareList Context, IsDirect bool) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 3 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], uint32(Visual))
	b += 4

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(ShareList))
	b += 4

	if IsDirect {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 3 // padding

	return buf
}

// CreateContextAttribsARBCookie is a cookie used only for CreateContextAttribsARB requests.
type CreateContextAttribsARBCookie struct {
	*xgb.Cookie
}

// CreateContextAttribsARB sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateContextAttribsARB(c *xgb.Conn, Context Context, Fbconfig Fbconfig, Screen uint32, ShareList Context, IsDirect bool, NumAttribs uint32, Attribs []uint32) CreateContextAttribsARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateContextAttribsARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createContextAttribsARBRequest(c, Context, Fbconfig, Screen, ShareList, IsDirect, NumAttribs, Attribs), cookie)
	return CreateContextAttribsARBCookie{cookie}
}

// CreateContextAttribsARBChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateContextAttribsARBCookie.Check()
func CreateContextAttribsARBChecked(c *xgb.Conn, Context Context, Fbconfig Fbconfig, Screen uint32, ShareList Context, IsDirect bool, NumAttribs uint32, Attribs []uint32) CreateContextAttribsARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateContextAttribsARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createContextAttribsARBRequest(c, Context, Fbconfig, Screen, ShareList, IsDirect, NumAttribs, Attribs), cookie)
	return CreateContextAttribsARBCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateContextAttribsARBCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateContextAttribsARB
// createContextAttribsARBRequest writes a CreateContextAttribsARB request to a byte slice.
func createContextAttribsARBRequest(c *xgb.Conn, Context Context, Fbconfig Fbconfig, Screen uint32, ShareList Context, IsDirect bool, NumAttribs uint32, Attribs []uint32) []byte {
	size := xgb.Pad((28 + xgb.Pad(((int(NumAttribs) * 2) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 34 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], uint32(Fbconfig))
	b += 4

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(ShareList))
	b += 4

	if IsDirect {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 3 // padding

	xgb.Put32(buf[b:], NumAttribs)
	b += 4

	for i := 0; i < int((int(NumAttribs) * 2)); i++ {
		xgb.Put32(buf[b:], Attribs[i])
		b += 4
	}

	return buf
}

// CreateGLXPixmapCookie is a cookie used only for CreateGLXPixmap requests.
type CreateGLXPixmapCookie struct {
	*xgb.Cookie
}

// CreateGLXPixmap sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateGLXPixmap(c *xgb.Conn, Screen uint32, Visual xproto.Visualid, Pixmap xproto.Pixmap, GlxPixmap Pixmap) CreateGLXPixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateGLXPixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createGLXPixmapRequest(c, Screen, Visual, Pixmap, GlxPixmap), cookie)
	return CreateGLXPixmapCookie{cookie}
}

// CreateGLXPixmapChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateGLXPixmapCookie.Check()
func CreateGLXPixmapChecked(c *xgb.Conn, Screen uint32, Visual xproto.Visualid, Pixmap xproto.Pixmap, GlxPixmap Pixmap) CreateGLXPixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateGLXPixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createGLXPixmapRequest(c, Screen, Visual, Pixmap, GlxPixmap), cookie)
	return CreateGLXPixmapCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateGLXPixmapCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateGLXPixmap
// createGLXPixmapRequest writes a CreateGLXPixmap request to a byte slice.
func createGLXPixmapRequest(c *xgb.Conn, Screen uint32, Visual xproto.Visualid, Pixmap xproto.Pixmap, GlxPixmap Pixmap) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Visual))
	b += 4

	xgb.Put32(buf[b:], uint32(Pixmap))
	b += 4

	xgb.Put32(buf[b:], uint32(GlxPixmap))
	b += 4

	return buf
}

// CreateNewContextCookie is a cookie used only for CreateNewContext requests.
type CreateNewContextCookie struct {
	*xgb.Cookie
}

// CreateNewContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateNewContext(c *xgb.Conn, Context Context, Fbconfig Fbconfig, Screen uint32, RenderType uint32, ShareList Context, IsDirect bool) CreateNewContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateNewContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createNewContextRequest(c, Context, Fbconfig, Screen, RenderType, ShareList, IsDirect), cookie)
	return CreateNewContextCookie{cookie}
}

// CreateNewContextChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateNewContextCookie.Check()
func CreateNewContextChecked(c *xgb.Conn, Context Context, Fbconfig Fbconfig, Screen uint32, RenderType uint32, ShareList Context, IsDirect bool) CreateNewContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateNewContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createNewContextRequest(c, Context, Fbconfig, Screen, RenderType, ShareList, IsDirect), cookie)
	return CreateNewContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateNewContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateNewContext
// createNewContextRequest writes a CreateNewContext request to a byte slice.
func createNewContextRequest(c *xgb.Conn, Context Context, Fbconfig Fbconfig, Screen uint32, RenderType uint32, ShareList Context, IsDirect bool) []byte {
	size := 28
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 24 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], uint32(Fbconfig))
	b += 4

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], RenderType)
	b += 4

	xgb.Put32(buf[b:], uint32(ShareList))
	b += 4

	if IsDirect {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 3 // padding

	return buf
}

// CreatePbufferCookie is a cookie used only for CreatePbuffer requests.
type CreatePbufferCookie struct {
	*xgb.Cookie
}

// CreatePbuffer sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreatePbuffer(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Pbuffer Pbuffer, NumAttribs uint32, Attribs []uint32) CreatePbufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreatePbuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createPbufferRequest(c, Screen, Fbconfig, Pbuffer, NumAttribs, Attribs), cookie)
	return CreatePbufferCookie{cookie}
}

// CreatePbufferChecked sends a checked request.
// If an error occurs, it can be retrieved using CreatePbufferCookie.Check()
func CreatePbufferChecked(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Pbuffer Pbuffer, NumAttribs uint32, Attribs []uint32) CreatePbufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreatePbuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createPbufferRequest(c, Screen, Fbconfig, Pbuffer, NumAttribs, Attribs), cookie)
	return CreatePbufferCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreatePbufferCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreatePbuffer
// createPbufferRequest writes a CreatePbuffer request to a byte slice.
func createPbufferRequest(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Pbuffer Pbuffer, NumAttribs uint32, Attribs []uint32) []byte {
	size := xgb.Pad((20 + xgb.Pad(((int(NumAttribs) * 2) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 27 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Fbconfig))
	b += 4

	xgb.Put32(buf[b:], uint32(Pbuffer))
	b += 4

	xgb.Put32(buf[b:], NumAttribs)
	b += 4

	for i := 0; i < int((int(NumAttribs) * 2)); i++ {
		xgb.Put32(buf[b:], Attribs[i])
		b += 4
	}

	return buf
}

// CreatePixmapCookie is a cookie used only for CreatePixmap requests.
type CreatePixmapCookie struct {
	*xgb.Cookie
}

// CreatePixmap sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreatePixmap(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Pixmap xproto.Pixmap, GlxPixmap Pixmap, NumAttribs uint32, Attribs []uint32) CreatePixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreatePixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createPixmapRequest(c, Screen, Fbconfig, Pixmap, GlxPixmap, NumAttribs, Attribs), cookie)
	return CreatePixmapCookie{cookie}
}

// CreatePixmapChecked sends a checked request.
// If an error occurs, it can be retrieved using CreatePixmapCookie.Check()
func CreatePixmapChecked(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Pixmap xproto.Pixmap, GlxPixmap Pixmap, NumAttribs uint32, Attribs []uint32) CreatePixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreatePixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createPixmapRequest(c, Screen, Fbconfig, Pixmap, GlxPixmap, NumAttribs, Attribs), cookie)
	return CreatePixmapCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreatePixmapCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreatePixmap
// createPixmapRequest writes a CreatePixmap request to a byte slice.
func createPixmapRequest(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Pixmap xproto.Pixmap, GlxPixmap Pixmap, NumAttribs uint32, Attribs []uint32) []byte {
	size := xgb.Pad((24 + xgb.Pad(((int(NumAttribs) * 2) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 22 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Fbconfig))
	b += 4

	xgb.Put32(buf[b:], uint32(Pixmap))
	b += 4

	xgb.Put32(buf[b:], uint32(GlxPixmap))
	b += 4

	xgb.Put32(buf[b:], NumAttribs)
	b += 4

	for i := 0; i < int((int(NumAttribs) * 2)); i++ {
		xgb.Put32(buf[b:], Attribs[i])
		b += 4
	}

	return buf
}

// CreateWindowCookie is a cookie used only for CreateWindow requests.
type CreateWindowCookie struct {
	*xgb.Cookie
}

// CreateWindow sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateWindow(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Window xproto.Window, GlxWindow Window, NumAttribs uint32, Attribs []uint32) CreateWindowCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateWindow' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createWindowRequest(c, Screen, Fbconfig, Window, GlxWindow, NumAttribs, Attribs), cookie)
	return CreateWindowCookie{cookie}
}

// CreateWindowChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateWindowCookie.Check()
func CreateWindowChecked(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Window xproto.Window, GlxWindow Window, NumAttribs uint32, Attribs []uint32) CreateWindowCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'CreateWindow' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createWindowRequest(c, Screen, Fbconfig, Window, GlxWindow, NumAttribs, Attribs), cookie)
	return CreateWindowCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateWindowCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateWindow
// createWindowRequest writes a CreateWindow request to a byte slice.
func createWindowRequest(c *xgb.Conn, Screen uint32, Fbconfig Fbconfig, Window xproto.Window, GlxWindow Window, NumAttribs uint32, Attribs []uint32) []byte {
	size := xgb.Pad((24 + xgb.Pad(((int(NumAttribs) * 2) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 31 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], uint32(Fbconfig))
	b += 4

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(GlxWindow))
	b += 4

	xgb.Put32(buf[b:], NumAttribs)
	b += 4

	for i := 0; i < int((int(NumAttribs) * 2)); i++ {
		xgb.Put32(buf[b:], Attribs[i])
		b += 4
	}

	return buf
}

// DeleteListsCookie is a cookie used only for DeleteLists requests.
type DeleteListsCookie struct {
	*xgb.Cookie
}

// DeleteLists sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteLists(c *xgb.Conn, ContextTag ContextTag, List uint32, Range int32) DeleteListsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteLists' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteListsRequest(c, ContextTag, List, Range), cookie)
	return DeleteListsCookie{cookie}
}

// DeleteListsChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteListsCookie.Check()
func DeleteListsChecked(c *xgb.Conn, ContextTag ContextTag, List uint32, Range int32) DeleteListsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteLists' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteListsRequest(c, ContextTag, List, Range), cookie)
	return DeleteListsCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteListsCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteLists
// deleteListsRequest writes a DeleteLists request to a byte slice.
func deleteListsRequest(c *xgb.Conn, ContextTag ContextTag, List uint32, Range int32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 103 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], List)
	b += 4

	xgb.Put32(buf[b:], uint32(Range))
	b += 4

	return buf
}

// DeleteQueriesARBCookie is a cookie used only for DeleteQueriesARB requests.
type DeleteQueriesARBCookie struct {
	*xgb.Cookie
}

// DeleteQueriesARB sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteQueriesARB(c *xgb.Conn, ContextTag ContextTag, N int32, Ids []uint32) DeleteQueriesARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteQueriesARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteQueriesARBRequest(c, ContextTag, N, Ids), cookie)
	return DeleteQueriesARBCookie{cookie}
}

// DeleteQueriesARBChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteQueriesARBCookie.Check()
func DeleteQueriesARBChecked(c *xgb.Conn, ContextTag ContextTag, N int32, Ids []uint32) DeleteQueriesARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteQueriesARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteQueriesARBRequest(c, ContextTag, N, Ids), cookie)
	return DeleteQueriesARBCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteQueriesARBCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteQueriesARB
// deleteQueriesARBRequest writes a DeleteQueriesARB request to a byte slice.
func deleteQueriesARBRequest(c *xgb.Conn, ContextTag ContextTag, N int32, Ids []uint32) []byte {
	size := xgb.Pad((12 + xgb.Pad((int(N) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 161 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(N))
	b += 4

	for i := 0; i < int(N); i++ {
		xgb.Put32(buf[b:], Ids[i])
		b += 4
	}

	return buf
}

// DeleteTexturesCookie is a cookie used only for DeleteTextures requests.
type DeleteTexturesCookie struct {
	*xgb.Cookie
}

// DeleteTextures sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteTextures(c *xgb.Conn, ContextTag ContextTag, N int32, Textures []uint32) DeleteTexturesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteTextures' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteTexturesRequest(c, ContextTag, N, Textures), cookie)
	return DeleteTexturesCookie{cookie}
}

// DeleteTexturesChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteTexturesCookie.Check()
func DeleteTexturesChecked(c *xgb.Conn, ContextTag ContextTag, N int32, Textures []uint32) DeleteTexturesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteTextures' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteTexturesRequest(c, ContextTag, N, Textures), cookie)
	return DeleteTexturesCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteTexturesCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteTextures
// deleteTexturesRequest writes a DeleteTextures request to a byte slice.
func deleteTexturesRequest(c *xgb.Conn, ContextTag ContextTag, N int32, Textures []uint32) []byte {
	size := xgb.Pad((12 + xgb.Pad((int(N) * 4))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 144 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(N))
	b += 4

	for i := 0; i < int(N); i++ {
		xgb.Put32(buf[b:], Textures[i])
		b += 4
	}

	return buf
}

// DeleteWindowCookie is a cookie used only for DeleteWindow requests.
type DeleteWindowCookie struct {
	*xgb.Cookie
}

// DeleteWindow sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeleteWindow(c *xgb.Conn, Glxwindow Window) DeleteWindowCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteWindow' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deleteWindowRequest(c, Glxwindow), cookie)
	return DeleteWindowCookie{cookie}
}

// DeleteWindowChecked sends a checked request.
// If an error occurs, it can be retrieved using DeleteWindowCookie.Check()
func DeleteWindowChecked(c *xgb.Conn, Glxwindow Window) DeleteWindowCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DeleteWindow' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deleteWindowRequest(c, Glxwindow), cookie)
	return DeleteWindowCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeleteWindowCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeleteWindow
// deleteWindowRequest writes a DeleteWindow request to a byte slice.
func deleteWindowRequest(c *xgb.Conn, Glxwindow Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 32 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Glxwindow))
	b += 4

	return buf
}

// DestroyContextCookie is a cookie used only for DestroyContext requests.
type DestroyContextCookie struct {
	*xgb.Cookie
}

// DestroyContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DestroyContext(c *xgb.Conn, Context Context) DestroyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(destroyContextRequest(c, Context), cookie)
	return DestroyContextCookie{cookie}
}

// DestroyContextChecked sends a checked request.
// If an error occurs, it can be retrieved using DestroyContextCookie.Check()
func DestroyContextChecked(c *xgb.Conn, Context Context) DestroyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(destroyContextRequest(c, Context), cookie)
	return DestroyContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DestroyContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DestroyContext
// destroyContextRequest writes a DestroyContext request to a byte slice.
func destroyContextRequest(c *xgb.Conn, Context Context) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// DestroyGLXPixmapCookie is a cookie used only for DestroyGLXPixmap requests.
type DestroyGLXPixmapCookie struct {
	*xgb.Cookie
}

// DestroyGLXPixmap sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DestroyGLXPixmap(c *xgb.Conn, GlxPixmap Pixmap) DestroyGLXPixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyGLXPixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(destroyGLXPixmapRequest(c, GlxPixmap), cookie)
	return DestroyGLXPixmapCookie{cookie}
}

// DestroyGLXPixmapChecked sends a checked request.
// If an error occurs, it can be retrieved using DestroyGLXPixmapCookie.Check()
func DestroyGLXPixmapChecked(c *xgb.Conn, GlxPixmap Pixmap) DestroyGLXPixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyGLXPixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(destroyGLXPixmapRequest(c, GlxPixmap), cookie)
	return DestroyGLXPixmapCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DestroyGLXPixmapCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DestroyGLXPixmap
// destroyGLXPixmapRequest writes a DestroyGLXPixmap request to a byte slice.
func destroyGLXPixmapRequest(c *xgb.Conn, GlxPixmap Pixmap) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 15 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(GlxPixmap))
	b += 4

	return buf
}

// DestroyPbufferCookie is a cookie used only for DestroyPbuffer requests.
type DestroyPbufferCookie struct {
	*xgb.Cookie
}

// DestroyPbuffer sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DestroyPbuffer(c *xgb.Conn, Pbuffer Pbuffer) DestroyPbufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyPbuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(destroyPbufferRequest(c, Pbuffer), cookie)
	return DestroyPbufferCookie{cookie}
}

// DestroyPbufferChecked sends a checked request.
// If an error occurs, it can be retrieved using DestroyPbufferCookie.Check()
func DestroyPbufferChecked(c *xgb.Conn, Pbuffer Pbuffer) DestroyPbufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyPbuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(destroyPbufferRequest(c, Pbuffer), cookie)
	return DestroyPbufferCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DestroyPbufferCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DestroyPbuffer
// destroyPbufferRequest writes a DestroyPbuffer request to a byte slice.
func destroyPbufferRequest(c *xgb.Conn, Pbuffer Pbuffer) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 28 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Pbuffer))
	b += 4

	return buf
}

// DestroyPixmapCookie is a cookie used only for DestroyPixmap requests.
type DestroyPixmapCookie struct {
	*xgb.Cookie
}

// DestroyPixmap sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DestroyPixmap(c *xgb.Conn, GlxPixmap Pixmap) DestroyPixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyPixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(destroyPixmapRequest(c, GlxPixmap), cookie)
	return DestroyPixmapCookie{cookie}
}

// DestroyPixmapChecked sends a checked request.
// If an error occurs, it can be retrieved using DestroyPixmapCookie.Check()
func DestroyPixmapChecked(c *xgb.Conn, GlxPixmap Pixmap) DestroyPixmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'DestroyPixmap' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(destroyPixmapRequest(c, GlxPixmap), cookie)
	return DestroyPixmapCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DestroyPixmapCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DestroyPixmap
// destroyPixmapRequest writes a DestroyPixmap request to a byte slice.
func destroyPixmapRequest(c *xgb.Conn, GlxPixmap Pixmap) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 23 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(GlxPixmap))
	b += 4

	return buf
}

// EndListCookie is a cookie used only for EndList requests.
type EndListCookie struct {
	*xgb.Cookie
}

// EndList sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func EndList(c *xgb.Conn, ContextTag ContextTag) EndListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'EndList' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(endListRequest(c, ContextTag), cookie)
	return EndListCookie{cookie}
}

// EndListChecked sends a checked request.
// If an error occurs, it can be retrieved using EndListCookie.Check()
func EndListChecked(c *xgb.Conn, ContextTag ContextTag) EndListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'EndList' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(endListRequest(c, ContextTag), cookie)
	return EndListCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook EndListCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for EndList
// endListRequest writes a EndList request to a byte slice.
func endListRequest(c *xgb.Conn, ContextTag ContextTag) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 102 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	return buf
}

// FeedbackBufferCookie is a cookie used only for FeedbackBuffer requests.
type FeedbackBufferCookie struct {
	*xgb.Cookie
}

// FeedbackBuffer sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FeedbackBuffer(c *xgb.Conn, ContextTag ContextTag, Size int32, Type int32) FeedbackBufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'FeedbackBuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(feedbackBufferRequest(c, ContextTag, Size, Type), cookie)
	return FeedbackBufferCookie{cookie}
}

// FeedbackBufferChecked sends a checked request.
// If an error occurs, it can be retrieved using FeedbackBufferCookie.Check()
func FeedbackBufferChecked(c *xgb.Conn, ContextTag ContextTag, Size int32, Type int32) FeedbackBufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'FeedbackBuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(feedbackBufferRequest(c, ContextTag, Size, Type), cookie)
	return FeedbackBufferCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FeedbackBufferCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for FeedbackBuffer
// feedbackBufferRequest writes a FeedbackBuffer request to a byte slice.
func feedbackBufferRequest(c *xgb.Conn, ContextTag ContextTag, Size int32, Type int32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 105 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Size))
	b += 4

	xgb.Put32(buf[b:], uint32(Type))
	b += 4

	return buf
}

// FinishCookie is a cookie used only for Finish requests.
type FinishCookie struct {
	*xgb.Cookie
}

// Finish sends a checked request.
// If an error occurs, it will be returned with the reply by calling FinishCookie.Reply()
func Finish(c *xgb.Conn, ContextTag ContextTag) FinishCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'Finish' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(finishRequest(c, ContextTag), cookie)
	return FinishCookie{cookie}
}

// FinishUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FinishUnchecked(c *xgb.Conn, ContextTag ContextTag) FinishCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'Finish' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(finishRequest(c, ContextTag), cookie)
	return FinishCookie{cookie}
}

// FinishReply represents the data returned from a Finish request.
type FinishReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
}

// Reply blocks and returns the reply data for a Finish request.
func (cook FinishCookie) Reply() (*FinishReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return finishReply(buf), nil
}

// finishReply reads a byte slice into a FinishReply value.
func finishReply(buf []byte) *FinishReply {
	v := new(FinishReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	return v
}

// Write request to wire for Finish
// finishRequest writes a Finish request to a byte slice.
func finishRequest(c *xgb.Conn, ContextTag ContextTag) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 108 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	return buf
}

// FlushCookie is a cookie used only for Flush requests.
type FlushCookie struct {
	*xgb.Cookie
}

// Flush sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func Flush(c *xgb.Conn, ContextTag ContextTag) FlushCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'Flush' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(flushRequest(c, ContextTag), cookie)
	return FlushCookie{cookie}
}

// FlushChecked sends a checked request.
// If an error occurs, it can be retrieved using FlushCookie.Check()
func FlushChecked(c *xgb.Conn, ContextTag ContextTag) FlushCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'Flush' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(flushRequest(c, ContextTag), cookie)
	return FlushCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook FlushCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for Flush
// flushRequest writes a Flush request to a byte slice.
func flushRequest(c *xgb.Conn, ContextTag ContextTag) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 142 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	return buf
}

// GenListsCookie is a cookie used only for GenLists requests.
type GenListsCookie struct {
	*xgb.Cookie
}

// GenLists sends a checked request.
// If an error occurs, it will be returned with the reply by calling GenListsCookie.Reply()
func GenLists(c *xgb.Conn, ContextTag ContextTag, Range int32) GenListsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GenLists' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(genListsRequest(c, ContextTag, Range), cookie)
	return GenListsCookie{cookie}
}

// GenListsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GenListsUnchecked(c *xgb.Conn, ContextTag ContextTag, Range int32) GenListsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GenLists' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(genListsRequest(c, ContextTag, Range), cookie)
	return GenListsCookie{cookie}
}

// GenListsReply represents the data returned from a GenLists request.
type GenListsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal uint32
}

// Reply blocks and returns the reply data for a GenLists request.
func (cook GenListsCookie) Reply() (*GenListsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return genListsReply(buf), nil
}

// genListsReply reads a byte slice into a GenListsReply value.
func genListsReply(buf []byte) *GenListsReply {
	v := new(GenListsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = xgb.Get32(buf[b:])
	b += 4

	return v
}

// Write request to wire for GenLists
// genListsRequest writes a GenLists request to a byte slice.
func genListsRequest(c *xgb.Conn, ContextTag ContextTag, Range int32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 104 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Range))
	b += 4

	return buf
}

// GenQueriesARBCookie is a cookie used only for GenQueriesARB requests.
type GenQueriesARBCookie struct {
	*xgb.Cookie
}

// GenQueriesARB sends a checked request.
// If an error occurs, it will be returned with the reply by calling GenQueriesARBCookie.Reply()
func GenQueriesARB(c *xgb.Conn, ContextTag ContextTag, N int32) GenQueriesARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GenQueriesARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(genQueriesARBRequest(c, ContextTag, N), cookie)
	return GenQueriesARBCookie{cookie}
}

// GenQueriesARBUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GenQueriesARBUnchecked(c *xgb.Conn, ContextTag ContextTag, N int32) GenQueriesARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GenQueriesARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(genQueriesARBRequest(c, ContextTag, N), cookie)
	return GenQueriesARBCookie{cookie}
}

// GenQueriesARBReply represents the data returned from a GenQueriesARB request.
type GenQueriesARBReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 24 bytes
	Data []uint32 // size: xgb.Pad((int(Length) * 4))
}

// Reply blocks and returns the reply data for a GenQueriesARB request.
func (cook GenQueriesARBCookie) Reply() (*GenQueriesARBReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return genQueriesARBReply(buf), nil
}

// genQueriesARBReply reads a byte slice into a GenQueriesARBReply value.
func genQueriesARBReply(buf []byte) *GenQueriesARBReply {
	v := new(GenQueriesARBReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 24 // padding

	v.Data = make([]uint32, v.Length)
	for i := 0; i < int(v.Length); i++ {
		v.Data[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GenQueriesARB
// genQueriesARBRequest writes a GenQueriesARB request to a byte slice.
func genQueriesARBRequest(c *xgb.Conn, ContextTag ContextTag, N int32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 162 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(N))
	b += 4

	return buf
}

// GenTexturesCookie is a cookie used only for GenTextures requests.
type GenTexturesCookie struct {
	*xgb.Cookie
}

// GenTextures sends a checked request.
// If an error occurs, it will be returned with the reply by calling GenTexturesCookie.Reply()
func GenTextures(c *xgb.Conn, ContextTag ContextTag, N int32) GenTexturesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GenTextures' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(genTexturesRequest(c, ContextTag, N), cookie)
	return GenTexturesCookie{cookie}
}

// GenTexturesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GenTexturesUnchecked(c *xgb.Conn, ContextTag ContextTag, N int32) GenTexturesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GenTextures' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(genTexturesRequest(c, ContextTag, N), cookie)
	return GenTexturesCookie{cookie}
}

// GenTexturesReply represents the data returned from a GenTextures request.
type GenTexturesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 24 bytes
	Data []uint32 // size: xgb.Pad((int(Length) * 4))
}

// Reply blocks and returns the reply data for a GenTextures request.
func (cook GenTexturesCookie) Reply() (*GenTexturesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return genTexturesReply(buf), nil
}

// genTexturesReply reads a byte slice into a GenTexturesReply value.
func genTexturesReply(buf []byte) *GenTexturesReply {
	v := new(GenTexturesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 24 // padding

	v.Data = make([]uint32, v.Length)
	for i := 0; i < int(v.Length); i++ {
		v.Data[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GenTextures
// genTexturesRequest writes a GenTextures request to a byte slice.
func genTexturesRequest(c *xgb.Conn, ContextTag ContextTag, N int32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 145 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(N))
	b += 4

	return buf
}

// GetBooleanvCookie is a cookie used only for GetBooleanv requests.
type GetBooleanvCookie struct {
	*xgb.Cookie
}

// GetBooleanv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetBooleanvCookie.Reply()
func GetBooleanv(c *xgb.Conn, ContextTag ContextTag, Pname int32) GetBooleanvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetBooleanv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getBooleanvRequest(c, ContextTag, Pname), cookie)
	return GetBooleanvCookie{cookie}
}

// GetBooleanvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetBooleanvUnchecked(c *xgb.Conn, ContextTag ContextTag, Pname int32) GetBooleanvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetBooleanv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getBooleanvRequest(c, ContextTag, Pname), cookie)
	return GetBooleanvCookie{cookie}
}

// GetBooleanvReply represents the data returned from a GetBooleanv request.
type GetBooleanvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum bool
	// padding: 15 bytes
	Data []bool // size: xgb.Pad((int(N) * 1))
}

// Reply blocks and returns the reply data for a GetBooleanv request.
func (cook GetBooleanvCookie) Reply() (*GetBooleanvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getBooleanvReply(buf), nil
}

// getBooleanvReply reads a byte slice into a GetBooleanvReply value.
func getBooleanvReply(buf []byte) *GetBooleanvReply {
	v := new(GetBooleanvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	if buf[b] == 1 {
		v.Datum = true
	} else {
		v.Datum = false
	}
	b += 1

	b += 15 // padding

	v.Data = make([]bool, v.N)
	for i := 0; i < int(v.N); i++ {
		if buf[b] == 1 {
			v.Data[i] = true
		} else {
			v.Data[i] = false
		}
		b += 1
	}

	return v
}

// Write request to wire for GetBooleanv
// getBooleanvRequest writes a GetBooleanv request to a byte slice.
func getBooleanvRequest(c *xgb.Conn, ContextTag ContextTag, Pname int32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 112 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Pname))
	b += 4

	return buf
}

// GetClipPlaneCookie is a cookie used only for GetClipPlane requests.
type GetClipPlaneCookie struct {
	*xgb.Cookie
}

// GetClipPlane sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetClipPlaneCookie.Reply()
func GetClipPlane(c *xgb.Conn, ContextTag ContextTag, Plane int32) GetClipPlaneCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetClipPlane' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getClipPlaneRequest(c, ContextTag, Plane), cookie)
	return GetClipPlaneCookie{cookie}
}

// GetClipPlaneUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetClipPlaneUnchecked(c *xgb.Conn, ContextTag ContextTag, Plane int32) GetClipPlaneCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetClipPlane' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getClipPlaneRequest(c, ContextTag, Plane), cookie)
	return GetClipPlaneCookie{cookie}
}

// GetClipPlaneReply represents the data returned from a GetClipPlane request.
type GetClipPlaneReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 24 bytes
	Data []Float64 // size: xgb.Pad(((int(Length) / 2) * 8))
}

// Reply blocks and returns the reply data for a GetClipPlane request.
func (cook GetClipPlaneCookie) Reply() (*GetClipPlaneReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getClipPlaneReply(buf), nil
}

// getClipPlaneReply reads a byte slice into a GetClipPlaneReply value.
func getClipPlaneReply(buf []byte) *GetClipPlaneReply {
	v := new(GetClipPlaneReply)
	b := 1 // skip reply determinant

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 1 // padding

	b += 24 // padding

	v.Data = make([]Float64, (int(v.Length) / 2))
	for i := 0; i < int((int(v.Length) / 2)); i++ {
		v.Data[i] = Float64(xgb.Get64(buf[b:]))
		b += 8
	}

	return v
}

// Write request to wire for GetClipPlane
// getClipPlaneRequest writes a GetClipPlane request to a byte slice.
func getClipPlaneRequest(c *xgb.Conn, ContextTag ContextTag, Plane int32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 113 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Plane))
	b += 4

	return buf
}

// GetColorTableCookie is a cookie used only for GetColorTable requests.
type GetColorTableCookie struct {
	*xgb.Cookie
}

// GetColorTable sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetColorTableCookie.Reply()
func GetColorTable(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) GetColorTableCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetColorTable' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getColorTableRequest(c, ContextTag, Target, Format, Type, SwapBytes), cookie)
	return GetColorTableCookie{cookie}
}

// GetColorTableUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetColorTableUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) GetColorTableCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetColorTable' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getColorTableRequest(c, ContextTag, Target, Format, Type, SwapBytes), cookie)
	return GetColorTableCookie{cookie}
}

// GetColorTableReply represents the data returned from a GetColorTable request.
type GetColorTableReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 8 bytes
	Width int32
	// padding: 12 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetColorTable request.
func (cook GetColorTableCookie) Reply() (*GetColorTableReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getColorTableReply(buf), nil
}

// getColorTableReply reads a byte slice into a GetColorTableReply value.
func getColorTableReply(buf []byte) *GetColorTableReply {
	v := new(GetColorTableReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 8 // padding

	v.Width = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetColorTable
// getColorTableRequest writes a GetColorTable request to a byte slice.
func getColorTableRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 147 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetColorTableParameterfvCookie is a cookie used only for GetColorTableParameterfv requests.
type GetColorTableParameterfvCookie struct {
	*xgb.Cookie
}

// GetColorTableParameterfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetColorTableParameterfvCookie.Reply()
func GetColorTableParameterfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetColorTableParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetColorTableParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getColorTableParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetColorTableParameterfvCookie{cookie}
}

// GetColorTableParameterfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetColorTableParameterfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetColorTableParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetColorTableParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getColorTableParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetColorTableParameterfvCookie{cookie}
}

// GetColorTableParameterfvReply represents the data returned from a GetColorTableParameterfv request.
type GetColorTableParameterfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetColorTableParameterfv request.
func (cook GetColorTableParameterfvCookie) Reply() (*GetColorTableParameterfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getColorTableParameterfvReply(buf), nil
}

// getColorTableParameterfvReply reads a byte slice into a GetColorTableParameterfvReply value.
func getColorTableParameterfvReply(buf []byte) *GetColorTableParameterfvReply {
	v := new(GetColorTableParameterfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetColorTableParameterfv
// getColorTableParameterfvRequest writes a GetColorTableParameterfv request to a byte slice.
func getColorTableParameterfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 148 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetColorTableParameterivCookie is a cookie used only for GetColorTableParameteriv requests.
type GetColorTableParameterivCookie struct {
	*xgb.Cookie
}

// GetColorTableParameteriv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetColorTableParameterivCookie.Reply()
func GetColorTableParameteriv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetColorTableParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetColorTableParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getColorTableParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetColorTableParameterivCookie{cookie}
}

// GetColorTableParameterivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetColorTableParameterivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetColorTableParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetColorTableParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getColorTableParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetColorTableParameterivCookie{cookie}
}

// GetColorTableParameterivReply represents the data returned from a GetColorTableParameteriv request.
type GetColorTableParameterivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetColorTableParameteriv request.
func (cook GetColorTableParameterivCookie) Reply() (*GetColorTableParameterivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getColorTableParameterivReply(buf), nil
}

// getColorTableParameterivReply reads a byte slice into a GetColorTableParameterivReply value.
func getColorTableParameterivReply(buf []byte) *GetColorTableParameterivReply {
	v := new(GetColorTableParameterivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetColorTableParameteriv
// getColorTableParameterivRequest writes a GetColorTableParameteriv request to a byte slice.
func getColorTableParameterivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 149 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetCompressedTexImageARBCookie is a cookie used only for GetCompressedTexImageARB requests.
type GetCompressedTexImageARBCookie struct {
	*xgb.Cookie
}

// GetCompressedTexImageARB sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCompressedTexImageARBCookie.Reply()
func GetCompressedTexImageARB(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32) GetCompressedTexImageARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetCompressedTexImageARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCompressedTexImageARBRequest(c, ContextTag, Target, Level), cookie)
	return GetCompressedTexImageARBCookie{cookie}
}

// GetCompressedTexImageARBUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCompressedTexImageARBUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32) GetCompressedTexImageARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetCompressedTexImageARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCompressedTexImageARBRequest(c, ContextTag, Target, Level), cookie)
	return GetCompressedTexImageARBCookie{cookie}
}

// GetCompressedTexImageARBReply represents the data returned from a GetCompressedTexImageARB request.
type GetCompressedTexImageARBReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 8 bytes
	Size int32
	// padding: 12 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetCompressedTexImageARB request.
func (cook GetCompressedTexImageARBCookie) Reply() (*GetCompressedTexImageARBReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCompressedTexImageARBReply(buf), nil
}

// getCompressedTexImageARBReply reads a byte slice into a GetCompressedTexImageARBReply value.
func getCompressedTexImageARBReply(buf []byte) *GetCompressedTexImageARBReply {
	v := new(GetCompressedTexImageARBReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 8 // padding

	v.Size = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetCompressedTexImageARB
// getCompressedTexImageARBRequest writes a GetCompressedTexImageARB request to a byte slice.
func getCompressedTexImageARBRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 160 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], uint32(Level))
	b += 4

	return buf
}

// GetConvolutionFilterCookie is a cookie used only for GetConvolutionFilter requests.
type GetConvolutionFilterCookie struct {
	*xgb.Cookie
}

// GetConvolutionFilter sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetConvolutionFilterCookie.Reply()
func GetConvolutionFilter(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) GetConvolutionFilterCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetConvolutionFilter' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getConvolutionFilterRequest(c, ContextTag, Target, Format, Type, SwapBytes), cookie)
	return GetConvolutionFilterCookie{cookie}
}

// GetConvolutionFilterUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetConvolutionFilterUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) GetConvolutionFilterCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetConvolutionFilter' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getConvolutionFilterRequest(c, ContextTag, Target, Format, Type, SwapBytes), cookie)
	return GetConvolutionFilterCookie{cookie}
}

// GetConvolutionFilterReply represents the data returned from a GetConvolutionFilter request.
type GetConvolutionFilterReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 8 bytes
	Width  int32
	Height int32
	// padding: 8 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetConvolutionFilter request.
func (cook GetConvolutionFilterCookie) Reply() (*GetConvolutionFilterReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getConvolutionFilterReply(buf), nil
}

// getConvolutionFilterReply reads a byte slice into a GetConvolutionFilterReply value.
func getConvolutionFilterReply(buf []byte) *GetConvolutionFilterReply {
	v := new(GetConvolutionFilterReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 8 // padding

	v.Width = int32(xgb.Get32(buf[b:]))
	b += 4

	v.Height = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 8 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetConvolutionFilter
// getConvolutionFilterRequest writes a GetConvolutionFilter request to a byte slice.
func getConvolutionFilterRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 150 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetConvolutionParameterfvCookie is a cookie used only for GetConvolutionParameterfv requests.
type GetConvolutionParameterfvCookie struct {
	*xgb.Cookie
}

// GetConvolutionParameterfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetConvolutionParameterfvCookie.Reply()
func GetConvolutionParameterfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetConvolutionParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetConvolutionParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getConvolutionParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetConvolutionParameterfvCookie{cookie}
}

// GetConvolutionParameterfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetConvolutionParameterfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetConvolutionParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetConvolutionParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getConvolutionParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetConvolutionParameterfvCookie{cookie}
}

// GetConvolutionParameterfvReply represents the data returned from a GetConvolutionParameterfv request.
type GetConvolutionParameterfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetConvolutionParameterfv request.
func (cook GetConvolutionParameterfvCookie) Reply() (*GetConvolutionParameterfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getConvolutionParameterfvReply(buf), nil
}

// getConvolutionParameterfvReply reads a byte slice into a GetConvolutionParameterfvReply value.
func getConvolutionParameterfvReply(buf []byte) *GetConvolutionParameterfvReply {
	v := new(GetConvolutionParameterfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetConvolutionParameterfv
// getConvolutionParameterfvRequest writes a GetConvolutionParameterfv request to a byte slice.
func getConvolutionParameterfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 151 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetConvolutionParameterivCookie is a cookie used only for GetConvolutionParameteriv requests.
type GetConvolutionParameterivCookie struct {
	*xgb.Cookie
}

// GetConvolutionParameteriv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetConvolutionParameterivCookie.Reply()
func GetConvolutionParameteriv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetConvolutionParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetConvolutionParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getConvolutionParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetConvolutionParameterivCookie{cookie}
}

// GetConvolutionParameterivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetConvolutionParameterivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetConvolutionParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetConvolutionParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getConvolutionParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetConvolutionParameterivCookie{cookie}
}

// GetConvolutionParameterivReply represents the data returned from a GetConvolutionParameteriv request.
type GetConvolutionParameterivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetConvolutionParameteriv request.
func (cook GetConvolutionParameterivCookie) Reply() (*GetConvolutionParameterivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getConvolutionParameterivReply(buf), nil
}

// getConvolutionParameterivReply reads a byte slice into a GetConvolutionParameterivReply value.
func getConvolutionParameterivReply(buf []byte) *GetConvolutionParameterivReply {
	v := new(GetConvolutionParameterivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetConvolutionParameteriv
// getConvolutionParameterivRequest writes a GetConvolutionParameteriv request to a byte slice.
func getConvolutionParameterivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 152 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetDoublevCookie is a cookie used only for GetDoublev requests.
type GetDoublevCookie struct {
	*xgb.Cookie
}

// GetDoublev sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetDoublevCookie.Reply()
func GetDoublev(c *xgb.Conn, ContextTag ContextTag, Pname uint32) GetDoublevCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetDoublev' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getDoublevRequest(c, ContextTag, Pname), cookie)
	return GetDoublevCookie{cookie}
}

// GetDoublevUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetDoublevUnchecked(c *xgb.Conn, ContextTag ContextTag, Pname uint32) GetDoublevCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetDoublev' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getDoublevRequest(c, ContextTag, Pname), cookie)
	return GetDoublevCookie{cookie}
}

// GetDoublevReply represents the data returned from a GetDoublev request.
type GetDoublevReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float64
	// padding: 8 bytes
	Data []Float64 // size: xgb.Pad((int(N) * 8))
}

// Reply blocks and returns the reply data for a GetDoublev request.
func (cook GetDoublevCookie) Reply() (*GetDoublevReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getDoublevReply(buf), nil
}

// getDoublevReply reads a byte slice into a GetDoublevReply value.
func getDoublevReply(buf []byte) *GetDoublevReply {
	v := new(GetDoublevReply)
	b := 1 // skip reply determinant

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 1 // padding

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float64(xgb.Get64(buf[b:]))
	b += 8

	b += 8 // padding

	v.Data = make([]Float64, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float64(xgb.Get64(buf[b:]))
		b += 8
	}

	return v
}

// Write request to wire for GetDoublev
// getDoublevRequest writes a GetDoublev request to a byte slice.
func getDoublevRequest(c *xgb.Conn, ContextTag ContextTag, Pname uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 114 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetDrawableAttributesCookie is a cookie used only for GetDrawableAttributes requests.
type GetDrawableAttributesCookie struct {
	*xgb.Cookie
}

// GetDrawableAttributes sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetDrawableAttributesCookie.Reply()
func GetDrawableAttributes(c *xgb.Conn, Drawable Drawable) GetDrawableAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetDrawableAttributes' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getDrawableAttributesRequest(c, Drawable), cookie)
	return GetDrawableAttributesCookie{cookie}
}

// GetDrawableAttributesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetDrawableAttributesUnchecked(c *xgb.Conn, Drawable Drawable) GetDrawableAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetDrawableAttributes' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getDrawableAttributesRequest(c, Drawable), cookie)
	return GetDrawableAttributesCookie{cookie}
}

// GetDrawableAttributesReply represents the data returned from a GetDrawableAttributes request.
type GetDrawableAttributesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumAttribs uint32
	// padding: 20 bytes
	Attribs []uint32 // size: xgb.Pad(((int(NumAttribs) * 2) * 4))
}

// Reply blocks and returns the reply data for a GetDrawableAttributes request.
func (cook GetDrawableAttributesCookie) Reply() (*GetDrawableAttributesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getDrawableAttributesReply(buf), nil
}

// getDrawableAttributesReply reads a byte slice into a GetDrawableAttributesReply value.
func getDrawableAttributesReply(buf []byte) *GetDrawableAttributesReply {
	v := new(GetDrawableAttributesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumAttribs = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Attribs = make([]uint32, (int(v.NumAttribs) * 2))
	for i := 0; i < int((int(v.NumAttribs) * 2)); i++ {
		v.Attribs[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetDrawableAttributes
// getDrawableAttributesRequest writes a GetDrawableAttributes request to a byte slice.
func getDrawableAttributesRequest(c *xgb.Conn, Drawable Drawable) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 29 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	return buf
}

// GetErrorCookie is a cookie used only for GetError requests.
type GetErrorCookie struct {
	*xgb.Cookie
}

// GetError sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetErrorCookie.Reply()
func GetError(c *xgb.Conn, ContextTag ContextTag) GetErrorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetError' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getErrorRequest(c, ContextTag), cookie)
	return GetErrorCookie{cookie}
}

// GetErrorUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetErrorUnchecked(c *xgb.Conn, ContextTag ContextTag) GetErrorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetError' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getErrorRequest(c, ContextTag), cookie)
	return GetErrorCookie{cookie}
}

// GetErrorReply represents the data returned from a GetError request.
type GetErrorReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Error int32
}

// Reply blocks and returns the reply data for a GetError request.
func (cook GetErrorCookie) Reply() (*GetErrorReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getErrorReply(buf), nil
}

// getErrorReply reads a byte slice into a GetErrorReply value.
func getErrorReply(buf []byte) *GetErrorReply {
	v := new(GetErrorReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Error = int32(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for GetError
// getErrorRequest writes a GetError request to a byte slice.
func getErrorRequest(c *xgb.Conn, ContextTag ContextTag) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 115 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	return buf
}

// GetFBConfigsCookie is a cookie used only for GetFBConfigs requests.
type GetFBConfigsCookie struct {
	*xgb.Cookie
}

// GetFBConfigs sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetFBConfigsCookie.Reply()
func GetFBConfigs(c *xgb.Conn, Screen uint32) GetFBConfigsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetFBConfigs' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getFBConfigsRequest(c, Screen), cookie)
	return GetFBConfigsCookie{cookie}
}

// GetFBConfigsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetFBConfigsUnchecked(c *xgb.Conn, Screen uint32) GetFBConfigsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetFBConfigs' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getFBConfigsRequest(c, Screen), cookie)
	return GetFBConfigsCookie{cookie}
}

// GetFBConfigsReply represents the data returned from a GetFBConfigs request.
type GetFBConfigsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumFbConfigs  uint32
	NumProperties uint32
	// padding: 16 bytes
	PropertyList []uint32 // size: xgb.Pad((int(Length) * 4))
}

// Reply blocks and returns the reply data for a GetFBConfigs request.
func (cook GetFBConfigsCookie) Reply() (*GetFBConfigsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getFBConfigsReply(buf), nil
}

// getFBConfigsReply reads a byte slice into a GetFBConfigsReply value.
func getFBConfigsReply(buf []byte) *GetFBConfigsReply {
	v := new(GetFBConfigsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumFbConfigs = xgb.Get32(buf[b:])
	b += 4

	v.NumProperties = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	v.PropertyList = make([]uint32, v.Length)
	for i := 0; i < int(v.Length); i++ {
		v.PropertyList[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetFBConfigs
// getFBConfigsRequest writes a GetFBConfigs request to a byte slice.
func getFBConfigsRequest(c *xgb.Conn, Screen uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 21 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	return buf
}

// GetFloatvCookie is a cookie used only for GetFloatv requests.
type GetFloatvCookie struct {
	*xgb.Cookie
}

// GetFloatv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetFloatvCookie.Reply()
func GetFloatv(c *xgb.Conn, ContextTag ContextTag, Pname uint32) GetFloatvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetFloatv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getFloatvRequest(c, ContextTag, Pname), cookie)
	return GetFloatvCookie{cookie}
}

// GetFloatvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetFloatvUnchecked(c *xgb.Conn, ContextTag ContextTag, Pname uint32) GetFloatvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetFloatv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getFloatvRequest(c, ContextTag, Pname), cookie)
	return GetFloatvCookie{cookie}
}

// GetFloatvReply represents the data returned from a GetFloatv request.
type GetFloatvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetFloatv request.
func (cook GetFloatvCookie) Reply() (*GetFloatvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getFloatvReply(buf), nil
}

// getFloatvReply reads a byte slice into a GetFloatvReply value.
func getFloatvReply(buf []byte) *GetFloatvReply {
	v := new(GetFloatvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetFloatv
// getFloatvRequest writes a GetFloatv request to a byte slice.
func getFloatvRequest(c *xgb.Conn, ContextTag ContextTag, Pname uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 116 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetHistogramCookie is a cookie used only for GetHistogram requests.
type GetHistogramCookie struct {
	*xgb.Cookie
}

// GetHistogram sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetHistogramCookie.Reply()
func GetHistogram(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool, Reset bool) GetHistogramCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetHistogram' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getHistogramRequest(c, ContextTag, Target, Format, Type, SwapBytes, Reset), cookie)
	return GetHistogramCookie{cookie}
}

// GetHistogramUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetHistogramUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool, Reset bool) GetHistogramCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetHistogram' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getHistogramRequest(c, ContextTag, Target, Format, Type, SwapBytes, Reset), cookie)
	return GetHistogramCookie{cookie}
}

// GetHistogramReply represents the data returned from a GetHistogram request.
type GetHistogramReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 8 bytes
	Width int32
	// padding: 12 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetHistogram request.
func (cook GetHistogramCookie) Reply() (*GetHistogramReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getHistogramReply(buf), nil
}

// getHistogramReply reads a byte slice into a GetHistogramReply value.
func getHistogramReply(buf []byte) *GetHistogramReply {
	v := new(GetHistogramReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 8 // padding

	v.Width = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetHistogram
// getHistogramRequest writes a GetHistogram request to a byte slice.
func getHistogramRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool, Reset bool) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 154 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if Reset {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetHistogramParameterfvCookie is a cookie used only for GetHistogramParameterfv requests.
type GetHistogramParameterfvCookie struct {
	*xgb.Cookie
}

// GetHistogramParameterfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetHistogramParameterfvCookie.Reply()
func GetHistogramParameterfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetHistogramParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetHistogramParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getHistogramParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetHistogramParameterfvCookie{cookie}
}

// GetHistogramParameterfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetHistogramParameterfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetHistogramParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetHistogramParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getHistogramParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetHistogramParameterfvCookie{cookie}
}

// GetHistogramParameterfvReply represents the data returned from a GetHistogramParameterfv request.
type GetHistogramParameterfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetHistogramParameterfv request.
func (cook GetHistogramParameterfvCookie) Reply() (*GetHistogramParameterfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getHistogramParameterfvReply(buf), nil
}

// getHistogramParameterfvReply reads a byte slice into a GetHistogramParameterfvReply value.
func getHistogramParameterfvReply(buf []byte) *GetHistogramParameterfvReply {
	v := new(GetHistogramParameterfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetHistogramParameterfv
// getHistogramParameterfvRequest writes a GetHistogramParameterfv request to a byte slice.
func getHistogramParameterfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 155 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetHistogramParameterivCookie is a cookie used only for GetHistogramParameteriv requests.
type GetHistogramParameterivCookie struct {
	*xgb.Cookie
}

// GetHistogramParameteriv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetHistogramParameterivCookie.Reply()
func GetHistogramParameteriv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetHistogramParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetHistogramParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getHistogramParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetHistogramParameterivCookie{cookie}
}

// GetHistogramParameterivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetHistogramParameterivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetHistogramParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetHistogramParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getHistogramParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetHistogramParameterivCookie{cookie}
}

// GetHistogramParameterivReply represents the data returned from a GetHistogramParameteriv request.
type GetHistogramParameterivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetHistogramParameteriv request.
func (cook GetHistogramParameterivCookie) Reply() (*GetHistogramParameterivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getHistogramParameterivReply(buf), nil
}

// getHistogramParameterivReply reads a byte slice into a GetHistogramParameterivReply value.
func getHistogramParameterivReply(buf []byte) *GetHistogramParameterivReply {
	v := new(GetHistogramParameterivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetHistogramParameteriv
// getHistogramParameterivRequest writes a GetHistogramParameteriv request to a byte slice.
func getHistogramParameterivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 156 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetIntegervCookie is a cookie used only for GetIntegerv requests.
type GetIntegervCookie struct {
	*xgb.Cookie
}

// GetIntegerv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetIntegervCookie.Reply()
func GetIntegerv(c *xgb.Conn, ContextTag ContextTag, Pname uint32) GetIntegervCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetIntegerv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getIntegervRequest(c, ContextTag, Pname), cookie)
	return GetIntegervCookie{cookie}
}

// GetIntegervUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetIntegervUnchecked(c *xgb.Conn, ContextTag ContextTag, Pname uint32) GetIntegervCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetIntegerv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getIntegervRequest(c, ContextTag, Pname), cookie)
	return GetIntegervCookie{cookie}
}

// GetIntegervReply represents the data returned from a GetIntegerv request.
type GetIntegervReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetIntegerv request.
func (cook GetIntegervCookie) Reply() (*GetIntegervReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getIntegervReply(buf), nil
}

// getIntegervReply reads a byte slice into a GetIntegervReply value.
func getIntegervReply(buf []byte) *GetIntegervReply {
	v := new(GetIntegervReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetIntegerv
// getIntegervRequest writes a GetIntegerv request to a byte slice.
func getIntegervRequest(c *xgb.Conn, ContextTag ContextTag, Pname uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 117 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetLightfvCookie is a cookie used only for GetLightfv requests.
type GetLightfvCookie struct {
	*xgb.Cookie
}

// GetLightfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetLightfvCookie.Reply()
func GetLightfv(c *xgb.Conn, ContextTag ContextTag, Light uint32, Pname uint32) GetLightfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetLightfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getLightfvRequest(c, ContextTag, Light, Pname), cookie)
	return GetLightfvCookie{cookie}
}

// GetLightfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetLightfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Light uint32, Pname uint32) GetLightfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetLightfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getLightfvRequest(c, ContextTag, Light, Pname), cookie)
	return GetLightfvCookie{cookie}
}

// GetLightfvReply represents the data returned from a GetLightfv request.
type GetLightfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetLightfv request.
func (cook GetLightfvCookie) Reply() (*GetLightfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getLightfvReply(buf), nil
}

// getLightfvReply reads a byte slice into a GetLightfvReply value.
func getLightfvReply(buf []byte) *GetLightfvReply {
	v := new(GetLightfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetLightfv
// getLightfvRequest writes a GetLightfv request to a byte slice.
func getLightfvRequest(c *xgb.Conn, ContextTag ContextTag, Light uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 118 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Light)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetLightivCookie is a cookie used only for GetLightiv requests.
type GetLightivCookie struct {
	*xgb.Cookie
}

// GetLightiv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetLightivCookie.Reply()
func GetLightiv(c *xgb.Conn, ContextTag ContextTag, Light uint32, Pname uint32) GetLightivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetLightiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getLightivRequest(c, ContextTag, Light, Pname), cookie)
	return GetLightivCookie{cookie}
}

// GetLightivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetLightivUnchecked(c *xgb.Conn, ContextTag ContextTag, Light uint32, Pname uint32) GetLightivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetLightiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getLightivRequest(c, ContextTag, Light, Pname), cookie)
	return GetLightivCookie{cookie}
}

// GetLightivReply represents the data returned from a GetLightiv request.
type GetLightivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetLightiv request.
func (cook GetLightivCookie) Reply() (*GetLightivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getLightivReply(buf), nil
}

// getLightivReply reads a byte slice into a GetLightivReply value.
func getLightivReply(buf []byte) *GetLightivReply {
	v := new(GetLightivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetLightiv
// getLightivRequest writes a GetLightiv request to a byte slice.
func getLightivRequest(c *xgb.Conn, ContextTag ContextTag, Light uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 119 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Light)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetMapdvCookie is a cookie used only for GetMapdv requests.
type GetMapdvCookie struct {
	*xgb.Cookie
}

// GetMapdv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMapdvCookie.Reply()
func GetMapdv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) GetMapdvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMapdv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMapdvRequest(c, ContextTag, Target, Query), cookie)
	return GetMapdvCookie{cookie}
}

// GetMapdvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMapdvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) GetMapdvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMapdv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMapdvRequest(c, ContextTag, Target, Query), cookie)
	return GetMapdvCookie{cookie}
}

// GetMapdvReply represents the data returned from a GetMapdv request.
type GetMapdvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float64
	// padding: 8 bytes
	Data []Float64 // size: xgb.Pad((int(N) * 8))
}

// Reply blocks and returns the reply data for a GetMapdv request.
func (cook GetMapdvCookie) Reply() (*GetMapdvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMapdvReply(buf), nil
}

// getMapdvReply reads a byte slice into a GetMapdvReply value.
func getMapdvReply(buf []byte) *GetMapdvReply {
	v := new(GetMapdvReply)
	b := 1 // skip reply determinant

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 1 // padding

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float64(xgb.Get64(buf[b:]))
	b += 8

	b += 8 // padding

	v.Data = make([]Float64, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float64(xgb.Get64(buf[b:]))
		b += 8
	}

	return v
}

// Write request to wire for GetMapdv
// getMapdvRequest writes a GetMapdv request to a byte slice.
func getMapdvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 120 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Query)
	b += 4

	return buf
}

// GetMapfvCookie is a cookie used only for GetMapfv requests.
type GetMapfvCookie struct {
	*xgb.Cookie
}

// GetMapfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMapfvCookie.Reply()
func GetMapfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) GetMapfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMapfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMapfvRequest(c, ContextTag, Target, Query), cookie)
	return GetMapfvCookie{cookie}
}

// GetMapfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMapfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) GetMapfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMapfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMapfvRequest(c, ContextTag, Target, Query), cookie)
	return GetMapfvCookie{cookie}
}

// GetMapfvReply represents the data returned from a GetMapfv request.
type GetMapfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetMapfv request.
func (cook GetMapfvCookie) Reply() (*GetMapfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMapfvReply(buf), nil
}

// getMapfvReply reads a byte slice into a GetMapfvReply value.
func getMapfvReply(buf []byte) *GetMapfvReply {
	v := new(GetMapfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetMapfv
// getMapfvRequest writes a GetMapfv request to a byte slice.
func getMapfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 121 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Query)
	b += 4

	return buf
}

// GetMapivCookie is a cookie used only for GetMapiv requests.
type GetMapivCookie struct {
	*xgb.Cookie
}

// GetMapiv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMapivCookie.Reply()
func GetMapiv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) GetMapivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMapiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMapivRequest(c, ContextTag, Target, Query), cookie)
	return GetMapivCookie{cookie}
}

// GetMapivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMapivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) GetMapivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMapiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMapivRequest(c, ContextTag, Target, Query), cookie)
	return GetMapivCookie{cookie}
}

// GetMapivReply represents the data returned from a GetMapiv request.
type GetMapivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetMapiv request.
func (cook GetMapivCookie) Reply() (*GetMapivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMapivReply(buf), nil
}

// getMapivReply reads a byte slice into a GetMapivReply value.
func getMapivReply(buf []byte) *GetMapivReply {
	v := new(GetMapivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetMapiv
// getMapivRequest writes a GetMapiv request to a byte slice.
func getMapivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Query uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 122 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Query)
	b += 4

	return buf
}

// GetMaterialfvCookie is a cookie used only for GetMaterialfv requests.
type GetMaterialfvCookie struct {
	*xgb.Cookie
}

// GetMaterialfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMaterialfvCookie.Reply()
func GetMaterialfv(c *xgb.Conn, ContextTag ContextTag, Face uint32, Pname uint32) GetMaterialfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMaterialfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMaterialfvRequest(c, ContextTag, Face, Pname), cookie)
	return GetMaterialfvCookie{cookie}
}

// GetMaterialfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMaterialfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Face uint32, Pname uint32) GetMaterialfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMaterialfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMaterialfvRequest(c, ContextTag, Face, Pname), cookie)
	return GetMaterialfvCookie{cookie}
}

// GetMaterialfvReply represents the data returned from a GetMaterialfv request.
type GetMaterialfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetMaterialfv request.
func (cook GetMaterialfvCookie) Reply() (*GetMaterialfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMaterialfvReply(buf), nil
}

// getMaterialfvReply reads a byte slice into a GetMaterialfvReply value.
func getMaterialfvReply(buf []byte) *GetMaterialfvReply {
	v := new(GetMaterialfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetMaterialfv
// getMaterialfvRequest writes a GetMaterialfv request to a byte slice.
func getMaterialfvRequest(c *xgb.Conn, ContextTag ContextTag, Face uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 123 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Face)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetMaterialivCookie is a cookie used only for GetMaterialiv requests.
type GetMaterialivCookie struct {
	*xgb.Cookie
}

// GetMaterialiv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMaterialivCookie.Reply()
func GetMaterialiv(c *xgb.Conn, ContextTag ContextTag, Face uint32, Pname uint32) GetMaterialivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMaterialiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMaterialivRequest(c, ContextTag, Face, Pname), cookie)
	return GetMaterialivCookie{cookie}
}

// GetMaterialivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMaterialivUnchecked(c *xgb.Conn, ContextTag ContextTag, Face uint32, Pname uint32) GetMaterialivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMaterialiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMaterialivRequest(c, ContextTag, Face, Pname), cookie)
	return GetMaterialivCookie{cookie}
}

// GetMaterialivReply represents the data returned from a GetMaterialiv request.
type GetMaterialivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetMaterialiv request.
func (cook GetMaterialivCookie) Reply() (*GetMaterialivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMaterialivReply(buf), nil
}

// getMaterialivReply reads a byte slice into a GetMaterialivReply value.
func getMaterialivReply(buf []byte) *GetMaterialivReply {
	v := new(GetMaterialivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetMaterialiv
// getMaterialivRequest writes a GetMaterialiv request to a byte slice.
func getMaterialivRequest(c *xgb.Conn, ContextTag ContextTag, Face uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 124 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Face)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetMinmaxCookie is a cookie used only for GetMinmax requests.
type GetMinmaxCookie struct {
	*xgb.Cookie
}

// GetMinmax sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMinmaxCookie.Reply()
func GetMinmax(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool, Reset bool) GetMinmaxCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMinmax' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMinmaxRequest(c, ContextTag, Target, Format, Type, SwapBytes, Reset), cookie)
	return GetMinmaxCookie{cookie}
}

// GetMinmaxUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMinmaxUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool, Reset bool) GetMinmaxCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMinmax' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMinmaxRequest(c, ContextTag, Target, Format, Type, SwapBytes, Reset), cookie)
	return GetMinmaxCookie{cookie}
}

// GetMinmaxReply represents the data returned from a GetMinmax request.
type GetMinmaxReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 24 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetMinmax request.
func (cook GetMinmaxCookie) Reply() (*GetMinmaxReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMinmaxReply(buf), nil
}

// getMinmaxReply reads a byte slice into a GetMinmaxReply value.
func getMinmaxReply(buf []byte) *GetMinmaxReply {
	v := new(GetMinmaxReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 24 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetMinmax
// getMinmaxRequest writes a GetMinmax request to a byte slice.
func getMinmaxRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool, Reset bool) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 157 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if Reset {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetMinmaxParameterfvCookie is a cookie used only for GetMinmaxParameterfv requests.
type GetMinmaxParameterfvCookie struct {
	*xgb.Cookie
}

// GetMinmaxParameterfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMinmaxParameterfvCookie.Reply()
func GetMinmaxParameterfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetMinmaxParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMinmaxParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMinmaxParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetMinmaxParameterfvCookie{cookie}
}

// GetMinmaxParameterfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMinmaxParameterfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetMinmaxParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMinmaxParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMinmaxParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetMinmaxParameterfvCookie{cookie}
}

// GetMinmaxParameterfvReply represents the data returned from a GetMinmaxParameterfv request.
type GetMinmaxParameterfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetMinmaxParameterfv request.
func (cook GetMinmaxParameterfvCookie) Reply() (*GetMinmaxParameterfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMinmaxParameterfvReply(buf), nil
}

// getMinmaxParameterfvReply reads a byte slice into a GetMinmaxParameterfvReply value.
func getMinmaxParameterfvReply(buf []byte) *GetMinmaxParameterfvReply {
	v := new(GetMinmaxParameterfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetMinmaxParameterfv
// getMinmaxParameterfvRequest writes a GetMinmaxParameterfv request to a byte slice.
func getMinmaxParameterfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 158 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetMinmaxParameterivCookie is a cookie used only for GetMinmaxParameteriv requests.
type GetMinmaxParameterivCookie struct {
	*xgb.Cookie
}

// GetMinmaxParameteriv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetMinmaxParameterivCookie.Reply()
func GetMinmaxParameteriv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetMinmaxParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMinmaxParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getMinmaxParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetMinmaxParameterivCookie{cookie}
}

// GetMinmaxParameterivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetMinmaxParameterivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetMinmaxParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetMinmaxParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getMinmaxParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetMinmaxParameterivCookie{cookie}
}

// GetMinmaxParameterivReply represents the data returned from a GetMinmaxParameteriv request.
type GetMinmaxParameterivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetMinmaxParameteriv request.
func (cook GetMinmaxParameterivCookie) Reply() (*GetMinmaxParameterivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getMinmaxParameterivReply(buf), nil
}

// getMinmaxParameterivReply reads a byte slice into a GetMinmaxParameterivReply value.
func getMinmaxParameterivReply(buf []byte) *GetMinmaxParameterivReply {
	v := new(GetMinmaxParameterivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetMinmaxParameteriv
// getMinmaxParameterivRequest writes a GetMinmaxParameteriv request to a byte slice.
func getMinmaxParameterivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 159 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetPixelMapfvCookie is a cookie used only for GetPixelMapfv requests.
type GetPixelMapfvCookie struct {
	*xgb.Cookie
}

// GetPixelMapfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPixelMapfvCookie.Reply()
func GetPixelMapfv(c *xgb.Conn, ContextTag ContextTag, Map uint32) GetPixelMapfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPixelMapfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPixelMapfvRequest(c, ContextTag, Map), cookie)
	return GetPixelMapfvCookie{cookie}
}

// GetPixelMapfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPixelMapfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Map uint32) GetPixelMapfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPixelMapfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPixelMapfvRequest(c, ContextTag, Map), cookie)
	return GetPixelMapfvCookie{cookie}
}

// GetPixelMapfvReply represents the data returned from a GetPixelMapfv request.
type GetPixelMapfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetPixelMapfv request.
func (cook GetPixelMapfvCookie) Reply() (*GetPixelMapfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPixelMapfvReply(buf), nil
}

// getPixelMapfvReply reads a byte slice into a GetPixelMapfvReply value.
func getPixelMapfvReply(buf []byte) *GetPixelMapfvReply {
	v := new(GetPixelMapfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetPixelMapfv
// getPixelMapfvRequest writes a GetPixelMapfv request to a byte slice.
func getPixelMapfvRequest(c *xgb.Conn, ContextTag ContextTag, Map uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 125 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Map)
	b += 4

	return buf
}

// GetPixelMapuivCookie is a cookie used only for GetPixelMapuiv requests.
type GetPixelMapuivCookie struct {
	*xgb.Cookie
}

// GetPixelMapuiv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPixelMapuivCookie.Reply()
func GetPixelMapuiv(c *xgb.Conn, ContextTag ContextTag, Map uint32) GetPixelMapuivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPixelMapuiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPixelMapuivRequest(c, ContextTag, Map), cookie)
	return GetPixelMapuivCookie{cookie}
}

// GetPixelMapuivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPixelMapuivUnchecked(c *xgb.Conn, ContextTag ContextTag, Map uint32) GetPixelMapuivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPixelMapuiv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPixelMapuivRequest(c, ContextTag, Map), cookie)
	return GetPixelMapuivCookie{cookie}
}

// GetPixelMapuivReply represents the data returned from a GetPixelMapuiv request.
type GetPixelMapuivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum uint32
	// padding: 12 bytes
	Data []uint32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetPixelMapuiv request.
func (cook GetPixelMapuivCookie) Reply() (*GetPixelMapuivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPixelMapuivReply(buf), nil
}

// getPixelMapuivReply reads a byte slice into a GetPixelMapuivReply value.
func getPixelMapuivReply(buf []byte) *GetPixelMapuivReply {
	v := new(GetPixelMapuivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Data = make([]uint32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetPixelMapuiv
// getPixelMapuivRequest writes a GetPixelMapuiv request to a byte slice.
func getPixelMapuivRequest(c *xgb.Conn, ContextTag ContextTag, Map uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 126 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Map)
	b += 4

	return buf
}

// GetPixelMapusvCookie is a cookie used only for GetPixelMapusv requests.
type GetPixelMapusvCookie struct {
	*xgb.Cookie
}

// GetPixelMapusv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPixelMapusvCookie.Reply()
func GetPixelMapusv(c *xgb.Conn, ContextTag ContextTag, Map uint32) GetPixelMapusvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPixelMapusv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPixelMapusvRequest(c, ContextTag, Map), cookie)
	return GetPixelMapusvCookie{cookie}
}

// GetPixelMapusvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPixelMapusvUnchecked(c *xgb.Conn, ContextTag ContextTag, Map uint32) GetPixelMapusvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPixelMapusv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPixelMapusvRequest(c, ContextTag, Map), cookie)
	return GetPixelMapusvCookie{cookie}
}

// GetPixelMapusvReply represents the data returned from a GetPixelMapusv request.
type GetPixelMapusvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum uint16
	// padding: 16 bytes
	Data []uint16 // size: xgb.Pad((int(N) * 2))
}

// Reply blocks and returns the reply data for a GetPixelMapusv request.
func (cook GetPixelMapusvCookie) Reply() (*GetPixelMapusvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPixelMapusvReply(buf), nil
}

// getPixelMapusvReply reads a byte slice into a GetPixelMapusvReply value.
func getPixelMapusvReply(buf []byte) *GetPixelMapusvReply {
	v := new(GetPixelMapusvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = xgb.Get16(buf[b:])
	b += 2

	b += 16 // padding

	v.Data = make([]uint16, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = xgb.Get16(buf[b:])
		b += 2
	}

	return v
}

// Write request to wire for GetPixelMapusv
// getPixelMapusvRequest writes a GetPixelMapusv request to a byte slice.
func getPixelMapusvRequest(c *xgb.Conn, ContextTag ContextTag, Map uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 127 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Map)
	b += 4

	return buf
}

// GetPolygonStippleCookie is a cookie used only for GetPolygonStipple requests.
type GetPolygonStippleCookie struct {
	*xgb.Cookie
}

// GetPolygonStipple sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPolygonStippleCookie.Reply()
func GetPolygonStipple(c *xgb.Conn, ContextTag ContextTag, LsbFirst bool) GetPolygonStippleCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPolygonStipple' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPolygonStippleRequest(c, ContextTag, LsbFirst), cookie)
	return GetPolygonStippleCookie{cookie}
}

// GetPolygonStippleUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPolygonStippleUnchecked(c *xgb.Conn, ContextTag ContextTag, LsbFirst bool) GetPolygonStippleCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetPolygonStipple' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPolygonStippleRequest(c, ContextTag, LsbFirst), cookie)
	return GetPolygonStippleCookie{cookie}
}

// GetPolygonStippleReply represents the data returned from a GetPolygonStipple request.
type GetPolygonStippleReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 24 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetPolygonStipple request.
func (cook GetPolygonStippleCookie) Reply() (*GetPolygonStippleReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPolygonStippleReply(buf), nil
}

// getPolygonStippleReply reads a byte slice into a GetPolygonStippleReply value.
func getPolygonStippleReply(buf []byte) *GetPolygonStippleReply {
	v := new(GetPolygonStippleReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 24 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetPolygonStipple
// getPolygonStippleRequest writes a GetPolygonStipple request to a byte slice.
func getPolygonStippleRequest(c *xgb.Conn, ContextTag ContextTag, LsbFirst bool) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 128 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	if LsbFirst {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetQueryObjectivARBCookie is a cookie used only for GetQueryObjectivARB requests.
type GetQueryObjectivARBCookie struct {
	*xgb.Cookie
}

// GetQueryObjectivARB sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetQueryObjectivARBCookie.Reply()
func GetQueryObjectivARB(c *xgb.Conn, ContextTag ContextTag, Id uint32, Pname uint32) GetQueryObjectivARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetQueryObjectivARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getQueryObjectivARBRequest(c, ContextTag, Id, Pname), cookie)
	return GetQueryObjectivARBCookie{cookie}
}

// GetQueryObjectivARBUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetQueryObjectivARBUnchecked(c *xgb.Conn, ContextTag ContextTag, Id uint32, Pname uint32) GetQueryObjectivARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetQueryObjectivARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getQueryObjectivARBRequest(c, ContextTag, Id, Pname), cookie)
	return GetQueryObjectivARBCookie{cookie}
}

// GetQueryObjectivARBReply represents the data returned from a GetQueryObjectivARB request.
type GetQueryObjectivARBReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetQueryObjectivARB request.
func (cook GetQueryObjectivARBCookie) Reply() (*GetQueryObjectivARBReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getQueryObjectivARBReply(buf), nil
}

// getQueryObjectivARBReply reads a byte slice into a GetQueryObjectivARBReply value.
func getQueryObjectivARBReply(buf []byte) *GetQueryObjectivARBReply {
	v := new(GetQueryObjectivARBReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetQueryObjectivARB
// getQueryObjectivARBRequest writes a GetQueryObjectivARB request to a byte slice.
func getQueryObjectivARBRequest(c *xgb.Conn, ContextTag ContextTag, Id uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 165 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Id)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetQueryObjectuivARBCookie is a cookie used only for GetQueryObjectuivARB requests.
type GetQueryObjectuivARBCookie struct {
	*xgb.Cookie
}

// GetQueryObjectuivARB sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetQueryObjectuivARBCookie.Reply()
func GetQueryObjectuivARB(c *xgb.Conn, ContextTag ContextTag, Id uint32, Pname uint32) GetQueryObjectuivARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetQueryObjectuivARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getQueryObjectuivARBRequest(c, ContextTag, Id, Pname), cookie)
	return GetQueryObjectuivARBCookie{cookie}
}

// GetQueryObjectuivARBUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetQueryObjectuivARBUnchecked(c *xgb.Conn, ContextTag ContextTag, Id uint32, Pname uint32) GetQueryObjectuivARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetQueryObjectuivARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getQueryObjectuivARBRequest(c, ContextTag, Id, Pname), cookie)
	return GetQueryObjectuivARBCookie{cookie}
}

// GetQueryObjectuivARBReply represents the data returned from a GetQueryObjectuivARB request.
type GetQueryObjectuivARBReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum uint32
	// padding: 12 bytes
	Data []uint32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetQueryObjectuivARB request.
func (cook GetQueryObjectuivARBCookie) Reply() (*GetQueryObjectuivARBReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getQueryObjectuivARBReply(buf), nil
}

// getQueryObjectuivARBReply reads a byte slice into a GetQueryObjectuivARBReply value.
func getQueryObjectuivARBReply(buf []byte) *GetQueryObjectuivARBReply {
	v := new(GetQueryObjectuivARBReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Data = make([]uint32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetQueryObjectuivARB
// getQueryObjectuivARBRequest writes a GetQueryObjectuivARB request to a byte slice.
func getQueryObjectuivARBRequest(c *xgb.Conn, ContextTag ContextTag, Id uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 166 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Id)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetQueryivARBCookie is a cookie used only for GetQueryivARB requests.
type GetQueryivARBCookie struct {
	*xgb.Cookie
}

// GetQueryivARB sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetQueryivARBCookie.Reply()
func GetQueryivARB(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetQueryivARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetQueryivARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getQueryivARBRequest(c, ContextTag, Target, Pname), cookie)
	return GetQueryivARBCookie{cookie}
}

// GetQueryivARBUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetQueryivARBUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetQueryivARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetQueryivARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getQueryivARBRequest(c, ContextTag, Target, Pname), cookie)
	return GetQueryivARBCookie{cookie}
}

// GetQueryivARBReply represents the data returned from a GetQueryivARB request.
type GetQueryivARBReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetQueryivARB request.
func (cook GetQueryivARBCookie) Reply() (*GetQueryivARBReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getQueryivARBReply(buf), nil
}

// getQueryivARBReply reads a byte slice into a GetQueryivARBReply value.
func getQueryivARBReply(buf []byte) *GetQueryivARBReply {
	v := new(GetQueryivARBReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetQueryivARB
// getQueryivARBRequest writes a GetQueryivARB request to a byte slice.
func getQueryivARBRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 164 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetSeparableFilterCookie is a cookie used only for GetSeparableFilter requests.
type GetSeparableFilterCookie struct {
	*xgb.Cookie
}

// GetSeparableFilter sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetSeparableFilterCookie.Reply()
func GetSeparableFilter(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) GetSeparableFilterCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetSeparableFilter' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getSeparableFilterRequest(c, ContextTag, Target, Format, Type, SwapBytes), cookie)
	return GetSeparableFilterCookie{cookie}
}

// GetSeparableFilterUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetSeparableFilterUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) GetSeparableFilterCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetSeparableFilter' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getSeparableFilterRequest(c, ContextTag, Target, Format, Type, SwapBytes), cookie)
	return GetSeparableFilterCookie{cookie}
}

// GetSeparableFilterReply represents the data returned from a GetSeparableFilter request.
type GetSeparableFilterReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 8 bytes
	RowW int32
	ColH int32
	// padding: 8 bytes
	RowsAndCols []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetSeparableFilter request.
func (cook GetSeparableFilterCookie) Reply() (*GetSeparableFilterReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getSeparableFilterReply(buf), nil
}

// getSeparableFilterReply reads a byte slice into a GetSeparableFilterReply value.
func getSeparableFilterReply(buf []byte) *GetSeparableFilterReply {
	v := new(GetSeparableFilterReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 8 // padding

	v.RowW = int32(xgb.Get32(buf[b:]))
	b += 4

	v.ColH = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 8 // padding

	v.RowsAndCols = make([]byte, (int(v.Length) * 4))
	copy(v.RowsAndCols[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetSeparableFilter
// getSeparableFilterRequest writes a GetSeparableFilter request to a byte slice.
func getSeparableFilterRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Format uint32, Type uint32, SwapBytes bool) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 153 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetStringCookie is a cookie used only for GetString requests.
type GetStringCookie struct {
	*xgb.Cookie
}

// GetString sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetStringCookie.Reply()
func GetString(c *xgb.Conn, ContextTag ContextTag, Name uint32) GetStringCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetString' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getStringRequest(c, ContextTag, Name), cookie)
	return GetStringCookie{cookie}
}

// GetStringUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetStringUnchecked(c *xgb.Conn, ContextTag ContextTag, Name uint32) GetStringCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetString' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getStringRequest(c, ContextTag, Name), cookie)
	return GetStringCookie{cookie}
}

// GetStringReply represents the data returned from a GetString request.
type GetStringReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N uint32
	// padding: 16 bytes
	String string // size: xgb.Pad((int(N) * 1))
}

// Reply blocks and returns the reply data for a GetString request.
func (cook GetStringCookie) Reply() (*GetStringReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getStringReply(buf), nil
}

// getStringReply reads a byte slice into a GetStringReply value.
func getStringReply(buf []byte) *GetStringReply {
	v := new(GetStringReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	{
		byteString := make([]byte, v.N)
		copy(byteString[:v.N], buf[b:])
		v.String = string(byteString)
		b += int(v.N)
	}

	return v
}

// Write request to wire for GetString
// getStringRequest writes a GetString request to a byte slice.
func getStringRequest(c *xgb.Conn, ContextTag ContextTag, Name uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 129 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Name)
	b += 4

	return buf
}

// GetTexEnvfvCookie is a cookie used only for GetTexEnvfv requests.
type GetTexEnvfvCookie struct {
	*xgb.Cookie
}

// GetTexEnvfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexEnvfvCookie.Reply()
func GetTexEnvfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexEnvfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexEnvfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexEnvfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexEnvfvCookie{cookie}
}

// GetTexEnvfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexEnvfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexEnvfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexEnvfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexEnvfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexEnvfvCookie{cookie}
}

// GetTexEnvfvReply represents the data returned from a GetTexEnvfv request.
type GetTexEnvfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexEnvfv request.
func (cook GetTexEnvfvCookie) Reply() (*GetTexEnvfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexEnvfvReply(buf), nil
}

// getTexEnvfvReply reads a byte slice into a GetTexEnvfvReply value.
func getTexEnvfvReply(buf []byte) *GetTexEnvfvReply {
	v := new(GetTexEnvfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexEnvfv
// getTexEnvfvRequest writes a GetTexEnvfv request to a byte slice.
func getTexEnvfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 130 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexEnvivCookie is a cookie used only for GetTexEnviv requests.
type GetTexEnvivCookie struct {
	*xgb.Cookie
}

// GetTexEnviv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexEnvivCookie.Reply()
func GetTexEnviv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexEnvivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexEnviv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexEnvivRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexEnvivCookie{cookie}
}

// GetTexEnvivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexEnvivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexEnvivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexEnviv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexEnvivRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexEnvivCookie{cookie}
}

// GetTexEnvivReply represents the data returned from a GetTexEnviv request.
type GetTexEnvivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexEnviv request.
func (cook GetTexEnvivCookie) Reply() (*GetTexEnvivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexEnvivReply(buf), nil
}

// getTexEnvivReply reads a byte slice into a GetTexEnvivReply value.
func getTexEnvivReply(buf []byte) *GetTexEnvivReply {
	v := new(GetTexEnvivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexEnviv
// getTexEnvivRequest writes a GetTexEnviv request to a byte slice.
func getTexEnvivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 131 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexGendvCookie is a cookie used only for GetTexGendv requests.
type GetTexGendvCookie struct {
	*xgb.Cookie
}

// GetTexGendv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexGendvCookie.Reply()
func GetTexGendv(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) GetTexGendvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexGendv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexGendvRequest(c, ContextTag, Coord, Pname), cookie)
	return GetTexGendvCookie{cookie}
}

// GetTexGendvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexGendvUnchecked(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) GetTexGendvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexGendv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexGendvRequest(c, ContextTag, Coord, Pname), cookie)
	return GetTexGendvCookie{cookie}
}

// GetTexGendvReply represents the data returned from a GetTexGendv request.
type GetTexGendvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float64
	// padding: 8 bytes
	Data []Float64 // size: xgb.Pad((int(N) * 8))
}

// Reply blocks and returns the reply data for a GetTexGendv request.
func (cook GetTexGendvCookie) Reply() (*GetTexGendvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexGendvReply(buf), nil
}

// getTexGendvReply reads a byte slice into a GetTexGendvReply value.
func getTexGendvReply(buf []byte) *GetTexGendvReply {
	v := new(GetTexGendvReply)
	b := 1 // skip reply determinant

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 1 // padding

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float64(xgb.Get64(buf[b:]))
	b += 8

	b += 8 // padding

	v.Data = make([]Float64, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float64(xgb.Get64(buf[b:]))
		b += 8
	}

	return v
}

// Write request to wire for GetTexGendv
// getTexGendvRequest writes a GetTexGendv request to a byte slice.
func getTexGendvRequest(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 132 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Coord)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexGenfvCookie is a cookie used only for GetTexGenfv requests.
type GetTexGenfvCookie struct {
	*xgb.Cookie
}

// GetTexGenfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexGenfvCookie.Reply()
func GetTexGenfv(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) GetTexGenfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexGenfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexGenfvRequest(c, ContextTag, Coord, Pname), cookie)
	return GetTexGenfvCookie{cookie}
}

// GetTexGenfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexGenfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) GetTexGenfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexGenfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexGenfvRequest(c, ContextTag, Coord, Pname), cookie)
	return GetTexGenfvCookie{cookie}
}

// GetTexGenfvReply represents the data returned from a GetTexGenfv request.
type GetTexGenfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexGenfv request.
func (cook GetTexGenfvCookie) Reply() (*GetTexGenfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexGenfvReply(buf), nil
}

// getTexGenfvReply reads a byte slice into a GetTexGenfvReply value.
func getTexGenfvReply(buf []byte) *GetTexGenfvReply {
	v := new(GetTexGenfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexGenfv
// getTexGenfvRequest writes a GetTexGenfv request to a byte slice.
func getTexGenfvRequest(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 133 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Coord)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexGenivCookie is a cookie used only for GetTexGeniv requests.
type GetTexGenivCookie struct {
	*xgb.Cookie
}

// GetTexGeniv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexGenivCookie.Reply()
func GetTexGeniv(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) GetTexGenivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexGeniv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexGenivRequest(c, ContextTag, Coord, Pname), cookie)
	return GetTexGenivCookie{cookie}
}

// GetTexGenivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexGenivUnchecked(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) GetTexGenivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexGeniv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexGenivRequest(c, ContextTag, Coord, Pname), cookie)
	return GetTexGenivCookie{cookie}
}

// GetTexGenivReply represents the data returned from a GetTexGeniv request.
type GetTexGenivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexGeniv request.
func (cook GetTexGenivCookie) Reply() (*GetTexGenivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexGenivReply(buf), nil
}

// getTexGenivReply reads a byte slice into a GetTexGenivReply value.
func getTexGenivReply(buf []byte) *GetTexGenivReply {
	v := new(GetTexGenivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexGeniv
// getTexGenivRequest writes a GetTexGeniv request to a byte slice.
func getTexGenivRequest(c *xgb.Conn, ContextTag ContextTag, Coord uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 134 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Coord)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexImageCookie is a cookie used only for GetTexImage requests.
type GetTexImageCookie struct {
	*xgb.Cookie
}

// GetTexImage sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexImageCookie.Reply()
func GetTexImage(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Format uint32, Type uint32, SwapBytes bool) GetTexImageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexImage' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexImageRequest(c, ContextTag, Target, Level, Format, Type, SwapBytes), cookie)
	return GetTexImageCookie{cookie}
}

// GetTexImageUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexImageUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Format uint32, Type uint32, SwapBytes bool) GetTexImageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexImage' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexImageRequest(c, ContextTag, Target, Level, Format, Type, SwapBytes), cookie)
	return GetTexImageCookie{cookie}
}

// GetTexImageReply represents the data returned from a GetTexImage request.
type GetTexImageReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 8 bytes
	Width  int32
	Height int32
	Depth  int32
	// padding: 4 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a GetTexImage request.
func (cook GetTexImageCookie) Reply() (*GetTexImageReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexImageReply(buf), nil
}

// getTexImageReply reads a byte slice into a GetTexImageReply value.
func getTexImageReply(buf []byte) *GetTexImageReply {
	v := new(GetTexImageReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 8 // padding

	v.Width = int32(xgb.Get32(buf[b:]))
	b += 4

	v.Height = int32(xgb.Get32(buf[b:]))
	b += 4

	v.Depth = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 4 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for GetTexImage
// getTexImageRequest writes a GetTexImage request to a byte slice.
func getTexImageRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Format uint32, Type uint32, SwapBytes bool) []byte {
	size := 28
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 135 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], uint32(Level))
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// GetTexLevelParameterfvCookie is a cookie used only for GetTexLevelParameterfv requests.
type GetTexLevelParameterfvCookie struct {
	*xgb.Cookie
}

// GetTexLevelParameterfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexLevelParameterfvCookie.Reply()
func GetTexLevelParameterfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Pname uint32) GetTexLevelParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexLevelParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexLevelParameterfvRequest(c, ContextTag, Target, Level, Pname), cookie)
	return GetTexLevelParameterfvCookie{cookie}
}

// GetTexLevelParameterfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexLevelParameterfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Pname uint32) GetTexLevelParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexLevelParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexLevelParameterfvRequest(c, ContextTag, Target, Level, Pname), cookie)
	return GetTexLevelParameterfvCookie{cookie}
}

// GetTexLevelParameterfvReply represents the data returned from a GetTexLevelParameterfv request.
type GetTexLevelParameterfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexLevelParameterfv request.
func (cook GetTexLevelParameterfvCookie) Reply() (*GetTexLevelParameterfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexLevelParameterfvReply(buf), nil
}

// getTexLevelParameterfvReply reads a byte slice into a GetTexLevelParameterfvReply value.
func getTexLevelParameterfvReply(buf []byte) *GetTexLevelParameterfvReply {
	v := new(GetTexLevelParameterfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexLevelParameterfv
// getTexLevelParameterfvRequest writes a GetTexLevelParameterfv request to a byte slice.
func getTexLevelParameterfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Pname uint32) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 138 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], uint32(Level))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexLevelParameterivCookie is a cookie used only for GetTexLevelParameteriv requests.
type GetTexLevelParameterivCookie struct {
	*xgb.Cookie
}

// GetTexLevelParameteriv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexLevelParameterivCookie.Reply()
func GetTexLevelParameteriv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Pname uint32) GetTexLevelParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexLevelParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexLevelParameterivRequest(c, ContextTag, Target, Level, Pname), cookie)
	return GetTexLevelParameterivCookie{cookie}
}

// GetTexLevelParameterivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexLevelParameterivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Pname uint32) GetTexLevelParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexLevelParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexLevelParameterivRequest(c, ContextTag, Target, Level, Pname), cookie)
	return GetTexLevelParameterivCookie{cookie}
}

// GetTexLevelParameterivReply represents the data returned from a GetTexLevelParameteriv request.
type GetTexLevelParameterivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexLevelParameteriv request.
func (cook GetTexLevelParameterivCookie) Reply() (*GetTexLevelParameterivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexLevelParameterivReply(buf), nil
}

// getTexLevelParameterivReply reads a byte slice into a GetTexLevelParameterivReply value.
func getTexLevelParameterivReply(buf []byte) *GetTexLevelParameterivReply {
	v := new(GetTexLevelParameterivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexLevelParameteriv
// getTexLevelParameterivRequest writes a GetTexLevelParameteriv request to a byte slice.
func getTexLevelParameterivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Level int32, Pname uint32) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 139 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], uint32(Level))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexParameterfvCookie is a cookie used only for GetTexParameterfv requests.
type GetTexParameterfvCookie struct {
	*xgb.Cookie
}

// GetTexParameterfv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexParameterfvCookie.Reply()
func GetTexParameterfv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexParameterfvCookie{cookie}
}

// GetTexParameterfvUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexParameterfvUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexParameterfvCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexParameterfv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexParameterfvRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexParameterfvCookie{cookie}
}

// GetTexParameterfvReply represents the data returned from a GetTexParameterfv request.
type GetTexParameterfvReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum Float32
	// padding: 12 bytes
	Data []Float32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexParameterfv request.
func (cook GetTexParameterfvCookie) Reply() (*GetTexParameterfvReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexParameterfvReply(buf), nil
}

// getTexParameterfvReply reads a byte slice into a GetTexParameterfvReply value.
func getTexParameterfvReply(buf []byte) *GetTexParameterfvReply {
	v := new(GetTexParameterfvReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = Float32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]Float32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = Float32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexParameterfv
// getTexParameterfvRequest writes a GetTexParameterfv request to a byte slice.
func getTexParameterfvRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 136 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetTexParameterivCookie is a cookie used only for GetTexParameteriv requests.
type GetTexParameterivCookie struct {
	*xgb.Cookie
}

// GetTexParameteriv sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetTexParameterivCookie.Reply()
func GetTexParameteriv(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getTexParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexParameterivCookie{cookie}
}

// GetTexParameterivUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetTexParameterivUnchecked(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) GetTexParameterivCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetTexParameteriv' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getTexParameterivRequest(c, ContextTag, Target, Pname), cookie)
	return GetTexParameterivCookie{cookie}
}

// GetTexParameterivReply represents the data returned from a GetTexParameteriv request.
type GetTexParameterivReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N     uint32
	Datum int32
	// padding: 12 bytes
	Data []int32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a GetTexParameteriv request.
func (cook GetTexParameterivCookie) Reply() (*GetTexParameterivReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getTexParameterivReply(buf), nil
}

// getTexParameterivReply reads a byte slice into a GetTexParameterivReply value.
func getTexParameterivReply(buf []byte) *GetTexParameterivReply {
	v := new(GetTexParameterivReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.Datum = int32(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	v.Data = make([]int32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = int32(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for GetTexParameteriv
// getTexParameterivRequest writes a GetTexParameteriv request to a byte slice.
func getTexParameterivRequest(c *xgb.Conn, ContextTag ContextTag, Target uint32, Pname uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 137 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Target)
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	return buf
}

// GetVisualConfigsCookie is a cookie used only for GetVisualConfigs requests.
type GetVisualConfigsCookie struct {
	*xgb.Cookie
}

// GetVisualConfigs sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetVisualConfigsCookie.Reply()
func GetVisualConfigs(c *xgb.Conn, Screen uint32) GetVisualConfigsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetVisualConfigs' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getVisualConfigsRequest(c, Screen), cookie)
	return GetVisualConfigsCookie{cookie}
}

// GetVisualConfigsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetVisualConfigsUnchecked(c *xgb.Conn, Screen uint32) GetVisualConfigsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'GetVisualConfigs' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getVisualConfigsRequest(c, Screen), cookie)
	return GetVisualConfigsCookie{cookie}
}

// GetVisualConfigsReply represents the data returned from a GetVisualConfigs request.
type GetVisualConfigsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumVisuals    uint32
	NumProperties uint32
	// padding: 16 bytes
	PropertyList []uint32 // size: xgb.Pad((int(Length) * 4))
}

// Reply blocks and returns the reply data for a GetVisualConfigs request.
func (cook GetVisualConfigsCookie) Reply() (*GetVisualConfigsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getVisualConfigsReply(buf), nil
}

// getVisualConfigsReply reads a byte slice into a GetVisualConfigsReply value.
func getVisualConfigsReply(buf []byte) *GetVisualConfigsReply {
	v := new(GetVisualConfigsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumVisuals = xgb.Get32(buf[b:])
	b += 4

	v.NumProperties = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	v.PropertyList = make([]uint32, v.Length)
	for i := 0; i < int(v.Length); i++ {
		v.PropertyList[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetVisualConfigs
// getVisualConfigsRequest writes a GetVisualConfigs request to a byte slice.
func getVisualConfigsRequest(c *xgb.Conn, Screen uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 14 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	return buf
}

// IsDirectCookie is a cookie used only for IsDirect requests.
type IsDirectCookie struct {
	*xgb.Cookie
}

// IsDirect sends a checked request.
// If an error occurs, it will be returned with the reply by calling IsDirectCookie.Reply()
func IsDirect(c *xgb.Conn, Context Context) IsDirectCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsDirect' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(isDirectRequest(c, Context), cookie)
	return IsDirectCookie{cookie}
}

// IsDirectUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func IsDirectUnchecked(c *xgb.Conn, Context Context) IsDirectCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsDirect' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(isDirectRequest(c, Context), cookie)
	return IsDirectCookie{cookie}
}

// IsDirectReply represents the data returned from a IsDirect request.
type IsDirectReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	IsDirect bool
	// padding: 23 bytes
}

// Reply blocks and returns the reply data for a IsDirect request.
func (cook IsDirectCookie) Reply() (*IsDirectReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return isDirectReply(buf), nil
}

// isDirectReply reads a byte slice into a IsDirectReply value.
func isDirectReply(buf []byte) *IsDirectReply {
	v := new(IsDirectReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	if buf[b] == 1 {
		v.IsDirect = true
	} else {
		v.IsDirect = false
	}
	b += 1

	b += 23 // padding

	return v
}

// Write request to wire for IsDirect
// isDirectRequest writes a IsDirect request to a byte slice.
func isDirectRequest(c *xgb.Conn, Context Context) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// IsEnabledCookie is a cookie used only for IsEnabled requests.
type IsEnabledCookie struct {
	*xgb.Cookie
}

// IsEnabled sends a checked request.
// If an error occurs, it will be returned with the reply by calling IsEnabledCookie.Reply()
func IsEnabled(c *xgb.Conn, ContextTag ContextTag, Capability uint32) IsEnabledCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsEnabled' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(isEnabledRequest(c, ContextTag, Capability), cookie)
	return IsEnabledCookie{cookie}
}

// IsEnabledUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func IsEnabledUnchecked(c *xgb.Conn, ContextTag ContextTag, Capability uint32) IsEnabledCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsEnabled' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(isEnabledRequest(c, ContextTag, Capability), cookie)
	return IsEnabledCookie{cookie}
}

// IsEnabledReply represents the data returned from a IsEnabled request.
type IsEnabledReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal Bool32
}

// Reply blocks and returns the reply data for a IsEnabled request.
func (cook IsEnabledCookie) Reply() (*IsEnabledReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return isEnabledReply(buf), nil
}

// isEnabledReply reads a byte slice into a IsEnabledReply value.
func isEnabledReply(buf []byte) *IsEnabledReply {
	v := new(IsEnabledReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = Bool32(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for IsEnabled
// isEnabledRequest writes a IsEnabled request to a byte slice.
func isEnabledRequest(c *xgb.Conn, ContextTag ContextTag, Capability uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 140 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Capability)
	b += 4

	return buf
}

// IsListCookie is a cookie used only for IsList requests.
type IsListCookie struct {
	*xgb.Cookie
}

// IsList sends a checked request.
// If an error occurs, it will be returned with the reply by calling IsListCookie.Reply()
func IsList(c *xgb.Conn, ContextTag ContextTag, List uint32) IsListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsList' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(isListRequest(c, ContextTag, List), cookie)
	return IsListCookie{cookie}
}

// IsListUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func IsListUnchecked(c *xgb.Conn, ContextTag ContextTag, List uint32) IsListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsList' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(isListRequest(c, ContextTag, List), cookie)
	return IsListCookie{cookie}
}

// IsListReply represents the data returned from a IsList request.
type IsListReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal Bool32
}

// Reply blocks and returns the reply data for a IsList request.
func (cook IsListCookie) Reply() (*IsListReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return isListReply(buf), nil
}

// isListReply reads a byte slice into a IsListReply value.
func isListReply(buf []byte) *IsListReply {
	v := new(IsListReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = Bool32(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for IsList
// isListRequest writes a IsList request to a byte slice.
func isListRequest(c *xgb.Conn, ContextTag ContextTag, List uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 141 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], List)
	b += 4

	return buf
}

// IsQueryARBCookie is a cookie used only for IsQueryARB requests.
type IsQueryARBCookie struct {
	*xgb.Cookie
}

// IsQueryARB sends a checked request.
// If an error occurs, it will be returned with the reply by calling IsQueryARBCookie.Reply()
func IsQueryARB(c *xgb.Conn, ContextTag ContextTag, Id uint32) IsQueryARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsQueryARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(isQueryARBRequest(c, ContextTag, Id), cookie)
	return IsQueryARBCookie{cookie}
}

// IsQueryARBUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func IsQueryARBUnchecked(c *xgb.Conn, ContextTag ContextTag, Id uint32) IsQueryARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsQueryARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(isQueryARBRequest(c, ContextTag, Id), cookie)
	return IsQueryARBCookie{cookie}
}

// IsQueryARBReply represents the data returned from a IsQueryARB request.
type IsQueryARBReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal Bool32
}

// Reply blocks and returns the reply data for a IsQueryARB request.
func (cook IsQueryARBCookie) Reply() (*IsQueryARBReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return isQueryARBReply(buf), nil
}

// isQueryARBReply reads a byte slice into a IsQueryARBReply value.
func isQueryARBReply(buf []byte) *IsQueryARBReply {
	v := new(IsQueryARBReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = Bool32(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for IsQueryARB
// isQueryARBRequest writes a IsQueryARB request to a byte slice.
func isQueryARBRequest(c *xgb.Conn, ContextTag ContextTag, Id uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 163 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Id)
	b += 4

	return buf
}

// IsTextureCookie is a cookie used only for IsTexture requests.
type IsTextureCookie struct {
	*xgb.Cookie
}

// IsTexture sends a checked request.
// If an error occurs, it will be returned with the reply by calling IsTextureCookie.Reply()
func IsTexture(c *xgb.Conn, ContextTag ContextTag, Texture uint32) IsTextureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsTexture' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(isTextureRequest(c, ContextTag, Texture), cookie)
	return IsTextureCookie{cookie}
}

// IsTextureUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func IsTextureUnchecked(c *xgb.Conn, ContextTag ContextTag, Texture uint32) IsTextureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'IsTexture' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(isTextureRequest(c, ContextTag, Texture), cookie)
	return IsTextureCookie{cookie}
}

// IsTextureReply represents the data returned from a IsTexture request.
type IsTextureReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal Bool32
}

// Reply blocks and returns the reply data for a IsTexture request.
func (cook IsTextureCookie) Reply() (*IsTextureReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return isTextureReply(buf), nil
}

// isTextureReply reads a byte slice into a IsTextureReply value.
func isTextureReply(buf []byte) *IsTextureReply {
	v := new(IsTextureReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = Bool32(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for IsTexture
// isTextureRequest writes a IsTexture request to a byte slice.
func isTextureRequest(c *xgb.Conn, ContextTag ContextTag, Texture uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 146 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Texture)
	b += 4

	return buf
}

// MakeContextCurrentCookie is a cookie used only for MakeContextCurrent requests.
type MakeContextCurrentCookie struct {
	*xgb.Cookie
}

// MakeContextCurrent sends a checked request.
// If an error occurs, it will be returned with the reply by calling MakeContextCurrentCookie.Reply()
func MakeContextCurrent(c *xgb.Conn, OldContextTag ContextTag, Drawable Drawable, ReadDrawable Drawable, Context Context) MakeContextCurrentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'MakeContextCurrent' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(makeContextCurrentRequest(c, OldContextTag, Drawable, ReadDrawable, Context), cookie)
	return MakeContextCurrentCookie{cookie}
}

// MakeContextCurrentUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func MakeContextCurrentUnchecked(c *xgb.Conn, OldContextTag ContextTag, Drawable Drawable, ReadDrawable Drawable, Context Context) MakeContextCurrentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'MakeContextCurrent' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(makeContextCurrentRequest(c, OldContextTag, Drawable, ReadDrawable, Context), cookie)
	return MakeContextCurrentCookie{cookie}
}

// MakeContextCurrentReply represents the data returned from a MakeContextCurrent request.
type MakeContextCurrentReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextTag ContextTag
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a MakeContextCurrent request.
func (cook MakeContextCurrentCookie) Reply() (*MakeContextCurrentReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return makeContextCurrentReply(buf), nil
}

// makeContextCurrentReply reads a byte slice into a MakeContextCurrentReply value.
func makeContextCurrentReply(buf []byte) *MakeContextCurrentReply {
	v := new(MakeContextCurrentReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextTag = ContextTag(xgb.Get32(buf[b:]))
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for MakeContextCurrent
// makeContextCurrentRequest writes a MakeContextCurrent request to a byte slice.
func makeContextCurrentRequest(c *xgb.Conn, OldContextTag ContextTag, Drawable Drawable, ReadDrawable Drawable, Context Context) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 26 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(OldContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	xgb.Put32(buf[b:], uint32(ReadDrawable))
	b += 4

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// MakeCurrentCookie is a cookie used only for MakeCurrent requests.
type MakeCurrentCookie struct {
	*xgb.Cookie
}

// MakeCurrent sends a checked request.
// If an error occurs, it will be returned with the reply by calling MakeCurrentCookie.Reply()
func MakeCurrent(c *xgb.Conn, Drawable Drawable, Context Context, OldContextTag ContextTag) MakeCurrentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'MakeCurrent' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(makeCurrentRequest(c, Drawable, Context, OldContextTag), cookie)
	return MakeCurrentCookie{cookie}
}

// MakeCurrentUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func MakeCurrentUnchecked(c *xgb.Conn, Drawable Drawable, Context Context, OldContextTag ContextTag) MakeCurrentCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'MakeCurrent' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(makeCurrentRequest(c, Drawable, Context, OldContextTag), cookie)
	return MakeCurrentCookie{cookie}
}

// MakeCurrentReply represents the data returned from a MakeCurrent request.
type MakeCurrentReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextTag ContextTag
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a MakeCurrent request.
func (cook MakeCurrentCookie) Reply() (*MakeCurrentReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return makeCurrentReply(buf), nil
}

// makeCurrentReply reads a byte slice into a MakeCurrentReply value.
func makeCurrentReply(buf []byte) *MakeCurrentReply {
	v := new(MakeCurrentReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextTag = ContextTag(xgb.Get32(buf[b:]))
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for MakeCurrent
// makeCurrentRequest writes a MakeCurrent request to a byte slice.
func makeCurrentRequest(c *xgb.Conn, Drawable Drawable, Context Context, OldContextTag ContextTag) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], uint32(OldContextTag))
	b += 4

	return buf
}

// NewListCookie is a cookie used only for NewList requests.
type NewListCookie struct {
	*xgb.Cookie
}

// NewList sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func NewList(c *xgb.Conn, ContextTag ContextTag, List uint32, Mode uint32) NewListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'NewList' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(newListRequest(c, ContextTag, List, Mode), cookie)
	return NewListCookie{cookie}
}

// NewListChecked sends a checked request.
// If an error occurs, it can be retrieved using NewListCookie.Check()
func NewListChecked(c *xgb.Conn, ContextTag ContextTag, List uint32, Mode uint32) NewListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'NewList' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(newListRequest(c, ContextTag, List, Mode), cookie)
	return NewListCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook NewListCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for NewList
// newListRequest writes a NewList request to a byte slice.
func newListRequest(c *xgb.Conn, ContextTag ContextTag, List uint32, Mode uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 101 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], List)
	b += 4

	xgb.Put32(buf[b:], Mode)
	b += 4

	return buf
}

// PixelStorefCookie is a cookie used only for PixelStoref requests.
type PixelStorefCookie struct {
	*xgb.Cookie
}

// PixelStoref sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PixelStoref(c *xgb.Conn, ContextTag ContextTag, Pname uint32, Datum Float32) PixelStorefCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'PixelStoref' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(pixelStorefRequest(c, ContextTag, Pname, Datum), cookie)
	return PixelStorefCookie{cookie}
}

// PixelStorefChecked sends a checked request.
// If an error occurs, it can be retrieved using PixelStorefCookie.Check()
func PixelStorefChecked(c *xgb.Conn, ContextTag ContextTag, Pname uint32, Datum Float32) PixelStorefCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'PixelStoref' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(pixelStorefRequest(c, ContextTag, Pname, Datum), cookie)
	return PixelStorefCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PixelStorefCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PixelStoref
// pixelStorefRequest writes a PixelStoref request to a byte slice.
func pixelStorefRequest(c *xgb.Conn, ContextTag ContextTag, Pname uint32, Datum Float32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 109 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	xgb.Put32(buf[b:], uint32(Datum))
	b += 4

	return buf
}

// PixelStoreiCookie is a cookie used only for PixelStorei requests.
type PixelStoreiCookie struct {
	*xgb.Cookie
}

// PixelStorei sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PixelStorei(c *xgb.Conn, ContextTag ContextTag, Pname uint32, Datum int32) PixelStoreiCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'PixelStorei' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(pixelStoreiRequest(c, ContextTag, Pname, Datum), cookie)
	return PixelStoreiCookie{cookie}
}

// PixelStoreiChecked sends a checked request.
// If an error occurs, it can be retrieved using PixelStoreiCookie.Check()
func PixelStoreiChecked(c *xgb.Conn, ContextTag ContextTag, Pname uint32, Datum int32) PixelStoreiCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'PixelStorei' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(pixelStoreiRequest(c, ContextTag, Pname, Datum), cookie)
	return PixelStoreiCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PixelStoreiCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PixelStorei
// pixelStoreiRequest writes a PixelStorei request to a byte slice.
func pixelStoreiRequest(c *xgb.Conn, ContextTag ContextTag, Pname uint32, Datum int32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 110 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Pname)
	b += 4

	xgb.Put32(buf[b:], uint32(Datum))
	b += 4

	return buf
}

// QueryContextCookie is a cookie used only for QueryContext requests.
type QueryContextCookie struct {
	*xgb.Cookie
}

// QueryContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryContextCookie.Reply()
func QueryContext(c *xgb.Conn, Context Context) QueryContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryContextRequest(c, Context), cookie)
	return QueryContextCookie{cookie}
}

// QueryContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryContextUnchecked(c *xgb.Conn, Context Context) QueryContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryContext' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryContextRequest(c, Context), cookie)
	return QueryContextCookie{cookie}
}

// QueryContextReply represents the data returned from a QueryContext request.
type QueryContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	NumAttribs uint32
	// padding: 20 bytes
	Attribs []uint32 // size: xgb.Pad(((int(NumAttribs) * 2) * 4))
}

// Reply blocks and returns the reply data for a QueryContext request.
func (cook QueryContextCookie) Reply() (*QueryContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryContextReply(buf), nil
}

// queryContextReply reads a byte slice into a QueryContextReply value.
func queryContextReply(buf []byte) *QueryContextReply {
	v := new(QueryContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.NumAttribs = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Attribs = make([]uint32, (int(v.NumAttribs) * 2))
	for i := 0; i < int((int(v.NumAttribs) * 2)); i++ {
		v.Attribs[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for QueryContext
// queryContextRequest writes a QueryContext request to a byte slice.
func queryContextRequest(c *xgb.Conn, Context Context) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 25 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// QueryExtensionsStringCookie is a cookie used only for QueryExtensionsString requests.
type QueryExtensionsStringCookie struct {
	*xgb.Cookie
}

// QueryExtensionsString sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryExtensionsStringCookie.Reply()
func QueryExtensionsString(c *xgb.Conn, Screen uint32) QueryExtensionsStringCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryExtensionsString' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryExtensionsStringRequest(c, Screen), cookie)
	return QueryExtensionsStringCookie{cookie}
}

// QueryExtensionsStringUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryExtensionsStringUnchecked(c *xgb.Conn, Screen uint32) QueryExtensionsStringCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryExtensionsString' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryExtensionsStringRequest(c, Screen), cookie)
	return QueryExtensionsStringCookie{cookie}
}

// QueryExtensionsStringReply represents the data returned from a QueryExtensionsString request.
type QueryExtensionsStringReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	N uint32
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a QueryExtensionsString request.
func (cook QueryExtensionsStringCookie) Reply() (*QueryExtensionsStringReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryExtensionsStringReply(buf), nil
}

// queryExtensionsStringReply reads a byte slice into a QueryExtensionsStringReply value.
func queryExtensionsStringReply(buf []byte) *QueryExtensionsStringReply {
	v := new(QueryExtensionsStringReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.N = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	return v
}

// Write request to wire for QueryExtensionsString
// queryExtensionsStringRequest writes a QueryExtensionsString request to a byte slice.
func queryExtensionsStringRequest(c *xgb.Conn, Screen uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	return buf
}

// QueryServerStringCookie is a cookie used only for QueryServerString requests.
type QueryServerStringCookie struct {
	*xgb.Cookie
}

// QueryServerString sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryServerStringCookie.Reply()
func QueryServerString(c *xgb.Conn, Screen uint32, Name uint32) QueryServerStringCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryServerString' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryServerStringRequest(c, Screen, Name), cookie)
	return QueryServerStringCookie{cookie}
}

// QueryServerStringUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryServerStringUnchecked(c *xgb.Conn, Screen uint32, Name uint32) QueryServerStringCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryServerString' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryServerStringRequest(c, Screen, Name), cookie)
	return QueryServerStringCookie{cookie}
}

// QueryServerStringReply represents the data returned from a QueryServerString request.
type QueryServerStringReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 4 bytes
	StrLen uint32
	// padding: 16 bytes
	String string // size: xgb.Pad((int(StrLen) * 1))
}

// Reply blocks and returns the reply data for a QueryServerString request.
func (cook QueryServerStringCookie) Reply() (*QueryServerStringReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryServerStringReply(buf), nil
}

// queryServerStringReply reads a byte slice into a QueryServerStringReply value.
func queryServerStringReply(buf []byte) *QueryServerStringReply {
	v := new(QueryServerStringReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 4 // padding

	v.StrLen = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	{
		byteString := make([]byte, v.StrLen)
		copy(byteString[:v.StrLen], buf[b:])
		v.String = string(byteString)
		b += int(v.StrLen)
	}

	return v
}

// Write request to wire for QueryServerString
// queryServerStringRequest writes a QueryServerString request to a byte slice.
func queryServerStringRequest(c *xgb.Conn, Screen uint32, Name uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Screen)
	b += 4

	xgb.Put32(buf[b:], Name)
	b += 4

	return buf
}

// QueryVersionCookie is a cookie used only for QueryVersion requests.
type QueryVersionCookie struct {
	*xgb.Cookie
}

// QueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryVersionCookie.Reply()
func QueryVersion(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryVersionRequest(c, MajorVersion, MinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryVersionUnchecked(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryVersionRequest(c, MajorVersion, MinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionReply represents the data returned from a QueryVersion request.
type QueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MajorVersion uint32
	MinorVersion uint32
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a QueryVersion request.
func (cook QueryVersionCookie) Reply() (*QueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryVersionReply(buf), nil
}

// queryVersionReply reads a byte slice into a QueryVersionReply value.
func queryVersionReply(buf []byte) *QueryVersionReply {
	v := new(QueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MajorVersion = xgb.Get32(buf[b:])
	b += 4

	v.MinorVersion = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	return v
}

// Write request to wire for QueryVersion
// queryVersionRequest writes a QueryVersion request to a byte slice.
func queryVersionRequest(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], MajorVersion)
	b += 4

	xgb.Put32(buf[b:], MinorVersion)
	b += 4

	return buf
}

// ReadPixelsCookie is a cookie used only for ReadPixels requests.
type ReadPixelsCookie struct {
	*xgb.Cookie
}

// ReadPixels sends a checked request.
// If an error occurs, it will be returned with the reply by calling ReadPixelsCookie.Reply()
func ReadPixels(c *xgb.Conn, ContextTag ContextTag, X int32, Y int32, Width int32, Height int32, Format uint32, Type uint32, SwapBytes bool, LsbFirst bool) ReadPixelsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'ReadPixels' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(readPixelsRequest(c, ContextTag, X, Y, Width, Height, Format, Type, SwapBytes, LsbFirst), cookie)
	return ReadPixelsCookie{cookie}
}

// ReadPixelsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ReadPixelsUnchecked(c *xgb.Conn, ContextTag ContextTag, X int32, Y int32, Width int32, Height int32, Format uint32, Type uint32, SwapBytes bool, LsbFirst bool) ReadPixelsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'ReadPixels' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(readPixelsRequest(c, ContextTag, X, Y, Width, Height, Format, Type, SwapBytes, LsbFirst), cookie)
	return ReadPixelsCookie{cookie}
}

// ReadPixelsReply represents the data returned from a ReadPixels request.
type ReadPixelsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	// padding: 24 bytes
	Data []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a ReadPixels request.
func (cook ReadPixelsCookie) Reply() (*ReadPixelsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return readPixelsReply(buf), nil
}

// readPixelsReply reads a byte slice into a ReadPixelsReply value.
func readPixelsReply(buf []byte) *ReadPixelsReply {
	v := new(ReadPixelsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	b += 24 // padding

	v.Data = make([]byte, (int(v.Length) * 4))
	copy(v.Data[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for ReadPixels
// readPixelsRequest writes a ReadPixels request to a byte slice.
func readPixelsRequest(c *xgb.Conn, ContextTag ContextTag, X int32, Y int32, Width int32, Height int32, Format uint32, Type uint32, SwapBytes bool, LsbFirst bool) []byte {
	size := 36
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 111 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(X))
	b += 4

	xgb.Put32(buf[b:], uint32(Y))
	b += 4

	xgb.Put32(buf[b:], uint32(Width))
	b += 4

	xgb.Put32(buf[b:], uint32(Height))
	b += 4

	xgb.Put32(buf[b:], Format)
	b += 4

	xgb.Put32(buf[b:], Type)
	b += 4

	if SwapBytes {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	if LsbFirst {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// RenderCookie is a cookie used only for Render requests.
type RenderCookie struct {
	*xgb.Cookie
}

// Render sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func Render(c *xgb.Conn, ContextTag ContextTag, Data []byte) RenderCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'Render' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(renderRequest(c, ContextTag, Data), cookie)
	return RenderCookie{cookie}
}

// RenderChecked sends a checked request.
// If an error occurs, it can be retrieved using RenderCookie.Check()
func RenderChecked(c *xgb.Conn, ContextTag ContextTag, Data []byte) RenderCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'Render' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(renderRequest(c, ContextTag, Data), cookie)
	return RenderCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook RenderCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for Render
// renderRequest writes a Render request to a byte slice.
func renderRequest(c *xgb.Conn, ContextTag ContextTag, Data []byte) []byte {
	size := xgb.Pad((8 + xgb.Pad((len(Data) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 1 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	copy(buf[b:], Data[:len(Data)])
	b += int(len(Data))

	return buf
}

// RenderLargeCookie is a cookie used only for RenderLarge requests.
type RenderLargeCookie struct {
	*xgb.Cookie
}

// RenderLarge sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func RenderLarge(c *xgb.Conn, ContextTag ContextTag, RequestNum uint16, RequestTotal uint16, DataLen uint32, Data []byte) RenderLargeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'RenderLarge' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(renderLargeRequest(c, ContextTag, RequestNum, RequestTotal, DataLen, Data), cookie)
	return RenderLargeCookie{cookie}
}

// RenderLargeChecked sends a checked request.
// If an error occurs, it can be retrieved using RenderLargeCookie.Check()
func RenderLargeChecked(c *xgb.Conn, ContextTag ContextTag, RequestNum uint16, RequestTotal uint16, DataLen uint32, Data []byte) RenderLargeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'RenderLarge' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(renderLargeRequest(c, ContextTag, RequestNum, RequestTotal, DataLen, Data), cookie)
	return RenderLargeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook RenderLargeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for RenderLarge
// renderLargeRequest writes a RenderLarge request to a byte slice.
func renderLargeRequest(c *xgb.Conn, ContextTag ContextTag, RequestNum uint16, RequestTotal uint16, DataLen uint32, Data []byte) []byte {
	size := xgb.Pad((16 + xgb.Pad((int(DataLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put16(buf[b:], RequestNum)
	b += 2

	xgb.Put16(buf[b:], RequestTotal)
	b += 2

	xgb.Put32(buf[b:], DataLen)
	b += 4

	copy(buf[b:], Data[:DataLen])
	b += int(DataLen)

	return buf
}

// RenderModeCookie is a cookie used only for RenderMode requests.
type RenderModeCookie struct {
	*xgb.Cookie
}

// RenderMode sends a checked request.
// If an error occurs, it will be returned with the reply by calling RenderModeCookie.Reply()
func RenderMode(c *xgb.Conn, ContextTag ContextTag, Mode uint32) RenderModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'RenderMode' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(renderModeRequest(c, ContextTag, Mode), cookie)
	return RenderModeCookie{cookie}
}

// RenderModeUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func RenderModeUnchecked(c *xgb.Conn, ContextTag ContextTag, Mode uint32) RenderModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'RenderMode' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(renderModeRequest(c, ContextTag, Mode), cookie)
	return RenderModeCookie{cookie}
}

// RenderModeReply represents the data returned from a RenderMode request.
type RenderModeReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	RetVal  uint32
	N       uint32
	NewMode uint32
	// padding: 12 bytes
	Data []uint32 // size: xgb.Pad((int(N) * 4))
}

// Reply blocks and returns the reply data for a RenderMode request.
func (cook RenderModeCookie) Reply() (*RenderModeReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return renderModeReply(buf), nil
}

// renderModeReply reads a byte slice into a RenderModeReply value.
func renderModeReply(buf []byte) *RenderModeReply {
	v := new(RenderModeReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.RetVal = xgb.Get32(buf[b:])
	b += 4

	v.N = xgb.Get32(buf[b:])
	b += 4

	v.NewMode = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Data = make([]uint32, v.N)
	for i := 0; i < int(v.N); i++ {
		v.Data[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for RenderMode
// renderModeRequest writes a RenderMode request to a byte slice.
func renderModeRequest(c *xgb.Conn, ContextTag ContextTag, Mode uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 107 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], Mode)
	b += 4

	return buf
}

// SelectBufferCookie is a cookie used only for SelectBuffer requests.
type SelectBufferCookie struct {
	*xgb.Cookie
}

// SelectBuffer sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SelectBuffer(c *xgb.Conn, ContextTag ContextTag, Size int32) SelectBufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SelectBuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(selectBufferRequest(c, ContextTag, Size), cookie)
	return SelectBufferCookie{cookie}
}

// SelectBufferChecked sends a checked request.
// If an error occurs, it can be retrieved using SelectBufferCookie.Check()
func SelectBufferChecked(c *xgb.Conn, ContextTag ContextTag, Size int32) SelectBufferCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SelectBuffer' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(selectBufferRequest(c, ContextTag, Size), cookie)
	return SelectBufferCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SelectBufferCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SelectBuffer
// selectBufferRequest writes a SelectBuffer request to a byte slice.
func selectBufferRequest(c *xgb.Conn, ContextTag ContextTag, Size int32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 106 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Size))
	b += 4

	return buf
}

// SetClientInfo2ARBCookie is a cookie used only for SetClientInfo2ARB requests.
type SetClientInfo2ARBCookie struct {
	*xgb.Cookie
}

// SetClientInfo2ARB sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetClientInfo2ARB(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, NumVersions uint32, GlStrLen uint32, GlxStrLen uint32, GlVersions []uint32, GlExtensionString string, GlxExtensionString string) SetClientInfo2ARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SetClientInfo2ARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setClientInfo2ARBRequest(c, MajorVersion, MinorVersion, NumVersions, GlStrLen, GlxStrLen, GlVersions, GlExtensionString, GlxExtensionString), cookie)
	return SetClientInfo2ARBCookie{cookie}
}

// SetClientInfo2ARBChecked sends a checked request.
// If an error occurs, it can be retrieved using SetClientInfo2ARBCookie.Check()
func SetClientInfo2ARBChecked(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, NumVersions uint32, GlStrLen uint32, GlxStrLen uint32, GlVersions []uint32, GlExtensionString string, GlxExtensionString string) SetClientInfo2ARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SetClientInfo2ARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setClientInfo2ARBRequest(c, MajorVersion, MinorVersion, NumVersions, GlStrLen, GlxStrLen, GlVersions, GlExtensionString, GlxExtensionString), cookie)
	return SetClientInfo2ARBCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetClientInfo2ARBCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetClientInfo2ARB
// setClientInfo2ARBRequest writes a SetClientInfo2ARB request to a byte slice.
func setClientInfo2ARBRequest(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, NumVersions uint32, GlStrLen uint32, GlxStrLen uint32, GlVersions []uint32, GlExtensionString string, GlxExtensionString string) []byte {
	size := xgb.Pad(((((24 + xgb.Pad(((int(NumVersions) * 3) * 4))) + xgb.Pad((int(GlStrLen) * 1))) + 4) + xgb.Pad((int(GlxStrLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 35 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], MajorVersion)
	b += 4

	xgb.Put32(buf[b:], MinorVersion)
	b += 4

	xgb.Put32(buf[b:], NumVersions)
	b += 4

	xgb.Put32(buf[b:], GlStrLen)
	b += 4

	xgb.Put32(buf[b:], GlxStrLen)
	b += 4

	for i := 0; i < int((int(NumVersions) * 3)); i++ {
		xgb.Put32(buf[b:], GlVersions[i])
		b += 4
	}

	copy(buf[b:], GlExtensionString[:GlStrLen])
	b += int(GlStrLen)

	b = (b + 3) & ^3 // alignment gap

	copy(buf[b:], GlxExtensionString[:GlxStrLen])
	b += int(GlxStrLen)

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// SetClientInfoARBCookie is a cookie used only for SetClientInfoARB requests.
type SetClientInfoARBCookie struct {
	*xgb.Cookie
}

// SetClientInfoARB sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetClientInfoARB(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, NumVersions uint32, GlStrLen uint32, GlxStrLen uint32, GlVersions []uint32, GlExtensionString string, GlxExtensionString string) SetClientInfoARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SetClientInfoARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setClientInfoARBRequest(c, MajorVersion, MinorVersion, NumVersions, GlStrLen, GlxStrLen, GlVersions, GlExtensionString, GlxExtensionString), cookie)
	return SetClientInfoARBCookie{cookie}
}

// SetClientInfoARBChecked sends a checked request.
// If an error occurs, it can be retrieved using SetClientInfoARBCookie.Check()
func SetClientInfoARBChecked(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, NumVersions uint32, GlStrLen uint32, GlxStrLen uint32, GlVersions []uint32, GlExtensionString string, GlxExtensionString string) SetClientInfoARBCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SetClientInfoARB' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setClientInfoARBRequest(c, MajorVersion, MinorVersion, NumVersions, GlStrLen, GlxStrLen, GlVersions, GlExtensionString, GlxExtensionString), cookie)
	return SetClientInfoARBCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetClientInfoARBCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetClientInfoARB
// setClientInfoARBRequest writes a SetClientInfoARB request to a byte slice.
func setClientInfoARBRequest(c *xgb.Conn, MajorVersion uint32, MinorVersion uint32, NumVersions uint32, GlStrLen uint32, GlxStrLen uint32, GlVersions []uint32, GlExtensionString string, GlxExtensionString string) []byte {
	size := xgb.Pad(((((24 + xgb.Pad(((int(NumVersions) * 2) * 4))) + xgb.Pad((int(GlStrLen) * 1))) + 4) + xgb.Pad((int(GlxStrLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 33 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], MajorVersion)
	b += 4

	xgb.Put32(buf[b:], MinorVersion)
	b += 4

	xgb.Put32(buf[b:], NumVersions)
	b += 4

	xgb.Put32(buf[b:], GlStrLen)
	b += 4

	xgb.Put32(buf[b:], GlxStrLen)
	b += 4

	for i := 0; i < int((int(NumVersions) * 2)); i++ {
		xgb.Put32(buf[b:], GlVersions[i])
		b += 4
	}

	copy(buf[b:], GlExtensionString[:GlStrLen])
	b += int(GlStrLen)

	b = (b + 3) & ^3 // alignment gap

	copy(buf[b:], GlxExtensionString[:GlxStrLen])
	b += int(GlxStrLen)

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// SwapBuffersCookie is a cookie used only for SwapBuffers requests.
type SwapBuffersCookie struct {
	*xgb.Cookie
}

// SwapBuffers sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SwapBuffers(c *xgb.Conn, ContextTag ContextTag, Drawable Drawable) SwapBuffersCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SwapBuffers' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(swapBuffersRequest(c, ContextTag, Drawable), cookie)
	return SwapBuffersCookie{cookie}
}

// SwapBuffersChecked sends a checked request.
// If an error occurs, it can be retrieved using SwapBuffersCookie.Check()
func SwapBuffersChecked(c *xgb.Conn, ContextTag ContextTag, Drawable Drawable) SwapBuffersCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'SwapBuffers' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(swapBuffersRequest(c, ContextTag, Drawable), cookie)
	return SwapBuffersCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SwapBuffersCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SwapBuffers
// swapBuffersRequest writes a SwapBuffers request to a byte slice.
func swapBuffersRequest(c *xgb.Conn, ContextTag ContextTag, Drawable Drawable) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	return buf
}

// UseXFontCookie is a cookie used only for UseXFont requests.
type UseXFontCookie struct {
	*xgb.Cookie
}

// UseXFont sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func UseXFont(c *xgb.Conn, ContextTag ContextTag, Font xproto.Font, First uint32, Count uint32, ListBase uint32) UseXFontCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'UseXFont' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(useXFontRequest(c, ContextTag, Font, First, Count, ListBase), cookie)
	return UseXFontCookie{cookie}
}

// UseXFontChecked sends a checked request.
// If an error occurs, it can be retrieved using UseXFontCookie.Check()
func UseXFontChecked(c *xgb.Conn, ContextTag ContextTag, Font xproto.Font, First uint32, Count uint32, ListBase uint32) UseXFontCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'UseXFont' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(useXFontRequest(c, ContextTag, Font, First, Count, ListBase), cookie)
	return UseXFontCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook UseXFontCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for UseXFont
// useXFontRequest writes a UseXFont request to a byte slice.
func useXFontRequest(c *xgb.Conn, ContextTag ContextTag, Font xproto.Font, First uint32, Count uint32, ListBase uint32) []byte {
	size := 24
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	xgb.Put32(buf[b:], uint32(Font))
	b += 4

	xgb.Put32(buf[b:], First)
	b += 4

	xgb.Put32(buf[b:], Count)
	b += 4

	xgb.Put32(buf[b:], ListBase)
	b += 4

	return buf
}

// VendorPrivateCookie is a cookie used only for VendorPrivate requests.
type VendorPrivateCookie struct {
	*xgb.Cookie
}

// VendorPrivate sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func VendorPrivate(c *xgb.Conn, VendorCode uint32, ContextTag ContextTag, Data []byte) VendorPrivateCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'VendorPrivate' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(vendorPrivateRequest(c, VendorCode, ContextTag, Data), cookie)
	return VendorPrivateCookie{cookie}
}

// VendorPrivateChecked sends a checked request.
// If an error occurs, it can be retrieved using VendorPrivateCookie.Check()
func VendorPrivateChecked(c *xgb.Conn, VendorCode uint32, ContextTag ContextTag, Data []byte) VendorPrivateCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'VendorPrivate' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(vendorPrivateRequest(c, VendorCode, ContextTag, Data), cookie)
	return VendorPrivateCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook VendorPrivateCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for VendorPrivate
// vendorPrivateRequest writes a VendorPrivate request to a byte slice.
func vendorPrivateRequest(c *xgb.Conn, VendorCode uint32, ContextTag ContextTag, Data []byte) []byte {
	size := xgb.Pad((12 + xgb.Pad((len(Data) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 16 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], VendorCode)
	b += 4

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	copy(buf[b:], Data[:len(Data)])
	b += int(len(Data))

	return buf
}

// VendorPrivateWithReplyCookie is a cookie used only for VendorPrivateWithReply requests.
type VendorPrivateWithReplyCookie struct {
	*xgb.Cookie
}

// VendorPrivateWithReply sends a checked request.
// If an error occurs, it will be returned with the reply by calling VendorPrivateWithReplyCookie.Reply()
func VendorPrivateWithReply(c *xgb.Conn, VendorCode uint32, ContextTag ContextTag, Data []byte) VendorPrivateWithReplyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'VendorPrivateWithReply' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(vendorPrivateWithReplyRequest(c, VendorCode, ContextTag, Data), cookie)
	return VendorPrivateWithReplyCookie{cookie}
}

// VendorPrivateWithReplyUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func VendorPrivateWithReplyUnchecked(c *xgb.Conn, VendorCode uint32, ContextTag ContextTag, Data []byte) VendorPrivateWithReplyCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'VendorPrivateWithReply' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(vendorPrivateWithReplyRequest(c, VendorCode, ContextTag, Data), cookie)
	return VendorPrivateWithReplyCookie{cookie}
}

// VendorPrivateWithReplyReply represents the data returned from a VendorPrivateWithReply request.
type VendorPrivateWithReplyReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Retval uint32
	Data1  []byte // size: 24
	Data2  []byte // size: xgb.Pad(((int(Length) * 4) * 1))
}

// Reply blocks and returns the reply data for a VendorPrivateWithReply request.
func (cook VendorPrivateWithReplyCookie) Reply() (*VendorPrivateWithReplyReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return vendorPrivateWithReplyReply(buf), nil
}

// vendorPrivateWithReplyReply reads a byte slice into a VendorPrivateWithReplyReply value.
func vendorPrivateWithReplyReply(buf []byte) *VendorPrivateWithReplyReply {
	v := new(VendorPrivateWithReplyReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Retval = xgb.Get32(buf[b:])
	b += 4

	v.Data1 = make([]byte, 24)
	copy(v.Data1[:24], buf[b:])
	b += int(24)

	v.Data2 = make([]byte, (int(v.Length) * 4))
	copy(v.Data2[:(int(v.Length)*4)], buf[b:])
	b += int((int(v.Length) * 4))

	return v
}

// Write request to wire for VendorPrivateWithReply
// vendorPrivateWithReplyRequest writes a VendorPrivateWithReply request to a byte slice.
func vendorPrivateWithReplyRequest(c *xgb.Conn, VendorCode uint32, ContextTag ContextTag, Data []byte) []byte {
	size := xgb.Pad((12 + xgb.Pad((len(Data) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], VendorCode)
	b += 4

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	copy(buf[b:], Data[:len(Data)])
	b += int(len(Data))

	return buf
}

// WaitGLCookie is a cookie used only for WaitGL requests.
type WaitGLCookie struct {
	*xgb.Cookie
}

// WaitGL sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func WaitGL(c *xgb.Conn, ContextTag ContextTag) WaitGLCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'WaitGL' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(waitGLRequest(c, ContextTag), cookie)
	return WaitGLCookie{cookie}
}

// WaitGLChecked sends a checked request.
// If an error occurs, it can be retrieved using WaitGLCookie.Check()
func WaitGLChecked(c *xgb.Conn, ContextTag ContextTag) WaitGLCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'WaitGL' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(waitGLRequest(c, ContextTag), cookie)
	return WaitGLCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook WaitGLCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for WaitGL
// waitGLRequest writes a WaitGL request to a byte slice.
func waitGLRequest(c *xgb.Conn, ContextTag ContextTag) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	return buf
}

// WaitXCookie is a cookie used only for WaitX requests.
type WaitXCookie struct {
	*xgb.Cookie
}

// WaitX sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func WaitX(c *xgb.Conn, ContextTag ContextTag) WaitXCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'WaitX' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(waitXRequest(c, ContextTag), cookie)
	return WaitXCookie{cookie}
}

// WaitXChecked sends a checked request.
// If an error occurs, it can be retrieved using WaitXCookie.Check()
func WaitXChecked(c *xgb.Conn, ContextTag ContextTag) WaitXCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["GLX"]; !ok {
		panic("Cannot issue request 'WaitX' using the uninitialized extension 'GLX'. glx.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(waitXRequest(c, ContextTag), cookie)
	return WaitXCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook WaitXCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for WaitX
// waitXRequest writes a WaitX request to a byte slice.
func waitXRequest(c *xgb.Conn, ContextTag ContextTag) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["GLX"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 9 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(ContextTag))
	b += 4

	return buf
}
