//go:build ignore

package main

import (
	"bytes"
	"fmt"
	"log"
	"os"

	"github.com/richardlehane/siegfried"
)

func main() {
	sf, err := siegfried.Load("../../cmd/roy/data/default.sig")
	if err != nil {
		log.Fatal(err)
	}
	var buf = &bytes.Buffer{}
	err = sf.SaveWriter(buf)
	out, err := os.Create("signature.go")
	if err != nil {
		log.Fatal(err)
	}
	fmt.Fprintf(out, "// Code generated by go generate; DO NOT EDIT.\npackage static\n\nvar sfcontent = %#v", buf.Bytes())
	fmt.Println("Generated a new signature.go file")
}
