/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;
import net.sf.samtools.util.BlockCompressedInputStream;

public class LargeFileReader {
    private RandomAccessFile txt = null;
    private BlockCompressedInputStream bgzf = null;
    boolean isASCII = true;
    long file_size = 0L;

    public LargeFileReader(String string) throws IOException {
        if (this.isText(string)) {
            this.isASCII = true;
            this.txt = new RandomAccessFile(string, "r");
            this.bgzf = null;
        } else if (this.isBGZF(string)) {
            this.isASCII = false;
            this.bgzf = new BlockCompressedInputStream(new File(string));
            this.bgzf.seek(0L);
            this.file_size = new File(string).length();
            this.txt = null;
        }
    }

    private boolean isText(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        byte[] byArray = new byte[1024];
        int n = bufferedInputStream.read(byArray);
        for (int i = 0; i < n; ++i) {
            char c = (char)byArray[i];
            if (c >= ' ' && c <= '~' || Character.isWhitespace(c)) continue;
            return false;
        }
        bufferedInputStream.close();
        return true;
    }

    private boolean isBGZF(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            return BlockCompressedInputStream.isValidFile(bufferedInputStream);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("Cannot test non-buffered stream.");
            return false;
        }
    }

    public void close() throws IOException {
        if (this.bgzf != null) {
            this.bgzf.close();
        }
        if (this.txt != null) {
            this.txt.close();
        }
    }

    public long getFilePointer() throws IOException {
        if (this.isASCII && this.txt != null) {
            return this.txt.getFilePointer();
        }
        if (!this.isASCII && this.bgzf != null) {
            try {
                return this.bgzf.getFilePointer();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0L;
    }

    public long getRealOffset() throws IOException {
        if (this.isASCII && this.txt != null) {
            return this.txt.getFilePointer();
        }
        if (!this.isASCII && this.bgzf != null) {
            return BlockCompressedFilePointerUtil.getBlockAddress(this.bgzf.getFilePointer());
        }
        return 0L;
    }

    public long length() throws IOException {
        if (this.isASCII && this.txt != null) {
            return this.txt.length();
        }
        if (!this.isASCII && this.bgzf != null) {
            return this.file_size;
        }
        return 0L;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.isASCII && this.txt != null) {
            return this.txt.read(byArray);
        }
        if (!this.isASCII && this.bgzf != null) {
            return this.bgzf.read(byArray);
        }
        return 0;
    }

    public String readLine() throws IOException {
        if (this.isASCII && this.txt != null) {
            return this.txt.readLine();
        }
        if (!this.isASCII && this.bgzf != null) {
            char c;
            String string = "";
            while ((c = (char)this.bgzf.read()) < '\u00ff') {
                if (c != '\n') {
                    string = string + c;
                    continue;
                }
                return string;
            }
        }
        return null;
    }

    public void seek(long l) throws IOException {
        if (this.isASCII && this.txt != null) {
            this.txt.seek(l);
        }
        if (!this.isASCII && this.bgzf != null) {
            this.bgzf.seek(l);
        }
    }
}

