/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;

public class FASTQParse
extends BaseParse {
    protected static final int BUFF_SIZE = 1024;
    protected static final byte[] buffer = new byte[1024];
    protected int buffer_pos = 0;
    protected int buffer_size;
    protected long file_pos = 0L;
    protected RandomAccessFile filein;
    String[] col_names = new String[]{"Sequence Name", "Sequence", "Quality"};

    public FASTQParse(String string) {
        super(string);
        try {
            this.filein = new RandomAccessFile(string, "r");
            this.parseHeader();
            this.file_pos = this.filein.getFilePointer();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't open file as FASTQ");
        }
    }

    protected void parseHeader() {
        String string = null;
        this.header = "";
        long l = 0L;
        try {
            String string2;
            l = this.filein.getFilePointer();
            while ((string = this.filein.readLine()) != null && (string2 = string.substring(0, 1)).equals("#")) {
                this.header = this.header + string;
                this.header = this.header + "\n";
                l = this.filein.getFilePointer();
            }
            if (l >= 0L) {
                this.filein.seek(l);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void seek(long l) throws IOException {
        this.filein.seek(l);
        this.file_pos = this.filein.getFilePointer();
    }

    @Override
    public long getNextRecordIndex() {
        long l = this.file_pos + (long)this.buffer_pos;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = 0;
        try {
            while (true) {
                if (this.buffer_size == 0 || this.buffer_pos >= this.buffer_size) {
                    this.file_pos = this.filein.getFilePointer();
                    this.buffer_size = this.filein.read(buffer);
                    this.buffer_pos = 0;
                }
                if (this.buffer_size < 1) {
                    return -1L;
                }
                if (buffer[this.buffer_pos] == 43 && bl2) {
                    bl3 = true;
                }
                if (buffer[this.buffer_pos] == 10) {
                    if (bl4) {
                        if (n == ++n2) {
                            ++this.buffer_pos;
                            return l;
                        }
                    } else if (bl3) {
                        bl4 = true;
                    } else if (bl2) {
                        ++n;
                    } else if (bl) {
                        bl2 = true;
                    }
                }
                ++this.buffer_pos;
            }
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public String[] getNextRecord() {
        try {
            String string;
            String[] stringArray = new String[3];
            while ((string = this.filein.readLine()) != null) {
                if (!string.substring(0, 1).equals("@")) {
                    return null;
                }
                stringArray[0] = string.substring(1);
                String string2 = "";
                String string3 = "";
                while ((string = this.filein.readLine()) != null) {
                    if (string.matches("[ACTGNacgtnURYSWKMBDHVN.-]*")) {
                        string2 = string2 + string;
                        continue;
                    }
                    if (!string.substring(0, 1).equals("+")) {
                        return null;
                    }
                    while ((string = this.filein.readLine()) != null) {
                        string3 = string3 + string;
                        if (string2.length() > string3.length()) continue;
                        stringArray[1] = string2;
                        stringArray[2] = string3;
                        return stringArray;
                    }
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public double getProgress() {
        try {
            return 1.0 * (double)this.filein.getFilePointer() / (1.0 * (double)this.filein.length());
        }
        catch (IOException iOException) {
            return 1.0;
        }
    }

    @Override
    public String getToolTip(String string, int n, int n2, String[] stringArray) {
        if (n2 == 1 && stringArray.length > 2) {
            String string2 = stringArray[2];
            return this.prettyPrintBaseQual(string, string2);
        }
        return string;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= this.col_names.length) {
            return "Unknown";
        }
        if (n < 0) {
            return "Unknown";
        }
        return this.col_names[n];
    }

    @Override
    public int getNumColumnLabels() {
        if (this.col_names == null) {
            return 0;
        }
        return this.col_names.length;
    }

    protected String prettyPrintBaseQual(String string, String string2) {
        if (string.equals("*") || string.length() != string2.length()) {
            return "<html><font size=\"5\">" + string + "</font></html>";
        }
        String string3 = "<html>";
        for (int i = 0; i < string.length(); ++i) {
            string3 = string3 + "<font size=\"5\" color=\"";
            int n = string2.charAt(i) - 33;
            string3 = n < 20 ? string3 + "#E9CFEC" : string3 + "#571B7e";
            string3 = string3 + "\">";
            string3 = string3 + string.charAt(i);
            string3 = string3 + "</font>";
        }
        string3 = string3 + "</html>";
        return string3;
    }
}

