/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ByteOperand;
import jas.CP;
import jas.CPOperand;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.Label;
import jas.LabelOperand;
import jas.LdcOperand;
import jas.OffsetOperand;
import jas.RelativeOffsetOperand;
import jas.RuntimeConstants;
import jas.UnsignedByteOperand;
import jas.UnsignedByteWideOperand;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

public class Insn
implements RuntimeConstants {
    int opc;
    InsnOperand operand;

    Insn() {
    }

    public Insn(int opc) throws jasError {
        if (opcLengths[opc] == 1) {
            this.operand = null;
            this.opc = opc;
            return;
        }
        throw new jasError(opcNames[opc] + " cannot be used without more parameters");
    }

    private void check_short(int val, int opc) throws jasError {
        if (val > Short.MAX_VALUE || val < Short.MIN_VALUE) {
            throw new jasError(opcNames[opc] + " numeric value exceed size for short");
        }
    }

    public Insn(int opc, int val, boolean Wide) throws jasError {
        this.opc = opc;
        switch (opc) {
            case 16: {
                if (val > 127 || val < -128) {
                    throw new jasError("bipush value exceed size of byte", true);
                }
                this.operand = new ByteOperand(val);
                break;
            }
            case 17: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.check_short(val, opc);
                this.operand = new OffsetOperand(this, val);
                break;
            }
            case 200: 
            case 201: {
                this.operand = new OffsetOperand(this, val, true);
                break;
            }
            case 188: {
                if (val < 0 || val > 255) {
                    throw new jasError("newarray counter is illegal", true);
                }
                this.operand = new UnsignedByteOperand(val);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                this.operand = new UnsignedByteWideOperand(val, Wide);
                break;
            }
            default: {
                throw new jasError(opcNames[opc] + " does not take a numeric argument");
            }
        }
    }

    public Insn(int opc, int val, char relative) throws jasError {
        this.opc = opc;
        switch (opc) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.check_short(val, opc);
                this.operand = new RelativeOffsetOperand(this, val);
                break;
            }
            case 200: 
            case 201: {
                this.operand = new RelativeOffsetOperand(this, val, true);
                break;
            }
            default: {
                throw new jasError(opcNames[opc] + " does not take a relative numeric argument");
            }
        }
    }

    public Insn(int opc, Label target, int line) throws jasError {
        this.opc = opc;
        switch (opc) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.operand = new LabelOperand(target, this, line);
                break;
            }
            case 200: 
            case 201: {
                this.operand = new LabelOperand(target, this, true, line);
                break;
            }
            default: {
                throw new jasError(opcNames[opc] + " does not take a label as its argument");
            }
        }
    }

    public Insn(int opc, CP arg) throws jasError {
        this.opc = opc;
        switch (opc) {
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 186: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                this.operand = new CPOperand(arg);
                break;
            }
            case 19: 
            case 20: {
                this.operand = new LdcOperand(this, arg);
                break;
            }
            case 18: {
                this.operand = new LdcOperand(this, arg, false);
                break;
            }
            default: {
                throw new jasError(opcNames[opc] + " does not take a CP item as an argument");
            }
        }
    }

    void resolve(ClassEnv e) {
        if (this.operand != null) {
            this.operand.resolve(e);
        }
    }

    int widen(ClassEnv e, CodeAttr ce) throws jasError {
        int tpc;
        if (this.opc != 167 && this.opc != 168) {
            return 0;
        }
        LabelOperand lo = (LabelOperand)this.operand;
        int pc = ce.getPc(lo.target);
        int off = pc - (tpc = ce.getPc(lo.source));
        if (off > Short.MAX_VALUE || off < Short.MIN_VALUE) {
            int prev = this.size(e, ce);
            this.opc = this.opc == 167 ? 200 : 201;
            lo.wide = true;
            int now = this.size(e, ce);
            return now - prev;
        }
        return 0;
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        if (this.operand != null) {
            this.operand.writePrefix(e, ce, out);
        }
        out.writeByte((byte)this.opc);
        if (this.operand != null) {
            this.operand.write(e, ce, out);
        }
    }

    int size(ClassEnv e, CodeAttr ce) throws jasError {
        if (this.operand == null) {
            return 1;
        }
        return 1 + this.operand.size(e, ce);
    }

    public String toString() {
        return "instruction " + this.opc + " " + (this.operand != null ? this.operand.toString() : "");
    }
}

