/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.BitSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ExactAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class BrownBacktrackColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ExactAlgorithm<Integer, V> {
    private int[] _color;
    private int[] _colorCount;
    private BitSet[] _allowedColors;
    private int _chi;

    public BrownBacktrackColoring(Graph<V, E> g) {
        super(g);
    }

    void recursiveColor(int pos) {
        int i;
        this._colorCount[pos] = this._colorCount[pos - 1];
        this._allowedColors[pos].set(0, this._colorCount[pos] + 1);
        for (i = 0; i < this._neighbors[pos].length; ++i) {
            int nb = this._neighbors[pos][i];
            if (this._color[nb] <= 0) continue;
            this._allowedColors[pos].clear(this._color[nb]);
        }
        for (i = 1; i <= this._colorCount[pos] && this._colorCount[pos] < this._chi; ++i) {
            if (!this._allowedColors[pos].get(i)) continue;
            this._color[pos] = i;
            if (pos < this._neighbors.length - 1) {
                this.recursiveColor(pos + 1);
                continue;
            }
            this._chi = this._colorCount[pos];
        }
        if (this._colorCount[pos] + 1 < this._chi) {
            int n = pos;
            this._colorCount[n] = this._colorCount[n] + 1;
            this._color[pos] = this._colorCount[pos];
            if (pos < this._neighbors.length - 1) {
                this.recursiveColor(pos + 1);
            } else {
                this._chi = this._colorCount[pos];
            }
        }
        this._color[pos] = 0;
    }

    @Override
    public Integer getResult(Map<V, Object> additionalData) {
        int i;
        this._chi = this._neighbors.length;
        this._color = new int[this._neighbors.length];
        this._color[0] = 1;
        this._colorCount = new int[this._neighbors.length];
        this._colorCount[0] = 1;
        this._allowedColors = new BitSet[this._neighbors.length];
        for (i = 0; i < this._neighbors.length; ++i) {
            this._allowedColors[i] = new BitSet(1);
        }
        this.recursiveColor(1);
        for (i = 0; i < this._vertices.size(); ++i) {
            additionalData.put(this._vertices.get(i), this._color[i]);
        }
        return this._chi;
    }
}

