/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.LoggerRt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateCapture;

final class SyntaxNodeDescriptorImpl
implements MutableSyntaxNodeDescriptor {
    private static final LoggerRt LOG = LoggerRt.getInstance(SyntaxNodeDescriptor.class);
    private Int2ObjectMap<SyntaxNodeDescriptor> myRepository = new Int2ObjectOpenHashMap();
    private Map<Constants.StringKey, CharSequence> myStringAttributes = new EnumMap<Constants.StringKey, CharSequence>(Constants.StringKey.class);
    private Map<Constants.CaptureKey, TextMateCapture[]> myCaptures = new EnumMap<Constants.CaptureKey, TextMateCapture[]>(Constants.CaptureKey.class);
    private List<SyntaxNodeDescriptor> myChildren = new ArrayList<SyntaxNodeDescriptor>();
    private List<InjectionNodeDescriptor> myInjections = new ArrayList<InjectionNodeDescriptor>();
    private final SyntaxNodeDescriptor myParentNode;
    @Nullable
    private final CharSequence myScopeName;

    SyntaxNodeDescriptorImpl(@Nullable CharSequence scopeName, @Nullable SyntaxNodeDescriptor parentNode) {
        this.myParentNode = parentNode;
        this.myScopeName = scopeName;
    }

    @Override
    public void setStringAttribute(@NotNull Constants.StringKey key, @Nullable CharSequence value) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myStringAttributes.put(key, value);
    }

    @Override
    @Nullable
    public CharSequence getStringAttribute(@NotNull Constants.StringKey key) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(1);
        }
        return this.myStringAttributes.get((Object)key);
    }

    @Override
    public void setCaptures(@NotNull Constants.CaptureKey key, TextMateCapture @Nullable [] captures) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(2);
        }
        this.myCaptures.put(key, captures);
    }

    @Override
    public boolean hasBackReference(@NotNull Constants.StringKey key) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public TextMateCapture[] getCaptureRules(@NotNull Constants.CaptureKey key) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(4);
        }
        return this.myCaptures.get((Object)key);
    }

    @Override
    @Nullable
    public Int2ObjectMap<CharSequence> getCaptures(@NotNull Constants.CaptureKey key) {
        TextMateCapture[] realCaptures;
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(5);
        }
        if ((realCaptures = this.myCaptures.get((Object)key)) == null) {
            return null;
        }
        Int2ObjectOpenHashMap captures = new Int2ObjectOpenHashMap(realCaptures.length);
        for (int group = 0; group < this.myCaptures.get((Object)key).length; ++group) {
            TextMateCapture capture = realCaptures[group];
            if (capture == null) continue;
            captures.put(group, (Object)(capture instanceof TextMateCapture.Name ? ((TextMateCapture.Name)capture).getName() : ""));
        }
        return captures;
    }

    @Override
    public boolean hasBackReference(@NotNull Constants.CaptureKey key, int group) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public void addChild(SyntaxNodeDescriptor descriptor) {
        this.myChildren.add(descriptor);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        List<SyntaxNodeDescriptor> list = this.myChildren;
        if (list == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public void appendRepository(int ruleId, SyntaxNodeDescriptor descriptor) {
        this.myRepository.put(ruleId, (Object)descriptor);
    }

    @Override
    public void compact() {
        this.myStringAttributes = PreferencesReadUtil.compactMap(this.myStringAttributes);
        this.myCaptures = PreferencesReadUtil.compactMap(this.myCaptures);
        this.myChildren = SyntaxNodeDescriptorImpl.compactList(this.myChildren);
        this.myInjections = SyntaxNodeDescriptorImpl.compactList(this.myInjections);
        this.myRepository = SyntaxNodeDescriptorImpl.compactMap(this.myRepository);
    }

    private static Int2ObjectMap<SyntaxNodeDescriptor> compactMap(Int2ObjectMap<SyntaxNodeDescriptor> map) {
        if (map.isEmpty()) {
            return null;
        }
        if (map instanceof Int2ObjectOpenHashMap) {
            ((Int2ObjectOpenHashMap)map).trim();
        }
        return map;
    }

    private static <T> List<T> compactList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @Override
    @NotNull
    public List<InjectionNodeDescriptor> getInjections() {
        List<InjectionNodeDescriptor> list = this.myInjections;
        if (list == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public void addInjection(@NotNull InjectionNodeDescriptor injection) {
        if (injection == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(9);
        }
        this.myInjections.add(injection);
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(int ruleId) {
        SyntaxNodeDescriptor syntaxNodeDescriptor;
        SyntaxNodeDescriptor syntaxNodeDescriptor2 = syntaxNodeDescriptor = this.myRepository != null ? (SyntaxNodeDescriptor)this.myRepository.get(ruleId) : null;
        if (syntaxNodeDescriptor == null && this.myParentNode != null) {
            SyntaxNodeDescriptor syntaxNodeDescriptor3 = this.myParentNode.findInRepository(ruleId);
            if (syntaxNodeDescriptor3 == null) {
                SyntaxNodeDescriptorImpl.$$$reportNull$$$0(10);
            }
            return syntaxNodeDescriptor3;
        }
        if (syntaxNodeDescriptor == null) {
            LOG.warn("Can't find repository " + ruleId);
            SyntaxNodeDescriptor syntaxNodeDescriptor4 = EMPTY_NODE;
            if (syntaxNodeDescriptor4 == null) {
                SyntaxNodeDescriptorImpl.$$$reportNull$$$0(11);
            }
            return syntaxNodeDescriptor4;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor5 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor5 == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(12);
        }
        return syntaxNodeDescriptor5;
    }

    @Override
    @Nullable
    public CharSequence getScopeName() {
        return this.myScopeName;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    public String toString() {
        CharSequence name = this.myStringAttributes.get((Object)Constants.StringKey.NAME);
        return name != null ? "Syntax rule: " + name : super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setStringAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCaptures";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasBackReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCaptureRules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCaptures";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addInjection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

