/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPusher;
import git4idea.push.GroupedPushResult;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitPushResultNotification
extends Notification {
    private static final Logger LOG = Logger.getInstance(GitPushResultNotification.class);

    private GitPushResultNotification(@NotNull String groupDisplayId, @NotNull @Nls String title, @NotNull @Nls String content, @NotNull NotificationType type) {
        if (groupDisplayId == null) {
            GitPushResultNotification.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GitPushResultNotification.$$$reportNull$$$0(1);
        }
        if (content == null) {
            GitPushResultNotification.$$$reportNull$$$0(2);
        }
        if (type == null) {
            GitPushResultNotification.$$$reportNull$$$0(3);
        }
        super(groupDisplayId, "", GitPushResultNotification.emulateTitle(title, content), type);
        this.setDisplayId("git.push.result");
    }

    @RequiresEdt
    @NotNull
    static GitPushResultNotification create(@NotNull Project project, @NotNull GitPushResult pushResult, @Nullable GitPushOperation pushOperation, boolean multiRepoProject, @Nullable GitUpdateInfoAsLog.NotificationData notificationData, @NotNull Map<String, VcsPushOptionValue> customParams) {
        List staleInfoRejected;
        String description;
        NotificationType type;
        String title;
        if (project == null) {
            GitPushResultNotification.$$$reportNull$$$0(4);
        }
        if (pushResult == null) {
            GitPushResultNotification.$$$reportNull$$$0(5);
        }
        if (customParams == null) {
            GitPushResultNotification.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        GroupedPushResult grouped = GroupedPushResult.group(pushResult.getResults());
        boolean singleRepoSuccess = false;
        if (!grouped.errors.isEmpty()) {
            title = !grouped.successful.isEmpty() ? GitBundle.message("push.notification.partially.failed.title", new Object[0]) : GitBundle.message("push.notification.push.failed.title", new Object[0]);
            type = NotificationType.ERROR;
        } else if (!grouped.rejected.isEmpty() || !grouped.customRejected.isEmpty()) {
            title = !grouped.successful.isEmpty() ? GitBundle.message("push.notification.partially.rejected.title", new Object[0]) : GitBundle.message("push.notification.rejected.title", new Object[0]);
            type = NotificationType.WARNING;
        } else {
            type = NotificationType.INFORMATION;
            if (!multiRepoProject) {
                singleRepoSuccess = true;
                GitPushRepoResult result3 = (GitPushRepoResult)ContainerUtil.getFirstItem(grouped.successful.values());
                title = GitPushResultNotification.formRepoDescription(result3);
            } else {
                title = GitBundle.message("push.notification.successful.title", new Object[0]);
            }
        }
        if (singleRepoSuccess) {
            if (notificationData != null) {
                int receivedCommitsCount = notificationData.getReceivedCommitsCount();
                description = GitBundle.message("push.notification.single.repo.success.description", receivedCommitsCount);
            } else {
                description = "";
            }
        } else {
            description = GitPushResultNotification.formDescription(pushResult.getResults(), multiRepoProject);
        }
        NotificationGroup group = type == NotificationType.INFORMATION ? VcsNotifier.standardNotification() : VcsNotifier.importantNotification();
        GitPushResultNotification notification = new GitPushResultNotification(group.getDisplayId(), title, description, type);
        if (AbstractCommonUpdateAction.showsCustomNotification(Collections.singletonList(GitVcs.getInstance(project)))) {
            if (notificationData != null && notificationData.getReceivedCommitsCount() > 0) {
                Integer filteredCommitsCount = notificationData.getFilteredCommitsCount();
                String actionText = filteredCommitsCount == null || filteredCommitsCount == 0 ? GitBundle.message("push.notification.view.received.commits.action", notificationData.getReceivedCommitsCount()) : GitBundle.message("push.notification.view.filtered.commits.actions", filteredCommitsCount);
                notification.addAction((AnAction)NotificationAction.createSimple((String)actionText, (Runnable)notificationData.getViewCommitAction()));
            }
        } else {
            UpdateInfoTree tree;
            UpdatedFiles updatedFiles = pushResult.getUpdatedFiles();
            if (!updatedFiles.isEmpty() && (tree = ProjectLevelVcsManagerEx.getInstanceEx((Project)project).showUpdateProjectInfo(updatedFiles, GitBundle.message("push.notification.update.action", new Object[0]), ActionInfo.UPDATE, false)) != null) {
                tree.setBefore(pushResult.getBeforeUpdateLabel());
                tree.setAfter(pushResult.getAfterUpdateLabel());
                notification.addAction((AnAction)new ViewUpdateInfoNotification(project, tree, GitBundle.message("push.notification.view.files.action", new Object[0]), (Notification)notification));
            }
        }
        if (!(staleInfoRejected = EntryStream.of(pushResult.getResults()).filterValues(result2 -> result2.getType() == GitPushRepoResult.Type.REJECTED_STALE_INFO).keys().toList()).isEmpty()) {
            notification.setContextHelpAction(new AnAction(GitBundle.message("push.notification.force.with.lease.help", new Object[0]), new HtmlBuilder().append(GitBundle.message("push.notification.force.with.lease.help.description.first", new Object[0])).br().append(GitBundle.message("push.notification.force.with.lease.help.description.second", new Object[0])).toString(), null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/push/GitPushResultNotification$1", "actionPerformed"));
                }
            });
            if (pushOperation != null) {
                notification.addAction((AnAction)new ForcePushNotificationAction(project, pushOperation, staleInfoRejected, customParams));
            }
        }
        if (!(grouped.errors.isEmpty() && grouped.rejected.isEmpty() && grouped.customRejected.isEmpty())) {
            VcsNotifier.addShowDetailsAction((Project)project, (Notification)notification);
        }
        GitPushResultNotification gitPushResultNotification = notification;
        if (gitPushResultNotification == null) {
            GitPushResultNotification.$$$reportNull$$$0(7);
        }
        return gitPushResultNotification;
    }

    @NlsContexts.NotificationContent
    @NotNull
    static String emulateTitle(@NotNull @Nls String title, @NotNull @Nls String content) {
        if (title == null) {
            GitPushResultNotification.$$$reportNull$$$0(8);
        }
        if (content == null) {
            GitPushResultNotification.$$$reportNull$$$0(9);
        }
        String string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.raw((String)title).bold()).br().appendRaw(content).toString();
        if (string == null) {
            GitPushResultNotification.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nls
    private static String formDescription(@NotNull Map<GitRepository, GitPushRepoResult> results, boolean multiRepoProject) {
        if (results == null) {
            GitPushResultNotification.$$$reportNull$$$0(11);
        }
        List entries = ContainerUtil.sorted(results.entrySet(), (o1, o2) -> {
            int compareResultTypes = GitPushRepoResult.TYPE_COMPARATOR.compare(((GitPushRepoResult)o1.getValue()).getType(), ((GitPushRepoResult)o2.getValue()).getType());
            if (compareResultTypes != 0) {
                return compareResultTypes;
            }
            return DvcsUtil.REPOSITORY_COMPARATOR.compare((Repository)o1.getKey(), (Repository)o2.getKey());
        });
        return new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map((Collection)entries, entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitPushRepoResult result2 = (GitPushRepoResult)entry.getValue();
            Object description = multiRepoProject ? DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + GitPushResultNotification.formRepoDescription(result2) : GitPushResultNotification.formRepoDescription(result2);
            return HtmlChunk.raw((String)description);
        })).toString();
    }

    @Nls
    private static String selectBundleMessageWithTags(List<@NlsSafe String> pushedTags, @Nls @Nls Supplier<@Nls String> withoutTagsMessage, @Nls @Nls Supplier<@Nls String> singleTagMessage, @Nls @Nls Supplier<@Nls String> manyTagsMessage) {
        if (pushedTags.isEmpty()) {
            return withoutTagsMessage.get();
        }
        if (pushedTags.size() == 1) {
            return singleTagMessage.get();
        }
        return manyTagsMessage.get();
    }

    @NlsSafe
    private static String tagName(List<@NlsSafe String> pushedTags) {
        return GitBranchUtil.stripRefsPrefix(pushedTags.get(0));
    }

    @NlsContexts.NotificationContent
    private static String formRepoDescription(@NotNull GitPushRepoResult result2) {
        if (result2 == null) {
            GitPushResultNotification.$$$reportNull$$$0(12);
        }
        @NotNull HtmlChunk sourceBranch = HtmlChunk.text((String)GitBranchUtil.stripRefsPrefix(result2.getSourceBranch()));
        @NotNull HtmlChunk targetBranch = HtmlChunk.text((String)GitBranchUtil.stripRefsPrefix(result2.getTargetBranch()));
        @NotNull HtmlChunk remoteName = HtmlChunk.text((String)result2.getTargetRemote());
        @NotNull List<String> pushedTags = result2.getPushedTags();
        boolean sourceIsTag = result2.getSourceBranch().startsWith("refs/tags/");
        HtmlChunk tagName = !pushedTags.isEmpty() ? HtmlChunk.text((String)GitPushResultNotification.tagName(pushedTags)) : HtmlChunk.empty();
        return switch (result2.getType()) {
            case GitPushRepoResult.Type.SUCCESS -> {
                int commitNum = result2.getNumberOfPushedCommits();
                yield GitPushResultNotification.selectBundleMessageWithTags(pushedTags, () -> GitBundle.message("push.notification.description.pushed", commitNum, targetBranch), () -> GitBundle.message("push.notification.description.pushed.with.single.tag", commitNum, targetBranch, tagName, remoteName), () -> GitBundle.message("push.notification.description.pushed.with.many.tags", commitNum, targetBranch, pushedTags.size(), remoteName));
            }
            case GitPushRepoResult.Type.NEW_BRANCH -> {
                if (sourceIsTag && result2.getPushedTags().size() == 1) {
                    yield GitBundle.message("push.notification.description.pushed.single.tag", tagName, remoteName);
                }
                yield GitPushResultNotification.selectBundleMessageWithTags(pushedTags, () -> GitBundle.message("push.notification.description.new.branch", sourceBranch, targetBranch), () -> GitBundle.message("push.notification.description.new.branch.with.single.tag", sourceBranch, targetBranch, tagName, remoteName), () -> GitBundle.message("push.notification.description.new.branch.with.many.tags", sourceBranch, targetBranch, pushedTags.size(), remoteName));
            }
            case GitPushRepoResult.Type.UP_TO_DATE -> GitPushResultNotification.selectBundleMessageWithTags(pushedTags, () -> GitBundle.message("push.notification.description.up.to.date", new Object[0]), () -> GitBundle.message("push.notification.description.pushed.single.tag", tagName, remoteName), () -> GitBundle.message("push.notification.description.pushed.many.tags", pushedTags.size(), remoteName));
            case GitPushRepoResult.Type.FORCED -> GitBundle.message("push.notification.description.force.pushed", sourceBranch, targetBranch);
            case GitPushRepoResult.Type.REJECTED_NO_FF -> {
                GitUpdateResult updateResult = result2.getUpdateResult();
                if (updateResult == null) {
                    yield GitBundle.message("push.notification.description.rejected", targetBranch);
                }
                switch (updateResult) {
                    case SUCCESS: 
                    case NOTHING_TO_UPDATE: {
                        yield GitBundle.message("push.notification.description.rejected", targetBranch);
                    }
                    case SUCCESS_WITH_RESOLVED_CONFLICTS: {
                        yield GitBundle.message("push.notification.description.rejected.and.conflicts", new Object[0]);
                    }
                    case INCOMPLETE: {
                        yield GitBundle.message("push.notification.description.rejected.and.incomplete", new Object[0]);
                    }
                    case CANCEL: {
                        yield GitBundle.message("push.notification.description.rejected.and.cancelled", new Object[0]);
                    }
                }
                yield GitBundle.message("push.notification.description.rejected.and.failed", new Object[0]);
            }
            case GitPushRepoResult.Type.REJECTED_STALE_INFO -> GitBundle.message("push.notification.description.push.with.lease.rejected", sourceBranch, targetBranch);
            case GitPushRepoResult.Type.REJECTED_OTHER -> {
                if (sourceIsTag) {
                    yield GitBundle.message("push.notification.description.rejected.by.remote.without.target", sourceBranch);
                }
                yield GitBundle.message("push.notification.description.rejected.by.remote", sourceBranch, targetBranch);
            }
            case GitPushRepoResult.Type.ERROR -> XmlStringUtil.escapeString((String)result2.getError());
            default -> {
                LOG.error("Unexpected push result: " + result2);
                yield "";
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayId";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customParams";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushResultNotification";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushResultNotification";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "emulateTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "emulateTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formRepoDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }

    private static final class ForcePushNotificationAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitPushOperation myOperation;
        @NotNull
        private final List<GitRepository> myRepositories;
        @NotNull
        private final Map<String, VcsPushOptionValue> customParams;

        private ForcePushNotificationAction(@NotNull Project project, @NotNull GitPushOperation pushOperation, @NotNull List<GitRepository> repositories, @NotNull Map<String, VcsPushOptionValue> params) {
            if (project == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(0);
            }
            if (pushOperation == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(1);
            }
            if (repositories == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(2);
            }
            if (params == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(3);
            }
            super(GitBundle.message("push.notification.force.push.anyway.action", new Object[0]));
            this.myProject = project;
            this.myOperation = pushOperation;
            this.myRepositories = repositories;
            this.customParams = params;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(4);
            }
            if (notification == null) {
                ForcePushNotificationAction.$$$reportNull$$$0(5);
            }
            notification.expire();
            final Project project = this.myProject;
            new Task.Backgroundable(project, GitBundle.message("push.notification.force.push.progress.title.pushing", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GitPushOperation forcePushOperation = myOperation.deriveForceWithoutLease(myRepositories);
                    GitPusher.pushAndNotify(project, forcePushOperation, customParams);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushResultNotification$ForcePushNotificationAction$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pushOperation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "git4idea/push/GitPushResultNotification$ForcePushNotificationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

