/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import com.intellij.openapi.util.ShutDownTracker;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class JulLogger
extends Logger {
    protected final java.util.logging.Logger myLogger;
    private static final boolean CLEANER_DELAYED;

    public JulLogger(java.util.logging.Logger delegate) {
        this.myLogger = delegate;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLogger.isLoggable(Level.FINER);
    }

    @Override
    public void trace(String message) {
        this.myLogger.log(Level.FINER, message);
    }

    @Override
    public void trace(@Nullable Throwable t) {
        this.myLogger.log(Level.FINER, "", t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.myLogger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String message, @Nullable Throwable t) {
        this.myLogger.log(Level.FINE, message, t);
    }

    @Override
    public void info(String message, @Nullable Throwable t) {
        this.myLogger.log(Level.INFO, message, t);
    }

    @Override
    public void warn(String message, @Nullable Throwable t) {
        this.myLogger.log(Level.WARNING, message, t);
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            JulLogger.$$$reportNull$$$0(0);
        }
        String fullMessage = details.length > 0 ? message + "\nDetails: " + String.join((CharSequence)"\n", details) : message;
        this.myLogger.log(Level.SEVERE, fullMessage, t);
    }

    @Override
    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            JulLogger.$$$reportNull$$$0(1);
        }
        this.myLogger.setLevel(level.getLevel());
    }

    public static void clearHandlers() {
        JulLogger.clearHandlers(java.util.logging.Logger.getLogger(""));
    }

    public static void clearHandlers(java.util.logging.Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    @ApiStatus.Internal
    public static void configureLogFileAndConsole(@NotNull Path logFilePath, boolean appendToFile, boolean enableConsoleLogger, boolean showDateInConsole, @Nullable Runnable onRotate) {
        if (logFilePath == null) {
            JulLogger.$$$reportNull$$$0(2);
        }
        long limit = Long.getLong("idea.log.limit", 10000000L);
        int count2 = Integer.getInteger("idea.log.count", 12);
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        IdeaLogRecordFormatter layout = new IdeaLogRecordFormatter();
        RollingFileHandler fileHandler = new RollingFileHandler(logFilePath, limit, count2, appendToFile, onRotate);
        fileHandler.setFormatter(layout);
        fileHandler.setLevel(Level.FINEST);
        rootLogger.addHandler(fileHandler);
        if (enableConsoleLogger) {
            OptimizedConsoleHandler consoleHandler = new OptimizedConsoleHandler();
            consoleHandler.setFormatter(new IdeaLogRecordFormatter(showDateInConsole, layout));
            consoleHandler.setLevel(Level.WARNING);
            rootLogger.addHandler(consoleHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean delayCleanerUntilIdeShutdownActivitiesFinished() throws Exception {
        Class<?> logManagerCleanerClass = Class.forName("java.util.logging.LogManager$Cleaner");
        Class<?> appShutdownHooks = Class.forName("java.lang.ApplicationShutdownHooks");
        Field hooksField = appShutdownHooks.getDeclaredField("hooks");
        hooksField.setAccessible(true);
        IdentityHashMap hooks = (IdentityHashMap)hooksField.get(null);
        Class<?> clazz = appShutdownHooks;
        synchronized (clazz) {
            for (Object o : hooks.keySet()) {
                if (!(o instanceof Thread) || !logManagerCleanerClass.isAssignableFrom(o.getClass())) continue;
                Thread logCloseThread = (Thread)o;
                ShutDownTracker.getInstance().registerShutdownTask(logCloseThread);
                hooks.remove(o);
                return true;
            }
        }
        return false;
    }

    @TestOnly
    public static boolean isJulLoggerCleanerDelayed() {
        return CLEANER_DELAYED;
    }

    static {
        boolean delayed = false;
        try {
            delayed = JulLogger.delayCleanerUntilIdeShutdownActivitiesFinished();
        }
        catch (Exception e) {
            System.err.println("Be careful, logger will be shut down earlier than application: " + e.getMessage());
        }
        CLEANER_DELAYED = delayed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFilePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diagnostic/JulLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureLogFileAndConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class OptimizedConsoleHandler
    extends ConsoleHandler {
        private OptimizedConsoleHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                super.publish(record);
            }
        }
    }
}

