/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Product;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.installer.BinaryInstallation;
import com.jetbrains.python.sdk.installer.BinaryInstaller;
import com.jetbrains.python.sdk.installer.BinaryInstallerUsagesCollector;
import com.jetbrains.python.sdk.installer.ResourceTypeBinaryInstaller;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bJ$\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00050\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallManager;", "", "<init>", "()V", "cpythonInstallers", "", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "getAvailableVersionsToInstall", "", "Lcom/jetbrains/python/psi/LanguageLevel;", "Lcom/jetbrains/python/sdk/installer/BinaryInstallation;", "getLanguageLevelInstallations", "product", "Lcom/jetbrains/python/sdk/Product;", "findInstalledSdk", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "languageLevel", "project", "Lcom/intellij/openapi/project/Project;", "systemWideSdksDetector", "Lkotlin/Function0;", "PkgBinaryInstaller", "ExeBinaryInstaller", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPySdkToInstallManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkToInstallManager.kt\ncom/jetbrains/python/sdk/PySdkToInstallManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n136#2,9:95\n216#2:104\n217#2:107\n145#2:108\n1#3:105\n1#3:106\n462#4:109\n412#4:110\n1246#5,2:111\n774#5:113\n865#5,2:114\n1368#5:116\n1454#5,2:117\n774#5:119\n865#5,2:120\n1557#5:122\n1628#5,3:123\n1456#5,3:126\n1368#5:129\n1454#5,2:130\n774#5:132\n865#5,2:133\n1557#5:135\n1628#5,3:136\n1456#5,3:139\n1249#5:142\n774#5:148\n865#5,2:149\n61#6,5:143\n*S KotlinDebug\n*F\n+ 1 PySdkToInstallManager.kt\ncom/jetbrains/python/sdk/PySdkToInstallManager\n*L\n42#1:95,9\n42#1:104\n42#1:107\n42#1:108\n42#1:106\n48#1:109\n48#1:110\n48#1:111,2\n50#1:113\n50#1:114,2\n51#1:116\n51#1:117,2\n52#1:119\n52#1:120,2\n52#1:122\n52#1:123,3\n51#1:126,3\n55#1:129\n55#1:130,2\n56#1:132\n56#1:133,2\n56#1:135\n56#1:136,3\n55#1:139,3\n48#1:142\n74#1:148\n74#1:149,2\n72#1:143,5\n*E\n"})
public final class PySdkToInstallManager {
    @NotNull
    public static final PySdkToInstallManager INSTANCE = new PySdkToInstallManager();
    @NotNull
    private static final List<ResourceTypeBinaryInstaller> cpythonInstallers;

    private PySdkToInstallManager() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LanguageLevel, BinaryInstallation> getAvailableVersionsToInstall() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = PySdkToInstallManager.getLanguageLevelInstallations$default(this, null, 1, null);
        boolean $i$f$mapNotNull = false;
        Map map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            LanguageLevel k = (LanguageLevel)entry.getKey();
            List v = (List)entry.getValue();
            if ((BinaryInstallation)CollectionsKt.firstOrNull((List)v) != null) {
                BinaryInstallation it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)k, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<LanguageLevel, List<BinaryInstallation>> getLanguageLevelInstallations(Product product) {
        void $this$mapValuesTo$iv$iv;
        Map<LanguageLevel, List<Release>> $this$mapValues$iv = SdksKeeper.INSTANCE.pythonReleasesByLanguageLevel();
        boolean $i$f$mapValues = false;
        Map<LanguageLevel, List<Release>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Iterable list$iv$iv;
            Iterable destination$iv$iv2;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List releases = (List)entry2.getValue();
            Iterable iterable = releases;
            boolean $i$f$filter = false;
            void var19_19 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Release it = (Release)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getProduct() == product)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                Release release = (Release)element$iv$iv;
                boolean bl4 = false;
                List<Binary> list2 = release.getBinaries();
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Object element$iv$iv22;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv2 = list2;
                    boolean $i$f$filter2 = false;
                    Iterable iterable2 = $this$filter$iv2;
                    Iterable destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv22 : $this$filterTo$iv$iv2) {
                        Binary it = (Binary)element$iv$iv22;
                        boolean bl5 = false;
                        if (!Binary.isCompatible$default(it, null, null, 3, null)) continue;
                        destination$iv$iv4.add(element$iv$iv22);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv4;
                    boolean $i$f$map = false;
                    destination$iv$iv4 = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    element$iv$iv22 = $this$mapTo$iv$iv.iterator();
                    while (element$iv$iv22.hasNext()) {
                        void it;
                        Object item$iv$iv = element$iv$iv22.next();
                        Binary bl5 = (Binary)item$iv$iv;
                        Iterable iterable3 = destination$iv$iv2;
                        boolean bl6 = false;
                        iterable3.add(TuplesKt.to((Object)release, (Object)it));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List releaseBinaries = (List)destination$iv$iv3;
            $this$flatMap$iv = releaseBinaries;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ResourceTypeBinaryInstaller it;
                void $this$filterTo$iv$iv3;
                list$iv$iv = (Pair)element$iv$iv;
                boolean bl7 = false;
                Release release = (Release)list$iv$iv.component1();
                Binary binary = (Binary)list$iv$iv.component2();
                Iterable $this$filter$iv3 = cpythonInstallers;
                boolean $i$f$filter3 = false;
                destination$iv$iv2 = $this$filter$iv3;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                    it = (ResourceTypeBinaryInstaller)element$iv$iv3;
                    boolean bl8 = false;
                    if (!it.canInstall(binary)) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                $this$filter$iv3 = (List)destination$iv$iv5;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv3 = $this$map$iv;
                destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void installer;
                    it = (ResourceTypeBinaryInstaller)item$iv$iv;
                    Collection collection = destination$iv$iv5;
                    boolean bl9 = false;
                    collection.add(new BinaryInstallation(release, binary, (BinaryInstaller)installer));
                }
                list$iv$iv = (List)destination$iv$iv5;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            map4.put(k, list);
        }
        return destination$iv$iv;
    }

    static /* synthetic */ Map getLanguageLevelInstallations$default(PySdkToInstallManager pySdkToInstallManager, Product product, int n, Object object) {
        if ((n & 1) != 0) {
            product = Product.CPython;
        }
        return pySdkToInstallManager.getLanguageLevelInstallations(product);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PyDetectedSdk findInstalledSdk(@Nullable LanguageLevel languageLevel, @Nullable Project project, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        BinaryInstallerUsagesCollector.LookupResult lookupResult;
        boolean bl;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        PySdkToInstallKt.getLOGGER().debug("Resetting system-wide sdks detectors");
        PySdkExtKt.resetSystemWideSdksDetectors();
        Object object = systemWideSdksDetector.invoke();
        List sdks2 = (List)object;
        boolean $i$a$-also-PySdkToInstallManager$findInstalledSdk$22 = false;
        Logger $this$debug_u24default$iv = PySdkToInstallKt.getLOGGER();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug(CollectionsKt.joinToString$default((Iterable)sdks2, null, (CharSequence)"Detected system-wide sdks: ", null, (int)0, null, PySdkToInstallManager::findInstalledSdk$lambda$12$lambda$11$lambda$10, (int)29, null), e$iv);
        }
        object = (Iterable)object;
        boolean $i$f$filter = false;
        void $i$a$-also-PySdkToInstallManager$findInstalledSdk$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LanguageLevel languageLevel2;
            PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv$iv);
            boolean bl3 = false;
            if (PythonSdkFlavor.getFlavor((Sdk)it) != null) {
                PythonSdkFlavor<?> flavor;
                boolean bl4 = false;
                String string = it.getHomePath();
                Intrinsics.checkNotNull((Object)string);
                languageLevel2 = flavor.getLanguageLevelFromVersionString(flavor.getVersionString(string));
            } else {
                languageLevel2 = null;
            }
            LanguageLevel detectedLevel = languageLevel2;
            LanguageLevel languageLevel3 = languageLevel;
            if (!(languageLevel3 != null ? languageLevel3.equals(detectedLevel) : true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object it = object = (List)destination$iv$iv;
        boolean bl5 = false;
        String string = String.valueOf(languageLevel);
        boolean bl6 = bl = !((Collection)it).isEmpty();
        if (bl) {
            lookupResult = BinaryInstallerUsagesCollector.LookupResult.FOUND;
        } else if (!bl) {
            lookupResult = BinaryInstallerUsagesCollector.LookupResult.NOT_FOUND;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        BinaryInstallerUsagesCollector.INSTANCE.logLookupEvent(project, Product.CPython, string, lookupResult);
        return (PyDetectedSdk)((Object)CollectionsKt.firstOrNull((List)object));
    }

    private static final CharSequence findInstalledSdk$lambda$12$lambda$11$lambda$10(PyDetectedSdk it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = it.getHomePath();
        if (string != null) {
            charSequence = string;
        } else {
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            charSequence = string2;
        }
        return charSequence;
    }

    static {
        Object[] objectArray = new ResourceTypeBinaryInstaller[]{new ExeBinaryInstaller(), new PkgBinaryInstaller()};
        cpythonInstallers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallManager$ExeBinaryInstaller;", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "<init>", "()V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.community.impl"})
    public static final class ExeBinaryInstaller
    extends ResourceTypeBinaryInstaller {
        public ExeBinaryInstaller() {
            super(ResourceType.MICROSOFT_WINDOWS_EXECUTABLE);
        }

        @Override
        @NotNull
        public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String[] stringArray = new String[]{((Object)path2.toAbsolutePath()).toString(), "/repair", "/quiet", "InstallAllUsers=0"};
            return new GeneralCommandLine(stringArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallManager$PkgBinaryInstaller;", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "<init>", "()V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.community.impl"})
    public static final class PkgBinaryInstaller
    extends ResourceTypeBinaryInstaller {
        public PkgBinaryInstaller() {
            super(ResourceType.APPLE_SOFTWARE_PACKAGE);
        }

        @Override
        @NotNull
        public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String[] stringArray = new String[]{"installer", "-pkg", ((Object)path2.toAbsolutePath()).toString(), "-target", "/"};
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
            Object[] objectArray = new Object[]{resource.getFileName()};
            String string = PySdkBundle.message("python.sdk.running.sudo.prompt", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return ExecUtil.sudoCommand((GeneralCommandLine)generalCommandLine, (String)string);
        }
    }
}

