/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeCheckerExtension;
import com.jetbrains.python.psi.types.PyTypeParameterMapping;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyTypingNewType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(0);
        }
        @NotNull GenericSubstitutions substitutions = new GenericSubstitutions();
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull Map<? extends PyTypeParameterType, PyType> typeVars) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(1);
        }
        if (typeVars == null) {
            PyTypeChecker.$$$reportNull$$$0(2);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions(typeVars);
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(3);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(4);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    @NotNull
    private static Optional<Boolean> match(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> result2;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(5);
        }
        Optional<Boolean> optional = (result2 = (Optional<Boolean>)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)expected, (Object)actual), (boolean)false, () -> PyTypeChecker.matchImpl(expected, actual, context))) == null ? Optional.of(true) : result2;
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(6);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchImpl(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        PyTypeVarType typeVarType;
        Optional<Boolean> match;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(7);
        }
        if (Objects.equals(expected, actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(8);
            }
            return optional;
        }
        for (PyTypeCheckerExtension extension : PyTypeCheckerExtension.EP_NAME.getExtensionList()) {
            Optional<Boolean> result2 = extension.match(expected, actual, context.context, context.mySubstitutions);
            if (!result2.isPresent()) continue;
            Optional<Boolean> optional = result2;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(9);
            }
            return optional;
        }
        if (expected instanceof PyClassType && (match = PyTypeChecker.matchObject((PyClassType)expected, actual)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(10);
            }
            return optional;
        }
        if (actual instanceof PyTypeVarTupleType) {
            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)actual;
            if (context.reversedSubstitutions) {
                Optional<Boolean> optional = Optional.of(PyTypeChecker.match(typeVarTupleType, expected, context));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(11);
                }
                return optional;
            }
        }
        if (expected instanceof PyVariadicType) {
            PyVariadicType variadic = (PyVariadicType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(variadic, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(12);
            }
            return optional;
        }
        if (actual instanceof PyTypeVarType) {
            typeVarType = (PyTypeVarType)actual;
            if (context.reversedSubstitutions) {
                Optional<Boolean> optional = Optional.of(PyTypeChecker.match(typeVarType, expected, context));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(13);
                }
                return optional;
            }
        }
        if (expected instanceof PyTypeVarType) {
            typeVarType = (PyTypeVarType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(typeVarType, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(14);
            }
            return optional;
        }
        if (expected instanceof PySelfType) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, actual, context);
        }
        if (actual instanceof PySelfType && context.reversedSubstitutions) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, expected, context);
        }
        if (expected instanceof PyParamSpecType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyParamSpecType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(15);
            }
            return optional;
        }
        if (expected == null || actual == null || PyTypeChecker.isUnknown(actual, context.context)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(16);
            }
            return optional;
        }
        if (actual instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(expected, (PyUnionType)actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(17);
            }
            return optional;
        }
        if (expected instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyUnionType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(18);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyClassType && (match = PyTypeChecker.match((PyClassType)expected, (PyClassType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(19);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && ((PyStructuralType)actual).isInferredFromUsages()) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(20);
            }
            return optional;
        }
        if (expected instanceof PyStructuralType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyStructuralType)expected, actual, context.context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(21);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && expected instanceof PyClassType) {
            Set<String> expectedAttributes = ((PyClassType)expected).getMemberNames(true, context.context);
            Optional<Boolean> optional = Optional.of(expectedAttributes.containsAll(((PyStructuralType)actual).getAttributeNames()));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(22);
            }
            return optional;
        }
        if (actual instanceof PyCallableType) {
            PyCallableType expectedCallable;
            Optional<Boolean> match2;
            PyCallableType actualCallable = (PyCallableType)actual;
            if (expected instanceof PyCallableType && (match2 = PyTypeChecker.match(expectedCallable = (PyCallableType)expected, actualCallable, context)).isPresent()) {
                Optional<Boolean> optional = match2;
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(23);
                }
                return optional;
            }
        }
        if (expected instanceof PyNoneType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyNoneType);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(24);
            }
            return optional;
        }
        if (expected instanceof PyModuleType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyModuleType && ((PyModuleType)expected).getModule() == ((PyModuleType)actual).getModule());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(25);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyModuleType) {
            return PyTypeChecker.match(expected, (PyType)((PyModuleType)actual).getModuleClassType(), context);
        }
        Optional<Boolean> optional = Optional.of(PyTypeChecker.matchNumericTypes(expected, actual));
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(26);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchObject(@NotNull PyClassType expected, @Nullable PyType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(27);
        }
        if (ArrayUtil.contains((String)expected.getName(), (String[])new String[]{"object", "type"})) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(expected.getPyClass());
            if (expected.equals(builtinCache.getObjectType())) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(28);
                }
                return optional;
            }
            if (expected.equals(builtinCache.getTypeType()) && actual instanceof PyInstantiableType && ((PyInstantiableType)actual).isDefinition()) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(29);
                }
                return optional;
            }
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(30);
        }
        return optional;
    }

    private static boolean match(@NotNull PyTypeVarType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        PyType safeActual;
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(32);
        }
        if (expected.isDefinition() && actual instanceof PyInstantiableType && !((PyInstantiableType)actual).isDefinition()) {
            return false;
        }
        PyType substituted = context.mySubstitutions.typeVars.get(expected);
        if (expected.getDefaultType() != null && expected.getDefaultType().equals(substituted)) {
            substituted = null;
        }
        PyType substitution = substituted;
        PyType bound = expected.getBound();
        if (expected.isDefinition()) {
            Function<PyType, PyType> toDefinition = t -> t instanceof PyInstantiableType ? ((PyInstantiableType)t).toClass() : t;
            bound = PyUnionType.union(PyTypeUtil.toStream(bound).map(toDefinition).toList());
        }
        if ((match = PyTypeChecker.match(bound, safeActual = bound instanceof PyLiteralStringType ? actual : PyTypeChecker.replaceLiteralStringWithStr(actual), context)).isPresent() && !match.get().booleanValue()) {
            return false;
        }
        if (substitution != null) {
            if (expected.equals(safeActual) || substitution.equals(expected)) {
                return true;
            }
            Optional recursiveMatch = (Optional)RecursionManager.doPreventingRecursion((Object)expected, (boolean)false, (Computable)(context.reversedSubstitutions ? () -> PyTypeChecker.match(safeActual, substitution, context) : () -> PyTypeChecker.match(substitution, safeActual, context)));
            return recursiveMatch != null ? recursiveMatch.orElse(false) : false;
        }
        if (safeActual != null) {
            context.mySubstitutions.typeVars.put(expected, safeActual);
        } else if (bound != null) {
            context.mySubstitutions.typeVars.put(expected, PyUnionType.createWeakType(bound));
        }
        return true;
    }

    private static boolean match(@NotNull PyVariadicType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(34);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyVariadicType)) {
            return false;
        }
        PyVariadicType actualVariadic = (PyVariadicType)actual;
        if (expected instanceof PyUnpackedTupleType) {
            PyUnpackedTupleType expectedUnpackedTupleType = (PyUnpackedTupleType)expected;
            if (!(actualVariadic instanceof PyUnpackedTupleType)) {
                return false;
            }
            PyUnpackedTupleType actualUnpackedTupleType = (PyUnpackedTupleType)actualVariadic;
            if (expectedUnpackedTupleType.isUnbound()) {
                PyType repeatedExpectedType = expectedUnpackedTupleType.getElementTypes().get(0);
                if (actualUnpackedTupleType.isUnbound()) {
                    return PyTypeChecker.match(repeatedExpectedType, actualUnpackedTupleType.getElementTypes().get(0), context).orElse(false);
                }
                return ContainerUtil.all(actualUnpackedTupleType.getElementTypes(), singleActualType -> PyTypeChecker.match(repeatedExpectedType, singleActualType, context).orElse(false));
            }
            if (actualUnpackedTupleType.isUnbound()) {
                PyType repeatedActualType = actualUnpackedTupleType.getElementTypes().get(0);
                return ContainerUtil.all(expectedUnpackedTupleType.getElementTypes(), singleExpectedType -> PyTypeChecker.match(singleExpectedType, repeatedActualType, context).orElse(false));
            }
            return PyTypeChecker.matchTypeParameters(expectedUnpackedTupleType.getElementTypes(), actualUnpackedTupleType.getElementTypes(), context);
        }
        PyVariadicType substitution = context.mySubstitutions.typeVarTuples.get(expected);
        if (substitution != null && !substitution.equals(PyUnpackedTupleTypeImpl.UNSPECIFIED)) {
            if (expected.equals(actual) || substitution.equals(expected)) {
                return true;
            }
            return context.reversedSubstitutions ? PyTypeChecker.match(actualVariadic, (PyType)substitution, context) : PyTypeChecker.match(substitution, (PyType)actualVariadic, context);
        }
        context.mySubstitutions.typeVarTuples.put((PyTypeVarTupleType)expected, actualVariadic);
        return true;
    }

    @Nullable
    private static PyType replaceLiteralStringWithStr(@Nullable PyType actual) {
        if (actual instanceof PyLiteralStringType) {
            PyLiteralStringType literalStringType = (PyLiteralStringType)actual;
            return new PyClassTypeImpl(literalStringType.getPyClass(), false);
        }
        if (actual instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)actual;
            return unionType.map(PyTypeChecker::replaceLiteralStringWithStr);
        }
        if (actual instanceof PyNamedTupleType) {
            return actual;
        }
        if (actual instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)actual;
            return new PyTupleType(tupleType.getPyClass(), ContainerUtil.map(tupleType.getElementTypes(), PyTypeChecker::replaceLiteralStringWithStr), tupleType.isHomogeneous(), tupleType.isDefinition());
        }
        if (actual instanceof PyCollectionType) {
            PyCollectionType generic = (PyCollectionType)actual;
            return new PyCollectionTypeImpl(generic.getPyClass(), generic.isDefinition(), ContainerUtil.map(generic.getElementTypes(), PyTypeChecker::replaceLiteralStringWithStr));
        }
        return actual;
    }

    private static boolean match(@NotNull PyParamSpecType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(36);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyParamSpecType)) {
            return false;
        }
        PyParamSpecType callableActual = (PyParamSpecType)actual;
        List<PyCallableParameter> parameters = callableActual.getParameters();
        if (parameters == null) {
            return false;
        }
        context.mySubstitutions.paramSpecs.put(expected, expected.withParameters(parameters, context.context));
        return true;
    }

    private static boolean match(@NotNull PyType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        PyTupleType expectedTupleType;
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(37);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(39);
        }
        if (expected instanceof PyTupleType && (match = PyTypeChecker.match(expectedTupleType = (PyTupleType)expected, actual, context)).isPresent()) {
            return match.get();
        }
        if (ContainerUtil.exists(actual.getMembers(), x -> x instanceof PyLiteralStringType || x instanceof PyLiteralType)) {
            return ContainerUtil.and(actual.getMembers(), type2 -> PyTypeChecker.match(expected, type2, context).orElse(false));
        }
        return ContainerUtil.or(actual.getMembers(), type2 -> PyTypeChecker.match(expected, type2, context).orElse(false));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        PyTupleType widenedActual;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(40);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(42);
        }
        int elementCount = expected.getElementCount();
        if (!expected.isHomogeneous() && (widenedActual = PyTypeChecker.widenUnionOfTuplesToTupleOfUnions(actual, elementCount)) != null) {
            return PyTypeChecker.match(expected, widenedActual, context);
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(43);
        }
        return optional;
    }

    private static boolean match(@NotNull PyUnionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(44);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(45);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(46);
        }
        if (expected.getMembers().contains(actual)) {
            return true;
        }
        return ContainerUtil.or(expected.getMembers(), type2 -> PyTypeChecker.match(type2, actual, context).orElse(true));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyTypedDictType.TypeCheckingResult matchResult;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(47);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(48);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(49);
        }
        if (expected.equals(actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(50);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected.isDefinition() ^ actual.isDefinition() && !PyProtocolsKt.isProtocol(expected, context)) {
            if (!expected.isDefinition() && actual.isDefinition()) {
                PyClassLikeType metaClass = actual.getMetaClassType(context, true);
                Optional<Boolean> optional = Optional.of(metaClass != null && PyTypeChecker.match((PyType)expected, (PyType)metaClass.toInstance(), matchContext).orElse(true) != false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(51);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(52);
            }
            return optional;
        }
        if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
            return PyTypeChecker.match((PyTupleType)expected, (PyTupleType)actual, matchContext);
        }
        if (expected instanceof PyLiteralType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyLiteralType && PyLiteralType.Companion.match((PyLiteralType)expected, (PyLiteralType)actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(53);
            }
            return optional;
        }
        if (actual instanceof PyTypedDictType && (matchResult = PyTypedDictType.Companion.checkTypes(expected, (PyTypedDictType)actual, context, null)) != null) {
            Optional<Boolean> optional = Optional.of(matchResult.getMatch());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(54);
            }
            return optional;
        }
        if (expected instanceof PyLiteralStringType) {
            Optional<Boolean> optional = Optional.of(PyLiteralStringType.Companion.match((PyLiteralStringType)expected, actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(55);
            }
            return optional;
        }
        PyClass superClass = expected.getPyClass();
        PyClass subClass = actual.getPyClass();
        if (!subClass.isSubclass(superClass, context) && PyProtocolsKt.isProtocol(expected, context)) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchProtocols(expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(56);
            }
            return optional;
        }
        if (expected instanceof PyCollectionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyCollectionType)expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(57);
            }
            return optional;
        }
        if (PyTypeChecker.matchClasses(superClass, subClass, context)) {
            if (expected instanceof PyTypingNewType && !expected.equals(actual) && superClass.equals(subClass)) {
                Optional<Boolean> optional = Optional.of(actual.getAncestorTypes(context).contains(expected));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(58);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(59);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(60);
        }
        return optional;
    }

    private static boolean matchProtocols(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyCollectionType genericSuperClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(61);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(62);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(63);
        }
        GenericSubstitutions substitutions = PyTypeChecker.collectTypeSubstitutions(actual, matchContext.context);
        MatchContext protocolContext = new MatchContext(matchContext.context, new GenericSubstitutions(), matchContext.reversedSubstitutions);
        for (kotlin.Pair<PyTypedElement, List<RatedResolveResult>> pair : PyProtocolsKt.inspectProtocolSubclass(expected, actual, matchContext.context)) {
            List subclassElements = (List)pair.getSecond();
            if (ContainerUtil.isEmpty((Collection)subclassElements)) {
                return false;
            }
            PyType protocolElementType = PyTypeChecker.dropSelfIfNeeded(expected, matchContext.context.getType((PyTypedElement)pair.getFirst()), matchContext.context);
            boolean elementResult = StreamEx.of((Collection)subclassElements).map(ResolveResult::getElement).select(PyTypedElement.class).map(matchContext.context::getType).map(type2 -> PyTypeChecker.dropSelfIfNeeded(actual, type2, matchContext.context)).map(type2 -> PyTypeChecker.substitute(type2, substitutions, matchContext.context)).anyMatch(subclassElementType -> {
                boolean matched = PyTypeChecker.match(protocolElementType, subclassElementType, protocolContext).orElse(true);
                if (!matched) {
                    return false;
                }
                if (!(protocolElementType instanceof PyFunctionType) || !(subclassElementType instanceof PyFunctionType)) {
                    return matched;
                }
                PyType protocolReturnType = ((PyFunctionType)protocolElementType).getReturnType(protocolContext.context);
                if (protocolReturnType instanceof PySelfType) {
                    PyType subclassReturnType = ((PyFunctionType)subclassElementType).getReturnType(protocolContext.context);
                    if (subclassReturnType instanceof PySelfType) {
                        return true;
                    }
                    return PyTypeChecker.match((PyType)actual, subclassReturnType, matchContext).orElse(true);
                }
                return matched;
            });
            if (elementResult) continue;
            return false;
        }
        if (expected instanceof PyCollectionType && (genericSuperClass = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), matchContext.context)) != null) {
            PyCollectionType concreteSuperClass = (PyCollectionType)PyTypeChecker.substitute(genericSuperClass, protocolContext.mySubstitutions, protocolContext.context);
            assert (concreteSuperClass != null);
            return PyTypeChecker.matchGenericClassesParameterWise((PyCollectionType)expected, concreteSuperClass, matchContext);
        }
        return true;
    }

    @Nullable
    private static PyType dropSelfIfNeeded(@NotNull PyClassType classType, @Nullable PyType elementType, @NotNull TypeEvalContext context) {
        PyFunctionType functionType;
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(64);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(65);
        }
        if (elementType instanceof PyFunctionType && (PyUtil.isInitOrNewMethod((PsiElement)(functionType = (PyFunctionType)elementType).getCallable()) || !classType.isDefinition())) {
            return functionType.dropSelf(context);
        }
        return elementType;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(66);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(67);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(68);
        }
        if (!expected.isHomogeneous() && !actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchTypeParameters(expected.getElementTypes(), actual.getElementTypes(), context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(69);
            }
            return optional;
        }
        if (expected.isHomogeneous() && !actual.isHomogeneous()) {
            PyType expectedElementType = expected.getIteratedItemType();
            for (int i = 0; i < actual.getElementCount(); ++i) {
                if (PyTypeChecker.match(expectedElementType, actual.getElementType(i), context).orElse(true).booleanValue()) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(70);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(71);
            }
            return optional;
        }
        if (!expected.isHomogeneous() && actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(72);
            }
            return optional;
        }
        return PyTypeChecker.match(expected.getIteratedItemType(), actual.getIteratedItemType(), context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        PyClass subClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(73);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(74);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(75);
        }
        if (actual instanceof PyTupleType) {
            return PyTypeChecker.match(expected, (PyTupleType)actual, context);
        }
        PyClass superClass = expected.getPyClass();
        return PyTypeChecker.matchClasses(superClass, subClass = actual.getPyClass(), context.context) && PyTypeChecker.matchGenerics(expected, actual, context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(76);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(77);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(78);
        }
        if (!PyTypeChecker.matchClasses(expected.getPyClass(), actual.getPyClass(), context.context)) {
            return false;
        }
        PyType superElementType = expected.getIteratedItemType();
        PyType subElementType = actual.getIteratedItemType();
        return PyTypeChecker.match(superElementType, subElementType, context).orElse(true);
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyType actual, @NotNull TypeEvalContext context) {
        PyFile module;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(79);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(80);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(81);
        }
        if (actual instanceof PyStructuralType) {
            return PyTypeChecker.match(expected, (PyStructuralType)actual);
        }
        if (actual instanceof PyClassType) {
            return PyTypeChecker.match(expected, (PyClassType)actual, context);
        }
        if (actual instanceof PyModuleType && (module = ((PyModuleType)actual).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && PyTypeChecker.definesGetAttr(module, context)) {
            return true;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return !ContainerUtil.exists(expected.getAttributeNames(), attribute -> ContainerUtil.isEmpty(actual.resolveMember((String)attribute, null, AccessDirection.READ, resolveContext)));
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyStructuralType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(82);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(83);
        }
        if (expected.isInferredFromUsages()) {
            return true;
        }
        return expected.getAttributeNames().containsAll(actual.getAttributeNames());
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyClassType actual, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(84);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(85);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(86);
        }
        if (PyTypeChecker.overridesGetAttr(actual.getPyClass(), context)) {
            return true;
        }
        Set<String> actualAttributes = actual.getMemberNames(true, context);
        return actualAttributes.containsAll(expected.getAttributeNames());
    }

    private static boolean matchCallableParameters(@NotNull List<PyCallableParameter> expectedParameters, @NotNull List<PyCallableParameter> actualParameters, @NotNull MatchContext matchContext) {
        if (expectedParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(87);
        }
        if (actualParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(88);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(89);
        }
        TypeEvalContext context = matchContext.context;
        if (expectedParameters.size() == 1) {
            PyCallableParameter firstExpectedParam = expectedParameters.get(0);
            PyType expectedParamType = firstExpectedParam.getType(context);
            if (expectedParamType instanceof PyParamSpecType) {
                PyParamSpecType expectedParamSpecType = (PyParamSpecType)expectedParamType;
                matchContext.mySubstitutions.paramSpecs.put(expectedParamSpecType, expectedParamSpecType.withParameters(actualParameters, context));
                return true;
            }
            if (expectedParamType instanceof PyConcatenateType) {
                PyConcatenateType expectedConcatenateType = (PyConcatenateType)expectedParamType;
                if (actualParameters.isEmpty()) {
                    return true;
                }
                PyType actualParamType = actualParameters.get(0).getType(context);
                List<PyType> expectedFirstTypes = expectedConcatenateType.getFirstTypes();
                if (actualParamType instanceof PyConcatenateType) {
                    PyConcatenateType actualConcatenateType = (PyConcatenateType)actualParamType;
                    List<PyType> actualFirstType = actualConcatenateType.getFirstTypes();
                    if (!PyTypeChecker.match(expectedFirstTypes, actualFirstType, matchContext)) {
                        return false;
                    }
                } else {
                    int actualParamRightBound = Math.min(expectedFirstTypes.size(), actualParameters.size());
                    List actualFirstParamTypes = ContainerUtil.map(actualParameters.subList(0, actualParamRightBound), it -> it.getType(context));
                    if (!PyTypeChecker.match(expectedFirstTypes, actualFirstParamTypes, matchContext)) {
                        return false;
                    }
                    if (actualParamRightBound < actualParameters.size()) {
                        PyParamSpecType expectedParamSpecType = expectedConcatenateType.getParamSpec();
                        List<PyCallableParameter> restActualParameters = actualParameters.subList(actualParamRightBound, actualParameters.size());
                        PyParamSpecType parametersSubst = expectedParamSpecType.withParameters(restActualParameters, context);
                        matchContext.mySubstitutions.paramSpecs.put(expectedParamSpecType, parametersSubst);
                        return true;
                    }
                }
                return true;
            }
        }
        int startIndex = 0;
        if (!expectedParameters.isEmpty() && !actualParameters.isEmpty()) {
            PyCallableParameter firstExpectedParam = expectedParameters.get(0);
            PyCallableParameter firstActualParam = actualParameters.get(0);
            if (firstExpectedParam.isSelf() && firstActualParam.isSelf()) {
                if (!PyTypeChecker.match(firstExpectedParam.getType(context), firstActualParam.getType(context), matchContext).orElse(true).booleanValue()) {
                    return false;
                }
                startIndex = 1;
            }
        }
        boolean shouldAcceptUnlimitedPositionalArgs = ContainerUtil.exists(expectedParameters, PyCallableParameter::isPositionalContainer);
        boolean canAcceptUnlimitedPositionalArgs = ContainerUtil.exists(actualParameters, PyCallableParameter::isPositionalContainer);
        if (shouldAcceptUnlimitedPositionalArgs && !canAcceptUnlimitedPositionalArgs) {
            return false;
        }
        boolean shouldAcceptArbitraryKeywordArgs = ContainerUtil.exists(expectedParameters, PyCallableParameter::isKeywordContainer);
        boolean canAcceptArbitraryKeywordArgs = ContainerUtil.exists(actualParameters, PyCallableParameter::isKeywordContainer);
        if (shouldAcceptArbitraryKeywordArgs && !canAcceptArbitraryKeywordArgs) {
            return false;
        }
        List expectedElementTypes = ((StreamEx)StreamEx.of(expectedParameters).filter(cp -> !(cp.getParameter() instanceof PySlashParameter) && !(cp.getParameter() instanceof PySingleStarParameter))).map(cp -> {
            PyType argType = cp.getArgumentType(context);
            if (cp.isPositionalContainer() && !(argType instanceof PyVariadicType)) {
                return PyUnpackedTupleTypeImpl.createUnbound(argType);
            }
            return argType;
        }).toList();
        PyTypeParameterMapping mapping = PyTypeParameterMapping.mapWithParameterList(ContainerUtil.subList((List)expectedElementTypes, (int)startIndex), ContainerUtil.subList(actualParameters, (int)startIndex), context);
        if (mapping == null) {
            return false;
        }
        for (Couple<PyType> pair : mapping.getMappedTypes()) {
            Optional<Boolean> matched = matchContext.reverseSubstitutions().reversedSubstitutions ? PyTypeChecker.match((PyType)pair.getSecond(), (PyType)pair.getFirst(), matchContext.reverseSubstitutions()) : PyTypeChecker.match((PyType)pair.getFirst(), (PyType)pair.getSecond(), matchContext.reverseSubstitutions());
            if (matched.orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyCallableType expected, @NotNull PyCallableType actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(90);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(91);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(92);
        }
        if (actual instanceof PyFunctionType && expected instanceof PyClassType && "function".equals(expected.getName()) && expected.equals(PyBuiltinCache.getInstance((PsiElement)actual.getCallable()).getObjectType("function"))) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(93);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected instanceof PyClassLikeType && !PyTypeChecker.isCallableProtocol((PyClassLikeType)expected, context)) {
            Optional<Boolean> optional = "typing.Callable".equals(((PyClassLikeType)expected).getClassQName()) ? Optional.of(actual.isCallable()) : Optional.empty();
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(94);
            }
            return optional;
        }
        if (expected.isCallable() && actual.isCallable()) {
            List<PyCallableParameter> expectedParameters = expected.getParameters(context);
            List<PyCallableParameter> actualParameters = actual.getParameters(context);
            if (expectedParameters != null && actualParameters != null && !PyTypeChecker.matchCallableParameters(expectedParameters, actualParameters, matchContext)) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(95);
                }
                return optional;
            }
            if (!PyTypeChecker.match(expected.getReturnType(context), PyTypeChecker.getActualReturnType(actual, context), matchContext).orElse(true).booleanValue()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(96);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(97);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(98);
        }
        return optional;
    }

    private static boolean match(@NotNull List<PyType> expected, @NotNull List<PyType> actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(99);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(100);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(101);
        }
        int size = Math.min(expected.size(), actual.size());
        for (int i = 0; i < size; ++i) {
            if (PyTypeChecker.match(expected.get(i), actual.get(i), matchContext).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean isCallableProtocol(@NotNull PyClassLikeType expected, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(102);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(103);
        }
        return PyProtocolsKt.isProtocol(expected, context) && expected.getMemberNames(false, context).contains("__call__");
    }

    @Nullable
    private static PyType getActualReturnType(@NotNull PyCallableType actual, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(104);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(105);
        }
        if ((callable = actual.getCallable()) instanceof PyFunction) {
            return PyUtil.getReturnTypeToAnalyzeAsCallType((PyFunction)callable, context);
        }
        return actual.getReturnType(context);
    }

    @Nullable
    private static PyTupleType widenUnionOfTuplesToTupleOfUnions(@NotNull PyUnionType unionType, int elementCount) {
        boolean consistsOfSameSizeTuples;
        if (unionType == null) {
            PyTypeChecker.$$$reportNull$$$0(106);
        }
        if (!(consistsOfSameSizeTuples = ContainerUtil.all(unionType.getMembers(), member -> {
            PyTupleType tupleType;
            return member instanceof PyTupleType && !(tupleType = (PyTupleType)member).isHomogeneous() && elementCount == tupleType.getElementCount();
        }))) {
            return null;
        }
        List newTupleElements = IntStreamEx.range((int)elementCount).mapToObj(index -> (PyType)PyTypeUtil.toStream(unionType).select(PyTupleType.class).map(tupleType -> tupleType.getElementType(index)).collect(PyTypeUtil.toUnion())).toList();
        PyClass tupleClass = ((PyTupleType)ContainerUtil.getFirstItem(unionType.getMembers())).getPyClass();
        return new PyTupleType(tupleClass, newTupleElements, false);
    }

    private static boolean matchGenerics(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(107);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(108);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(109);
        }
        if (actual instanceof PyCollectionType && expected.getPyClass().equals(actual.getPyClass())) {
            return PyTypeChecker.matchGenericClassesParameterWise(expected, (PyCollectionType)actual, context);
        }
        PyCollectionType expectedGenericType = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), context.context);
        if (expectedGenericType != null) {
            GenericSubstitutions actualSubstitutions = PyTypeChecker.collectTypeSubstitutions(actual, context.context);
            PyCollectionType concreteExpected = (PyCollectionType)PyTypeChecker.substitute(expectedGenericType, actualSubstitutions, context.context);
            assert (concreteExpected != null);
            return PyTypeChecker.matchGenericClassesParameterWise(expected, concreteExpected, context);
        }
        return true;
    }

    @NotNull
    private static GenericSubstitutions collectTypeSubstitutions(@NotNull PyClassType classType, @NotNull TypeEvalContext context) {
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(110);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(111);
        }
        GenericSubstitutions result2 = new GenericSubstitutions();
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyCollectionType genericDefinitionType;
            Map<PyType, PyType> substitutionsFromClassDefinition = provider.getGenericSubstitutions(classType.getPyClass(), context);
            for (Map.Entry<PyType, PyType> entry : substitutionsFromClassDefinition.entrySet()) {
                Object object = entry.getKey();
                if (object instanceof PyTypeVarType) {
                    PyTypeVarType typeVarType = (PyTypeVarType)object;
                    result2.typeVars.put(typeVarType, entry.getValue());
                    continue;
                }
                object = entry.getKey();
                if (!(object instanceof PyTypeVarTupleType)) continue;
                PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)object;
                assert (entry.getValue() instanceof PyVariadicType);
                result2.typeVarTuples.put(typeVarTuple, (PyVariadicType)entry.getValue());
            }
            if (!classType.isDefinition() && (genericDefinitionType = PyUtil.as(provider.getGenericType(classType.getPyClass(), context), PyCollectionType.class)) != null) {
                List<PyType> definitionTypeParameters = genericDefinitionType.getElementTypes();
                if (!(classType instanceof PyCollectionType)) {
                    for (PyType typeParameter : definitionTypeParameters) {
                        if (typeParameter instanceof PyTypeVarTupleType) {
                            PyTypeVarTupleType pyTypeVarTupleType = (PyTypeVarTupleType)typeParameter;
                            result2.typeVarTuples.put(pyTypeVarTupleType, null);
                            continue;
                        }
                        if (typeParameter instanceof PyParamSpecType) {
                            PyParamSpecType paramSpecType = (PyParamSpecType)typeParameter;
                            result2.paramSpecs.put(paramSpecType, null);
                            continue;
                        }
                        if (!(typeParameter instanceof PyTypeVarType)) continue;
                        PyTypeVarType typeVarType = (PyTypeVarType)typeParameter;
                        result2.typeVars.put(typeVarType, null);
                    }
                } else {
                    PyCollectionType genericType = (PyCollectionType)classType;
                    PyTypeParameterMapping mapping = PyTypeParameterMapping.mapByShape(definitionTypeParameters, genericType.getElementTypes(), PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY);
                    if (mapping != null) {
                        for (Couple couple : mapping.getMappedTypes()) {
                            PyType typeParameter = (PyType)couple.getFirst();
                            PyType typeArgument = (PyType)couple.getSecond();
                            if (typeParameter instanceof PyTypeVarType) {
                                PyTypeVarType typeVarType = (PyTypeVarType)typeParameter;
                                result2.typeVars.put(typeVarType, typeArgument);
                                continue;
                            }
                            if (typeParameter instanceof PyTypeVarTupleType) {
                                PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)typeParameter;
                                assert (typeArgument instanceof PyVariadicType || typeArgument == null);
                                result2.typeVarTuples.put(typeVarTuple, (PyVariadicType)typeArgument);
                                continue;
                            }
                            if (!(typeParameter instanceof PyParamSpecType)) continue;
                            result2.paramSpecs.put((PyParamSpecType)typeParameter, PyUtil.as(typeArgument, PyParamSpecType.class));
                        }
                    }
                }
            }
            if (result2.typeVars.isEmpty() && result2.typeVarTuples.isEmpty() && result2.paramSpecs.isEmpty()) continue;
            GenericSubstitutions genericSubstitutions = result2;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(112);
            }
            return genericSubstitutions;
        }
        GenericSubstitutions genericSubstitutions = result2;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(113);
        }
        return genericSubstitutions;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyCollectionType findGenericDefinitionType(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypeChecker.$$$reportNull$$$0(114);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(115);
        }
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyType definitionType = provider.getGenericType(pyClass, context);
            if (!(definitionType instanceof PyCollectionType)) continue;
            return (PyCollectionType)definitionType;
        }
        return null;
    }

    private static boolean matchGenericClassesParameterWise(@NotNull PyCollectionType expected, @NotNull PyCollectionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(116);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(118);
        }
        if (expected.equals(actual)) {
            return true;
        }
        if (!expected.getPyClass().equals(actual.getPyClass())) {
            return false;
        }
        List<PyType> expectedElementTypes = expected.getElementTypes();
        List<PyType> actualElementTypes = actual.getElementTypes();
        if (context.reversedSubstitutions) {
            return PyTypeChecker.matchTypeParameters(actualElementTypes, expectedElementTypes, context.resetSubstitutions());
        }
        return PyTypeChecker.matchTypeParameters(expectedElementTypes, actualElementTypes, context);
    }

    private static boolean matchTypeParameters(@NotNull List<PyType> expectedTypeParameters, @NotNull List<PyType> actualTypeParameters, @NotNull MatchContext context) {
        PyTypeParameterMapping mapping;
        if (expectedTypeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(119);
        }
        if (actualTypeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(120);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(121);
        }
        if ((mapping = PyTypeParameterMapping.mapByShape(expectedTypeParameters, actualTypeParameters, PyTypeParameterMapping.Option.USE_DEFAULTS)) == null) {
            return false;
        }
        for (Couple<PyType> pair : mapping.getMappedTypes()) {
            Optional<Boolean> matched = context.reversedSubstitutions ? PyTypeChecker.match((PyType)pair.getSecond(), (PyType)pair.getFirst(), context) : PyTypeChecker.match((PyType)pair.getFirst(), (PyType)pair.getSecond(), context);
            if (matched.orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        if (expected instanceof PyClassType && actual instanceof PyClassType) {
            String superName = ((PyClassType)expected).getPyClass().getName();
            String subName = ((PyClassType)actual).getPyClass().getName();
            boolean subIsBool = "bool".equals(subName);
            boolean subIsInt = "int".equals(subName);
            boolean subIsLong = "long".equals(subName);
            boolean subIsFloat = "float".equals(subName);
            boolean subIsComplex = "complex".equals(subName);
            if (superName == null || subName == null || superName.equals(subName) || "int".equals(superName) && subIsBool || ("long".equals(superName) || "Integral".equals(superName)) && (subIsBool || subIsInt) || ("float".equals(superName) || "Real".equals(superName)) && (subIsBool || subIsInt || subIsLong) || ("complex".equals(superName) || "Complex".equals(superName)) && (subIsBool || subIsInt || subIsLong || subIsFloat) || "Number".equals(superName) && (subIsBool || subIsInt || subIsLong || subIsFloat || subIsComplex)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnknown(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(122);
        }
        return PyTypeChecker.isUnknown(type2, true, context);
    }

    public static boolean isUnknown(@Nullable PyType type2, boolean genericsAreUnknown, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(123);
        }
        if (type2 == null || genericsAreUnknown && type2 instanceof PyTypeParameterType) {
            return true;
        }
        if (type2 instanceof PyFunctionType && (callable = ((PyFunctionType)type2).getCallable()) instanceof PyDecoratable && PyKnownDecoratorUtil.hasChangingReturnTypeDecorator((PyDecoratable)((Object)callable), context)) {
            return true;
        }
        if (type2 instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type2;
            for (PyType t : union.getMembers()) {
                if (!PyTypeChecker.isUnknown(t, genericsAreUnknown, context)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static GenericSubstitutions getSubstitutionsWithUnresolvedReturnGenerics(@NotNull Collection<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        boolean isAlreadyBound;
        boolean canGetBoundFromArguments;
        if (parameters == null) {
            PyTypeChecker.$$$reportNull$$$0(124);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(125);
        }
        GenericSubstitutions existingSubstitutions = substitutions == null ? new GenericSubstitutions() : substitutions;
        Generics typeParamsFromReturnType = PyTypeChecker.collectGenerics(returnType, context);
        if (typeParamsFromReturnType.typeVars.isEmpty() && typeParamsFromReturnType.paramSpecs.isEmpty()) {
            GenericSubstitutions genericSubstitutions = existingSubstitutions;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(126);
            }
            return genericSubstitutions;
        }
        HashSet visited = new HashSet();
        Generics typeParamsFromParameterTypes = new Generics();
        for (PyCallableParameter parameter : parameters) {
            PyTypeChecker.collectGenerics(parameter.getArgumentType(context), context, typeParamsFromParameterTypes, visited);
        }
        for (PyTypeVarType returnTypeParam : typeParamsFromReturnType.typeVars) {
            canGetBoundFromArguments = typeParamsFromParameterTypes.typeVars.contains(returnTypeParam) || typeParamsFromParameterTypes.typeVars.contains(PyTypeChecker.invert(returnTypeParam));
            boolean bl = isAlreadyBound = existingSubstitutions.typeVars.containsKey(returnTypeParam) || existingSubstitutions.typeVars.containsKey(PyTypeChecker.invert(returnTypeParam));
            if (!canGetBoundFromArguments || isAlreadyBound) continue;
            existingSubstitutions.typeVars.put(returnTypeParam, returnTypeParam.getDefaultType());
        }
        for (PyParamSpecType paramSpecType : typeParamsFromReturnType.paramSpecs) {
            if (paramSpecType.getParameters() != null) continue;
            canGetBoundFromArguments = typeParamsFromParameterTypes.paramSpecs.contains(paramSpecType);
            isAlreadyBound = existingSubstitutions.paramSpecs.containsKey(paramSpecType);
            if (!canGetBoundFromArguments || isAlreadyBound) continue;
            if (paramSpecType.getDefaultType() != null) {
                PyType defaultType = paramSpecType.getDefaultType();
                if (!(defaultType instanceof PyParamSpecType)) continue;
                PyParamSpecType defaultParamSpec = (PyParamSpecType)defaultType;
                existingSubstitutions.paramSpecs.put(paramSpecType, defaultParamSpec);
                continue;
            }
            existingSubstitutions.paramSpecs.put(paramSpecType, new PyParamSpecType(paramSpecType.getName()).withParameters(List.of(PyCallableParameterImpl.positionalNonPsi("args", null), PyCallableParameterImpl.keywordNonPsi("kwargs", null)), context));
        }
        GenericSubstitutions genericSubstitutions = existingSubstitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(127);
        }
        return genericSubstitutions;
    }

    @NotNull
    private static <T extends PyInstantiableType<T>> T invert(@NotNull PyInstantiableType<T> instantiable) {
        if (instantiable == null) {
            PyTypeChecker.$$$reportNull$$$0(128);
        }
        T t = instantiable.isDefinition() ? instantiable.toInstance() : instantiable.toClass();
        if (t == null) {
            PyTypeChecker.$$$reportNull$$$0(129);
        }
        return t;
    }

    public static boolean hasGenerics(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(130);
        }
        return !PyTypeChecker.collectGenerics(type2, context).isEmpty();
    }

    @ApiStatus.Internal
    @NotNull
    public static Generics collectGenerics(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(131);
        }
        Generics result2 = new Generics();
        PyTypeChecker.collectGenerics(type2, context, result2, new HashSet());
        Generics generics = result2;
        if (generics == null) {
            PyTypeChecker.$$$reportNull$$$0(132);
        }
        return generics;
    }

    private static void collectGenerics(@Nullable PyType type2, @NotNull TypeEvalContext context, @NotNull Generics generics, @NotNull Set<? super PyType> visited) {
        block17: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block16: {
                                    if (context == null) {
                                        PyTypeChecker.$$$reportNull$$$0(133);
                                    }
                                    if (generics == null) {
                                        PyTypeChecker.$$$reportNull$$$0(134);
                                    }
                                    if (visited == null) {
                                        PyTypeChecker.$$$reportNull$$$0(135);
                                    }
                                    if (type2 instanceof PyTypeParameterType) {
                                        PyTypeParameterType typeParameter = (PyTypeParameterType)type2;
                                        generics.allTypeParameters.add(typeParameter);
                                    }
                                    if (visited.contains(type2)) {
                                        return;
                                    }
                                    visited.add(type2);
                                    if (type2 instanceof PyTypeVarType) {
                                        PyTypeVarType typeVarType = (PyTypeVarType)type2;
                                        generics.typeVars.add(typeVarType);
                                    }
                                    if (type2 instanceof PyTypeVarTupleType) {
                                        PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)type2;
                                        generics.typeVarTuples.add(typeVarTupleType);
                                    }
                                    if (type2 instanceof PyParamSpecType) {
                                        generics.paramSpecs.add((PyParamSpecType)type2);
                                    }
                                    if (type2 instanceof PyConcatenateType) {
                                        generics.concatenates.add((PyConcatenateType)type2);
                                    }
                                    if (!(type2 instanceof PySelfType)) break block16;
                                    generics.self = (PySelfType)type2;
                                    break block17;
                                }
                                if (!(type2 instanceof PyUnionType)) break block18;
                                PyUnionType union = (PyUnionType)type2;
                                for (PyType t : union.getMembers()) {
                                    PyTypeChecker.collectGenerics(t, context, generics, visited);
                                }
                                break block17;
                            }
                            if (!(type2 instanceof PyTupleType)) break block19;
                            PyTupleType tuple = (PyTupleType)type2;
                            int n = tuple.isHomogeneous() ? 1 : tuple.getElementCount();
                            for (int i = 0; i < n; ++i) {
                                PyTypeChecker.collectGenerics(tuple.getElementType(i), context, generics, visited);
                            }
                            break block17;
                        }
                        if (!(type2 instanceof PyCollectionType)) break block20;
                        PyCollectionType collection = (PyCollectionType)type2;
                        for (PyType elementType : collection.getElementTypes()) {
                            PyTypeChecker.collectGenerics(elementType, context, generics, visited);
                        }
                        break block17;
                    }
                    if (!(type2 instanceof PyCallableType)) break block21;
                    PyCallableType callable = (PyCallableType)type2;
                    if (type2 instanceof PyClassLikeType) break block21;
                    List<PyCallableParameter> parameters = callable.getParameters(context);
                    if (parameters != null) {
                        for (PyCallableParameter parameter : parameters) {
                            if (parameter == null) continue;
                            PyTypeChecker.collectGenerics(parameter.getType(context), context, generics, visited);
                        }
                    }
                    PyTypeChecker.collectGenerics(callable.getReturnType(context), context, generics, visited);
                    break block17;
                }
                if (!(type2 instanceof PyConcatenateType)) break block22;
                PyConcatenateType concatenateType = (PyConcatenateType)type2;
                for (PyType elementType : concatenateType.getFirstTypes()) {
                    PyTypeChecker.collectGenerics(elementType, context, generics, visited);
                }
                PyTypeChecker.collectGenerics(concatenateType.getParamSpec(), context, generics, visited);
                break block17;
            }
            if (!(type2 instanceof PyUnpackedTupleType)) break block17;
            PyUnpackedTupleType unpackedTupleType = (PyUnpackedTupleType)type2;
            for (PyType elementType : unpackedTupleType.getElementTypes()) {
                PyTypeChecker.collectGenerics(elementType, context, generics, visited);
            }
        }
    }

    public static @NotNull List<@Nullable PyType> substituteExpand(@Nullable PyType type2, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context, @NotNull Set<PyType> substituting) {
        PyUnpackedTupleType unpackedTupleType;
        PyType substituted;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(136);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(137);
        }
        if (substituting == null) {
            PyTypeChecker.$$$reportNull$$$0(138);
        }
        if ((substituted = PyTypeChecker.substitute(type2, substitutions, context, substituting)) instanceof PyUnpackedTupleType && !(unpackedTupleType = (PyUnpackedTupleType)substituted).isUnbound()) {
            List<PyType> list = unpackedTupleType.getElementTypes();
            if (list == null) {
                PyTypeChecker.$$$reportNull$$$0(139);
            }
            return list;
        }
        List<PyType> list = Collections.singletonList(substituted);
        if (list == null) {
            PyTypeChecker.$$$reportNull$$$0(140);
        }
        return list;
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type2, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(141);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(142);
        }
        return PyTypeChecker.substitute(type2, substitutions, context, new HashSet<PyType>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PyType substitute(@Nullable PyType type2, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context, @NotNull Set<PyType> substituting) {
        boolean alreadySubstituting;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(143);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(144);
        }
        if (substituting == null) {
            PyTypeChecker.$$$reportNull$$$0(145);
        }
        boolean bl = alreadySubstituting = !substituting.add(type2);
        if (alreadySubstituting) {
            return null;
        }
        try {
            if (PyTypeChecker.hasGenerics(type2, context)) {
                PyParamSpecType paramSpecType;
                if (type2 instanceof PyUnpackedTupleType) {
                    PyUnpackedTupleType unpackedTupleType = (PyUnpackedTupleType)type2;
                    PyUnpackedTupleTypeImpl pyUnpackedTupleTypeImpl = new PyUnpackedTupleTypeImpl(ContainerUtil.flatMap(unpackedTupleType.getElementTypes(), t -> PyTypeChecker.substituteExpand(t, substitutions, context, substituting)), unpackedTupleType.isUnbound());
                    return pyUnpackedTupleTypeImpl;
                }
                if (type2 instanceof PyTypeVarTupleType) {
                    PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)type2;
                    if (!substitutions.typeVarTuples.containsKey(typeVarTupleType)) {
                        PyType pyType = type2;
                        return pyType;
                    }
                    PyVariadicType substitution = substitutions.typeVarTuples.get(typeVarTupleType);
                    if (!typeVarTupleType.equals(substitution) && PyTypeChecker.hasGenerics(substitution, context)) {
                        PyType pyType = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                        return pyType;
                    }
                    PyVariadicType pyVariadicType = substitution == null ? PyUnpackedTupleTypeImpl.UNSPECIFIED : substitution;
                    return pyVariadicType;
                }
                if (type2 instanceof PyTypeVarType) {
                    PyType typeVarSubstitution;
                    PyTypeVarType invertedTypeVar;
                    PyInstantiableType invertedSubstitution;
                    PyTypeVarType typeVar = (PyTypeVarType)type2;
                    if (!substitutions.typeVars.containsKey(typeVar) && !substitutions.typeVars.containsKey(PyTypeChecker.invert(typeVar))) {
                        PyTypeVarType substitution = StreamEx.of(substitutions.typeVars.keySet()).findFirst(typeVarType -> typeVarType.getDeclarationElement() != null && (typeVar.getScopeOwner() == null || typeVarType.getScopeOwner() == typeVar.getScopeOwner()) && typeVarType.getDeclarationElement().equals(typeVar.getDeclarationElement())).orElse(null);
                        if (substitution != null) {
                            PyType pyType = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                            return pyType;
                        }
                        PyTypeVarType pyTypeVarType = typeVar;
                        return pyTypeVarType;
                    }
                    PyType substitution = substitutions.typeVars.get(typeVar);
                    if (substitution == null && (invertedSubstitution = PyUtil.as(substitutions.typeVars.get(invertedTypeVar = PyTypeChecker.invert(typeVar)), PyInstantiableType.class)) != null) {
                        substitution = PyTypeChecker.invert(invertedSubstitution);
                    }
                    if (substitution instanceof PyTypeVarType) {
                        typeVarSubstitution = (PyTypeVarType)substitution;
                        PyTypeVarType sameScopeSubstitution = StreamEx.of(substitutions.typeVars.keySet()).findFirst(arg_0 -> PyTypeChecker.lambda$substitute$22((PyTypeVarType)typeVarSubstitution, arg_0)).orElse(null);
                        if (sameScopeSubstitution != null && typeVarSubstitution.getDefaultType() != null) {
                            PyType pyType = PyTypeChecker.substitute(sameScopeSubstitution, substitutions, context, substituting);
                            return pyType;
                        }
                    }
                    if (!typeVar.equals(substitution) && PyTypeChecker.hasGenerics(substitution, context)) {
                        typeVarSubstitution = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                        return typeVarSubstitution;
                    }
                    typeVarSubstitution = substitution;
                    return typeVarSubstitution;
                }
                if (type2 instanceof PyParamSpecType && (paramSpecType = (PyParamSpecType)type2).getParameters() == null) {
                    if (!substitutions.paramSpecs.containsKey(paramSpecType)) {
                        PyParamSpecType sameScopeSubstitution = StreamEx.of(substitutions.paramSpecs.keySet()).findFirst(typeVarType -> typeVarType.getDeclarationElement() != null && typeVarType.getDeclarationElement().equals(paramSpecType.getDeclarationElement())).orElse(null);
                        if (sameScopeSubstitution != null) {
                            PyType typeVarSubstitution = PyTypeChecker.substitute(sameScopeSubstitution, substitutions, context, substituting);
                            return typeVarSubstitution;
                        }
                        PyParamSpecType typeVarSubstitution = paramSpecType;
                        return typeVarSubstitution;
                    }
                    PyParamSpecType substitution = substitutions.paramSpecs.get(paramSpecType);
                    if (substitution != null && !substitution.equals(paramSpecType) && PyTypeChecker.hasGenerics(substitution, context)) {
                        PyType typeVarSubstitution = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                        return typeVarSubstitution;
                    }
                    PyParamSpecType typeVarSubstitution = substitution;
                    return typeVarSubstitution;
                }
                if (type2 instanceof PySelfType) {
                    PyType qualifierType = substitutions.qualifierType;
                    PyClassLikeType selfScopeClassType = ((PySelfType)type2).getScopeClassType();
                    PyType sameScopeSubstitution = (PyType)((StreamEx)PyTypeUtil.toStream(qualifierType).filter(memberType -> PyTypeChecker.match((PyType)selfScopeClassType, memberType, context))).collect(PyTypeUtil.toUnion());
                    return sameScopeSubstitution;
                }
                if (type2 instanceof PyUnionType) {
                    PyType qualifierType = ((PyUnionType)type2).map(member -> PyTypeChecker.substitute(member, substitutions, context, substituting));
                    return qualifierType;
                }
                if (type2 instanceof PyTypedDictType) {
                    PyTypedDictType typedDictType = (PyTypedDictType)type2;
                    Map<String, kotlin.Pair<PyExpression, PyType>> tdFields = typedDictType.getKeysToValuesWithTypes();
                    Map substitutedTDFields = ContainerUtil.map2Map(tdFields.entrySet(), field -> Pair.create((Object)((String)field.getKey()), (Object)new kotlin.Pair((Object)((PyExpression)((kotlin.Pair)field.getValue()).getFirst()), (Object)PyTypeChecker.substitute((PyType)((kotlin.Pair)field.getValue()).getSecond(), substitutions, context, substituting))));
                    PyTypedDictType sameScopeSubstitution = PyTypedDictType.Companion.createFromKeysToValueTypes(typedDictType.myClass, substitutedTDFields, false);
                    return sameScopeSubstitution;
                }
                if (type2 instanceof PyNarrowedType) {
                    PyNarrowedType pyNarrowedType = (PyNarrowedType)type2;
                    PyNarrowedType tdFields = pyNarrowedType.substitute(ContainerUtil.flatMap(pyNarrowedType.getElementTypes(), t -> PyTypeChecker.substituteExpand(t, substitutions, context, substituting)));
                    return tdFields;
                }
                if (type2 instanceof PyCollectionTypeImpl) {
                    PyCollectionTypeImpl collection = (PyCollectionTypeImpl)type2;
                    PyCollectionTypeImpl tdFields = new PyCollectionTypeImpl(collection.getPyClass(), collection.isDefinition(), ContainerUtil.flatMap(collection.getElementTypes(), t -> PyTypeChecker.substituteExpand(t, substitutions, context, substituting)));
                    return tdFields;
                }
                if (type2 instanceof PyTupleType) {
                    PyTupleType tupleType = (PyTupleType)type2;
                    PyClass tupleClass = tupleType.getPyClass();
                    List<PyType> oldElementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                    ArrayList newElementTypes = new ArrayList(ContainerUtil.flatMap(oldElementTypes, elementType -> PyTypeChecker.substituteExpand(elementType, substitutions, context, substituting)));
                    PyTupleType pyTupleType = new PyTupleType(tupleClass, newElementTypes, tupleType.isHomogeneous());
                    return pyTupleType;
                }
                if (type2 instanceof PyCallableType) {
                    PyCallableType callable = (PyCallableType)type2;
                    if (!(type2 instanceof PyClassLikeType)) {
                        List<PyCallableParameter> substParams;
                        List<PyCallableParameter> parameters = callable.getParameters(context);
                        if (parameters != null) {
                            PyType substitution;
                            PyType pyType;
                            PyCallableParameter onlyParam = (PyCallableParameter)ContainerUtil.getOnlyItem(parameters);
                            if (onlyParam != null && (pyType = onlyParam.getType(context)) instanceof PyParamSpecType) {
                                PyParamSpecType paramSpecSubst;
                                PyParamSpecType paramSpecType2 = (PyParamSpecType)pyType;
                                substitution = PyTypeChecker.substitute(paramSpecType2, substitutions, context);
                                substParams = substitution instanceof PyParamSpecType && (paramSpecSubst = (PyParamSpecType)substitution).getParameters() != null ? paramSpecSubst.getParameters() : List.of(PyCallableParameterImpl.nonPsi(substitution));
                            } else if (onlyParam != null && (substitution = onlyParam.getType(context)) instanceof PyConcatenateType) {
                                PyConcatenateType concatenateType = (PyConcatenateType)substitution;
                                PyParamSpecType paramSpecSubst = PyUtil.as(PyTypeChecker.substitute(concatenateType.getParamSpec(), substitutions, context), PyParamSpecType.class);
                                List<PyCallableParameter> paramSpecParams = paramSpecSubst != null ? paramSpecSubst.getParameters() : null;
                                substParams = StreamEx.of(concatenateType.getFirstTypes()).flatCollection(paramType -> PyTypeChecker.substituteExpand(paramType, substitutions, context, substituting)).map(PyCallableParameterImpl::nonPsi).append(paramSpecParams != null ? paramSpecParams : Collections.singletonList(PyCallableParameterImpl.nonPsi(paramSpecSubst))).toList();
                            } else {
                                substParams = StreamEx.of(parameters).mapToEntry(param -> param.getType(context)).flatMapKeyValue((param, paramType) -> {
                                    PyParameter paramPsi = param.getParameter();
                                    return StreamEx.of(PyTypeChecker.substituteExpand(param.getType(context), substitutions, context, substituting)).map(paramSubType -> paramPsi != null ? PyCallableParameterImpl.psi(paramPsi, paramSubType) : PyCallableParameterImpl.nonPsi(param.getName(), paramSubType, param.getDefaultValue()));
                                }).toList();
                            }
                        } else {
                            substParams = null;
                        }
                        PyType substResult = PyTypeChecker.substitute(callable.getReturnType(context), substitutions, context, substituting);
                        PyCallableTypeImpl pyCallableTypeImpl = new PyCallableTypeImpl(substParams, substResult);
                        return pyCallableTypeImpl;
                    }
                }
            }
        }
        finally {
            substituting.remove(type2);
        }
        return type2;
    }

    @Nullable
    public static GenericSubstitutions unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(146);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(147);
        }
        GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiver, context);
        for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType promotedToLiteral;
            PyType actualType;
            PyType expectedType;
            PyCallableParameter paramWrapper = entry.getValue();
            boolean matchedByTypes = PyTypeChecker.matchParameterArgumentTypes(paramWrapper, expectedType = paramWrapper.getArgumentType(context), actualType = (promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(entry.getKey(), expectedType, context, substitutions)) != null ? promotedToLiteral : context.getType(entry.getKey()), substitutions, context);
            if (matchedByTypes) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedPositionalContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedKeywordContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    @Nullable
    public static GenericSubstitutions unifyGenericCallOnArgumentTypes(@Nullable PyType receiverType, @NotNull Map<Ref<PyType>, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(148);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(149);
        }
        GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiverType, context);
        for (Map.Entry<Ref<PyType>, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType actualType;
            PyType expectedType;
            PyCallableParameter paramWrapper = entry.getValue();
            boolean matchedByTypes = PyTypeChecker.matchParameterArgumentTypes(paramWrapper, expectedType = paramWrapper.getArgumentType(context), actualType = (PyType)Ref.deref(entry.getKey()), substitutions, context);
            if (matchedByTypes) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainerByType(PyCallExpressionHelper.getMappedPositionalContainer(arguments), ContainerUtil.map(PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), Ref::deref), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainerByType(PyCallExpressionHelper.getMappedKeywordContainer(arguments), ContainerUtil.map(PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), Ref::deref), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    @Nullable
    private static PyType processSelfParameter(@NotNull PyCallableParameter paramWrapper, @Nullable PyType expectedType, @Nullable PyType actualType, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (paramWrapper == null) {
            PyTypeChecker.$$$reportNull$$$0(150);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(151);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(152);
        }
        PyParameter param = paramWrapper.getParameter();
        PyFunction function = PyUtil.as(ScopeUtil.getScopeOwner((PsiElement)param), PyFunction.class);
        assert (function != null);
        if (function.getModifier() == PyAstFunction.Modifier.CLASSMETHOD) {
            actualType = PyTypeUtil.toStream(actualType).select(PyClassLikeType.class).map(PyInstantiableType::toClass).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
        } else if (PyUtil.isInitMethod(function)) {
            actualType = PyTypeUtil.toStream(actualType).select(PyInstantiableType.class).map(PyInstantiableType::toInstance).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
        }
        PyClass containingClass = function.getContainingClass();
        assert (containingClass != null);
        PyCollectionType genericClass = PyTypeChecker.findGenericDefinitionType(containingClass, context);
        if (genericClass instanceof PyInstantiableType) {
            PyInstantiableType instantiableType = genericClass;
            if (PyUtil.isNewMethod(function) || function.getModifier() == PyAstFunction.Modifier.CLASSMETHOD) {
                genericClass = instantiableType.toClass();
            }
        }
        if (genericClass != null && !PyTypeChecker.match((PyType)genericClass, expectedType, context, substitutions)) {
            return null;
        }
        return actualType;
    }

    private static boolean matchParameterArgumentTypes(@NotNull PyCallableParameter paramWrapper, @Nullable PyType expectedType, @Nullable PyType actualType, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (paramWrapper == null) {
            PyTypeChecker.$$$reportNull$$$0(153);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(154);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(155);
        }
        if (paramWrapper.isSelf() && (actualType = PyTypeChecker.processSelfParameter(paramWrapper, expectedType, actualType, substitutions, context)) == null) {
            return false;
        }
        return PyTypeChecker.match(expectedType, actualType, context, substitutions);
    }

    private static boolean matchContainer(@Nullable PyCallableParameter container, @NotNull List<? extends PyExpression> arguments, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(156);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(157);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(158);
        }
        if (container == null) {
            return true;
        }
        List actualArgumentTypes = ContainerUtil.map(arguments, context::getType);
        return PyTypeChecker.matchContainerByType(container, actualArgumentTypes, substitutions, context);
    }

    private static boolean matchContainerByType(@Nullable PyCallableParameter container, @NotNull List<PyType> actualArgumentTypes, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (actualArgumentTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(159);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(160);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(161);
        }
        if (container == null) {
            return true;
        }
        PyType expectedArgumentType = container.getArgumentType(context);
        if (container.isPositionalContainer() && expectedArgumentType instanceof PyVariadicType) {
            PyVariadicType variadicType = (PyVariadicType)expectedArgumentType;
            return PyTypeChecker.match(variadicType, (PyType)PyUnpackedTupleTypeImpl.create(actualArgumentTypes), new MatchContext(context, substitutions, false));
        }
        return PyTypeChecker.match(expectedArgumentType, PyUnionType.union(actualArgumentTypes), context, substitutions);
    }

    @NotNull
    public static GenericSubstitutions unifyReceiver(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(162);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions();
        if (receiver != null) {
            PyType receiverType = context.getType(receiver);
            return PyTypeChecker.unifyReceiver(receiverType, context);
        }
        GenericSubstitutions genericSubstitutions = substitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(163);
        }
        return genericSubstitutions;
    }

    @NotNull
    public static GenericSubstitutions unifyReceiver(@Nullable PyType receiverType, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(164);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions();
        if (receiverType != null) {
            substitutions.qualifierType = receiverType instanceof PyClassType ? ((PyClassType)receiverType).toInstance() : receiverType;
            PyTypeUtil.toStream(receiverType).select(PyClassType.class).map(type2 -> PyTypeChecker.collectTypeSubstitutions(type2, context)).forEach(newSubstitutions -> {
                for (Map.Entry<PyTypeVarType, PyType> entry : newSubstitutions.typeVars.entrySet()) {
                    substitutions.typeVars.putIfAbsent(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<PyTypeParameterType, PyType> entry : newSubstitutions.typeVarTuples.entrySet()) {
                    substitutions.typeVarTuples.putIfAbsent((PyTypeVarTupleType)entry.getKey(), (PyVariadicType)entry.getValue());
                }
                for (Map.Entry<PyTypeParameterType, PyType> entry : newSubstitutions.paramSpecs.entrySet()) {
                    substitutions.paramSpecs.putIfAbsent((PyParamSpecType)entry.getKey(), (PyParamSpecType)entry.getValue());
                }
            });
        }
        GenericSubstitutions genericSubstitutions = substitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(165);
        }
        return genericSubstitutions;
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(166);
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass, context) || PyABCUtil.isSubclass(subClass, superClass, context) || PyTypeChecker.isStrUnicodeMatch(subClass, superClass) || PyTypeChecker.isBytearrayBytesStringMatch(subClass, superClass) || PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    private static boolean isStrUnicodeMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(167);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(168);
        }
        return "str".equals(subClass.getName()) && "unicode".equals(superClass.getName());
    }

    private static boolean isBytearrayBytesStringMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(169);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(170);
        }
        if (!"bytearray".equals(subClass.getName())) {
            return false;
        }
        PsiFile subClassFile = subClass.getContainingFile();
        boolean isPy2 = subClassFile instanceof PyiFile ? PythonRuntimeService.getInstance().getLanguageLevelForSdk(PythonSdkUtil.findPythonSdk((PsiElement)subClassFile)).isPython2() : LanguageLevel.forElement((PsiElement)subClass).isPython2();
        String superClassName = superClass.getName();
        return isPy2 && "str".equals(superClassName) || !isPy2 && "bytes".equals(superClassName);
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof PyUnionType) {
            return PyTypeChecker.isUnionCallable((PyUnionType)type2);
        }
        if (type2 instanceof PyCallableType) {
            return ((PyCallableType)type2).isCallable();
        }
        if (type2 instanceof PyStructuralType && ((PyStructuralType)type2).isInferredFromUsages()) {
            return true;
        }
        if (type2 instanceof PyTypeVarType) {
            PyTypeVarType typeVarType = (PyTypeVarType)type2;
            if (typeVarType.isDefinition()) {
                return true;
            }
            return PyTypeChecker.isCallable(typeVarType.getBound());
        }
        return false;
    }

    @Nullable
    private static Boolean isUnionCallable(@NotNull PyUnionType type2) {
        if (type2 == null) {
            PyTypeChecker.$$$reportNull$$$0(171);
        }
        for (PyType member : type2.getMembers()) {
            Boolean callable = PyTypeChecker.isCallable(member);
            if (callable == null) {
                return null;
            }
            if (!callable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean definesGetAttr(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        PyType type2;
        if (file == null) {
            PyTypeChecker.$$$reportNull$$$0(172);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(173);
        }
        if (file instanceof PyTypedElement && (type2 = context.getType((PyTypedElement)((Object)file))) != null) {
            return PyTypeChecker.resolveTypeMember(type2, "__getattr__", context) != null;
        }
        return false;
    }

    public static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyType type2;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(174);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(175);
        }
        if ((type2 = context.getType(cls)) != null) {
            if (PyTypeChecker.resolveTypeMember(type2, "__getattr__", context) != null) {
                return true;
            }
            PsiElement method = PyTypeChecker.resolveTypeMember(type2, "__getattribute__", context);
            if (method != null && !PyBuiltinCache.getInstance(cls).isBuiltin(method)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type2 == null) {
            PyTypeChecker.$$$reportNull$$$0(176);
        }
        if (name2 == null) {
            PyTypeChecker.$$$reportNull$$$0(177);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(178);
        }
        return !ContainerUtil.isEmpty(results = type2.resolveMember(name2, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) ? results.get(0).getElement() : null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyExpression target, @NotNull PySequenceExpression parentTupleOrList, @NotNull PyTupleType assignedTupleType) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(179);
        }
        if (parentTupleOrList == null) {
            PyTypeChecker.$$$reportNull$$$0(180);
        }
        if (assignedTupleType == null) {
            PyTypeChecker.$$$reportNull$$$0(181);
        }
        int count = assignedTupleType.getElementCount();
        Object[] elements = parentTupleOrList.getElements();
        if (elements.length == count || assignedTupleType.isHomogeneous()) {
            int index = ArrayUtil.indexOf((Object[])elements, (Object)target);
            if (index >= 0) {
                return assignedTupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyTupleType nestedAssignedTupleType;
                PyType result2;
                PyType elementType;
                PyExpression element = PyPsiUtils.flattenParens((PyExpression)elements[i]);
                if (!(element instanceof PyTupleExpression) && !(element instanceof PyListLiteralExpression) || !((elementType = assignedTupleType.getElementType(i)) instanceof PyTupleType) || (result2 = PyTypeChecker.getTargetTypeFromTupleAssignment(target, (PySequenceExpression)element, nestedAssignedTupleType = (PyTupleType)elementType)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType parameterizeType(@NotNull PyType genericType, @NotNull List<PyType> actualTypeParams, @NotNull TypeEvalContext context) {
        Generics typeParams;
        if (genericType == null) {
            PyTypeChecker.$$$reportNull$$$0(182);
        }
        if (actualTypeParams == null) {
            PyTypeChecker.$$$reportNull$$$0(183);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(184);
        }
        if (!(typeParams = PyTypeChecker.collectGenerics(genericType, context)).isEmpty()) {
            ArrayList<PyTypeParameterType> expectedTypeParams = new ArrayList<PyTypeParameterType>(new LinkedHashSet<PyTypeParameterType>(typeParams.getAllTypeParameters()));
            GenericSubstitutions substitutions = PyTypeChecker.mapTypeParametersToSubstitutions(new GenericSubstitutions(), expectedTypeParams, actualTypeParams, PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY, PyTypeParameterMapping.Option.USE_DEFAULTS);
            if (substitutions == null) {
                return null;
            }
            return PyTypeChecker.substitute(genericType, substitutions, context);
        }
        if (genericType instanceof PyCollectionType) {
            return genericType;
        }
        if (genericType instanceof PyClassType) {
            PyClass cls = ((PyClassType)genericType).getPyClass();
            return new PyCollectionTypeImpl(cls, false, actualTypeParams);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static GenericSubstitutions mapTypeParametersToSubstitutions(@NotNull GenericSubstitutions substitutions, @NotNull List<? extends PyType> expectedTypes, @NotNull List<? extends PyType> actualTypes, PyTypeParameterMapping.Option ... options) {
        PyTypeParameterMapping mapping;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(185);
        }
        if (expectedTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(186);
        }
        if (actualTypes == null) {
            PyTypeChecker.$$$reportNull$$$0(187);
        }
        if (options == null) {
            PyTypeChecker.$$$reportNull$$$0(188);
        }
        if ((mapping = PyTypeParameterMapping.mapByShape(expectedTypes, actualTypes, options)) != null) {
            return PyTypeChecker.fillSubstitutionsWithTypeParameters(substitutions, mapping.getMappedTypes());
        }
        return null;
    }

    @NotNull
    @ApiStatus.Internal
    public static GenericSubstitutions fillSubstitutionsWithTypeParameters(@NotNull GenericSubstitutions substitutions, @NotNull List<Couple<PyType>> typeParameters) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(189);
        }
        if (typeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(190);
        }
        for (Couple<PyType> pair : typeParameters) {
            Object object = pair.getFirst();
            if (object instanceof PyTypeVarType) {
                PyTypeVarType typeVar = (PyTypeVarType)object;
                substitutions.typeVars.put(typeVar, (PyType)pair.getSecond());
                continue;
            }
            object = pair.getFirst();
            if (object instanceof PyTypeVarTupleType) {
                PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)object;
                substitutions.typeVarTuples.put(typeVarTuple, PyUtil.as(pair.getSecond(), PyVariadicType.class));
                continue;
            }
            object = pair.getFirst();
            if (!(object instanceof PyParamSpecType)) continue;
            PyParamSpecType paramSpec = (PyParamSpecType)object;
            substitutions.paramSpecs.put(paramSpec, PyUtil.as(pair.getSecond(), PyParamSpecType.class));
        }
        GenericSubstitutions genericSubstitutions = substitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(191);
        }
        return genericSubstitutions;
    }

    private static /* synthetic */ boolean lambda$substitute$22(PyTypeVarType typeVarSubstitution, PyTypeVarType typeVarType) {
        return typeVarType.getDeclarationElement() != null && typeVarType.getDeclarationElement().equals(typeVarSubstitution.getDeclarationElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 43, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 69, 70, 71, 72, 93, 94, 95, 96, 97, 98, 112, 113, 126, 127, 129, 132, 139, 140, 163, 165, 191 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVars";
                break;
            }
            case 4: 
            case 136: 
            case 141: 
            case 143: 
            case 151: 
            case 154: 
            case 157: 
            case 160: 
            case 185: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 126: 
            case 127: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 165: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 47: 
            case 61: 
            case 66: 
            case 73: 
            case 76: 
            case 79: 
            case 82: 
            case 84: 
            case 90: 
            case 99: 
            case 102: 
            case 107: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 38: 
            case 41: 
            case 45: 
            case 48: 
            case 62: 
            case 67: 
            case 74: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 91: 
            case 100: 
            case 104: 
            case 108: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 49: 
            case 63: 
            case 89: 
            case 92: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 64: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParameters";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeParameters";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParameters";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiable";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 138: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituting";
                break;
            }
            case 146: 
            case 148: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 150: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramWrapper";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArgumentTypes";
                break;
            }
            case 167: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 168: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 171: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTupleOrList";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTupleType";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParams";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypes";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 6: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "matchImpl";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "matchObject";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeSubstitutions";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGenerics";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteExpand";
                break;
            }
            case 163: 
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyReceiver";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "fillSubstitutionsWithTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 126: 
            case 127: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 163: 
            case 165: 
            case 191: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "matchObject";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "matchProtocols";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "dropSelfIfNeeded";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "matchCallableParameters";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isCallableProtocol";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getActualReturnType";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "widenUnionOfTuplesToTupleOfUnions";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "matchGenerics";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeSubstitutions";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "findGenericDefinitionType";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericClassesParameterWise";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeParameters";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "hasGenerics";
                break;
            }
            case 131: 
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "collectGenerics";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "substituteExpand";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCall";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCallOnArgumentTypes";
                break;
            }
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "processSelfParameter";
                break;
            }
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "matchParameterArgumentTypes";
                break;
            }
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "matchContainer";
                break;
            }
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "matchContainerByType";
                break;
            }
            case 162: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "unifyReceiver";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "matchClasses";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "isStrUnicodeMatch";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "isBytearrayBytesStringMatch";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "isUnionCallable";
                break;
            }
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "definesGetAttr";
                break;
            }
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "overridesGetAttr";
                break;
            }
            case 176: 
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeMember";
                break;
            }
            case 179: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromTupleAssignment";
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "parameterizeType";
                break;
            }
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "mapTypeParametersToSubstitutions";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "fillSubstitutionsWithTypeParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 43, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 69, 70, 71, 72, 93, 94, 95, 96, 97, 98, 112, 113, 126, 127, 129, 132, 139, 140, 163, 165, 191 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Experimental
    public static class GenericSubstitutions {
        @NotNull
        private final Map<PyTypeVarType, PyType> typeVars;
        @NotNull
        private final Map<PyTypeVarTupleType, PyVariadicType> typeVarTuples;
        @NotNull
        private final Map<PyParamSpecType, PyParamSpecType> paramSpecs;
        @Nullable
        private PyType qualifierType;

        public GenericSubstitutions(@NotNull Map<? extends PyTypeParameterType, PyType> typeParameters) {
            if (typeParameters == null) {
                GenericSubstitutions.$$$reportNull$$$0(0);
            }
            this(EntryStream.of(typeParameters).selectKeys(PyTypeVarType.class).toCustomMap(LinkedHashMap::new), EntryStream.of(typeParameters).selectKeys(PyTypeVarTupleType.class).selectValues(PyVariadicType.class).toCustomMap(LinkedHashMap::new), EntryStream.of(typeParameters).selectKeys(PyParamSpecType.class).selectValues(PyParamSpecType.class).toCustomMap(LinkedHashMap::new), null);
        }

        public GenericSubstitutions() {
            this(new LinkedHashMap<PyTypeVarType, PyType>(), new LinkedHashMap<PyTypeVarTupleType, PyVariadicType>(), new LinkedHashMap<PyParamSpecType, PyParamSpecType>(), null);
        }

        private GenericSubstitutions(@NotNull Map<PyTypeVarType, PyType> typeVars, @NotNull Map<PyTypeVarTupleType, PyVariadicType> typeVarTuples, @NotNull Map<PyParamSpecType, PyParamSpecType> paramSpecs, @Nullable PyType qualifierType) {
            if (typeVars == null) {
                GenericSubstitutions.$$$reportNull$$$0(1);
            }
            if (typeVarTuples == null) {
                GenericSubstitutions.$$$reportNull$$$0(2);
            }
            if (paramSpecs == null) {
                GenericSubstitutions.$$$reportNull$$$0(3);
            }
            this.typeVars = typeVars;
            this.typeVarTuples = typeVarTuples;
            this.paramSpecs = paramSpecs;
            this.qualifierType = qualifierType;
        }

        @NotNull
        public Map<PyParamSpecType, PyParamSpecType> getParamSpecs() {
            Map<PyParamSpecType, PyParamSpecType> map2 = Collections.unmodifiableMap(this.paramSpecs);
            if (map2 == null) {
                GenericSubstitutions.$$$reportNull$$$0(4);
            }
            return map2;
        }

        @NotNull
        public Map<PyTypeVarType, PyType> getTypeVars() {
            Map<PyTypeVarType, PyType> map2 = Collections.unmodifiableMap(this.typeVars);
            if (map2 == null) {
                GenericSubstitutions.$$$reportNull$$$0(5);
            }
            return map2;
        }

        @NotNull
        public Map<PyTypeVarTupleType, PyVariadicType> getTypeVarTuples() {
            Map<PyTypeVarTupleType, PyVariadicType> map2 = Collections.unmodifiableMap(this.typeVarTuples);
            if (map2 == null) {
                GenericSubstitutions.$$$reportNull$$$0(6);
            }
            return map2;
        }

        @Nullable
        public PyType getQualifierType() {
            return this.qualifierType;
        }

        public String toString() {
            return "GenericSubstitutions{typeVars=" + this.typeVars + ", typeVarTuples" + this.typeVarTuples + ", paramSpecs=" + this.paramSpecs + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVarTuples";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpecs";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVarTuples";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class MatchContext {
        @NotNull
        private final TypeEvalContext context;
        @NotNull
        private final GenericSubstitutions mySubstitutions;
        private final boolean reversedSubstitutions;

        MatchContext(@NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions, boolean reversedSubstitutions) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(0);
            }
            if (substitutions == null) {
                MatchContext.$$$reportNull$$$0(1);
            }
            this.context = context;
            this.mySubstitutions = substitutions;
            this.reversedSubstitutions = reversedSubstitutions;
        }

        @NotNull
        public MatchContext reverseSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, !this.reversedSubstitutions);
        }

        @NotNull
        public MatchContext resetSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/types/PyTypeChecker$MatchContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class Generics {
        @NotNull
        private final Set<PyTypeVarType> typeVars = new LinkedHashSet<PyTypeVarType>();
        @NotNull
        private final Set<PyTypeVarTupleType> typeVarTuples = new LinkedHashSet<PyTypeVarTupleType>();
        @NotNull
        private final List<PyTypeParameterType> allTypeParameters = new ArrayList<PyTypeParameterType>();
        @NotNull
        private final Set<PyParamSpecType> paramSpecs = new LinkedHashSet<PyParamSpecType>();
        @NotNull
        private final Set<PyConcatenateType> concatenates = new LinkedHashSet<PyConcatenateType>();
        @Nullable
        private PySelfType self;

        @NotNull
        public Set<PyTypeVarType> getTypeVars() {
            Set<PyTypeVarType> set = Collections.unmodifiableSet(this.typeVars);
            if (set == null) {
                Generics.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public Set<PyTypeVarTupleType> getTypeVarTuples() {
            Set<PyTypeVarTupleType> set = Collections.unmodifiableSet(this.typeVarTuples);
            if (set == null) {
                Generics.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public List<PyTypeParameterType> getAllTypeParameters() {
            List<PyTypeParameterType> list = Collections.unmodifiableList(this.allTypeParameters);
            if (list == null) {
                Generics.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public Set<PyParamSpecType> getParamSpecs() {
            Set<PyParamSpecType> set = Collections.unmodifiableSet(this.paramSpecs);
            if (set == null) {
                Generics.$$$reportNull$$$0(3);
            }
            return set;
        }

        public boolean isEmpty() {
            return this.typeVars.isEmpty() && this.typeVarTuples.isEmpty() && this.paramSpecs.isEmpty() && this.concatenates.isEmpty() && this.self == null;
        }

        public String toString() {
            return "Generics{typeVars=" + this.typeVars + ", typeVarTuples" + this.typeVarTuples + ", paramSpecs=" + this.paramSpecs + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/psi/types/PyTypeChecker$Generics";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVarTuples";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllTypeParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

