/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerImplBase;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.VirtualEnvReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTargetEnvironmentPackageManager
extends PyPackageManagerImplBase {
    private static final Logger LOG = Logger.getInstance(PyTargetEnvironmentPackageManager.class);

    @Override
    protected void installUsingPipWheel(String ... pipArgs) throws ExecutionException {
        if (pipArgs == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(0);
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = this.getPythonTargetInterpreter();
        PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PyTargetEnvironmentPackageManager.getPipHelperPackage(), helpersAwareTargetRequest);
        pythonExecution.addParameter("install");
        pythonExecution.addParameters(pipArgs);
        this.getPythonProcessResult(pythonExecution, true, true, helpersAwareTargetRequest.getTargetEnvironmentRequest());
    }

    PyTargetEnvironmentPackageManager(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(1);
        }
        super(sdk2);
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(2);
        }
        this.install(Collections.singletonList(this.parseRequirement(requirementString)), Collections.emptyList());
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        if (extraArgs == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(3);
        }
        this.install(requirements, extraArgs, null);
    }

    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs, @Nullable String workingDir) throws ExecutionException {
        if (extraArgs == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(4);
        }
        if (requirements == null) {
            return;
        }
        if (!this.hasManagement()) {
            this.installManagement();
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = this.getPythonTargetInterpreter();
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PythonHelper.PACKAGING_TOOL, helpersAwareTargetRequest);
        PyTargetEnvironmentPackageManager.applyWorkingDir(pythonExecution, workingDir);
        pythonExecution.addParameter("install");
        boolean useUserSite = extraArgs.contains("--user");
        String proxyString = PyTargetEnvironmentPackageManager.getProxyString();
        if (proxyString != null) {
            pythonExecution.addParameter("--proxy");
            pythonExecution.addParameter(proxyString);
        }
        pythonExecution.addParameters(extraArgs);
        for (PyRequirement req : requirements) {
            pythonExecution.addParameters(req.getInstallOptions());
        }
        try {
            this.getPythonProcessResult(pythonExecution, !useUserSite, true, targetEnvironmentRequest);
        }
        catch (PyExecutionException e) {
            ArrayList<String> simplifiedArgs = new ArrayList<String>();
            simplifiedArgs.add("install");
            if (proxyString != null) {
                simplifiedArgs.add("--proxy");
                simplifiedArgs.add(proxyString);
            }
            simplifiedArgs.addAll(extraArgs);
            for (PyRequirement req : requirements) {
                simplifiedArgs.addAll(req.getInstallOptions());
            }
            throw new PyExecutionException(e.getMessage(), "pip", PyTargetEnvironmentPackageManager.makeSafeToDisplayCommand(simplifiedArgs), e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these requirements were installed: " + requirements);
            this.refreshPackagesSynchronously();
        }
    }

    private static void applyWorkingDir(@NotNull PythonScriptExecution execution, @Nullable String workingDir) {
        if (execution == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(5);
        }
        if (workingDir != null) {
            execution.setWorkingDir(TargetEnvironmentFunctions.constant((Object)workingDir));
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages2) throws ExecutionException {
        if (packages2 == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(6);
        }
        ArrayList<String> args = new ArrayList<String>();
        HelpersAwareTargetEnvironmentRequest helpersAwareRequest = this.getPythonTargetInterpreter();
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareRequest.getTargetEnvironmentRequest();
        PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PythonHelper.PACKAGING_TOOL, helpersAwareRequest);
        try {
            pythonExecution.addParameter("uninstall");
            args.add("uninstall");
            boolean canModify = true;
            for (PyPackage pkg : packages2) {
                String location;
                if (canModify && (location = pkg.getLocation()) != null) {
                    canModify = Files.isWritable(Paths.get(location, new String[0]));
                }
                pythonExecution.addParameter(pkg.getName());
                args.add(pkg.getName());
            }
            this.getPythonProcessResult(pythonExecution, !canModify, true, targetEnvironmentRequest);
        }
        catch (PyExecutionException e) {
            throw new PyExecutionException(e.getMessage(), "pip", args, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these packages were uninstalled: " + packages2);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List packages2 = this.myPackagesCache;
        return packages2 != null ? Collections.unmodifiableList(packages2) : null;
    }

    @Override
    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        String output2;
        if (this.getSdk() instanceof PyLazySdk) {
            List<PyPackage> list = List.of();
            if (list == null) {
                PyTargetEnvironmentPackageManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareRequest = this.getPythonTargetInterpreter();
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareRequest.getTargetEnvironmentRequest();
        try {
            LOG.debug("Collecting installed packages for the SDK " + this.getSdk().getName(), new Throwable());
            PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PythonHelper.PACKAGING_TOOL, helpersAwareRequest);
            pythonExecution.addParameter("list");
            output2 = this.getPythonProcessResult(pythonExecution, false, false, targetEnvironmentRequest);
        }
        catch (ProcessNotCreatedException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Not-env unit test mode, will return mock packages");
                List<PyPackage> list = List.of(new PyPackage("pip", "24.3.1"), new PyPackage("setuptools", "44.1.1"));
                if (list == null) {
                    PyTargetEnvironmentPackageManager.$$$reportNull$$$0(8);
                }
                return list;
            }
            throw ex;
        }
        List<PyPackage> list = this.parsePackagingToolOutput(output2);
        if (list == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        Sdk sdk2;
        LanguageLevel languageLevel;
        if (destinationDir == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(10);
        }
        if ((languageLevel = PyTargetEnvironmentPackageManager.getOrRequestLanguageLevelForSdk(sdk2 = this.getSdk())).isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.packaging.creating.virtual.environment.for.python.not.supported", languageLevel, LanguageLevel.PYTHON27));
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = this.getPythonTargetInterpreter();
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PyTargetEnvironmentPackageManager.isLegacyPython(languageLevel) != false ? PythonHelper.LEGACY_VIRTUALENV_ZIPAPP : PythonHelper.VIRTUALENV_ZIPAPP, helpersAwareTargetRequest);
        if (useGlobalSite) {
            pythonExecution.addParameter("--system-site-packages");
        }
        pythonExecution.addParameter(destinationDir);
        this.getPythonProcessResult(pythonExecution, false, true, targetEnvironmentRequest);
        Path binary = VirtualEnvReader.getInstance().findPythonInPythonRoot(Path.of(destinationDir, new String[0]));
        char separator = targetEnvironmentRequest.getTargetPlatform().getPlatform().fileSeparator;
        String binaryFallback = destinationDir + separator + "bin" + separator + "python";
        Object object = binary != null ? binary.toString() : binaryFallback;
        if (object == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    private static Boolean isLegacyPython(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(12);
        }
        Boolean bl = languageLevel.isPython2() || languageLevel.isOlderThan(LanguageLevel.PYTHON37);
        if (bl == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(13);
        }
        return bl;
    }

    @NotNull
    private String getPythonProcessResult(@NotNull PythonExecution pythonExecution, boolean askForSudo, boolean showProgress, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) throws ExecutionException {
        if (pythonExecution == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(14);
        }
        if (targetEnvironmentRequest == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(15);
        }
        ProcessOutputWithCommandLine result2 = this.getPythonProcessOutput(pythonExecution, askForSudo, showProgress, targetEnvironmentRequest);
        String path2 = result2.getExePath();
        List<String> args = result2.getArgs();
        ProcessOutput processOutput = result2.getProcessOutput();
        int exitCode = processOutput.getExitCode();
        if (processOutput.isTimeout()) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.timed.out", new Object[0]), path2, args, processOutput);
        }
        if (exitCode != 0) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.packaging.non.zero.exit.code", exitCode), path2, args, processOutput);
        }
        String string = processOutput.getStdout();
        if (string == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private ProcessOutputWithCommandLine getPythonProcessOutput(@NotNull PythonExecution pythonExecution, boolean askForSudo, boolean showProgress, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) throws ExecutionException {
        ProcessOutput result2;
        if (pythonExecution == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(17);
        }
        if (targetEnvironmentRequest == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(18);
        }
        TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
        TargetEnvironment targetEnvironment = targetEnvironmentRequest.prepareEnvironment(targetProgressIndicator);
        for (Map.Entry entry : targetEnvironment.getUploadVolumes().entrySet()) {
            try {
                ((TargetEnvironment.UploadableVolume)entry.getValue()).upload(".", TargetProgressIndicator.EMPTY);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine(pythonExecution, targetEnvironment, this.getSdk(), Collections.emptyList());
        LOG.info("Running packaging tool");
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        Process process = this.createProcess(targetEnvironment, targetedCommandLine, askForSudo, indicator);
        List commandLine = targetedCommandLine.collectCommandsSynchronously();
        String commandLineString = StringUtil.join((Collection)commandLine, (String)" ");
        CapturingProcessHandler handler = new CapturingProcessHandler(process, targetedCommandLine.getCharset(), commandLineString);
        if (showProgress && indicator != null) {
            handler.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
            result2 = handler.runProcessWithProgressIndicator(indicator);
        } else {
            result2 = handler.runProcess(600000);
        }
        if (result2.isCancelled()) {
            throw new RunCanceledByUserException();
        }
        result2.checkSuccess(LOG);
        int exitCode = result2.getExitCode();
        String helperPath = (String)ContainerUtil.getFirstItem((Collection)commandLine, (Object)"");
        List<String> args = commandLine.subList(Math.min(1, commandLine.size()), commandLine.size());
        if (exitCode != 0) {
            String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? PySdkBundle.message("python.conda.permission.denied", new Object[0]) : PySdkBundle.message("python.sdk.packaging.non.zero.exit.code", exitCode);
            throw new PyExecutionException(message, helperPath, args, result2);
        }
        return new ProcessOutputWithCommandLine(helperPath, args, result2);
    }

    @NotNull
    private Process createProcess(@NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine targetedCommandLine, boolean askForSudo, @Nullable ProgressIndicator indicator) throws ExecutionException {
        if (targetEnvironment == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(19);
        }
        if (targetedCommandLine == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(20);
        }
        if (askForSudo) {
            if (!(targetEnvironment instanceof LocalTargetEnvironment)) {
                LOG.warn("Sudo flag is ignored");
            } else if (PySdkExtKt.adminPermissionsNeeded(this.getSdk())) {
                GeneralCommandLine localCommandLine = ((LocalTargetEnvironment)targetEnvironment).createGeneralCommandLine(targetedCommandLine);
                return PyTargetEnvironmentPackageManager.executeOnLocalMachineWithSudo(localCommandLine);
            }
        }
        Process process = targetEnvironment.createProcess(targetedCommandLine, Objects.requireNonNullElseGet(indicator, EmptyProgressIndicator::new));
        if (process == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(21);
        }
        return process;
    }

    @NotNull
    private static Process executeOnLocalMachineWithSudo(@NotNull GeneralCommandLine localCommandLine) throws ExecutionException {
        Process process;
        if (localCommandLine == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(22);
        }
        try {
            process = ExecUtil.sudo((GeneralCommandLine)localCommandLine, (String)PySdkBundle.message("python.sdk.packaging.enter.your.password.to.make.changes", new Object[0]));
        }
        catch (IOException e) {
            String exePath = localCommandLine.getExePath();
            List args = localCommandLine.getCommandLineList(exePath);
            throw new PyExecutionException(e.getMessage(), exePath, args);
        }
        if (process == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(23);
        }
        return process;
    }

    @NotNull
    private HelpersAwareTargetEnvironmentRequest getPythonTargetInterpreter() throws ExecutionException {
        HelpersAwareTargetEnvironmentRequest request = PythonInterpreterTargetEnvironmentFactory.findPythonTargetInterpreter(this.getSdk(), ProjectManager.getInstance().getDefaultProject());
        if (request == null) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.package.managing.not.supported.for.sdk", this.getSdk().getName()));
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = request;
        if (helpersAwareTargetEnvironmentRequest == null) {
            PyTargetEnvironmentPackageManager.$$$reportNull$$$0(24);
        }
        return helpersAwareTargetEnvironmentRequest;
    }

    @NotNull
    private static HelperPackage getPipHelperPackage() {
        return new PythonHelper.ScriptPythonHelper("pip-24.3.1-py2.py3-none-any.whl/pip", PythonHelpersLocator.getCommunityHelpersRoot().toFile(), Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11, 13, 16, 21, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyTargetEnvironmentPackageManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonExecution";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetedCommandLine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyTargetEnvironmentPackageManager";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isLegacyPython";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnLocalMachineWithSudo";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonTargetInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installUsingPipWheel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyWorkingDir";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyPython";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "executeOnLocalMachineWithSudo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11, 13, 16, 21, 23, 24 -> new IllegalStateException(string);
        };
    }

    private static class ProcessOutputWithCommandLine {
        @NotNull
        private final String myExePath;
        @NotNull
        private final List<String> myArgs;
        @NotNull
        private final ProcessOutput myProcessOutput;

        private ProcessOutputWithCommandLine(@NotNull String exePath, @NotNull List<String> args, @NotNull ProcessOutput output2) {
            if (exePath == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(0);
            }
            if (args == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(1);
            }
            if (output2 == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(2);
            }
            this.myExePath = exePath;
            this.myArgs = args;
            this.myProcessOutput = output2;
        }

        @NotNull
        private String getExePath() {
            String string = this.myExePath;
            if (string == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private List<String> getArgs() {
            List<String> list = this.myArgs;
            if (list == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private ProcessOutput getProcessOutput() {
            ProcessOutput processOutput = this.myProcessOutput;
            if (processOutput == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(5);
            }
            return processOutput;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyTargetEnvironmentPackageManager$ProcessOutputWithCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyTargetEnvironmentPackageManager$ProcessOutputWithCommandLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

