/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnProcessHandler
extends OSProcessHandler {
    private final boolean myForceUtf8;
    private final boolean myForceBinary;
    @NotNull
    private final ByteArrayOutputStream myBinaryOutput;

    public SvnProcessHandler(@NotNull Process process, @NotNull String commandLine, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            SvnProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            SvnProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine);
        this.myForceUtf8 = forceUtf8;
        this.myForceBinary = forceBinary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        ByteArrayOutputStream byteArrayOutputStream = this.myBinaryOutput;
        if (byteArrayOutputStream == null) {
            SvnProcessHandler.$$$reportNull$$$0(2);
        }
        return byteArrayOutputStream;
    }

    @Nullable
    public Charset getCharset() {
        return this.myForceUtf8 ? StandardCharsets.UTF_8 : super.getCharset();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        if (this.myForceBinary) {
            return new SimpleBinaryOutputReader(this.myProcess.getInputStream(), this.readerOptions().policy());
        }
        BaseDataReader baseDataReader = super.createOutputDataReader();
        if (baseDataReader == null) {
            SvnProcessHandler.$$$reportNull$$$0(3);
        }
        return baseDataReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/SvnProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/SvnProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryOutput";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputDataReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private final class SimpleBinaryOutputReader
    extends BinaryOutputReader {
        private SimpleBinaryOutputReader(@NotNull InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
            if (stream == null) {
                SimpleBinaryOutputReader.$$$reportNull$$$0(0);
            }
            if (sleepingPolicy == null) {
                SimpleBinaryOutputReader.$$$reportNull$$$0(1);
            }
            super(stream, sleepingPolicy);
            this.start(SvnProcessHandler.this.myPresentableName);
        }

        protected void onBinaryAvailable(byte @NotNull [] data, int size) {
            if (data == null) {
                SimpleBinaryOutputReader.$$$reportNull$$$0(2);
            }
            SvnProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                SimpleBinaryOutputReader.$$$reportNull$$$0(3);
            }
            Future future = SvnProcessHandler.this.executeTask(runnable);
            if (future == null) {
                SimpleBinaryOutputReader.$$$reportNull$$$0(4);
            }
            return future;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sleepingPolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/commandLine/SvnProcessHandler$SimpleBinaryOutputReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/commandLine/SvnProcessHandler$SimpleBinaryOutputReader";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onBinaryAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

