/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.query.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolsPrioritizedScope;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.context.WebSymbolsContext;
import com.intellij.webSymbols.context.WebSymbolsContextKindRules;
import com.intellij.webSymbols.context.WebSymbolsContextRulesProvider;
import com.intellij.webSymbols.context.impl.WebSymbolsContextDiscoveryKt;
import com.intellij.webSymbols.query.WebSymbolNameConversionRulesProvider;
import com.intellij.webSymbols.query.WebSymbolNamesProvider;
import com.intellij.webSymbols.query.WebSymbolsQueryConfigurator;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import com.intellij.webSymbols.query.WebSymbolsQueryResultsCustomizerFactory;
import com.intellij.webSymbols.query.impl.WebSymbolNamesProviderImpl;
import com.intellij.webSymbols.query.impl.WebSymbolsQueryExecutorImpl;
import com.intellij.webSymbols.utils.FileUtils;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J9\u0010\u0019\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u001d0\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b J\"\u0010!\u001a\u00020\"2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&2\b\u0010#\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&2\u0006\u0010#\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/webSymbols/query/impl/WebSymbolsQueryExecutorFactoryImpl;", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutorFactory;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "customScope", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "modificationCount", "", "create", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "location", "Lcom/intellij/psi/PsiElement;", "allowResolve", "", "addScope", "", "scope", "contextDirectory", "disposable", "dispose", "getContextRules", "Lkotlin/Pair;", "", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/context/WebSymbolsContextKindRules;", "Lcom/intellij/openapi/util/ModificationTracker;", "dir", "getContextRules$intellij_platform_webSymbols", "createNamesProvider", "Lcom/intellij/webSymbols/query/WebSymbolNamesProvider;", "context", "Lcom/intellij/webSymbols/context/WebSymbolsContext;", "getCustomScope", "", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsQueryExecutorFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsQueryExecutorFactoryImpl.kt\ncom/intellij/webSymbols/query/impl/WebSymbolsQueryExecutorFactoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n1863#2,2:146\n1863#2,2:149\n1368#2:151\n1454#2,2:152\n1456#2,3:156\n1010#2,2:159\n808#2,11:161\n1557#2:172\n1628#2,3:173\n1863#2,2:176\n1368#2:178\n1454#2,5:179\n1368#2:184\n1454#2,5:185\n1863#2,2:190\n1#3:148\n14#4:154\n14#4:155\n*S KotlinDebug\n*F\n+ 1 WebSymbolsQueryExecutorFactoryImpl.kt\ncom/intellij/webSymbols/query/impl/WebSymbolsQueryExecutorFactoryImpl\n*L\n38#1:146,2\n43#1:149,2\n46#1:151\n46#1:152,2\n46#1:156,3\n64#1:159,2\n92#1:161,11\n93#1:172\n93#1:173,3\n94#1:176,2\n99#1:178\n99#1:179,5\n112#1:184\n112#1:185,5\n114#1:190,2\n53#1:154\n57#1:155\n*E\n"})
public final class WebSymbolsQueryExecutorFactoryImpl
implements WebSymbolsQueryExecutorFactory,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<VirtualFile, WebSymbolsScope> customScope;
    private long modificationCount;

    public WebSymbolsQueryExecutorFactoryImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.customScope = new MultiMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WebSymbolsQueryExecutor create(@Nullable PsiElement location, boolean allowResolve) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        WebSymbolsScope p0;
        Object object;
        block11: {
            block10: {
                void $this$forEach$iv;
                Application application = ApplicationManager.getApplication();
                application.assertReadAccessAllowed();
                Iterable iterable = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WebSymbolsQueryConfigurator it = (WebSymbolsQueryConfigurator)element$iv;
                    boolean bl = false;
                    it.beforeQueryExecutorCreation(this.project);
                }
                object = location;
                if (object == null) break block10;
                PsiElement it = object;
                boolean bl = false;
                WebSymbolsContext webSymbolsContext = WebSymbolsContextDiscoveryKt.buildWebSymbolsContext(it);
                object = webSymbolsContext;
                if (webSymbolsContext != null) break block11;
            }
            object = WebSymbolsContext.Companion.empty();
        }
        Object context = object;
        List scopeList = new ArrayList();
        Iterable $this$forEach$iv = this.getCustomScope(location);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (WebSymbolsScope)element$iv;
            boolean bl = false;
            scopeList.add(p0);
        }
        boolean internalMode = ApplicationManager.getApplication().isInternal();
        PsiElement psiElement = location;
        PsiElement originalLocation = psiElement != null ? psiElement.getOriginalElement() : null;
        Iterable bl = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
        List list2 = scopeList;
        boolean $i$f$flatMap = false;
        p0 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<WebSymbolsScope> list3;
            WebSymbolsQueryConfigurator queryConfigurator = (WebSymbolsQueryConfigurator)element$iv$iv;
            boolean bl2 = false;
            List<WebSymbolsScope> it = list3 = queryConfigurator.getScope(this.project, originalLocation, (WebSymbolsContext)context, allowResolve);
            boolean bl3 = false;
            if (internalMode && Math.random() < 0.2) {
                boolean $i$f$logger;
                List<WebSymbolsScope> newScope = queryConfigurator.getScope(this.project, originalLocation, (WebSymbolsContext)context, allowResolve);
                if (!Intrinsics.areEqual(newScope, it)) {
                    $i$f$logger = false;
                    Logger logger = Logger.getInstance(WebSymbolsQueryExecutorFactory.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Query configurator " + queryConfigurator + " should provide scope, which is the same (by equals()), when called with the same arguments: " + it + " != " + newScope);
                }
                if (((Object)newScope).hashCode() != ((Object)it).hashCode()) {
                    $i$f$logger = false;
                    Logger logger = Logger.getInstance(WebSymbolsQueryExecutorFactory.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Query configurator " + queryConfigurator + " should provide scope, which has the same hashCode(), when called with the same arguments: " + it + " != " + newScope);
                }
            }
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
        List $this$sortBy$iv = scopeList;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Object object;
                    Object object2;
                    WebSymbolsScope it = (WebSymbolsScope)a;
                    boolean bl = false;
                    WebSymbolsScope $this$asSafely$iv = it;
                    boolean $i$f$asSafely = false;
                    WebSymbolsScope webSymbolsScope = $this$asSafely$iv;
                    if (!(webSymbolsScope instanceof WebSymbolsPrioritizedScope)) {
                        webSymbolsScope = null;
                    }
                    if ((object2 = (WebSymbolsPrioritizedScope)((Object)webSymbolsScope)) == null || (object2 = object2.getPriority()) == null) {
                        object2 = WebSymbol.Priority.NORMAL;
                    }
                    it = (WebSymbolsScope)b;
                    Comparable comparable = Double.valueOf(((WebSymbol.Priority)((Object)object2)).getValue());
                    bl = false;
                    $this$asSafely$iv = it;
                    $i$f$asSafely = false;
                    WebSymbolsScope webSymbolsScope2 = $this$asSafely$iv;
                    if (!(webSymbolsScope2 instanceof WebSymbolsPrioritizedScope)) {
                        webSymbolsScope2 = null;
                    }
                    if ((object = (WebSymbolsPrioritizedScope)((Object)webSymbolsScope2)) == null || (object = object.getPriority()) == null) {
                        object = WebSymbol.Priority.NORMAL;
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(((WebSymbol.Priority)((Object)object)).getValue()));
                }
            });
        }
        return new WebSymbolsQueryExecutorImpl(scopeList, this.createNamesProvider(this.project, originalLocation, (WebSymbolsContext)context), WebSymbolsQueryResultsCustomizerFactory.Companion.getQueryResultsCustomizer(location, (WebSymbolsContext)context), (WebSymbolsContext)context, allowResolve);
    }

    @Override
    public void addScope(@NotNull WebSymbolsScope scope, @Nullable VirtualFile contextDirectory, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        this.customScope.putValue((Object)contextDirectory, (Object)scope);
        Disposer.register((Disposable)disposable, () -> WebSymbolsQueryExecutorFactoryImpl.addScope$lambda$5(this, contextDirectory, scope));
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<MultiMap<String, WebSymbolsContextKindRules>, ModificationTracker> getContextRules$intellij_platform_webSymbols(@NotNull Project project2, @NotNull VirtualFile dir) {
        void $this$flatMapTo$iv$iv;
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        MultiMap result2 = new MultiMap();
        Iterable iterable = this.getCustomScope(dir);
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WebSymbolsContextRulesProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            WebSymbolsContextRulesProvider webSymbolsContextRulesProvider = (WebSymbolsContextRulesProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContextRules());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MultiMap it = (MultiMap)element$iv;
            boolean bl = false;
            result2.putAllValues(it);
        }
        List providers = new ArrayList();
        Iterable $this$flatMap$iv = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable it = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WebSymbolsQueryConfigurator it2 = (WebSymbolsQueryConfigurator)element$iv$iv;
            boolean bl = false;
            it2.beforeQueryExecutorCreation(project2);
            Iterable list$iv$iv = it2.getContextRulesProviders(project2, dir);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        for (WebSymbolsContextRulesProvider provider : (List)destination$iv$iv2) {
            result2.putAllValues(provider.getContextRules());
            providers.add(provider.createPointer());
        }
        return new Pair((Object)result2, (Object)WebSymbolUtils.createModificationTracker(providers));
    }

    /*
     * WARNING - void declaration
     */
    private final WebSymbolNamesProvider createNamesProvider(Project project2, PsiElement location, WebSymbolsContext context) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        List nameConversionRules = new ArrayList();
        List providers = new ArrayList();
        Iterable $this$flatMap$iv = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WebSymbolsQueryConfigurator provider = (WebSymbolsQueryConfigurator)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = provider.getNameConversionRulesProviders(project2, location, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebSymbolNameConversionRulesProvider provider = (WebSymbolNameConversionRulesProvider)element$iv;
            boolean bl = false;
            nameConversionRules.add(provider.getNameConversionRules());
            providers.add(provider.createPointer());
        }
        return new WebSymbolNamesProviderImpl(context.getFramework(), nameConversionRules, WebSymbolUtils.createModificationTracker(providers));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<WebSymbolsScope> getCustomScope(PsiElement context) {
        List<WebSymbolsScope> list2;
        if (context != null) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            PsiElement it = context;
            boolean bl = false;
            PsiFile psiFile2 = InjectedLanguageManager.getInstance((Project)it.getProject()).getTopLevelFile(it);
            if (psiFile2 != null && (psiFile = psiFile2.getOriginalFile()) != null && (virtualFile = psiFile.getVirtualFile()) != null) {
                VirtualFile it2 = virtualFile;
                boolean bl2 = false;
                VirtualFile virtualFile2 = FileUtils.findOriginalFile(it2);
                if (virtualFile2 != null) {
                    VirtualFile it3 = virtualFile2;
                    boolean bl3 = false;
                    List<WebSymbolsScope> list3 = this.getCustomScope(it3);
                    if (list3 != null) {
                        list2 = list3;
                        return list2;
                    }
                }
            }
        }
        list2 = CollectionsKt.emptyList();
        return list2;
    }

    private final List<WebSymbolsScope> getCustomScope(VirtualFile context) {
        List result2 = new ArrayList();
        if (!this.customScope.isEmpty()) {
            Collection collection = this.customScope.get(null);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            result2.addAll(collection);
            for (VirtualFile f = context; f != null; f = f.getParent()) {
                if (!this.customScope.containsKey((Object)f)) continue;
                Collection collection2 = this.customScope.get((Object)f);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                result2.addAll(collection2);
            }
        }
        return result2;
    }

    private static final void addScope$lambda$5(WebSymbolsQueryExecutorFactoryImpl this$0, VirtualFile $contextDirectory, WebSymbolsScope $scope) {
        this$0.customScope.remove((Object)$contextDirectory, (Object)$scope);
    }
}

