/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.ArrayTrieCounter;
import com.intellij.completion.ngram.slp.modeling.Model;
import com.intellij.completion.ngram.slp.modeling.ngram.JMModel;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.modeling.runners.ModelRunner;
import com.intellij.completion.ngram.slp.translating.Vocabulary;
import com.intellij.internal.ml.ngram.NGramModelScorer;
import com.intellij.internal.ml.ngram.VocabularyWithLimit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "Lcom/intellij/completion/ngram/slp/modeling/runners/ModelRunner;", "nGramOrder", "", "lambda", "", "model", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "vocabulary", "Lcom/intellij/internal/ml/ngram/VocabularyWithLimit;", "<init>", "(IDLcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;Lcom/intellij/internal/ml/ngram/VocabularyWithLimit;)V", "getLambda", "()D", "prevTokens", "", "", "getPrevTokens$intellij_platform_ml_impl", "()Ljava/util/List;", "learnNextToken", "", "token", "createScorer", "Lcom/intellij/internal/ml/ngram/NGramModelScorer;", "scoreTokens", "tokens", "", "updatePrevTokens", "shiftTokens", "Companion", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNGramIncrementalModelRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NGramIncrementalModelRunner.kt\ncom/intellij/internal/ml/ngram/NGramIncrementalModelRunner\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,100:1\n37#2,2:101\n*S KotlinDebug\n*F\n+ 1 NGramIncrementalModelRunner.kt\ncom/intellij/internal/ml/ngram/NGramIncrementalModelRunner\n*L\n62#1:101,2\n*E\n"})
public final class NGramIncrementalModelRunner
extends ModelRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int nGramOrder;
    private final double lambda;
    @NotNull
    private final List<String> prevTokens;
    private static final double DEFAULT_LAMBDA = 0.5;
    private static final int LAST_STORED_TOKENS = 200;
    private static final int LAST_STORED_TOKENS_SEQUENCE = 5000;

    public NGramIncrementalModelRunner(int nGramOrder, double lambda, @NotNull NGramModel model2, @NotNull VocabularyWithLimit vocabulary) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)vocabulary, (String)"vocabulary");
        super((Model)model2, (Vocabulary)vocabulary);
        this.nGramOrder = nGramOrder;
        this.lambda = lambda;
        boolean bl2 = bl = vocabulary.getMaxVocabularySize() >= this.nGramOrder && vocabulary.getRecentSequence().getMaxSequenceLength() >= this.nGramOrder;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.prevTokens = new ArrayList();
    }

    public final double getLambda() {
        return this.lambda;
    }

    @NotNull
    public final List<String> getPrevTokens$intellij_platform_ml_impl() {
        return this.prevTokens;
    }

    public final void learnNextToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.updatePrevTokens(token);
        Vocabulary vocabulary = this.getVocabulary();
        Model model2 = this.getModel();
        if (vocabulary instanceof VocabularyWithLimit && model2 instanceof NGramModel) {
            List<Integer> indices = ((VocabularyWithLimit)vocabulary).toIndicesWithLimit(this.prevTokens, (NGramModel)model2);
            if (indices.size() > 1) {
                ((NGramModel)model2).forget(indices.subList(0, indices.size() - 1));
            }
            ((NGramModel)model2).learn(indices);
        }
    }

    @NotNull
    public final NGramModelScorer createScorer() {
        String[] stringArray;
        List prevTokensSnapshot = CollectionsKt.toList((Iterable)this.prevTokens);
        if (prevTokensSnapshot.size() > 1) {
            Collection $this$toTypedArray$iv = prevTokensSnapshot.subList(1, prevTokensSnapshot.size());
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = new String[]{};
        }
        String[] prefix = stringArray;
        return new NGramModelScorer((Function1<? super List<String>, Double>)((Function1)arg_0 -> NGramIncrementalModelRunner.createScorer$lambda$0(this, arg_0)), prefix);
    }

    private final double scoreTokens(List<String> tokens) {
        Vocabulary vocabulary = this.getVocabulary();
        if (vocabulary instanceof VocabularyWithLimit) {
            List<Integer> queryIndices = ((VocabularyWithLimit)vocabulary).toExistingIndices(tokens);
            return ((Number)this.getModel().modelToken(queryIndices, queryIndices.size() - 1).getFirst()).doubleValue();
        }
        return 0.0;
    }

    private final void updatePrevTokens(String token) {
        if (this.prevTokens.size() < this.nGramOrder) {
            this.prevTokens.add(token);
            return;
        }
        this.shiftTokens();
        this.prevTokens.set(this.prevTokens.size() - 1, token);
    }

    private final void shiftTokens() {
        int i = 0;
        int n = this.prevTokens.size() - 2;
        if (i <= n) {
            while (true) {
                this.prevTokens.set(i, this.prevTokens.get(i + 1));
                if (i == n) break;
                ++i;
            }
        }
    }

    private static final double createScorer$lambda$0(NGramIncrementalModelRunner this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.scoreTokens(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0005J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner$Companion;", "", "<init>", "()V", "DEFAULT_LAMBDA", "", "LAST_STORED_TOKENS", "", "LAST_STORED_TOKENS_SEQUENCE", "createNewModelRunner", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "order", "lambda", "createModelRunner", "counter", "Lcom/intellij/completion/ngram/slp/counting/trie/ArrayTrieCounter;", "vocabulary", "Lcom/intellij/internal/ml/ngram/VocabularyWithLimit;", "intellij.platform.ml.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NGramIncrementalModelRunner createNewModelRunner(int order, double lambda) {
            ArrayTrieCounter arrayTrieCounter = new ArrayTrieCounter();
            return new NGramIncrementalModelRunner(order, lambda, (NGramModel)new JMModel(order, 0.0, (Counter)arrayTrieCounter, 2, null), new VocabularyWithLimit(200, order, 5000, 0, 8, null));
        }

        public static /* synthetic */ NGramIncrementalModelRunner createNewModelRunner$default(Companion companion, int n, double d, int n2, Object object) {
            if ((n2 & 2) != 0) {
                d = 0.5;
            }
            return companion.createNewModelRunner(n, d);
        }

        @NotNull
        public final NGramIncrementalModelRunner createModelRunner(int order, double lambda, @NotNull ArrayTrieCounter counter, @NotNull VocabularyWithLimit vocabulary) {
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            Intrinsics.checkNotNullParameter((Object)vocabulary, (String)"vocabulary");
            return new NGramIncrementalModelRunner(order, lambda, (NGramModel)new JMModel(order, lambda, (Counter)counter), vocabulary);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

