/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.ProjectSnapshot;
import com.intellij.packageChecker.service.IgnorableDependenciesServiceKt;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH&J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000eH&J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\r\u001a\u00020\u000eH&R \u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/intellij/packageChecker/model/ProjectDependenciesModelSimplified;", "", "modules", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/packageChecker/model/ModuleModel;", "getModules", "()Lkotlinx/coroutines/flow/StateFlow;", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "psiFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/security/package/Package;", "project", "Lcom/intellij/packageChecker/model/ProjectSnapshot;", "refresh", "", "Lcom/intellij/openapi/project/Project;", "libraryDependencies", "Lcom/intellij/packageChecker/model/LibraryDependency;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nProjectDependenciesModelSimplified.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDependenciesModelSimplified.kt\ncom/intellij/packageChecker/model/ProjectDependenciesModelSimplified\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n827#2:50\n855#2,2:51\n*S KotlinDebug\n*F\n+ 1 ProjectDependenciesModelSimplified.kt\ncom/intellij/packageChecker/model/ProjectDependenciesModelSimplified\n*L\n26#1:50\n26#1:51,2\n*E\n"})
public interface ProjectDependenciesModelSimplified {
    @NotNull
    public StateFlow<Set<ModuleModel>> getModules();

    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile var1);

    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module var1);

    @NotNull
    default public List<Package> declaredDependencies(@NotNull ProjectSnapshot project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)project.getModules()), arg_0 -> ProjectDependenciesModelSimplified.declaredDependencies$lambda$1(this, arg_0)), ProjectDependenciesModelSimplified::declaredDependencies$lambda$2));
    }

    public void refresh();

    default public void refresh(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.refresh();
    }

    @NotNull
    public List<LibraryDependency> libraryDependencies(@NotNull Module var1);

    /*
     * WARNING - void declaration
     */
    private static Iterable declaredDependencies$lambda$1(ProjectDependenciesModelSimplified this$0, Module module) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$filterNot$iv = this$0.declaredDependencies(module);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PackageDeclaration it = (PackageDeclaration)element$iv$iv;
            boolean bl = false;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Package package_ = it.getPkg();
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (IgnorableDependenciesServiceKt.isPackageIgnored(project, package_, string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static Package declaredDependencies$lambda$2(PackageDeclaration packageDeclaration) {
        Intrinsics.checkNotNullParameter((Object)packageDeclaration, (String)"packageDeclaration");
        return packageDeclaration.getPkg();
    }
}

