/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.ui.painter.badge;

import androidx.compose.runtime.Immutable;
import androidx.compose.ui.geometry.CornerRadiusKt;
import androidx.compose.ui.geometry.RoundRectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.GenerateDataFunctions;
import org.jetbrains.jewel.ui.painter.badge.BadgeShape;
import org.jetbrains.jewel.ui.painter.badge.BadgeShapeKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@GenerateDataFunctions
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/jewel/ui/painter/badge/DotBadgeShape;", "Lorg/jetbrains/jewel/ui/painter/badge/BadgeShape;", "x", "", "y", "radius", "border", "<init>", "(FFFF)V", "getX", "()F", "getY", "getRadius", "getBorder", "createHoleOutline", "Landroidx/compose/ui/graphics/Outline;", "size", "Landroidx/compose/ui/geometry/Size;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "density", "Landroidx/compose/ui/unit/Density;", "createHoleOutline-Pq9zytI", "(JLandroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/Density;)Landroidx/compose/ui/graphics/Outline;", "createOutline", "createOutline-Pq9zytI", "hole", "", "createOutline-TmRCtEA", "(JZ)Landroidx/compose/ui/graphics/Outline;", "Companion", "ui"})
@Immutable
public final class DotBadgeShape
implements BadgeShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float radius;
    private final float border;
    public static final int $stable;
    @NotNull
    private static final DotBadgeShape Default;

    public DotBadgeShape(float x, float y, float radius, float border) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.border = border;
    }

    public /* synthetic */ DotBadgeShape(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.825f;
        }
        if ((n & 2) != 0) {
            f2 = 0.175f;
        }
        if ((n & 4) != 0) {
            f3 = 0.175f;
        }
        if ((n & 8) != 0) {
            f4 = 0.075f;
        }
        this(f, f2, f3, f4);
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getRadius() {
        return this.radius;
    }

    public final float getBorder() {
        return this.border;
    }

    @Override
    @NotNull
    public Outline createHoleOutline-Pq9zytI(long size2, @NotNull LayoutDirection layoutDirection, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return this.createOutline-TmRCtEA(size2, true);
    }

    @Override
    @NotNull
    public Outline createOutline-Pq9zytI(long size2, @NotNull LayoutDirection layoutDirection, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return this.createOutline-TmRCtEA(size2, false);
    }

    private final Outline createOutline-TmRCtEA(long size2, boolean hole) {
        float dotSize = RangesKt.coerceAtMost((float)Size.getWidth-impl(size2), (float)Size.getHeight-impl(size2));
        if (dotSize <= 0.0f) {
            return BadgeShapeKt.getEmptyOutline();
        }
        float radius = dotSize * this.radius;
        if (radius <= 0.0f) {
            return BadgeShapeKt.getEmptyOutline();
        }
        float x = Size.getWidth-impl(size2) * this.x;
        if (0.0f > x + radius || x - radius > Size.getWidth-impl(size2)) {
            return BadgeShapeKt.getEmptyOutline();
        }
        float y = Size.getHeight-impl(size2) * this.y;
        if (0.0f > y + radius || y - radius > Size.getHeight-impl(size2)) {
            return BadgeShapeKt.getEmptyOutline();
        }
        float border = hole ? dotSize * this.border : 0.0f;
        float r = radius + RangesKt.coerceAtLeast((float)border, (float)0.0f);
        return new Outline.Rounded(RoundRectKt.RoundRect-gG7oq9Y(x - r, y - r, x + r, y + r, CornerRadiusKt.CornerRadius$default(r, 0.0f, 2, null)));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DotBadgeShape)) {
            return false;
        }
        DotBadgeShape dotBadgeShape = (DotBadgeShape)other;
        if (Float.compare(this.x, dotBadgeShape.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, dotBadgeShape.y) != 0) {
            return false;
        }
        if (Float.compare(this.radius, dotBadgeShape.radius) != 0) {
            return false;
        }
        return Float.compare(this.border, dotBadgeShape.border) == 0;
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.radius);
        result2 = result2 * 31 + Float.hashCode(this.border);
        return result2;
    }

    @NotNull
    public String toString() {
        return "DotBadgeShape(x=" + this.x + ", y=" + this.y + ", radius=" + this.radius + ", border=" + this.border + ")";
    }

    public DotBadgeShape() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }

    static {
        Default = new DotBadgeShape(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jewel/ui/painter/badge/DotBadgeShape$Companion;", "", "<init>", "()V", "Default", "Lorg/jetbrains/jewel/ui/painter/badge/DotBadgeShape;", "getDefault", "()Lorg/jetbrains/jewel/ui/painter/badge/DotBadgeShape;", "ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DotBadgeShape getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

